/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.pareto;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.paint.Color;

public class ParetoBar {
    private Double value;
    private String name;
    private double x;
    private double y;
    private double width;
    private double height;
    private Color _fillColor;
    private ObjectProperty<Color> fillColor;
    private ArrayList<ParetoBar> bars;

    public ParetoBar(String name, List<ParetoBar> bars) {
        this(name, null, bars);
    }

    public ParetoBar(String name, double value) {
        this(name, value, null);
    }

    public ParetoBar(String name, Double value, List<ParetoBar> bars) {
        this(name, value, Color.BLUE, bars);
    }

    public ParetoBar(String name, Double value, Color color, List<ParetoBar> bars) {
        this.bars = bars == null ? new ArrayList() : new ArrayList<ParetoBar>(bars);
        this.name = name;
        this._fillColor = color;
        if (value == null && bars != null && bars.size() > 0) {
            double temp = 0.0;
            for (ParetoBar bar : bars) {
                temp += bar.getValue().doubleValue();
            }
            this.value = temp;
        } else {
            this.value = value;
        }
        if (bars != null) {
            this.sortAscending();
        }
    }

    private void updateValue() {
        this.value = this.bars.stream().mapToDouble(ParetoBar::getValue).sum();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double X) {
        this.x = X;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double Y) {
        this.y = Y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double WIDTH) {
        this.width = WIDTH;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double HEIGHT) {
        this.height = HEIGHT;
    }

    public Color getFillColor() {
        return null != this.fillColor ? (Color)this.fillColor.getValue() : this._fillColor;
    }

    public void setFillColor(Color COLOR) {
        if (null == this.fillColor) {
            this._fillColor = COLOR;
        } else {
            this.fillColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> fillColorProperty() {
        if (null == this.fillColor) {
            this.fillColor = new ObjectPropertyBase<Color>(this._fillColor){

                public Object getBean() {
                    return ParetoBar.this;
                }

                public String getName() {
                    return "fillColor";
                }
            };
            this._fillColor = null;
        }
        return this.fillColor;
    }

    public Double getValue() {
        if (null == this.value) {
            this.updateValue();
        }
        return this.value;
    }

    private void sortAscending() {
        this.bars.sort((c1, c2) -> {
            if (Double.compare(c1.getValue(), c2.getValue()) == 0) {
                return 0;
            }
            return c1.getValue() > c2.getValue() ? -1 : 1;
        });
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<ParetoBar> getBars() {
        return this.bars;
    }

    public void addBar(ParetoBar bar) {
        if (null == this.bars) {
            this.bars = new ArrayList();
        }
        this.bars.add(bar);
        this.sortAscending();
        this.updateValue();
    }

    public void addBar(String name, double value) {
        this.addBar(new ParetoBar(name, value));
    }
}

