/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.wafermap.Defect;
import eu.hansolo.fx.charts.wafermap.DefectBuilder;
import eu.hansolo.fx.charts.wafermap.DefectClass;
import eu.hansolo.fx.charts.wafermap.DefectRecordField;
import eu.hansolo.fx.charts.wafermap.KLA;
import eu.hansolo.fx.charts.wafermap.OrientationMarkLocation;
import eu.hansolo.fx.charts.wafermap.SampleOrientationMarkType;
import eu.hansolo.fx.charts.wafermap.SampleTest;
import eu.hansolo.fx.charts.wafermap.SampleType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum KLAParser {
    INSTANCE;

    public static final DateTimeFormatter DTF;
    private static final Pattern FILE_VERSION_PATTERN;
    private static final Pattern FILE_TIMESTAMP_PATTERN;
    private static final Pattern INSPECTION_STATION_ID_PATTERN;
    private static final Pattern SAMPLE_TYPE_PATTERN;
    private static final Pattern RESULT_TIMESTAMP_PATTERN;
    private static final Pattern LOT_ID_PATTERN;
    private static final Pattern SAMPLE_SIZE_PATTERN;
    private static final Pattern SETUP_ID_PATTERN;
    private static final Pattern STEP_ID_PATTERN;
    private static final Pattern SAMPLE_ORIENTATION_MARK_TYPE_PATTERN;
    private static final Pattern ORIENTATION_MARK_LOCATION_PATTERN;
    private static final Pattern DIE_PITCH_PATTERN;
    private static final Pattern DIE_ORIGIN_PATTERN;
    private static final Pattern WAFER_ID_PATTERN;
    private static final Pattern SLOT_PATTERN;
    private static final Pattern SAMPLE_CENTER_LOCATION_PATTERN;
    private static final Pattern CLASS_PATTERN;
    private static final Pattern INSPECTION_TEST_PATTERN;
    private static final Pattern SAMPLE_PATTERN;
    private static final Pattern AREA_PER_TEST_PATTERN;
    private static final Pattern DEFECT_RECORD_SPEC_PATTERN;
    private static Pattern defectPattern;
    private static final Pattern SUMMARY_SPEC_PATTERN;
    private static final Pattern SUMMARY_PATTERN;
    private static final Pattern WAFER_STATUS_PATTERN;
    private static final Matcher FILE_VERSION_MATCHER;
    private static final Matcher FILE_TIMESTAMP_MATCHER;
    private static final Matcher INSPECTION_STATION_ID_MATCHER;
    private static final Matcher SAMPLE_TYPE_MATCHER;
    private static final Matcher RESULT_TIMESTAMP_MATCHER;
    private static final Matcher LOT_ID_MATCHER;
    private static final Matcher SAMPLE_SIZE_MATCHER;
    private static final Matcher SETUP_ID_MATCHER;
    private static final Matcher STEP_ID_MATCHER;
    private static final Matcher SAMPLE_ORIENTATION_MARK_TYPE_MATCHER;
    private static final Matcher ORIENTATION_MARK_LOCATION_MATCHER;
    private static final Matcher DIE_PITCH_MATCHER;
    private static final Matcher DIE_ORIGIN_MATCHER;
    private static final Matcher WAFER_ID_MATCHER;
    private static final Matcher SLOT_MATCHER;
    private static final Matcher SAMPLE_CENTER_LOCATION_MATCHER;
    private static final Matcher CLASS_MATCHER;
    private static final Matcher INSPECTION_TEST_MATCHER;
    private static final Matcher SAMPLE_MATCHER;
    private static final Matcher AREA_PER_TEST_MATCHER;
    private static final Matcher DEFECT_RECORD_SPEC_MATCHER;
    private static Matcher defectMatcher;
    private static final Matcher SUMMARY_SPEC_MATCHER;
    private static final Matcher SUMMARY_MATCHER;
    private static final Matcher WAFER_STATUS_MATCHER;
    private static final Map<DefectRecordField, Integer> GROUP_OFFSETS;
    private static final Map<Integer, DefectRecordField> DEFECT_FIELD_MAP;

    public Optional<KLA> parse(String filename) {
        if (null == filename || filename.isEmpty()) {
            return Optional.empty();
        }
        if (Helper.isFileReadable(filename) && Helper.check4KLAFormat(filename)) {
            Optional<KLA> optional;
            block10: {
                GROUP_OFFSETS.clear();
                KLA kla = new KLA();
                LinkedList<DefectClass> classes = new LinkedList<DefectClass>();
                LinkedList<SampleTest> sampleTestPlan = new LinkedList<SampleTest>();
                ArrayList<Defect> defects = new ArrayList<Defect>();
                Stream<String> stream = Files.lines(Paths.get(filename, new String[0]));
                try {
                    stream.forEach(line -> {
                        FILE_VERSION_MATCHER.reset((CharSequence)line);
                        while (FILE_VERSION_MATCHER.find()) {
                            int fileVersionMajor = Integer.parseInt(FILE_VERSION_MATCHER.group(2));
                            int fileVersionMinor = Integer.parseInt(FILE_VERSION_MATCHER.group(3));
                            kla.setFileVersionMajor(fileVersionMajor);
                            kla.setFileVersionMinor(fileVersionMinor);
                        }
                        if (FILE_VERSION_MATCHER.matches()) {
                            return;
                        }
                        FILE_TIMESTAMP_MATCHER.reset((CharSequence)line);
                        while (FILE_TIMESTAMP_MATCHER.find()) {
                            String fileTimestamp = FILE_TIMESTAMP_MATCHER.group(2) + "-" + FILE_TIMESTAMP_MATCHER.group(3) + "-" + FILE_TIMESTAMP_MATCHER.group(4) + " " + FILE_TIMESTAMP_MATCHER.group(5) + ":" + FILE_TIMESTAMP_MATCHER.group(6) + ":" + FILE_TIMESTAMP_MATCHER.group(7);
                            kla.setFileTimestamp(LocalDateTime.parse(fileTimestamp, DTF));
                        }
                        if (FILE_TIMESTAMP_MATCHER.matches()) {
                            return;
                        }
                        INSPECTION_STATION_ID_MATCHER.reset((CharSequence)line);
                        while (INSPECTION_STATION_ID_MATCHER.find()) {
                            String inspectionStationIdPart1 = INSPECTION_STATION_ID_MATCHER.group(2).replaceAll("\\\"", "");
                            String inspectionStationIdPart2 = INSPECTION_STATION_ID_MATCHER.group(3).replaceAll("\\\"", "");
                            String inspectionStationIdPart3 = INSPECTION_STATION_ID_MATCHER.group(4).replaceAll("\\\"", "");
                            kla.setInspectionStationIdPart1(inspectionStationIdPart1);
                            kla.setInspectionStationIdPart2(inspectionStationIdPart2);
                            kla.setInspectionStationIdPart3(inspectionStationIdPart3);
                        }
                        if (INSPECTION_STATION_ID_MATCHER.matches()) {
                            return;
                        }
                        SAMPLE_TYPE_MATCHER.reset((CharSequence)line);
                        while (SAMPLE_TYPE_MATCHER.find()) {
                            String sampleType = SAMPLE_TYPE_MATCHER.group(2);
                            kla.setSampleType(SampleType.valueOf(sampleType));
                        }
                        if (SAMPLE_TYPE_MATCHER.matches()) {
                            return;
                        }
                        RESULT_TIMESTAMP_MATCHER.reset((CharSequence)line);
                        while (RESULT_TIMESTAMP_MATCHER.find()) {
                            String resultTimestamp = RESULT_TIMESTAMP_MATCHER.group(2) + "-" + RESULT_TIMESTAMP_MATCHER.group(3) + "-" + RESULT_TIMESTAMP_MATCHER.group(4) + " " + RESULT_TIMESTAMP_MATCHER.group(5) + ":" + RESULT_TIMESTAMP_MATCHER.group(6) + ":" + RESULT_TIMESTAMP_MATCHER.group(7);
                            kla.setResultTimestamp(LocalDateTime.parse(resultTimestamp, DTF));
                        }
                        if (RESULT_TIMESTAMP_MATCHER.matches()) {
                            return;
                        }
                        LOT_ID_MATCHER.reset((CharSequence)line);
                        while (LOT_ID_MATCHER.find()) {
                            String lotID = LOT_ID_MATCHER.group(2).replaceAll("\\\"", "");
                            kla.setLotID(lotID);
                        }
                        if (LOT_ID_MATCHER.matches()) {
                            return;
                        }
                        SAMPLE_SIZE_MATCHER.reset((CharSequence)line);
                        while (SAMPLE_SIZE_MATCHER.find()) {
                            String sampleSize = SAMPLE_SIZE_MATCHER.group(3);
                            kla.setSampleSize(Double.parseDouble(sampleSize));
                        }
                        if (SAMPLE_SIZE_MATCHER.matches()) {
                            return;
                        }
                        SETUP_ID_MATCHER.reset((CharSequence)line);
                        while (SETUP_ID_MATCHER.find()) {
                            String setupIdName = SETUP_ID_MATCHER.group(2).replaceAll("\\\"", "");
                            String setupIdTimestamp = SETUP_ID_MATCHER.group(3) + "-" + SETUP_ID_MATCHER.group(4) + "-" + SETUP_ID_MATCHER.group(5) + " " + SETUP_ID_MATCHER.group(6) + ":" + SETUP_ID_MATCHER.group(7) + ":" + SETUP_ID_MATCHER.group(8);
                            kla.setSetupIdName(setupIdName);
                            kla.setSetupIdTimestamp(LocalDateTime.parse(setupIdTimestamp, DTF));
                        }
                        if (SETUP_ID_MATCHER.matches()) {
                            return;
                        }
                        STEP_ID_MATCHER.reset((CharSequence)line);
                        while (STEP_ID_MATCHER.find()) {
                            String stepID = STEP_ID_MATCHER.group(2).replaceAll("\\\"", "");
                            kla.setStepID(stepID);
                        }
                        if (STEP_ID_MATCHER.matches()) {
                            return;
                        }
                        SAMPLE_ORIENTATION_MARK_TYPE_MATCHER.reset((CharSequence)line);
                        while (SAMPLE_ORIENTATION_MARK_TYPE_MATCHER.find()) {
                            String sampleOrientationMarkType = SAMPLE_ORIENTATION_MARK_TYPE_MATCHER.group(2);
                            kla.setSampleOrientationMarkType(SampleOrientationMarkType.valueOf(sampleOrientationMarkType));
                        }
                        if (SAMPLE_ORIENTATION_MARK_TYPE_MATCHER.matches()) {
                            return;
                        }
                        ORIENTATION_MARK_LOCATION_MATCHER.reset((CharSequence)line);
                        while (ORIENTATION_MARK_LOCATION_MATCHER.find()) {
                            String orientationMarkLocation = ORIENTATION_MARK_LOCATION_MATCHER.group(2);
                            kla.setOrientationMarkLocation(OrientationMarkLocation.valueOf(orientationMarkLocation));
                        }
                        if (ORIENTATION_MARK_LOCATION_MATCHER.matches()) {
                            return;
                        }
                        DIE_PITCH_MATCHER.reset((CharSequence)line);
                        while (DIE_PITCH_MATCHER.find()) {
                            String diePitchX = DIE_PITCH_MATCHER.group(2);
                            String diePitchY = DIE_PITCH_MATCHER.group(5);
                            kla.setDiePitchX(Double.parseDouble(diePitchX));
                            kla.setDiePitchY(Double.parseDouble(diePitchY));
                        }
                        if (DIE_PITCH_MATCHER.matches()) {
                            return;
                        }
                        DIE_ORIGIN_MATCHER.reset((CharSequence)line);
                        while (DIE_ORIGIN_MATCHER.find()) {
                            String dieOriginX = DIE_ORIGIN_MATCHER.group(2);
                            String dieOriginY = DIE_ORIGIN_MATCHER.group(3);
                            kla.setDieOriginX(Double.parseDouble(dieOriginX));
                            kla.setDieOriginY(Double.parseDouble(dieOriginY));
                        }
                        if (DIE_ORIGIN_MATCHER.matches()) {
                            return;
                        }
                        WAFER_ID_MATCHER.reset((CharSequence)line);
                        while (WAFER_ID_MATCHER.find()) {
                            String waferID = WAFER_ID_MATCHER.group(2).replaceAll("\\\"", "");
                            kla.setWaferId(waferID);
                        }
                        if (WAFER_ID_MATCHER.matches()) {
                            return;
                        }
                        SLOT_MATCHER.reset((CharSequence)line);
                        while (SLOT_MATCHER.find()) {
                            String slot = SLOT_MATCHER.group(2);
                            kla.setSlot(Integer.parseInt(slot));
                        }
                        if (SLOT_MATCHER.matches()) {
                            return;
                        }
                        SAMPLE_CENTER_LOCATION_MATCHER.reset((CharSequence)line);
                        while (SAMPLE_CENTER_LOCATION_MATCHER.find()) {
                            String sampleCenterLocationX = SAMPLE_CENTER_LOCATION_MATCHER.group(2);
                            String sampleCenterLocationY = SAMPLE_CENTER_LOCATION_MATCHER.group(5);
                            kla.setSampleCenterLocationX(Double.parseDouble(sampleCenterLocationX));
                            kla.setSampleCenterLocationY(Double.parseDouble(sampleCenterLocationY));
                        }
                        if (SAMPLE_CENTER_LOCATION_MATCHER.matches()) {
                            return;
                        }
                        CLASS_MATCHER.reset((CharSequence)line);
                        while (CLASS_MATCHER.find()) {
                            Integer classID = Integer.valueOf(CLASS_MATCHER.group(1));
                            String className = CLASS_MATCHER.group(2).replaceAll("\\\"", "");
                            DefectClass defectClass = new DefectClass(classID, className);
                            classes.add(defectClass);
                        }
                        if (CLASS_MATCHER.matches()) {
                            return;
                        }
                        SAMPLE_MATCHER.reset((CharSequence)line);
                        while (SAMPLE_MATCHER.find()) {
                            Integer indexX = Integer.valueOf(SAMPLE_MATCHER.group(1));
                            Integer indexY = Integer.valueOf(SAMPLE_MATCHER.group(2));
                            sampleTestPlan.add(new SampleTest(indexX, indexY));
                        }
                        if (CLASS_MATCHER.matches()) {
                            return;
                        }
                        INSPECTION_TEST_MATCHER.reset((CharSequence)line);
                        while (INSPECTION_TEST_MATCHER.find()) {
                            int inspectionTest = Integer.parseInt(INSPECTION_TEST_MATCHER.group(2));
                            kla.setInspectionTest(inspectionTest);
                        }
                        AREA_PER_TEST_MATCHER.reset((CharSequence)line);
                        while (AREA_PER_TEST_MATCHER.find()) {
                            double areaPerTest = Double.parseDouble(AREA_PER_TEST_MATCHER.group(2));
                            kla.setAreaPerTest(areaPerTest);
                        }
                        if (AREA_PER_TEST_MATCHER.matches()) {
                            return;
                        }
                        DEFECT_RECORD_SPEC_MATCHER.reset((CharSequence)line);
                        while (DEFECT_RECORD_SPEC_MATCHER.find()) {
                            String defectRecordSpec = DEFECT_RECORD_SPEC_MATCHER.group(2);
                            DEFECT_FIELD_MAP.clear();
                            AtomicInteger currentOffset = new AtomicInteger(1);
                            DefectRecordField.getAsList().forEach(field -> {
                                int index = defectRecordSpec.indexOf(field.name);
                                if (index != -1) {
                                    DEFECT_FIELD_MAP.put(index, (DefectRecordField)((Object)((Object)field)));
                                }
                            });
                            StringBuilder patternBuilder = new StringBuilder();
                            patternBuilder.append("^");
                            DEFECT_FIELD_MAP.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                                patternBuilder.append("\\s+").append(((DefectRecordField)((Object)((Object)((Object)entry.getValue())))).pattern);
                                GROUP_OFFSETS.put((DefectRecordField)((Object)((Object)((Object)entry.getValue()))), currentOffset.get());
                                currentOffset.set(currentOffset.get() + ((DefectRecordField)((Object)((Object)((Object)entry.getValue())))).groups);
                            });
                            kla.setDefectFieldMap(DEFECT_FIELD_MAP);
                            patternBuilder.append(";?");
                            defectPattern = Pattern.compile(patternBuilder.toString());
                            defectMatcher = defectPattern.matcher("");
                        }
                        if (DEFECT_RECORD_SPEC_MATCHER.matches()) {
                            return;
                        }
                        if (null != defectMatcher) {
                            defectMatcher.reset((CharSequence)line);
                            while (defectMatcher.find()) {
                                int defectID = Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.DEFECT_ID)));
                                DefectBuilder defectBuilder = DefectBuilder.create(defectID);
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.X_REL)) {
                                    defectBuilder.relX(Double.parseDouble(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.X_REL))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.Y_REL)) {
                                    defectBuilder.relY(Double.parseDouble(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.Y_REL))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.X_INDEX)) {
                                    defectBuilder.indexX(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.X_INDEX))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.Y_INDEX)) {
                                    defectBuilder.indexY(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.Y_INDEX))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.X_SIZE)) {
                                    defectBuilder.sizeX(Double.parseDouble(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.X_SIZE))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.Y_SIZE)) {
                                    defectBuilder.sizeY(Double.parseDouble(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.Y_SIZE))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.DEFECT_AREA)) {
                                    defectBuilder.defectArea(Double.parseDouble(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.DEFECT_AREA))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.D_SIZE)) {
                                    defectBuilder.sizeD(Double.parseDouble(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.D_SIZE))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.CLASS_NUMBER)) {
                                    defectBuilder.classNumber(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.CLASS_NUMBER))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.ROUGH_BIN_NUMBER)) {
                                    defectBuilder.fineBinNumber(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.ROUGH_BIN_NUMBER))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.FINE_BIN_NUMBER)) {
                                    defectBuilder.fineBinNumber(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.FINE_BIN_NUMBER))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.TEST)) {
                                    defectBuilder.test(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.TEST))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.CLUSTER_NUMBER)) {
                                    defectBuilder.clusterNumber(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.CLUSTER_NUMBER))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.IMAGE_COUNT)) {
                                    defectBuilder.imageCount(Integer.parseInt(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.IMAGE_COUNT))));
                                }
                                if (GROUP_OFFSETS.containsKey((Object)DefectRecordField.IMAGE_LIST)) {
                                    defectBuilder.imageList(defectMatcher.group(GROUP_OFFSETS.get((Object)DefectRecordField.IMAGE_LIST)).split("\\s+"));
                                }
                                Defect defect = defectBuilder.build();
                                defects.add(defect);
                            }
                            if (defectMatcher.matches()) {
                                return;
                            }
                        }
                        SUMMARY_SPEC_MATCHER.reset((CharSequence)line);
                        while (SUMMARY_SPEC_MATCHER.find()) {
                            String summarySpec = SUMMARY_SPEC_MATCHER.group(2);
                            kla.setSummarySpec(summarySpec);
                        }
                        if (SUMMARY_SPEC_MATCHER.matches()) {
                            return;
                        }
                        SUMMARY_MATCHER.reset((CharSequence)line);
                        while (SUMMARY_MATCHER.find()) {
                            int testNo = Integer.parseInt(SUMMARY_MATCHER.group(1));
                            int numberOfDefects = Integer.parseInt(SUMMARY_MATCHER.group(2));
                            double defectDensity = Double.parseDouble(SUMMARY_MATCHER.group(3));
                            int numberOfDies = Integer.parseInt(SUMMARY_MATCHER.group(4));
                            int numberOfDefectDies = Integer.parseInt(SUMMARY_MATCHER.group(5));
                            kla.setTestNo(testNo);
                            kla.setNumberOfDefects(numberOfDefects);
                            kla.setDefectDensity(defectDensity);
                            kla.setNumberOfDies(numberOfDies);
                            kla.setNumberOfDefectDies(numberOfDefectDies);
                        }
                        if (SUMMARY_MATCHER.matches()) {
                            return;
                        }
                        WAFER_STATUS_MATCHER.reset((CharSequence)line);
                        while (WAFER_STATUS_MATCHER.find()) {
                            String waferStatus = WAFER_STATUS_MATCHER.group(2);
                            kla.setWaferStatus(waferStatus);
                        }
                        if (WAFER_STATUS_MATCHER.matches()) {
                            return;
                        }
                    });
                    kla.setClasses(classes);
                    kla.setSampleTestPlan(sampleTestPlan);
                    kla.setDefects(defects);
                    optional = Optional.of(kla);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                stream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    static {
        DTF = DateTimeFormatter.ofPattern("MM-dd-yy HH:mm:ss");
        FILE_VERSION_PATTERN = Pattern.compile("^(FileVersion)\\s+([0-9]+)\\s+([0-9]+);");
        FILE_TIMESTAMP_PATTERN = Pattern.compile("^(FileTimestamp)\\s+([0-9]{2})-([0-9]{2})-([0-9]{2})\\s+([0-9]{2}):([0-9]{2}):([0-9]{2});");
        INSPECTION_STATION_ID_PATTERN = Pattern.compile("^(InspectionStationID)\\s+(\\\".*\\\")\\s+(\\\".*\\\")\\s+(\\\".*)\\\";$");
        SAMPLE_TYPE_PATTERN = Pattern.compile("^(SampleType)\\s+([a-zA-Z0-9]+);");
        RESULT_TIMESTAMP_PATTERN = Pattern.compile("^(ResultTimestamp)\\s+([0-9]{2})-([0-9]{2})-([0-9]{2})\\s+([0-9]{2}):([0-9]{2}):([0-9]{2});");
        LOT_ID_PATTERN = Pattern.compile("^(LotID)\\s+(.*);");
        SAMPLE_SIZE_PATTERN = Pattern.compile("^(SampleSize)\\s+([0-9]+)\\s+([0-9]+);");
        SETUP_ID_PATTERN = Pattern.compile("^(SetupID)\\s+(\\\"\\w+\\\")\\s+([0-9]{2})-([0-9]{2})-([0-9]{2})\\s+([0-9]{2}):([0-9]{2}):([0-9]{2});");
        STEP_ID_PATTERN = Pattern.compile("^(StepID)\\s+(.*);");
        SAMPLE_ORIENTATION_MARK_TYPE_PATTERN = Pattern.compile("^(SampleOrientationMarkType)\\s+([a-zA-Z0-9]+);");
        ORIENTATION_MARK_LOCATION_PATTERN = Pattern.compile("^(OrientationMarkLocation)\\s+([a-zA-Z0-9]+);");
        DIE_PITCH_PATTERN = Pattern.compile("^(DiePitch)\\s+([+|-]?(\\d+\\.\\d*(e[+|-][0-9]+)?))\\s+([+|-]?(\\d+\\.\\d*(e[+|-|-][0-9]+)?));");
        DIE_ORIGIN_PATTERN = Pattern.compile("^(DieOrigin)\\s+([+|-]?(\\d+\\.\\d*))\\s+([+|-]?(\\d+\\.\\d*));");
        WAFER_ID_PATTERN = Pattern.compile("^(WaferID)\\s+(.*);");
        SLOT_PATTERN = Pattern.compile("^(Slot)\\s+(.*);");
        SAMPLE_CENTER_LOCATION_PATTERN = Pattern.compile("^(SampleCenterLocation)\\s+([+|-]?(\\d+\\.\\d*(e[+|-|-][0-9]+)?))\\s+([+|-]?(\\d+\\.\\d*(e[+|-][0-9]+)?));");
        CLASS_PATTERN = Pattern.compile("^\\s([0-9]+)\\s+\"(.*)\";?");
        INSPECTION_TEST_PATTERN = Pattern.compile("^(InspectionTest)\\s+(.*);");
        SAMPLE_PATTERN = Pattern.compile("^\\s+(\\-?\\d+)\\s+(\\-?\\d+);?$");
        AREA_PER_TEST_PATTERN = Pattern.compile("^(AreaPerTest)\\s+(\\d+\\.\\d*(e[+|-|-][0-9]+)?);");
        DEFECT_RECORD_SPEC_PATTERN = Pattern.compile("^(DefectRecordSpec)\\s+(.*);");
        SUMMARY_SPEC_PATTERN = Pattern.compile("^(SummarySpec)\\s+(.*);");
        SUMMARY_PATTERN = Pattern.compile("^\\s([0-9]+)\\s+([0-9]+)\\s+(\\d+.\\d*)\\s+([0-9]+)\\s+([0-9]+);");
        WAFER_STATUS_PATTERN = Pattern.compile("^(WaferStatus)\\s+(.*);");
        FILE_VERSION_MATCHER = FILE_VERSION_PATTERN.matcher("");
        FILE_TIMESTAMP_MATCHER = FILE_TIMESTAMP_PATTERN.matcher("");
        INSPECTION_STATION_ID_MATCHER = INSPECTION_STATION_ID_PATTERN.matcher("");
        SAMPLE_TYPE_MATCHER = SAMPLE_TYPE_PATTERN.matcher("");
        RESULT_TIMESTAMP_MATCHER = RESULT_TIMESTAMP_PATTERN.matcher("");
        LOT_ID_MATCHER = LOT_ID_PATTERN.matcher("");
        SAMPLE_SIZE_MATCHER = SAMPLE_SIZE_PATTERN.matcher("");
        SETUP_ID_MATCHER = SETUP_ID_PATTERN.matcher("");
        STEP_ID_MATCHER = STEP_ID_PATTERN.matcher("");
        SAMPLE_ORIENTATION_MARK_TYPE_MATCHER = SAMPLE_ORIENTATION_MARK_TYPE_PATTERN.matcher("");
        ORIENTATION_MARK_LOCATION_MATCHER = ORIENTATION_MARK_LOCATION_PATTERN.matcher("");
        DIE_PITCH_MATCHER = DIE_PITCH_PATTERN.matcher("");
        DIE_ORIGIN_MATCHER = DIE_ORIGIN_PATTERN.matcher("");
        WAFER_ID_MATCHER = WAFER_ID_PATTERN.matcher("");
        SLOT_MATCHER = SLOT_PATTERN.matcher("");
        SAMPLE_CENTER_LOCATION_MATCHER = SAMPLE_CENTER_LOCATION_PATTERN.matcher("");
        CLASS_MATCHER = CLASS_PATTERN.matcher("");
        INSPECTION_TEST_MATCHER = INSPECTION_TEST_PATTERN.matcher("");
        SAMPLE_MATCHER = SAMPLE_PATTERN.matcher("");
        AREA_PER_TEST_MATCHER = AREA_PER_TEST_PATTERN.matcher("");
        DEFECT_RECORD_SPEC_MATCHER = DEFECT_RECORD_SPEC_PATTERN.matcher("");
        SUMMARY_SPEC_MATCHER = SUMMARY_SPEC_PATTERN.matcher("");
        SUMMARY_MATCHER = SUMMARY_PATTERN.matcher("");
        WAFER_STATUS_MATCHER = WAFER_STATUS_PATTERN.matcher("");
        GROUP_OFFSETS = new HashMap<DefectRecordField, Integer>();
        DEFECT_FIELD_MAP = new HashMap<Integer, DefectRecordField>();
    }
}

