/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.Line;
import eu.hansolo.fx.geometry.Path;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import java.util.NoSuchElementException;

class LineIterator
implements PathIterator {
    Line line;
    BaseTransform transform;
    int index;

    LineIterator(Line LINE, BaseTransform TRANSFORM) {
        this.line = LINE;
        this.transform = TRANSFORM;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public Path.WindingRule getWindingRule() {
        return Path.WindingRule.WIND_NON_ZERO;
    }

    @Override
    public int currentSegment(double[] COORDS) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        if (this.index == 0) {
            COORDS[0] = this.line.x1;
            COORDS[1] = this.line.y1;
            type = 0;
        } else {
            COORDS[0] = this.line.x2;
            COORDS[1] = this.line.y2;
            type = 1;
        }
        if (this.transform != null) {
            this.transform.transform(COORDS, 0, COORDS, 0, 1);
        }
        return type;
    }
}

