/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry.transform;

import eu.hansolo.fx.geometry.tools.NonInvertibleTransformException;
import eu.hansolo.fx.geometry.transform.AffineBase;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import eu.hansolo.toolboxfx.geom.Point;

public class Affine
extends AffineBase {
    private Affine(double mxx, double myx, double mxy, double myy, double mxt, double myt, int state) {
        this.mxx = mxx;
        this.myx = myx;
        this.mxy = mxy;
        this.myy = myy;
        this.mxt = mxt;
        this.myt = myt;
        this.state = state;
        this.type = -1;
    }

    public Affine() {
        this.myy = 1.0;
        this.mxx = 1.0;
    }

    public Affine(BaseTransform Tx) {
        this.setTransform(Tx);
    }

    public Affine(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.mxx = mxx;
        this.myx = myx;
        this.mxy = mxy;
        this.myy = myy;
        this.mxt = mxt;
        this.myt = myt;
        this.updateState();
    }

    @Override
    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.AFFINE;
    }

    public void rotate(double theta, double anchorx, double anchory) {
        this.translate(anchorx, anchory);
        this.rotate(theta);
        this.translate(-anchorx, -anchory);
    }

    public void rotate(double vecx, double vecy) {
        if (vecy == 0.0) {
            if (vecx < 0.0) {
                this.rotate180();
            }
        } else if (vecx == 0.0) {
            if (vecy > 0.0) {
                this.rotate90();
            } else {
                this.rotate270();
            }
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            double sin = vecy / len;
            double cos = vecx / len;
            double M0 = this.mxx;
            double M1 = this.mxy;
            this.mxx = cos * M0 + sin * M1;
            this.mxy = -sin * M0 + cos * M1;
            M0 = this.myx;
            M1 = this.myy;
            this.myx = cos * M0 + sin * M1;
            this.myy = -sin * M0 + cos * M1;
            this.updateState();
        }
    }

    public void rotate(double vecx, double vecy, double anchorx, double anchory) {
        this.translate(anchorx, anchory);
        this.rotate(vecx, vecy);
        this.translate(-anchorx, -anchory);
    }

    public void quadrantRotate(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                break;
            }
            case 1: {
                this.rotate90();
                break;
            }
            case 2: {
                this.rotate180();
                break;
            }
            case 3: {
                this.rotate270();
            }
        }
    }

    public void quadrantRotate(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                return;
            }
            case 1: {
                this.mxt += anchorx * (this.mxx - this.mxy) + anchory * (this.mxy + this.mxx);
                this.myt += anchorx * (this.myx - this.myy) + anchory * (this.myy + this.myx);
                this.rotate90();
                break;
            }
            case 2: {
                this.mxt += anchorx * (this.mxx + this.mxx) + anchory * (this.mxy + this.mxy);
                this.myt += anchorx * (this.myx + this.myx) + anchory * (this.myy + this.myy);
                this.rotate180();
                break;
            }
            case 3: {
                this.mxt += anchorx * (this.mxx + this.mxy) + anchory * (this.mxy - this.mxx);
                this.myt += anchorx * (this.myx + this.myy) + anchory * (this.myy - this.myx);
                this.rotate270();
            }
        }
        if (this.mxt == 0.0 && this.myt == 0.0) {
            this.state &= 0xFFFFFFFE;
            if (this.type != -1) {
                this.type &= 0xFFFFFFFE;
            }
        } else {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToTranslation(double tx, double ty) {
        this.mxx = 1.0;
        this.myx = 0.0;
        this.mxy = 0.0;
        this.myy = 1.0;
        this.mxt = tx;
        this.myt = ty;
        if (tx != 0.0 || ty != 0.0) {
            this.state = 1;
            this.type = 1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public void setToRotation(double theta) {
        double cos;
        double sin = Math.sin(theta);
        if (sin == 1.0 || sin == -1.0) {
            cos = 0.0;
            this.state = 4;
            this.type = 8;
        } else {
            cos = Math.cos(theta);
            if (cos == -1.0) {
                sin = 0.0;
                this.state = 2;
                this.type = 8;
            } else if (cos == 1.0) {
                sin = 0.0;
                this.state = 0;
                this.type = 0;
            } else {
                this.state = 6;
                this.type = 16;
            }
        }
        this.mxx = cos;
        this.myx = sin;
        this.mxy = -sin;
        this.myy = cos;
        this.mxt = 0.0;
        this.myt = 0.0;
    }

    public void setToRotation(double theta, double anchorx, double anchory) {
        this.setToRotation(theta);
        double sin = this.myx;
        double oneMinusCos = 1.0 - this.mxx;
        this.mxt = anchorx * oneMinusCos + anchory * sin;
        this.myt = anchory * oneMinusCos - anchorx * sin;
        if (this.mxt != 0.0 || this.myt != 0.0) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToRotation(double vecx, double vecy) {
        double cos;
        double sin;
        if (vecy == 0.0) {
            sin = 0.0;
            if (vecx < 0.0) {
                cos = -1.0;
                this.state = 2;
                this.type = 8;
            } else {
                cos = 1.0;
                this.state = 0;
                this.type = 0;
            }
        } else if (vecx == 0.0) {
            cos = 0.0;
            sin = vecy > 0.0 ? 1.0 : -1.0;
            this.state = 4;
            this.type = 8;
        } else {
            double len = Math.sqrt(vecx * vecx + vecy * vecy);
            cos = vecx / len;
            sin = vecy / len;
            this.state = 6;
            this.type = 16;
        }
        this.mxx = cos;
        this.myx = sin;
        this.mxy = -sin;
        this.myy = cos;
        this.mxt = 0.0;
        this.myt = 0.0;
    }

    public void setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        this.setToRotation(vecx, vecy);
        double sin = this.myx;
        double oneMinusCos = 1.0 - this.mxx;
        this.mxt = anchorx * oneMinusCos + anchory * sin;
        this.myt = anchory * oneMinusCos - anchorx * sin;
        if (this.mxt != 0.0 || this.myt != 0.0) {
            this.state |= 1;
            this.type |= 1;
        }
    }

    public void setToQuadrantRotation(int numquadrants) {
        switch (numquadrants & 3) {
            case 0: {
                this.mxx = 1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = 1.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 0;
                this.type = 0;
                break;
            }
            case 1: {
                this.mxx = 0.0;
                this.myx = 1.0;
                this.mxy = -1.0;
                this.myy = 0.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 4;
                this.type = 8;
                break;
            }
            case 2: {
                this.mxx = -1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = -1.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 2;
                this.type = 8;
                break;
            }
            case 3: {
                this.mxx = 0.0;
                this.myx = -1.0;
                this.mxy = 1.0;
                this.myy = 0.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 4;
                this.type = 8;
            }
        }
    }

    public void setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        switch (numquadrants & 3) {
            case 0: {
                this.mxx = 1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = 1.0;
                this.mxt = 0.0;
                this.myt = 0.0;
                this.state = 0;
                this.type = 0;
                break;
            }
            case 1: {
                this.mxx = 0.0;
                this.myx = 1.0;
                this.mxy = -1.0;
                this.myy = 0.0;
                this.mxt = anchorx + anchory;
                this.myt = anchory - anchorx;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 4;
                    this.type = 8;
                    break;
                }
                this.state = 5;
                this.type = 9;
                break;
            }
            case 2: {
                this.mxx = -1.0;
                this.myx = 0.0;
                this.mxy = 0.0;
                this.myy = -1.0;
                this.mxt = anchorx + anchorx;
                this.myt = anchory + anchory;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 2;
                    this.type = 8;
                    break;
                }
                this.state = 3;
                this.type = 9;
                break;
            }
            case 3: {
                this.mxx = 0.0;
                this.myx = -1.0;
                this.mxy = 1.0;
                this.myy = 0.0;
                this.mxt = anchorx - anchory;
                this.myt = anchory + anchorx;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 4;
                    this.type = 8;
                    break;
                }
                this.state = 5;
                this.type = 9;
            }
        }
    }

    public void setToScale(double sx, double sy) {
        this.mxx = sx;
        this.myx = 0.0;
        this.mxy = 0.0;
        this.myy = sy;
        this.mxt = 0.0;
        this.myt = 0.0;
        if (sx != 1.0 || sy != 1.0) {
            this.state = 2;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    @Override
    public void setTransform(BaseTransform Tx) {
        switch (Tx.getDegree()) {
            case IDENTITY: {
                this.setToIdentity();
                break;
            }
            case TRANSLATE: {
                this.setToTranslation(Tx.getMxt(), Tx.getMyt());
                break;
            }
            default: {
                if (Tx.getType() > 127) {
                    System.out.println(String.valueOf(Tx) + " is " + Tx.getType());
                    System.out.print("  " + Tx.getMxx());
                    System.out.print(", " + Tx.getMxy());
                    System.out.print(", " + Tx.getMxz());
                    System.out.print(", " + Tx.getMxt());
                    System.out.println();
                    System.out.print("  " + Tx.getMyx());
                    System.out.print(", " + Tx.getMyy());
                    System.out.print(", " + Tx.getMyz());
                    System.out.print(", " + Tx.getMyt());
                    System.out.println();
                    System.out.print("  " + Tx.getMzx());
                    System.out.print(", " + Tx.getMzy());
                    System.out.print(", " + Tx.getMzz());
                    System.out.print(", " + Tx.getMzt());
                    System.out.println();
                    Affine.degreeError(BaseTransform.Degree.AFFINE);
                }
            }
            case AFFINE: {
                this.mxx = Tx.getMxx();
                this.myx = Tx.getMyx();
                this.mxy = Tx.getMxy();
                this.myy = Tx.getMyy();
                this.mxt = Tx.getMxt();
                this.myt = Tx.getMyt();
                if (Tx instanceof AffineBase) {
                    this.state = ((AffineBase)Tx).state;
                    this.type = ((AffineBase)Tx).type;
                    break;
                }
                this.updateState();
            }
        }
    }

    public void preConcatenate(BaseTransform Tx) {
        switch (Tx.getDegree()) {
            case IDENTITY: {
                return;
            }
            case TRANSLATE: {
                this.translate(Tx.getMxt(), Tx.getMyt());
                return;
            }
            case AFFINE: {
                break;
            }
            default: {
                Affine.degreeError(BaseTransform.Degree.AFFINE);
            }
        }
        int mystate = this.state;
        Affine at = (Affine)Tx;
        int txstate = at.state;
        switch (txstate << 4 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                this.mxt = at.mxt;
                this.myt = at.myt;
                this.state = mystate | 1;
                this.type |= 1;
                return;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                this.mxt += at.mxt;
                this.myt += at.myt;
                return;
            }
            case 32: 
            case 33: {
                this.state = mystate | 2;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                double Txx = at.mxx;
                double Tyy = at.myy;
                if ((mystate & 4) != 0) {
                    this.mxy *= Txx;
                    this.myx *= Tyy;
                    if ((mystate & 2) != 0) {
                        this.mxx *= Txx;
                        this.myy *= Tyy;
                    }
                } else {
                    this.mxx *= Txx;
                    this.myy *= Tyy;
                }
                if ((mystate & 1) != 0) {
                    this.mxt *= Txx;
                    this.myt *= Tyy;
                }
                this.type = -1;
                return;
            }
            case 68: 
            case 69: {
                mystate |= 2;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                this.state = mystate ^ 4;
            }
            case 70: 
            case 71: {
                double Txy = at.mxy;
                double Tyx = at.myx;
                double M0 = this.mxx;
                this.mxx = this.myx * Txy;
                this.myx = M0 * Tyx;
                M0 = this.mxy;
                this.mxy = this.myy * Txy;
                this.myy = M0 * Tyx;
                M0 = this.mxt;
                this.mxt = this.myt * Txy;
                this.myt = M0 * Tyx;
                this.type = -1;
                return;
            }
        }
        double Txx = at.mxx;
        double Txy = at.mxy;
        double Txt = at.mxt;
        double Tyx = at.myx;
        double Tyy = at.myy;
        double Tyt = at.myt;
        switch (mystate) {
            default: {
                Affine.stateError();
            }
            case 7: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 6: {
                this.mxt = Txt;
                this.myt = Tyt;
                double M0 = this.mxx;
                double M1 = this.myx;
                this.mxx = M0 * Txx + M1 * Txy;
                this.myx = M0 * Tyx + M1 * Tyy;
                M0 = this.mxy;
                M1 = this.myy;
                this.mxy = M0 * Txx + M1 * Txy;
                this.myy = M0 * Tyx + M1 * Tyy;
                break;
            }
            case 5: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 4: {
                this.mxt = Txt;
                this.myt = Tyt;
                double M0 = this.myx;
                this.mxx = M0 * Txy;
                this.myx = M0 * Tyy;
                M0 = this.mxy;
                this.mxy = M0 * Txx;
                this.myy = M0 * Tyx;
                break;
            }
            case 3: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 2: {
                this.mxt = Txt;
                this.myt = Tyt;
                double M0 = this.mxx;
                this.mxx = M0 * Txx;
                this.myx = M0 * Tyx;
                M0 = this.myy;
                this.mxy = M0 * Txy;
                this.myy = M0 * Tyy;
                break;
            }
            case 1: {
                double M0 = this.mxt;
                double M1 = this.myt;
                Txt += M0 * Txx + M1 * Txy;
                Tyt += M0 * Tyx + M1 * Tyy;
            }
            case 0: {
                this.mxt = Txt;
                this.myt = Tyt;
                this.mxx = Txx;
                this.myx = Tyx;
                this.mxy = Txy;
                this.myy = Tyy;
                this.state = mystate | txstate;
                this.type = -1;
                return;
            }
        }
        this.updateState();
    }

    @Override
    public Affine createInverse() throws NonInvertibleTransformException {
        switch (this.state) {
            default: {
                Affine.stateError();
            }
            case 7: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NonInvertibleTransformException("Determinant is " + det);
                }
                return new Affine(this.myy / det, -this.myx / det, -this.mxy / det, this.mxx / det, (this.mxy * this.myt - this.myy * this.mxt) / det, (this.myx * this.mxt - this.mxx * this.myt) / det, 7);
            }
            case 6: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NonInvertibleTransformException("Determinant is " + det);
                }
                return new Affine(this.myy / det, -this.myx / det, -this.mxy / det, this.mxx / det, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Affine(0.0, 1.0 / this.mxy, 1.0 / this.myx, 0.0, -this.myt / this.myx, -this.mxt / this.mxy, 5);
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Affine(0.0, 1.0 / this.mxy, 1.0 / this.myx, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Affine(1.0 / this.mxx, 0.0, 0.0, 1.0 / this.myy, -this.mxt / this.mxx, -this.myt / this.myy, 3);
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NonInvertibleTransformException("Determinant is 0");
                }
                return new Affine(1.0 / this.mxx, 0.0, 0.0, 1.0 / this.myy, 0.0, 0.0, 2);
            }
            case 1: {
                return new Affine(1.0, 0.0, 0.0, 1.0, -this.mxt, -this.myt, 1);
            }
            case 0: 
        }
        return new Affine();
    }

    public void transform(Point[] ptSrc, int srcOff, Point[] ptDst, int dstOff, int numPts) {
        int mystate = this.state;
        block10: while (--numPts >= 0) {
            Point dst;
            Point src = ptSrc[srcOff++];
            double x = src.x;
            double y = src.y;
            if ((dst = ptDst[dstOff++]) == null) {
                ptDst[dstOff - 1] = dst = new Point();
            }
            switch (mystate) {
                default: {
                    Affine.stateError();
                }
                case 7: {
                    dst.set(x * this.mxx + y * this.mxy + this.mxt, x * this.myx + y * this.myy + this.myt);
                    continue block10;
                }
                case 6: {
                    dst.set(x * this.mxx + y * this.mxy, x * this.myx + y * this.myy);
                    continue block10;
                }
                case 5: {
                    dst.set(y * this.mxy + this.mxt, x * this.myx + this.myt);
                    continue block10;
                }
                case 4: {
                    dst.set(y * this.mxy, x * this.myx);
                    continue block10;
                }
                case 3: {
                    dst.set(x * this.mxx + this.mxt, y * this.myy + this.myt);
                    continue block10;
                }
                case 2: {
                    dst.set(x * this.mxx, y * this.myy);
                    continue block10;
                }
                case 1: {
                    dst.set(x + this.mxt, y + this.myt);
                    continue block10;
                }
                case 0: 
            }
            dst.set(x, y);
        }
    }

    public Point deltaTransform(Point ptSrc, Point ptDst) {
        if (ptDst == null) {
            ptDst = new Point();
        }
        double x = ptSrc.x;
        double y = ptSrc.y;
        switch (this.state) {
            default: {
                Affine.stateError();
            }
            case 6: 
            case 7: {
                ptDst.set(x * this.mxx + y * this.mxy, x * this.myx + y * this.myy);
                return ptDst;
            }
            case 4: 
            case 5: {
                ptDst.set(y * this.mxy, x * this.myx);
                return ptDst;
            }
            case 2: 
            case 3: {
                ptDst.set(x * this.mxx, y * this.myy);
                return ptDst;
            }
            case 0: 
            case 1: 
        }
        ptDst.set(x, y);
        return ptDst;
    }

    private static double _matRound(double value) {
        return Math.rint(value * 1.0E15) / 1.0E15;
    }

    @Override
    public void restoreTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public void restoreTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz != 0.0 || myz != 0.0 || mzx != 0.0 || mzy != 0.0 || mzz != 1.0 || mzt != 0.0) {
            Affine.degreeError(BaseTransform.Degree.AFFINE);
        }
        this.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt) {
        this.translate(mxt, myt);
        return this;
    }

    @Override
    public BaseTransform deriveWithPreTranslation(double mxt, double myt) {
        this.mxt += mxt;
        this.myt += myt;
        if (this.mxt != 0.0 || this.myt != 0.0) {
            this.state |= 1;
            this.type |= 1;
        } else {
            this.state &= 0xFFFFFFFE;
            if (this.type != -1) {
                this.type &= 0xFFFFFFFE;
            }
        }
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        BaseTransform tmpTx = Affine.getInstance(mxx, myx, mxy, myy, mxt, myt);
        this.concatenate(tmpTx);
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(BaseTransform tx) {
        this.concatenate(tx);
        return this;
    }

    @Override
    public BaseTransform deriveWithPreConcatenation(BaseTransform tx) {
        this.preConcatenate(tx);
        return this;
    }

    @Override
    public BaseTransform deriveWithNewTransform(BaseTransform tx) {
        this.setTransform(tx);
        return this;
    }

    @Override
    public BaseTransform copy() {
        return new Affine(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseTransform) {
            BaseTransform a = (BaseTransform)obj;
            return a.getType() <= 127 && a.getMxx() == this.mxx && a.getMxy() == this.mxy && a.getMxt() == this.mxt && a.getMyx() == this.myx && a.getMyy() == this.myy && a.getMyt() == this.myt;
        }
        return false;
    }
}

