/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.paint.Color;

public class Category
implements Comparable<Category> {
    private final ChartEvt UPDATE_EVT = new ChartEvt(this, ChartEvt.UPDATE);
    private final String name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Color _textFill;
    private ObjectProperty<Color> textFill;
    private double _value;
    private DoubleProperty value;
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;

    public Category(String name) {
        this(name, Color.LIGHTGRAY, Color.TRANSPARENT, Color.BLACK);
    }

    public Category(String name, Color fill) {
        this(name, fill, Color.TRANSPARENT, Color.BLACK);
    }

    public Category(String name, Color fill, Color stroke, Color textFill) {
        this.name = name;
        this._fill = fill;
        this._stroke = stroke;
        this._textFill = textFill;
        this._value = 0.0;
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    }

    public String getName() {
        return this.name;
    }

    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color fill) {
        if (null == this.fill) {
            this._fill = fill;
            this.fireChartEvt(this.UPDATE_EVT);
        } else {
            this.fill.set((Object)fill);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    Category.this.fireChartEvt(Category.this.UPDATE_EVT);
                }

                public Object getBean() {
                    return Category.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color stroke) {
        if (null == this.stroke) {
            this._stroke = stroke;
            this.fireChartEvt(this.UPDATE_EVT);
        } else {
            this.stroke.set((Object)stroke);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    Category.this.fireChartEvt(Category.this.UPDATE_EVT);
                }

                public Object getBean() {
                    return Category.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getTextFill() {
        return null == this.textFill ? this._textFill : (Color)this.textFill.get();
    }

    public void setTextFill(Color textFill) {
        if (null == this.textFill) {
            this._textFill = textFill;
            this.fireChartEvt(this.UPDATE_EVT);
        } else {
            this.textFill.set((Object)textFill);
        }
    }

    public ObjectProperty<Color> textFillProperty() {
        if (null == this.textFill) {
            this.textFill = new ObjectPropertyBase<Color>(this._textFill){

                protected void invalidated() {
                    Category.this.fireChartEvt(Category.this.UPDATE_EVT);
                }

                public Object getBean() {
                    return Category.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
            this._textFill = null;
        }
        return this.textFill;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double value) {
        if (null == this.value) {
            this._value = value;
            this.fireChartEvt(this.UPDATE_EVT);
        } else {
            this.value.set(value);
        }
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    Category.this.fireChartEvt(Category.this.UPDATE_EVT);
                }

                public Object getBean() {
                    return Category.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    @Override
    public int compareTo(Category other) {
        return this.getName().compareTo(other.getName());
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

