/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.CoxcombChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class CoxcombChartBuilder<B extends CoxcombChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected CoxcombChartBuilder() {
    }

    public static final CoxcombChartBuilder create() {
        return new CoxcombChartBuilder();
    }

    public final B items(ChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B order(Order ORDER) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B autoTextColor(boolean AUTO) {
        this.properties.put("autoTextColor", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B useChartItemTextFill(boolean USE) {
        this.properties.put("useChartItemTextFill", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B equalSegmentAngles(boolean EQUAL) {
        this.properties.put("equalSegmentAngles", (Property)new SimpleBooleanProperty(EQUAL));
        return (B)this;
    }

    public final B onMousePressed(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("onMousePressed", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B onMouseReleased(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("onMouseReleased", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B onMouseMoved(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("onMouseMoved", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B showPopup(boolean SHOW) {
        this.properties.put("showPopup", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B formatString(String FORMAT_STRING) {
        this.properties.put("formatString", (Property)new SimpleStringProperty(FORMAT_STRING));
        return (B)this;
    }

    public final B showItemName(boolean SHOW) {
        this.properties.put("showItemName", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B selectedItemFill(Color SELECTED_ITEM_FILL) {
        this.properties.put("selectedItemFill", (Property)new SimpleObjectProperty((Object)SELECTED_ITEM_FILL));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final CoxcombChart build() {
        CoxcombChart control = new CoxcombChart();
        if (this.properties.keySet().contains("itemsArray")) {
            control.setItems((ChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            control.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "textColor": {
                    control.setTextColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "order": {
                    control.setOrder((Order)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "autoTextColor": {
                    control.setAutoTextColor(((BooleanProperty)property).get());
                    break;
                }
                case "useChartItemTextFill": {
                    control.setUseChartItemTextFill(((BooleanProperty)property).get());
                    break;
                }
                case "equalSegmentAngles": {
                    control.setEqualSegmentAngles(((BooleanProperty)property).get());
                    break;
                }
                case "onMousePressed": {
                    control.onMousePressed((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "onMouseReleased": {
                    control.onMouseReleased((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "onMouseMoved": {
                    control.onMouseMoved((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "showPopup": {
                    control.setShowPopup(((BooleanProperty)property).get());
                    break;
                }
                case "formatString": {
                    control.setFormatString((String)((StringProperty)property).get());
                    break;
                }
                case "showItemName": {
                    control.setShowItemName(((BooleanProperty)property).get());
                    break;
                }
                case "selectedItemFill": {
                    control.setSelectedItemFill((Color)((ObjectProperty)property).get());
                }
            }
        });
        return control;
    }
}

