/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Category;
import eu.hansolo.fx.charts.PanelBarChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class PanelBarChartBuilder<B extends PanelBarChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private List<? extends Category> categories;

    protected PanelBarChartBuilder(List<? extends Category> categories) {
        this.categories = categories;
    }

    public static final PanelBarChartBuilder create(List<? extends Category> categories) {
        if (null == categories) {
            throw new IllegalArgumentException("categories cannot be null");
        }
        return new PanelBarChartBuilder(categories);
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B nameColor(Color COLOR) {
        this.properties.put("nameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B listOfSeries(ChartItemSeries<ChartItem> ... SERIES) {
        return this.listOfSeries(Arrays.asList(SERIES));
    }

    public final B listOfSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        this.properties.put("chartItemSeriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B chartBackground(Color COLOR) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B categoryNameColor(Color COLOR) {
        this.properties.put("categoryNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B categorySumColor(Color COLOR) {
        this.properties.put("categorySumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B seriesNameColor(Color COLOR) {
        this.properties.put("seriesNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B seriesSumColor(Color COLOR) {
        this.properties.put("seriesSumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B gridColor(Color COLOR) {
        this.properties.put("gridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B colorByCategory(boolean COLOR_BY_CATEGORY) {
        this.properties.put("colorByCategory", (Property)new SimpleBooleanProperty(COLOR_BY_CATEGORY));
        return (B)this;
    }

    public final B comparisonEnabled(boolean ENABLED) {
        this.properties.put("comparisonEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B comparisonName(String NAME) {
        this.properties.put("comparisonName", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B comparisonNameColor(Color COLOR) {
        this.properties.put("comparisonNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B comparisonListOfSeries(ChartItemSeries<ChartItem> ... SERIES) {
        return this.comparisonListOfSeries(Arrays.asList(SERIES));
    }

    public final B comparisonListOfSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        this.properties.put("comparisonChartItemSeriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B comparisonCategorySumColor(Color COLOR) {
        this.properties.put("comparisonCategorySumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B comparisonSeriesNameColor(Color COLOR) {
        this.properties.put("comparisonSeriesNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B comparisonSeriesSumColor(Color COLOR) {
        this.properties.put("comparisonSeriesSumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final PanelBarChart build() {
        ArrayList<ChartItemSeries<ChartItem>> listOfSeries = new ArrayList<ChartItemSeries<ChartItem>>();
        if (this.properties.keySet().contains("chartItemSeriesList")) {
            listOfSeries.addAll((Collection)((ObjectProperty)this.properties.get("chartItemSeriesList")).get());
        }
        PanelBarChart control = new PanelBarChart(this.categories, listOfSeries);
        ArrayList<ChartItemSeries<ChartItem>> comparisonListOfSeries = new ArrayList<ChartItemSeries<ChartItem>>();
        if (this.properties.keySet().contains("comparisonChartItemSeriesList")) {
            comparisonListOfSeries.addAll((Collection)((ObjectProperty)this.properties.get("comparisonChartItemSeriesList")).get());
        }
        control.setComparisonListOfSeries(comparisonListOfSeries);
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "chartBackground": {
                    control.setChartBackground((Paint)((ObjectProperty)property).get());
                    break;
                }
                case "name": {
                    control.setName((String)((StringProperty)property).get());
                    break;
                }
                case "nameColor": {
                    control.setNameColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "categoryNameColor": {
                    control.setCategoryNameColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "categorySumColor": {
                    control.setCategorySumColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "seriesNameColor": {
                    control.setSeriesNameColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "seriesSumColor": {
                    control.setSeriesSumColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "gridColor": {
                    control.setGridColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "colorByCategory": {
                    control.setColorByCategory(((BooleanProperty)property).get());
                    break;
                }
                case "comparisonEnabled": {
                    control.setComparisonEnabled(((BooleanProperty)property).get());
                    break;
                }
                case "comparisonName": {
                    control.setComparisonName((String)((StringProperty)property).get());
                    break;
                }
                case "comparisonNameColor": {
                    control.setComparisonNameColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "comparisonCategorySumColor": {
                    control.setComparisonCategorySumColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "comparisonSeriesNameColor": {
                    control.setComparisonSeriesNameColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "comparisonSeriesSumColor": {
                    control.setComparisonSeriesSumColor((Color)((ObjectProperty)property).get());
                }
            }
        });
        return control;
    }
}

