/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.SankeyPlot;
import eu.hansolo.fx.charts.data.PlotItem;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class SankeyPlotBuilder<B extends SankeyPlotBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SankeyPlotBuilder() {
    }

    public static final SankeyPlotBuilder create() {
        return new SankeyPlotBuilder();
    }

    public final B items(PlotItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<PlotItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B streamFillMode(SankeyPlot.StreamFillMode MODE) {
        this.properties.put("streamFillMode", (Property)new SimpleObjectProperty((Object)MODE));
        return (B)this;
    }

    public final B streamColor(Color COLOR) {
        this.properties.put("streamColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectionColor(Color COLOR) {
        this.properties.put("selectionColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B showFlowDirection(boolean SHOW) {
        this.properties.put("showFlowDirection", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B itemWidth(int WIDTH) {
        this.properties.put("itemWidth", (Property)new SimpleIntegerProperty(WIDTH));
        return (B)this;
    }

    public final B autoItemWidth(boolean AUTO) {
        this.properties.put("autoItemWidth", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B itemGap(int GAP) {
        this.properties.put("itemGap", (Property)new SimpleIntegerProperty(GAP));
        return (B)this;
    }

    public final B autoItemGap(boolean AUTO) {
        this.properties.put("autoItemGap", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B useItemColor(boolean USE) {
        this.properties.put("useItemColor", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B itemColor(Color COLOR) {
        this.properties.put("itemColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B connectionOpacity(double OPACITY) {
        this.properties.put("connectionOpacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B useCustomFont(boolean useCustomFont) {
        this.properties.put("useCustomFont", (Property)new SimpleBooleanProperty(useCustomFont));
        return (B)this;
    }

    public final B customFont(Font customFont) {
        this.properties.put("customFont", (Property)new SimpleObjectProperty((Object)customFont));
        return (B)this;
    }

    public final B useItemTextColor(boolean useItemTextColor) {
        this.properties.put("useItemTextColor", (Property)new SimpleBooleanProperty(useItemTextColor));
        return (B)this;
    }

    public final B autoAdjustVerticalTextPosition(boolean autoAdjustVerticalTextPosition) {
        this.properties.put("autoAdjustVerticalTextPosition", (Property)new SimpleBooleanProperty(autoAdjustVerticalTextPosition));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final SankeyPlot build() {
        SankeyPlot control = new SankeyPlot();
        if (this.properties.keySet().contains("itemsArray")) {
            control.setItems((PlotItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            control.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "streamFillMode": {
                    control.setStreamFillMode((SankeyPlot.StreamFillMode)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "streamColor": {
                    control.setStreamColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "textColor": {
                    control.setTextColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "selectionColor": {
                    control.setSelectionColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "decimals": {
                    control.setDecimals(((IntegerProperty)property).get());
                    break;
                }
                case "showFlowDirection": {
                    control.setShowFlowDirection(((BooleanProperty)property).get());
                    break;
                }
                case "itemWidth": {
                    control.setItemWidth(((IntegerProperty)property).get());
                    break;
                }
                case "autoItemWidth": {
                    control.setAutoItemWidth(((BooleanProperty)property).get());
                    break;
                }
                case "itemGap": {
                    control.setItemGap(((IntegerProperty)property).get());
                    break;
                }
                case "autoItemGap": {
                    control.setAutoItemGap(((BooleanProperty)property).get());
                    break;
                }
                case "useItemColor": {
                    control.setUseItemColor(((BooleanProperty)property).get());
                    break;
                }
                case "itemColor": {
                    control.setItemColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "connectionOpacity": {
                    control.setConnectionOpacity(((DoubleProperty)property).get());
                    break;
                }
                case "locale": {
                    control.setLocale((Locale)((ObjectProperty)property).get());
                    break;
                }
                case "useCustomFont": {
                    control.setUseCustomFont(((BooleanProperty)property).get());
                    break;
                }
                case "customFont": {
                    control.setCustomFont((Font)((ObjectProperty)property).get());
                    break;
                }
                case "useItemTextColor": {
                    control.setUseItemTextColor(((BooleanProperty)property).get());
                    break;
                }
                case "autoAdjustVerticalTextPosition": {
                    control.setAutoAdjustVerticalTextPosition(((BooleanProperty)property).get());
                }
            }
        });
        return control;
    }
}

