/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.tools.Helper;
import java.awt.image.BufferedImage;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class WaffleChart
extends Region {
    public static final Color DEFAULT_BACKGROUND_FILL = Color.web((String)"#f0f0f0");
    public static final Color DEFAULT_EMPTY_CELL_FILL = Color.web((String)"#cdcdcd");
    public static final Color DEFAULT_CELL_FILL = Color.web((String)"#3ca9e2");
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private double _value;
    private DoubleProperty value;
    private Paint _backgroundFill;
    private ObjectProperty<Paint> backgroundFill;
    private Paint _cellFill;
    private ObjectProperty<Paint> cellFill;
    private Paint _emptyCellFill;
    private ObjectProperty<Paint> emptyCellFill;
    private double inset;
    private double chartSize;
    private double gap;
    private double cellSize;
    private double cellRadius;

    public WaffleChart() {
        this(0.0);
    }

    public WaffleChart(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Value must be between 0...1");
        }
        this._value = value;
        this._backgroundFill = DEFAULT_BACKGROUND_FILL;
        this._emptyCellFill = DEFAULT_EMPTY_CELL_FILL;
        this._cellFill = DEFAULT_CELL_FILL;
        this.inset = 5.0;
        this.chartSize = 250.0 - 2.0 * this.inset;
        this.gap = 1.0;
        this.cellSize = (this.chartSize - 9.0 * this.gap) / 10.0;
        this.cellRadius = this.cellSize * 0.25;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"comparison-ring-chart");
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 4096.0;
    }

    protected double computeMaxHeight(double width) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Value must be between 0...1");
        }
        if (null == this.value) {
            this._value = value;
            this.redraw();
        } else {
            this.value.set(value);
        }
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    if (this.get() < 0.0 || this.get() > 1.0) {
                        throw new IllegalArgumentException("Value must be between 0...1");
                    }
                    WaffleChart.this.redraw();
                }

                public Object getBean() {
                    return WaffleChart.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public Paint getBackgroundFill() {
        return null == this.backgroundFill ? this._backgroundFill : (Paint)this.backgroundFill.get();
    }

    public void setBackgroundFill(Paint backgroundFill) {
        if (null == this.backgroundFill) {
            this._backgroundFill = backgroundFill;
            this.redraw();
        } else {
            this.backgroundFill.set((Object)backgroundFill);
        }
    }

    public ObjectProperty<Paint> backgroundFillProperty() {
        if (null == this.backgroundFill) {
            this.backgroundFill = new ObjectPropertyBase<Paint>(this._backgroundFill){

                protected void invalidated() {
                    WaffleChart.this.redraw();
                }

                public Object getBean() {
                    return WaffleChart.this;
                }

                public String getName() {
                    return "backgroundFill";
                }
            };
            this._backgroundFill = null;
        }
        return this.backgroundFill;
    }

    public Paint getCellFill() {
        return null == this.cellFill ? this._cellFill : (Paint)this.cellFill.get();
    }

    public void setCellFill(Paint cellFill) {
        if (null == this.cellFill) {
            this._cellFill = cellFill;
            this.redraw();
        } else {
            this.cellFill.set((Object)cellFill);
        }
    }

    public ObjectProperty<Paint> cellFillProperty() {
        if (null == this.cellFill) {
            this.cellFill = new ObjectPropertyBase<Paint>(this._cellFill){

                protected void invalidated() {
                    WaffleChart.this.redraw();
                }

                public Object getBean() {
                    return WaffleChart.this;
                }

                public String getName() {
                    return "cellFill";
                }
            };
            this._cellFill = null;
        }
        return this.cellFill;
    }

    public Paint getEmptyCellFill() {
        return null == this.emptyCellFill ? this._emptyCellFill : (Paint)this.emptyCellFill.get();
    }

    public void setEmptyCellFill(Paint emptyCellFill) {
        if (null == this.emptyCellFill) {
            this._emptyCellFill = emptyCellFill;
            this.redraw();
        } else {
            this.emptyCellFill.set((Object)emptyCellFill);
        }
    }

    public ObjectProperty<Paint> emptyCellFillProperty() {
        if (null == this.emptyCellFill) {
            this.emptyCellFill = new ObjectPropertyBase<Paint>(this._emptyCellFill){

                protected void invalidated() {
                    WaffleChart.this.redraw();
                }

                public Object getBean() {
                    return WaffleChart.this;
                }

                public String getName() {
                    return "emptyCellFill";
                }
            };
            this._emptyCellFill = null;
        }
        return this.emptyCellFill;
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    private void drawChart() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        Paint emptyCellFill = this.getEmptyCellFill();
        Paint cellFill = this.getCellFill();
        double value = this.getValue();
        long boxToChange = Math.round(100.0 * value);
        this.ctx.setFill(this.getBackgroundFill());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        double x = this.inset;
        double y = this.inset + (this.chartSize - this.cellSize);
        double xCounter = 0.0;
        for (int i = 0; i < 100; ++i) {
            this.ctx.setFill(value > 0.0 && (long)i <= boxToChange ? cellFill : emptyCellFill);
            this.ctx.fillRoundRect(x, y, this.cellSize, this.cellSize, this.cellRadius, this.cellRadius);
            x += this.gap + this.cellSize;
            if ((xCounter += 1.0) != 10.0) continue;
            xCounter = 0.0;
            x = this.inset;
            y -= this.gap + this.cellSize;
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.size = Math.min(this.width, this.height);
        if (this.width > 0.0 && this.height > 0.0) {
            this.chartSize = this.size - 2.0 * this.inset;
            this.gap = 1.0;
            this.cellSize = (this.chartSize - 9.0 * this.gap) / 10.0;
            this.cellRadius = this.cellSize * 0.25;
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

