/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.YPane;
import eu.hansolo.fx.charts.data.ValueItem;
import eu.hansolo.fx.charts.series.YSeries;
import eu.hansolo.fx.charts.tools.Helper;
import java.awt.image.BufferedImage;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;

public class YChart<T extends ValueItem>
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final Double AXIS_WIDTH = 25.0;
    private double width;
    private double height;
    private YPane<T> yPane;
    private String _title;
    private StringProperty title;
    private String _subTitle;
    private StringProperty subTitle;
    private AnchorPane pane;

    public YChart(YPane<T> Y_PANE) {
        if (null == Y_PANE) {
            throw new IllegalArgumentException("YPane has not to be null");
        }
        this.yPane = Y_PANE;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.validateSeries();
        this.pane = new AnchorPane(new Node[]{this.yPane});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
            this.yPane.redraw();
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    YChart.this.yPane.redraw();
                }

                public Object getBean() {
                    return YChart.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getSubTitle() {
        return null == this.subTitle ? this._subTitle : (String)this.subTitle.get();
    }

    public void setSubTitle(String SUB_TITLE) {
        if (null == this.subTitle) {
            this._subTitle = SUB_TITLE;
            this.yPane.redraw();
        } else {
            this.subTitle.set((Object)SUB_TITLE);
        }
    }

    public StringProperty subTitleProperty() {
        if (null == this.subTitle) {
            this.subTitle = new StringPropertyBase(this._subTitle){

                protected void invalidated() {
                    YChart.this.yPane.redraw();
                }

                public Object getBean() {
                    return YChart.this;
                }

                public String getName() {
                    return "subTitle";
                }
            };
            this._subTitle = null;
        }
        return this.subTitle;
    }

    public YPane<T> getYPane() {
        return this.yPane;
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    public void refresh() {
        this.yPane.redraw();
    }

    private void validateSeries() {
        List<YSeries<T>> listOfSeries = this.yPane.getListOfSeries();
        double MIN_VALUE = listOfSeries.stream().mapToDouble(YSeries::getMinY).min().getAsDouble();
        ChartType TYPE = listOfSeries.get(0).getChartType();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.yPane.setPrefSize(this.width, this.height);
        }
    }
}

