/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.areaheatmap;

import eu.hansolo.fx.charts.data.DataPoint;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.toolboxfx.font.Fonts;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class AreaHeatMap
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Color HALF_WHITE = Color.rgb((int)255, (int)255, (int)255, (double)0.5);
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private List<DataPoint> points = new ArrayList<DataPoint>();
    private List<DataPoint> polygon = new ArrayList<DataPoint>();
    private Quality _quality;
    private ObjectProperty<Quality> quality;
    private int _noOfCloserInfluentPoints;
    private IntegerProperty noOfCloserInfluentPoints;
    private double _heatMapOpacity;
    private DoubleProperty heatMapOpacity;
    private boolean _dataPointsVisible;
    private BooleanProperty dataPointsVisible;
    private boolean _discreteColors;
    private BooleanProperty discreteColors;
    private boolean _smoothedHull;
    private BooleanProperty smoothedHull;
    private Mapping _mapping;
    private ObjectProperty<Mapping> mapping;
    private boolean _useColorMapping;
    private BooleanProperty useColorMapping;
    private double minValue;
    private double maxValue;
    private double range;

    public AreaHeatMap() {
        this(5, Quality.STANDARD);
    }

    public AreaHeatMap(Quality quality) {
        this(5, quality);
    }

    public AreaHeatMap(int noOfCloserInfluentPoints, Quality quality) {
        this._quality = quality;
        this._noOfCloserInfluentPoints = noOfCloserInfluentPoints;
        this._heatMapOpacity = 0.5;
        this._dataPointsVisible = false;
        this._discreteColors = false;
        this._smoothedHull = false;
        this._mapping = ColorMapping.BLUE_CYAN_GREEN_YELLOW_RED;
        this._useColorMapping = true;
        this.minValue = Double.MAX_VALUE;
        this.maxValue = -1.7976931348623157E308;
        this.range = this.maxValue - this.minValue;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 1024.0;
    }

    protected double computeMaxHeight(double width) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public Quality getQuality() {
        return null == this.quality ? this._quality : (Quality)((Object)this.quality.get());
    }

    public void setQuality(Quality quality) {
        if (null == this.quality) {
            this._quality = quality;
            this.redraw();
        } else {
            this.quality.set((Object)quality);
        }
    }

    public ObjectProperty<Quality> qualityProperty() {
        if (null == this.quality) {
            this.quality = new ObjectPropertyBase<Quality>(this._quality){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "quality";
                }
            };
            this._quality = null;
        }
        return this.quality;
    }

    public int getNoOfCloserInfluentPoints() {
        return null == this.noOfCloserInfluentPoints ? this._noOfCloserInfluentPoints : this.noOfCloserInfluentPoints.get();
    }

    public void setNoOfCloserInfluentialPoints(int numberOfPoints) {
        if (null == this.noOfCloserInfluentPoints) {
            this._noOfCloserInfluentPoints = Helper.clamp(1, 10, numberOfPoints);
            this.redraw();
        } else {
            this.noOfCloserInfluentPoints.set(numberOfPoints);
        }
    }

    public IntegerProperty noOfCloserInfluentPointsProperty() {
        if (null == this.noOfCloserInfluentPoints) {
            this.noOfCloserInfluentPoints = new IntegerPropertyBase(this._noOfCloserInfluentPoints){

                protected void invalidated() {
                    this.set(Helper.clamp(1, 10, this.get()));
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "noOfCloserInfluentPoints";
                }
            };
        }
        return this.noOfCloserInfluentPoints;
    }

    public double getHeatMapOpacity() {
        return null == this.heatMapOpacity ? this._heatMapOpacity : this.heatMapOpacity.get();
    }

    public void setHeatMapOpacity(double opacity) {
        if (null == this.heatMapOpacity) {
            this._heatMapOpacity = Helper.clamp(0.0, 1.0, opacity);
            this.redraw();
        } else {
            this.heatMapOpacity.set(opacity);
        }
    }

    public DoubleProperty heatMapOpacityProperty() {
        if (null == this.heatMapOpacity) {
            this.heatMapOpacity = new DoublePropertyBase(this._heatMapOpacity){

                protected void invalidated() {
                    this.set(Helper.clamp(0.0, 1.0, this.get()));
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "heatMapOpacity";
                }
            };
        }
        return this.heatMapOpacity;
    }

    public boolean getShowDataPoints() {
        return null == this.dataPointsVisible ? this._dataPointsVisible : this.dataPointsVisible.get();
    }

    public void setDataPointsVisible(boolean visible) {
        if (null == this.dataPointsVisible) {
            this._dataPointsVisible = visible;
            this.redraw();
        } else {
            this.dataPointsVisible.set(visible);
        }
    }

    public BooleanProperty dataPointsVisibleProperty() {
        if (null == this.dataPointsVisible) {
            this.dataPointsVisible = new BooleanPropertyBase(this._dataPointsVisible){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "dataPointsVisible";
                }
            };
        }
        return this.dataPointsVisible;
    }

    public boolean isSmoothedHull() {
        return null == this.smoothedHull ? this._smoothedHull : this.smoothedHull.get();
    }

    public void setSmoothedHull(boolean smoothed) {
        if (null == this.smoothedHull) {
            this._smoothedHull = smoothed;
            this.createHullPolygon();
            this.redraw();
        } else {
            this.smoothedHull.set(smoothed);
        }
    }

    public BooleanProperty smoothedHullProperty() {
        if (null == this.smoothedHull) {
            this.smoothedHull = new BooleanPropertyBase(this._smoothedHull){

                protected void invalidated() {
                    AreaHeatMap.this.createHullPolygon();
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "smoothedHull";
                }
            };
        }
        return this.smoothedHull;
    }

    public boolean isDiscreteColors() {
        return null == this.discreteColors ? this._discreteColors : this.discreteColors.get();
    }

    public void setDiscreteColors(boolean discrete) {
        if (null == this.discreteColors) {
            this._discreteColors = discrete;
            this.redraw();
        } else {
            this.discreteColors.set(discrete);
        }
    }

    public BooleanProperty discreteColorsProperty() {
        if (null == this.discreteColors) {
            this.discreteColors = new BooleanPropertyBase(this._discreteColors){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "discreteColors";
                }
            };
        }
        return this.discreteColors;
    }

    public Mapping getMapping() {
        return null == this.mapping ? this._mapping : (Mapping)this.mapping.get();
    }

    public void setColorMapping(Mapping mapping) {
        if (null == this.mapping) {
            this._mapping = mapping;
            this.redraw();
        } else {
            this.mapping.set((Object)mapping);
        }
    }

    public ObjectProperty<Mapping> mappingProperty() {
        if (null == this.mapping) {
            this.mapping = new ObjectPropertyBase<Mapping>(this._mapping){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "mapping";
                }
            };
            this._mapping = null;
        }
        return this.mapping;
    }

    public boolean getUseColorMapping() {
        return null == this.useColorMapping ? this._useColorMapping : this.useColorMapping.get();
    }

    public void setUseColorMapping(boolean use) {
        if (null == this.useColorMapping) {
            this._useColorMapping = use;
            this.redraw();
        } else {
            this.useColorMapping.set(use);
        }
    }

    public BooleanProperty useColorMapping() {
        if (null == this.useColorMapping) {
            this.useColorMapping = new BooleanPropertyBase(this._useColorMapping){

                protected void invalidated() {
                    AreaHeatMap.this.redraw();
                }

                public Object getBean() {
                    return AreaHeatMap.this;
                }

                public String getName() {
                    return "useColorMapping";
                }
            };
        }
        return this.useColorMapping;
    }

    public void setDataPoints(DataPoint ... POINTS) {
        this.setDataPoints(Arrays.asList(POINTS));
    }

    public void setDataPoints(List<DataPoint> POINTS) {
        this.minValue = POINTS.stream().mapToDouble(DataPoint::getValue).min().getAsDouble();
        this.maxValue = POINTS.stream().mapToDouble(DataPoint::getValue).max().getAsDouble();
        this.range = this.maxValue - this.minValue;
        this.points.clear();
        this.points.addAll(POINTS);
        this.createHullPolygon();
        this.redraw();
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    private Color getColorForValue(double value, boolean levels) {
        double limit = 0.55;
        double min = -30.0;
        double max = 50.0;
        double delta = max - min;
        double newLevels = 25.0;
        double newValue = Helper.clamp(min, max, value);
        double tmp = 1.0 - (1.0 - limit) - (newValue - min) * limit / delta;
        if (levels) {
            tmp = (double)Math.round(tmp * newLevels) / newLevels;
        }
        return Helper.hslToRGB(tmp, 1.0, 0.5);
    }

    private Color getColorForValue(double value) {
        return this.getColorForValue(value, this.getHeatMapOpacity());
    }

    private Color getColorForValue(double value, double opacity) {
        return Helper.getColorWithOpacityAt(this.getMapping().getGradient(), (value - this.minValue) / this.range, opacity);
    }

    private void createHullPolygon() {
        this.polygon.clear();
        if (this.isSmoothedHull()) {
            List<DataPoint> p = Helper.createSmoothedHull(this.points, 16);
            this.polygon.addAll(p);
        } else {
            this.polygon.addAll(Helper.createHull(this.points));
        }
    }

    private double getValueAt(int limit, double x, double y) {
        ArrayList<Number[]> arr = new ArrayList<Number[]>();
        double t = 0.0;
        double b = 0.0;
        if (Helper.isInPolygon(x, y, this.polygon)) {
            int counter;
            for (counter = 0; counter < this.points.size(); ++counter) {
                DataPoint point = this.points.get(counter);
                double distance = Helper.squareDistance(x, y, point.getX(), point.getY());
                if (Double.compare(distance, 0.0) == 0) {
                    return point.getValue();
                }
                arr.add(counter, new Number[]{distance, counter});
            }
            arr.sort(Comparator.comparingInt(n -> n[0].intValue()));
            for (counter = 0; counter < limit; ++counter) {
                Number[] ptr = (Number[])arr.get(counter);
                double inv = 1.0 / Math.pow(ptr[0].intValue(), 2.0);
                t += inv * this.points.get(ptr[1].intValue()).getValue();
                b += inv;
            }
            return t / b;
        }
        return -255.0;
    }

    private void draw(int limit, double resolution, double pixelSize) {
        int newLimit = limit > this.points.size() ? this.points.size() : limit + 1;
        double heatMapOpacity = this.getHeatMapOpacity();
        boolean useColorMapping = this.getUseColorMapping();
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        for (double y = 0.0; y < this.height; y += resolution) {
            for (double x = 0.0; x < this.width; x += resolution) {
                double value = this.getValueAt(newLimit, x, y);
                if (value == -255.0) continue;
                Color color = useColorMapping ? this.getColorForValue(value) : this.getColorForValue(value, this.isDiscreteColors());
                double red = color.getRed();
                double green = color.getGreen();
                double blue = color.getBlue();
                RadialGradient gradient = new RadialGradient(0.0, 0.0, x, y, resolution, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)red, (double)green, (double)blue, (double)heatMapOpacity)), new Stop(1.0, Color.color((double)red, (double)green, (double)blue, (double)0.0))});
                this.ctx.setFill((Paint)gradient);
                this.ctx.fillOval(x - resolution, y - resolution, pixelSize, pixelSize);
            }
        }
    }

    private void drawDataPoints() {
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(Fonts.opensansRegular((double)(this.size * 0.0175)));
        this.ctx.setStroke((Paint)Color.BLACK);
        this.points.stream().forEach(point -> {
            double centerX = point.getX() - 8.0;
            double centerY = point.getY() - 8.0;
            this.ctx.setFill((Paint)HALF_WHITE);
            this.ctx.fillOval(centerX, centerY, 16.0, 16.0);
            this.ctx.setStroke((Paint)Color.BLACK);
            this.ctx.strokeOval(centerX, centerY, 16.0, 16.0);
            this.ctx.setFill((Paint)Color.BLACK);
            this.ctx.fillText(Long.toString(Math.round(point.getValue())), point.getX(), point.getY(), 16.0);
        });
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.draw(this.getNoOfCloserInfluentPoints(), this.getQuality().getFactor(), this.getQuality().getPixelSize());
        if (this.getShowDataPoints()) {
            this.drawDataPoints();
        }
    }

    public static enum Quality {
        EXCELLENT(2, 4.0),
        REFINED(3, 6.0),
        GODD(4, 8.0),
        STANDARD(5, 10.0),
        BASIC(8, 16.0),
        POOR(16, 32.0),
        RAW(32, 64.0);

        private final int factor;
        private final double pixelSize;

        private Quality(int factor, double pixelSize) {
            this.factor = factor;
            this.pixelSize = pixelSize;
        }

        public int getFactor() {
            return this.factor;
        }

        public double getPixelSize() {
            return this.pixelSize;
        }
    }
}

