/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.areaheatmap;

import eu.hansolo.fx.charts.areaheatmap.AreaHeatMap;
import eu.hansolo.fx.charts.data.DataPoint;
import eu.hansolo.fx.heatmap.Mapping;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;

public class AreaHeatMapBuilder<B extends AreaHeatMapBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected AreaHeatMapBuilder() {
    }

    public static final AreaHeatMapBuilder create() {
        return new AreaHeatMapBuilder();
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        return this.prefSize(new Dimension2D(WIDTH, HEIGHT));
    }

    public final B prefSize(Dimension2D PREF_SIZE) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)PREF_SIZE));
        return (B)this;
    }

    public final B dataPoints(DataPoint ... POINTS) {
        this.properties.put("dataPointsArray", (Property)new SimpleObjectProperty((Object)POINTS));
        return (B)this;
    }

    public final B dataPoints(List<DataPoint> POINTS) {
        this.properties.put("dataPointsList", (Property)new SimpleObjectProperty(POINTS));
        return (B)this;
    }

    public final B colorMapping(Mapping COLOR_MAPPING) {
        this.properties.put("colorMapping", (Property)new SimpleObjectProperty((Object)COLOR_MAPPING));
        return (B)this;
    }

    public final B useColorMapping(boolean USE) {
        this.properties.put("useColorMapping", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B quality(AreaHeatMap.Quality QUALITY) {
        this.properties.put("quality", (Property)new SimpleObjectProperty((Object)QUALITY));
        return (B)this;
    }

    public final B dataPointsVisible(boolean VISIBLE) {
        this.properties.put("dataPointsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B smoothedHull(boolean SMOOTHED) {
        this.properties.put("smoothedHull", (Property)new SimpleBooleanProperty(SMOOTHED));
        return (B)this;
    }

    public final B discreteColors(boolean DISCRETE_COLORS) {
        this.properties.put("discreteColors", (Property)new SimpleBooleanProperty(DISCRETE_COLORS));
        return (B)this;
    }

    public final B heatMapOpacity(double HEAT_MAP_OPACITY) {
        this.properties.put("heatMapOpacity", (Property)new SimpleDoubleProperty(HEAT_MAP_OPACITY));
        return (B)this;
    }

    public final B noOfCloserInfluentialPoints(int NO_OF_POINTS) {
        this.properties.put("noOfCloserInfluentialPoints", (Property)new SimpleIntegerProperty(NO_OF_POINTS));
        return (B)this;
    }

    public final AreaHeatMap build() {
        AreaHeatMap control = new AreaHeatMap();
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "colorMapping": {
                    control.setColorMapping((Mapping)((ObjectProperty)property).get());
                    break;
                }
                case "useColorMapping": {
                    control.setUseColorMapping(((BooleanProperty)property).get());
                    break;
                }
                case "quality": {
                    control.setQuality((AreaHeatMap.Quality)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "heatMapOpacity": {
                    control.setHeatMapOpacity(((DoubleProperty)property).get());
                    break;
                }
                case "dataPointsVisible": {
                    control.setDataPointsVisible(((BooleanProperty)property).get());
                    break;
                }
                case "smoothedHull": {
                    control.setSmoothedHull(((BooleanProperty)property).get());
                    break;
                }
                case "discreteColors": {
                    control.setDiscreteColors(((BooleanProperty)property).get());
                    break;
                }
                case "noOfCloserInfluentialPoints": {
                    control.setNoOfCloserInfluentialPoints(((IntegerProperty)property).get());
                }
            }
        });
        if (this.properties.keySet().contains("dataPointsArray")) {
            control.setDataPoints((DataPoint[])((ObjectProperty)this.properties.get("dataPointsArray")).get());
        }
        if (this.properties.keySet().contains("dataPointsList")) {
            control.setDataPoints((List)((ObjectProperty)this.properties.get("dataPointsList")).get());
        }
        return control;
    }
}

