/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.forcedirectedgraph;

import eu.hansolo.fx.charts.forcedirectedgraph.GraphNode;
import eu.hansolo.fx.charts.forcedirectedgraph.NodeEdgeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class GraphEdge {
    private ObjectProperty<GraphNode> u;
    private ObjectProperty<GraphNode> v;
    private double force;
    private double width;
    private HashMap<String, Double> nummericAttributes;

    public GraphEdge(GraphNode node1, GraphNode node2, double force, double width, Map<String, Double> nummericAttributes) {
        this.u = new SimpleObjectProperty((Object)node1);
        this.v = new SimpleObjectProperty((Object)node2);
        this.force = force;
        this.width = width;
        this.nummericAttributes = new HashMap<String, Double>(nummericAttributes);
        this.addDefault();
    }

    public GraphEdge(GraphNode node1, GraphNode node2, Map<String, Double> nummericAttributes) {
        this(node1, node2, 1.0, 1.0, nummericAttributes);
    }

    public GraphEdge(GraphNode node1, GraphNode node2) {
        this(node1, node2, new HashMap<String, Double>());
    }

    private void addDefault() {
        this.nummericAttributes.put(NodeEdgeModel.DEFAULT, 1.0);
    }

    public double getForce() {
        return this.force;
    }

    public void setForce(double force) {
        this.force = force;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public GraphNode getU() {
        return (GraphNode)this.u.get();
    }

    public void setU(GraphNode U) {
        this.u.set((Object)U);
    }

    public ObjectProperty<GraphNode> uProperty() {
        return this.u;
    }

    public GraphNode getV() {
        return (GraphNode)this.v.get();
    }

    public void setV(GraphNode V) {
        this.v.set((Object)V);
    }

    public ObjectProperty<GraphNode> vProperty() {
        return this.v;
    }

    public double getNummericAttribute(String key) {
        if (this.nummericAttributes.containsKey(key)) {
            return this.nummericAttributes.get(key);
        }
        return -1.0;
    }

    public ArrayList<String> getNummericAttributeKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (String o : this.nummericAttributes.keySet()) {
            if (!(o instanceof String)) continue;
            keys.add(o);
        }
        return keys;
    }
}

