/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.LineStyle;
import javafx.scene.paint.Color;

public class Marker {
    private Axis axis;
    private double value;
    private Color stroke;
    private double lineWidth;
    private String text;
    private Color textFill;
    private String formatString;
    private LineStyle lineStyle;

    public Marker(Axis axis, double value) {
        this(axis, value, Color.RED, 1.0, LineStyle.SOLID, "", Color.RED, "%.0f");
    }

    public Marker(Axis axis, double value, Color stroke, double lineWidth, LineStyle lineStyle, String text, Color textFill, String formatString) {
        if (null == axis) {
            throw new IllegalArgumentException("Given axis cannot be null");
        }
        if (Position.LEFT != axis.getPosition() && Position.BOTTOM != axis.getPosition()) {
            throw new IllegalArgumentException("Marker axis position has to be either LEFT or BOTTOM");
        }
        this.axis = axis;
        this.value = Helper.clamp(axis.getMinValue(), axis.getMaxValue(), value);
        this.stroke = null == stroke ? Color.RED : stroke;
        this.lineWidth = Helper.clamp(1.0, 10.0, lineWidth);
        this.text = null == text ? "" : text;
        this.textFill = null == textFill ? Color.RED : textFill;
        this.formatString = null == formatString || formatString.isEmpty() ? "%.0f" : formatString;
        this.lineStyle = null == lineStyle ? LineStyle.SOLID : lineStyle;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public double getValue() {
        return this.value;
    }

    public Color getStroke() {
        return this.stroke;
    }

    public void setStroke(Color stroke) {
        this.stroke = null == stroke ? Color.RED : stroke;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = Helper.clamp(1.0, 10.0, lineWidth);
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = null == lineStyle ? LineStyle.SOLID : lineStyle;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = null == text ? "" : text;
    }

    public Color getTextFill() {
        return this.textFill;
    }

    public void setTextFill(Color textFill) {
        this.textFill = null == textFill ? Color.RED : textFill;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = null == formatString || formatString.isEmpty() ? "%.0f" : formatString;
    }
}

