/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import eu.hansolo.fx.charts.voronoi.VPoint;
import eu.hansolo.fx.charts.voronoi.VoronoiChart;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class VoronoiChartBuilder<B extends VoronoiChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected VoronoiChartBuilder() {
    }

    public static final VoronoiChartBuilder create() {
        return new VoronoiChartBuilder();
    }

    public final B points(List<VPoint> POINTS) {
        this.properties.put("points", (Property)new SimpleObjectProperty(POINTS));
        return (B)this;
    }

    public final B pointsVisible(boolean VISIBLE) {
        this.properties.put("pointsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B pointColor(Color COLOR) {
        this.properties.put("pointColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B fillRegions(boolean FILL) {
        this.properties.put("fillRegions", (Property)new SimpleBooleanProperty(FILL));
        return (B)this;
    }

    public final B borderColor(Color COLOR) {
        this.properties.put("borderColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B type(VoronoiChart.Type TYPE) {
        this.properties.put("type", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B multiColor(boolean MULTICOLOR) {
        this.properties.put("multiColor", (Property)new SimpleBooleanProperty(MULTICOLOR));
        return (B)this;
    }

    public final B voronoiColor(Color COLOR) {
        this.properties.put("voronoiColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B delaunayColor(Color COLOR) {
        this.properties.put("delaunayColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B interactive(boolean INTERACTIVE) {
        this.properties.put("interactive", (Property)new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final VoronoiChart build() {
        VoronoiChart control = this.properties.containsKey("points") ? new VoronoiChart((List)((ObjectProperty)this.properties.get("points")).get()) : new VoronoiChart();
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "pointsVisible": {
                    control.setPointsVisible(((BooleanProperty)property).get());
                    break;
                }
                case "pointColor": {
                    control.setPointColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "fillRegions": {
                    control.setFillRegions(((BooleanProperty)property).get());
                    break;
                }
                case "borderColor": {
                    control.setBorderColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "type": {
                    control.setType((VoronoiChart.Type)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "multiColor": {
                    control.setMulticolor(((BooleanProperty)property).get());
                    break;
                }
                case "voronoiColor": {
                    control.setVoronoiColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "delaunayColor": {
                    control.setDelaunayColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "interactive": {
                    control.setInteractive(((BooleanProperty)property).get());
                }
            }
        });
        return control;
    }
}

