/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.AxisType;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.TickLabelOrientation;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.TickLabelFormat;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Bounds;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;

@DefaultProperty(value="children")
public class Axis
extends Region {
    private static final double MINIMUM_WIDTH = 0.0;
    private static final double MINIMUM_HEIGHT = 0.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final double MIN_MAJOR_LINE_WIDTH = 1.0;
    private static final double MIN_MEDIUM_LINE_WIDTH = 0.75;
    private static final double MIN_MINOR_LINE_WIDTH = 0.5;
    private final ChartEvt AXIS_RANGE_CHANGED_EVT = new ChartEvt((Object)this, ChartEvt.AXIS_RANGE_CHANGED);
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    private double size;
    private double width;
    private double height;
    private Canvas axisCanvas;
    private GraphicsContext axisCtx;
    private Pane pane;
    private double _minValue;
    private DoubleProperty minValue;
    private LocalDateTime _start;
    private ObjectProperty<LocalDateTime> start;
    private double _maxValue;
    private DoubleProperty maxValue;
    private LocalDateTime _end;
    private ObjectProperty<LocalDateTime> end;
    private boolean _autoScale;
    private BooleanProperty autoScale;
    private double stepSize;
    private Bounds axisBounds;
    private String _title;
    private StringProperty title;
    private String _unit;
    private StringProperty unit;
    private AxisType _type;
    private ObjectProperty<AxisType> type;
    private Orientation _orientation;
    private ObjectProperty<Orientation> orientation;
    private Position _position;
    private ObjectProperty<Position> position;
    private Color _axisBackgroundColor;
    private ObjectProperty<Color> axisBackgroundColor;
    private Color _axisColor;
    private ObjectProperty<Color> axisColor;
    private Color _tickLabelColor;
    private ObjectProperty<Color> tickLabelColor;
    private Color _titleColor;
    private ObjectProperty<Color> titleColor;
    private Color _minorTickMarkColor;
    private ObjectProperty<Color> minorTickMarkColor;
    private Color _mediumTickMarkColor;
    private ObjectProperty<Color> mediumTickMarkColor;
    private Color _majorTickMarkColor;
    private ObjectProperty<Color> majorTickMarkColor;
    private Color _zeroColor;
    private ObjectProperty<Color> zeroColor;
    private double _zeroPosition;
    private DoubleProperty zeroPosition;
    private double _minorTickSpace;
    private double _majorTickSpace;
    private boolean _majorTickMarksVisible;
    private BooleanProperty majorTickMarksVisible;
    private boolean _mediumTickMarksVisible;
    private BooleanProperty mediumTickMarksVisible;
    private boolean _minorTickMarksVisible;
    private BooleanProperty minorTickMarksVisible;
    private boolean _sameTickMarkLength;
    private BooleanProperty sameTickMarkLength;
    private boolean _tickLabelsVisible;
    private BooleanProperty tickLabelsVisible;
    private boolean _mediumTimeAxisTickLabelsVisible;
    private BooleanProperty mediumTimeAxisTickLabelsVisible;
    private boolean _onlyFirstAndLastTickLabelVisible;
    private BooleanProperty onlyFirstAndLastTickLabelVisible;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private int _decimals;
    private IntegerProperty decimals;
    private String tickLabelFormatString;
    private StringConverter<Number> numberFormatter;
    private TickLabelOrientation _tickLabelOrientation;
    private ObjectProperty<TickLabelOrientation> tickLabelOrientation;
    private TickLabelFormat _tickLabelFormat;
    private ObjectProperty<TickLabelFormat> tickLabelFormat;
    private Font tickLabelFont;
    private Font titleFont;
    private boolean _autoTitleFontSize;
    private BooleanProperty autoTitleFontSize;
    private boolean _autoFontSize;
    private BooleanProperty autoFontSize;
    private double _tickLabelFontSize;
    private DoubleProperty tickLabelFontSize;
    private double _titleFontSize;
    private DoubleProperty titleFontSize;
    private ZoneId _zoneId;
    private ObjectProperty<ZoneId> zoneId;
    private String _dateTimeFormatPattern;
    private StringProperty dateTimeFormatPattern;
    private List<String> categories;
    private DateTimeFormatter dateTimeFormatter;
    private Helper.Interval currentInterval;
    private EvtObserver<ChartEvt> evtEvtObserver;

    public Axis() {
        this(0.0, 100.0, Orientation.VERTICAL, AxisType.LINEAR, Position.LEFT, "");
    }

    public Axis(Orientation ORIENTATION, Position POSITION) {
        this(0.0, 100.0, ORIENTATION, AxisType.LINEAR, POSITION, "");
    }

    public Axis(Orientation ORIENTATION, AxisType TYPE, Position POSITION) {
        this(0.0, 100.0, ORIENTATION, TYPE, POSITION, "");
    }

    public Axis(double MIN_VALUE, double MAX_VALUE, Orientation ORIENTATION, Position POSITION) {
        this(MIN_VALUE, MAX_VALUE, ORIENTATION, AxisType.LINEAR, POSITION, "");
    }

    public Axis(double MIN_VALUE, double MAX_VALUE, Orientation ORIENTATION, AxisType TYPE, Position POSITION) {
        this(MIN_VALUE, MAX_VALUE, ORIENTATION, TYPE, POSITION, "");
    }

    public Axis(double MIN_VALUE, double MAX_VALUE, Orientation ORIENTATION, AxisType TYPE, Position POSITION, String TITLE) {
        if (Orientation.VERTICAL == ORIENTATION ? Position.LEFT != POSITION && Position.RIGHT != POSITION && Position.CENTER != POSITION : Position.TOP != POSITION && Position.BOTTOM != POSITION && Position.CENTER != POSITION) {
            throw new IllegalArgumentException("Wrong combination of orientation and position!");
        }
        this._minValue = MIN_VALUE;
        this._maxValue = MAX_VALUE;
        this._type = TYPE;
        this._autoScale = true;
        this._title = TITLE;
        this._unit = "";
        this._orientation = ORIENTATION;
        this._position = POSITION;
        this._axisBackgroundColor = Color.TRANSPARENT;
        this._axisColor = Color.BLACK;
        this._tickLabelColor = Color.BLACK;
        this._titleColor = Color.BLACK;
        this._minorTickMarkColor = Color.BLACK;
        this._mediumTickMarkColor = Color.BLACK;
        this._majorTickMarkColor = Color.BLACK;
        this._zeroColor = Color.BLACK;
        this._zeroPosition = 0.0;
        this._minorTickSpace = 1.0;
        this._majorTickSpace = 10.0;
        this._majorTickMarksVisible = true;
        this._mediumTickMarksVisible = true;
        this._minorTickMarksVisible = true;
        this._sameTickMarkLength = false;
        this._tickLabelsVisible = true;
        this._mediumTimeAxisTickLabelsVisible = false;
        this._onlyFirstAndLastTickLabelVisible = false;
        this._locale = Locale.US;
        this._decimals = 0;
        this._tickLabelOrientation = TickLabelOrientation.HORIZONTAL;
        this._tickLabelFormat = TickLabelFormat.NUMBER;
        this._autoTitleFontSize = true;
        this._autoFontSize = true;
        this._tickLabelFontSize = 10.0;
        this._titleFontSize = 10.0;
        this._zoneId = ZoneId.systemDefault();
        this._dateTimeFormatPattern = "dd.MM.YY HH:mm:ss";
        this.axisBounds = new Bounds();
        this.currentInterval = Helper.Interval.SECOND_1;
        this.evtEvtObserver = e -> this.drawAxis();
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this._dateTimeFormatPattern, this._locale);
        this.categories = new LinkedList<String>();
        this.tickLabelFormatString = "%." + Integer.toString(this._decimals) + "f";
        this.initGraphics();
        this.registerListeners();
    }

    public Axis(LocalDateTime START, LocalDateTime END, Orientation ORIENTATION, Position POSITION) {
        this(START, END, ORIENTATION, POSITION, "");
    }

    public Axis(LocalDateTime START, LocalDateTime END, Orientation ORIENTATION, Position POSITION, String TITLE) {
        if (Orientation.VERTICAL == ORIENTATION ? Position.LEFT != POSITION && Position.RIGHT != POSITION && Position.CENTER != POSITION : Position.TOP != POSITION && Position.BOTTOM != POSITION && Position.CENTER != POSITION) {
            throw new IllegalArgumentException("Wrong combination of orientation and position!");
        }
        this.getStylesheets().add((Object)Axis.class.getResource("chart.css").toExternalForm());
        this._minValue = START.toEpochSecond(Helper.getZoneOffset());
        this._start = START;
        this._maxValue = END.toEpochSecond(Helper.getZoneOffset());
        this._end = END;
        this._type = AxisType.TIME;
        this._autoScale = true;
        this._title = TITLE;
        this._unit = "";
        this._orientation = ORIENTATION;
        this._position = POSITION;
        this._axisBackgroundColor = Color.TRANSPARENT;
        this._axisColor = Color.BLACK;
        this._tickLabelColor = Color.BLACK;
        this._minorTickMarkColor = Color.BLACK;
        this._mediumTickMarkColor = Color.BLACK;
        this._majorTickMarkColor = Color.BLACK;
        this._zeroColor = Color.BLACK;
        this._zeroPosition = 0.0;
        this._minorTickSpace = 1.0;
        this._majorTickSpace = 10.0;
        this._majorTickMarksVisible = true;
        this._mediumTickMarksVisible = true;
        this._minorTickMarksVisible = true;
        this._sameTickMarkLength = false;
        this._tickLabelsVisible = true;
        this._mediumTimeAxisTickLabelsVisible = false;
        this._onlyFirstAndLastTickLabelVisible = false;
        this._locale = Locale.US;
        this._decimals = 0;
        this._tickLabelOrientation = TickLabelOrientation.HORIZONTAL;
        this._tickLabelFormat = TickLabelFormat.NUMBER;
        this._autoTitleFontSize = true;
        this._autoFontSize = true;
        this._tickLabelFontSize = 10.0;
        this._titleFontSize = 10.0;
        this._zoneId = ZoneId.systemDefault();
        this._dateTimeFormatPattern = "dd.MM.YY HH:mm:ss";
        this.currentInterval = Helper.Interval.SECOND_1;
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this._dateTimeFormatPattern, this._locale);
        this.tickLabelFormatString = "%." + Integer.toString(this._decimals) + "f";
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if ((Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) && this.getPrefWidth() != 0.0 && this.getPrefHeight() != 0.0) {
            if (Orientation.VERTICAL == this.getOrientation()) {
                this.setPrefSize(20.0, 250.0);
            } else {
                this.setPrefSize(250.0, 20.0);
            }
        }
        this.getStyleClass().add((Object)"axis");
        this.axisCanvas = new Canvas(this.width, this.height);
        this.axisCtx = this.axisCanvas.getGraphicsContext2D();
        this.axisBounds.set(0.0, 0.0, this.width, this.height);
        this.pane = new Pane(new Node[]{this.axisCanvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, this.evtEvtObserver);
    }

    protected double computeMinWidth(double HEIGHT) {
        return 0.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 0.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public double getMinValue() {
        return null == this.minValue ? this._minValue : this.minValue.get();
    }

    public void setMinValue(LocalDateTime START) {
        this.setMinValue(START.toEpochSecond(Helper.getZoneOffset(this.getZoneId())));
    }

    public void setMinValue(double VALUE) {
        if (null == this.minValue) {
            if (VALUE > this.getMaxValue()) {
                this.setMaxValue(VALUE);
            }
            this._minValue = Helper.clamp(-1.7976931348623157E308, this.getMaxValue(), VALUE);
            this.fireChartEvt(this.AXIS_RANGE_CHANGED_EVT);
        } else {
            this.minValue.set(VALUE);
        }
    }

    public DoubleProperty minValueProperty() {
        if (null == this.minValue) {
            this.minValue = new DoublePropertyBase(this._minValue){

                protected void invalidated() {
                    if (this.getValue() > Axis.this.getMaxValue()) {
                        Axis.this.setMaxValue(this.getValue());
                    }
                    Axis.this.fireChartEvt(Axis.this.AXIS_RANGE_CHANGED_EVT);
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "minValue";
                }
            };
        }
        return this.minValue;
    }

    public LocalDateTime getStart() {
        return null == this.start ? this._start : (LocalDateTime)this.start.get();
    }

    public void setStart(long EPOCH_SECONDS) {
        if (0L > EPOCH_SECONDS) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0");
        }
        this.setStart(Instant.ofEpochSecond(EPOCH_SECONDS));
    }

    public void setStart(long EPOCH_SECONDS, ZoneId ZONE_ID) {
        if (0L > EPOCH_SECONDS || null == ZONE_ID) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0 and zone id cannot be null");
        }
        this.setStart(Instant.ofEpochSecond(EPOCH_SECONDS), ZONE_ID);
    }

    public void setStart(Instant INSTANT) {
        this.setStart(INSTANT, ZoneId.systemDefault());
    }

    public void setStart(Instant INSTANT, ZoneId ZONE_ID) {
        if (null == INSTANT || null == ZONE_ID) {
            throw new IllegalArgumentException("Instant cannot be null");
        }
        this.setStart(LocalDateTime.ofInstant(INSTANT, ZONE_ID));
    }

    public void setStart(LocalDateTime DATE_TIME) {
        if (AxisType.TIME != this.getType()) {
            throw new IllegalArgumentException("Axis type has to be TIME");
        }
        if (null == this.start) {
            this.setMinValue(DATE_TIME.toEpochSecond(Helper.getZoneOffset()));
            this._start = DATE_TIME;
        } else {
            this.start.set((Object)DATE_TIME);
        }
    }

    public ObjectProperty<LocalDateTime> startProperty() {
        if (null == this.start) {
            this.start = new ObjectPropertyBase<LocalDateTime>(this._start){

                protected void invalidated() {
                    if (AxisType.TIME != Axis.this.getType()) {
                        throw new IllegalArgumentException("Axis type has to be TIME");
                    }
                    Axis.this.setMinValue(((LocalDateTime)this.get()).toEpochSecond(Helper.getZoneOffset()));
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "start";
                }
            };
            this._start = null;
        }
        return this.start;
    }

    public double getMaxValue() {
        return null == this.maxValue ? this._maxValue : this.maxValue.get();
    }

    public void setMaxValue(LocalDateTime END) {
        this.setMaxValue(END.toEpochSecond(Helper.getZoneOffset(this.getZoneId())));
    }

    public void setMaxValue(double VALUE) {
        if (null == this.maxValue) {
            if (VALUE < this.getMinValue()) {
                this.setMinValue(VALUE);
            }
            this._maxValue = Helper.clamp(this.getMinValue(), Double.MAX_VALUE, VALUE);
            this.fireChartEvt(this.AXIS_RANGE_CHANGED_EVT);
        } else {
            this.maxValue.set(VALUE);
        }
    }

    public DoubleProperty maxValueProperty() {
        if (null == this.maxValue) {
            this.maxValue = new DoublePropertyBase(this._maxValue){

                protected void invalidated() {
                    if (this.get() < Axis.this.getMinValue()) {
                        Axis.this.setMinValue(this.get());
                    }
                    Axis.this.fireChartEvt(Axis.this.AXIS_RANGE_CHANGED_EVT);
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "maxValue";
                }
            };
        }
        return this.maxValue;
    }

    public LocalDateTime getEnd() {
        return null == this.end ? this._end : (LocalDateTime)this.end.get();
    }

    public void setEnd(Instant INSTANT) {
        this.setEnd(INSTANT, ZoneId.systemDefault());
    }

    public void setEnd(long EPOCH_SECONDS) {
        if (0L > EPOCH_SECONDS) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0");
        }
        this.setEnd(Instant.ofEpochSecond(EPOCH_SECONDS));
    }

    public void setEnd(long EPOCH_SECONDS, ZoneId ZONE_ID) {
        if (0L > EPOCH_SECONDS || null == ZONE_ID) {
            throw new IllegalArgumentException("Epoch seconds cannot be smaller than 0 and zone id cannot be null");
        }
        this.setEnd(Instant.ofEpochSecond(EPOCH_SECONDS), ZONE_ID);
    }

    public void setEnd(Instant INSTANT, ZoneId ZONE_ID) {
        if (null == INSTANT || null == ZONE_ID) {
            throw new IllegalArgumentException("Instant cannot be null");
        }
        this.setEnd(LocalDateTime.ofInstant(INSTANT, ZONE_ID));
    }

    public void setEnd(LocalDateTime DATE_TIME) {
        if (null == this.end) {
            this.setMaxValue(DATE_TIME.toEpochSecond(Helper.getZoneOffset()));
            this._end = DATE_TIME;
        } else {
            this.end.set((Object)DATE_TIME);
        }
    }

    public ObjectProperty<LocalDateTime> endProperty() {
        if (null == this.end) {
            this.end = new ObjectPropertyBase<LocalDateTime>(this._end){

                protected void invalidated() {
                    Axis.this.setMaxValue(((LocalDateTime)this.get()).toEpochSecond(Helper.getZoneOffset()));
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "end";
                }
            };
            this._end = null;
        }
        return this.end;
    }

    public boolean isAutoScale() {
        return null == this.autoScale ? this._autoScale : this.autoScale.get();
    }

    public void setAutoScale(boolean AUTO_SCALE) {
        if (null == this.autoScale) {
            this._autoScale = AUTO_SCALE;
            this.redraw();
        } else {
            this.autoScale.set(AUTO_SCALE);
        }
    }

    public BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new BooleanPropertyBase(this._autoScale){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "autoScale";
                }
            };
        }
        return this.autoScale;
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
            this.redraw();
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
            this.redraw();
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public AxisType getType() {
        return null == this.type ? this._type : (AxisType)((Object)this.type.get());
    }

    public void setType(AxisType TYPE) {
        if (null == this.type) {
            this._type = TYPE;
            this.redraw();
        } else {
            this.type.set((Object)TYPE);
        }
    }

    public ObjectProperty<AxisType> typeProperty() {
        if (null == this.type) {
            this.type = new ObjectPropertyBase<AxisType>(this._type){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "axisType";
                }
            };
            this._type = null;
        }
        return this.type;
    }

    public Orientation getOrientation() {
        return null == this.orientation ? this._orientation : (Orientation)this.orientation.get();
    }

    public void setOrientation(Orientation ORIENTATION) {
        if (null == this.orientation) {
            this._orientation = ORIENTATION;
            this.redraw();
        } else {
            this.orientation.set((Object)ORIENTATION);
        }
    }

    public ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new ObjectPropertyBase<Orientation>(this._orientation){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
            this._orientation = null;
        }
        return this.orientation;
    }

    public Position getPosition() {
        return null == this.position ? this._position : (Position)((Object)this.position.get());
    }

    public void setPosition(Position POSITION) {
        if (null == this.position) {
            this._position = POSITION;
            this.redraw();
        } else {
            this.position.set((Object)POSITION);
        }
    }

    public ObjectProperty<Position> positionProperty() {
        if (null == this.position) {
            this.position = new ObjectPropertyBase<Position>(this._position){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "position";
                }
            };
            this._position = null;
        }
        return this.position;
    }

    public void setForegroundColor(Color COLOR) {
        this.setAxisColor(COLOR);
        this.setTickMarkColor(COLOR);
        this.setTickLabelColor(COLOR);
    }

    public Color getAxisBackgroundColor() {
        return null == this.axisBackgroundColor ? this._axisBackgroundColor : (Color)this.axisBackgroundColor.get();
    }

    public void setAxisBackgroundColor(Color COLOR) {
        if (null == this.axisBackgroundColor) {
            this._axisBackgroundColor = COLOR;
            this.redraw();
        } else {
            this.axisBackgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> axisBackgroundColorProperty() {
        if (null == this.axisBackgroundColor) {
            this.axisBackgroundColor = new ObjectPropertyBase<Color>(this._axisBackgroundColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "axisBackgroundColor";
                }
            };
            this._axisBackgroundColor = null;
        }
        return this.axisBackgroundColor;
    }

    public Color getAxisColor() {
        return null == this.axisColor ? this._axisColor : (Color)this.axisColor.get();
    }

    public void setAxisColor(Color COLOR) {
        if (null == this.axisColor) {
            this._axisColor = COLOR;
            this.redraw();
        } else {
            this.axisColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> axisColorProperty() {
        if (null == this.axisColor) {
            this.axisColor = new ObjectPropertyBase<Color>(this._axisColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "axisColor";
                }
            };
            this._axisColor = null;
        }
        return this.axisColor;
    }

    public Color getTickLabelColor() {
        return null == this.tickLabelColor ? this._tickLabelColor : (Color)this.tickLabelColor.get();
    }

    public void setTickLabelColor(Color COLOR) {
        if (null == this.tickLabelColor) {
            this._tickLabelColor = COLOR;
            this.redraw();
        } else {
            this.tickLabelColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> tickLabelColorProperty() {
        if (null == this.tickLabelColor) {
            this.tickLabelColor = new ObjectPropertyBase<Color>(this._tickLabelColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "tickLabelColor";
                }
            };
            this._tickLabelColor = null;
        }
        return this.tickLabelColor;
    }

    public Color getTitleColor() {
        return null == this.titleColor ? this._titleColor : (Color)this.titleColor.get();
    }

    public void setTitleColor(Color COLOR) {
        if (null == this.titleColor) {
            this._titleColor = COLOR;
            this.redraw();
        } else {
            this.titleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> titleColorProperty() {
        if (null == this.titleColor) {
            this.titleColor = new ObjectPropertyBase<Color>(this._titleColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "titleColor";
                }
            };
            this._titleColor = null;
        }
        return this.titleColor;
    }

    public Color getMinorTickMarkColor() {
        return null == this.minorTickMarkColor ? this._minorTickMarkColor : (Color)this.minorTickMarkColor.get();
    }

    public void setMinorTickMarkColor(Color COLOR) {
        if (null == this.minorTickMarkColor) {
            this._minorTickMarkColor = COLOR;
            this.redraw();
        } else {
            this.minorTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> minorTickMarkColorProperty() {
        if (null == this.minorTickMarkColor) {
            this.minorTickMarkColor = new ObjectPropertyBase<Color>(this._minorTickMarkColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "minorTickMarkColor";
                }
            };
            this._minorTickMarkColor = null;
        }
        return this.minorTickMarkColor;
    }

    public Color getMediumTickMarkColor() {
        return null == this.mediumTickMarkColor ? this._mediumTickMarkColor : (Color)this.mediumTickMarkColor.get();
    }

    public void setMediumTickMarkColor(Color COLOR) {
        if (null == this.mediumTickMarkColor) {
            this._mediumTickMarkColor = COLOR;
            this.redraw();
        } else {
            this.mediumTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> mediumTickMarkColorProperty() {
        if (null == this.mediumTickMarkColor) {
            this.mediumTickMarkColor = new ObjectPropertyBase<Color>(this._mediumTickMarkColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "mediumTickMarkColor";
                }
            };
            this._mediumTickMarkColor = null;
        }
        return this.mediumTickMarkColor;
    }

    public Color getMajorTickMarkColor() {
        return null == this.majorTickMarkColor ? this._majorTickMarkColor : (Color)this.majorTickMarkColor.get();
    }

    public void setMajorTickMarkColor(Color COLOR) {
        if (null == this.majorTickMarkColor) {
            this._majorTickMarkColor = COLOR;
            this.redraw();
        } else {
            this.majorTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> majorTickMarkColorProperty() {
        if (null == this.majorTickMarkColor) {
            this.majorTickMarkColor = new ObjectPropertyBase<Color>(this._majorTickMarkColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "majorTickMarkColor";
                }
            };
            this._majorTickMarkColor = null;
        }
        return this.majorTickMarkColor;
    }

    public Color getZeroColor() {
        return null == this.zeroColor ? this._zeroColor : (Color)this.zeroColor.get();
    }

    public void setZeroColor(Color COLOR) {
        if (null == this.zeroColor) {
            this._zeroColor = COLOR;
            this.redraw();
        } else {
            this.zeroColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> zeroColorProperty() {
        if (null == this.zeroColor) {
            this.zeroColor = new ObjectPropertyBase<Color>(this._zeroColor){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "zeroColor";
                }
            };
            this._zeroColor = null;
        }
        return this.zeroColor;
    }

    public double getZeroPosition() {
        return null == this.zeroPosition ? this._zeroPosition : this.zeroPosition.get();
    }

    private void setZeroPosition(double POSITION) {
        if (null == this.zeroPosition) {
            this._zeroPosition = POSITION;
        } else {
            this.zeroPosition.set(POSITION);
        }
    }

    public ReadOnlyDoubleProperty zeroPositionProperty() {
        if (null == this.zeroPosition) {
            this.zeroPosition = new DoublePropertyBase(this._zeroPosition){

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "zeroPosition";
                }
            };
        }
        return this.zeroPosition;
    }

    protected double getMajorTickSpace() {
        return this._majorTickSpace;
    }

    protected void setMajorTickSpace(double SPACE) {
        this._majorTickSpace = SPACE;
    }

    protected double getMinorTickSpace() {
        return this._minorTickSpace;
    }

    protected void setMinorTickSpace(double SPACE) {
        this._minorTickSpace = SPACE;
    }

    public boolean getMajorTickMarksVisible() {
        return null == this.majorTickMarksVisible ? this._majorTickMarksVisible : this.majorTickMarksVisible.get();
    }

    public void setMajorTickMarksVisible(boolean VISIBLE) {
        if (null == this.majorTickMarksVisible) {
            this._majorTickMarksVisible = VISIBLE;
            this.redraw();
        } else {
            this.majorTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty majorTickMarksVisibleProperty() {
        if (null == this.majorTickMarksVisible) {
            this.majorTickMarksVisible = new BooleanPropertyBase(this._majorTickMarksVisible){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "majorTickMarksVisible";
                }
            };
        }
        return this.majorTickMarksVisible;
    }

    public boolean getMediumTickMarksVisible() {
        return null == this.mediumTickMarksVisible ? this._mediumTickMarksVisible : this.mediumTickMarksVisible.get();
    }

    public void setMediumTickMarksVisible(boolean VISIBLE) {
        if (null == this.mediumTickMarksVisible) {
            this._mediumTickMarksVisible = VISIBLE;
            this.redraw();
        } else {
            this.mediumTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty mediumTickMarksVisibleProperty() {
        if (null == this.mediumTickMarksVisible) {
            this.mediumTickMarksVisible = new BooleanPropertyBase(this._mediumTickMarksVisible){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "mediumTickMarksVisible";
                }
            };
        }
        return this.mediumTickMarksVisible;
    }

    public boolean getMinorTickMarksVisible() {
        return null == this.minorTickMarksVisible ? this._minorTickMarksVisible : this.minorTickMarksVisible.get();
    }

    public void setMinorTickMarksVisible(boolean VISIBLE) {
        if (null == this.minorTickMarksVisible) {
            this._minorTickMarksVisible = VISIBLE;
            this.redraw();
        } else {
            this.minorTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty minorTickMarksVisibleProperty() {
        if (null == this.minorTickMarksVisible) {
            this.minorTickMarksVisible = new BooleanPropertyBase(this._minorTickMarksVisible){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "minorTickMarksVisible";
                }
            };
        }
        return this.minorTickMarksVisible;
    }

    public boolean getSameTickMarkLength() {
        return null == this.sameTickMarkLength ? this._sameTickMarkLength : this.sameTickMarkLength.get();
    }

    public void setSameTickMarkLength(boolean SAME_LENGTH) {
        if (null == this.sameTickMarkLength) {
            this._sameTickMarkLength = SAME_LENGTH;
            this.redraw();
        } else {
            this.sameTickMarkLength.set(SAME_LENGTH);
        }
    }

    public BooleanProperty sameTickMarkLengthProperty() {
        if (null == this.sameTickMarkLength) {
            this.sameTickMarkLength = new BooleanPropertyBase(this._sameTickMarkLength){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "sameTickMarkLength";
                }
            };
        }
        return this.sameTickMarkLength;
    }

    public boolean getTickLabelsVisible() {
        return null == this.tickLabelsVisible ? this._tickLabelsVisible : this.tickLabelsVisible.get();
    }

    public void setTickLabelsVisible(boolean VISIBLE) {
        if (null == this.tickLabelsVisible) {
            this._tickLabelsVisible = VISIBLE;
            this.redraw();
        } else {
            this.tickLabelsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty tickLabelsVisibleProperty() {
        if (null == this.tickLabelsVisible) {
            this.tickLabelsVisible = new BooleanPropertyBase(this._tickLabelsVisible){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "tickLabelsVisible";
                }
            };
        }
        return this.tickLabelsVisible;
    }

    public boolean getMediumTimeAxisTickLabelsVisible() {
        return null == this.mediumTimeAxisTickLabelsVisible ? this._mediumTimeAxisTickLabelsVisible : this.mediumTimeAxisTickLabelsVisible.get();
    }

    public void setMediumTimeAxisTickLabelsVisible(boolean VISIBLE) {
        if (null == this.mediumTimeAxisTickLabelsVisible) {
            this._mediumTimeAxisTickLabelsVisible = VISIBLE;
            this.redraw();
        } else {
            this.mediumTimeAxisTickLabelsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty mediumTimeAxisTickLabelsVisibleProperty() {
        if (null == this.mediumTimeAxisTickLabelsVisible) {
            this.mediumTimeAxisTickLabelsVisible = new BooleanPropertyBase(this._mediumTimeAxisTickLabelsVisible){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "mediumTickLabelsVisible";
                }
            };
        }
        return this.mediumTimeAxisTickLabelsVisible;
    }

    public boolean isOnlyFirstAndLastTickLabelVisible() {
        return null == this.onlyFirstAndLastTickLabelVisible ? this._onlyFirstAndLastTickLabelVisible : this.onlyFirstAndLastTickLabelVisible.get();
    }

    public void setOnlyFirstAndLastTickLabelVisible(boolean VISIBLE) {
        if (null == this.onlyFirstAndLastTickLabelVisible) {
            this._onlyFirstAndLastTickLabelVisible = VISIBLE;
            this.redraw();
        } else {
            this.onlyFirstAndLastTickLabelVisible.set(VISIBLE);
        }
    }

    public BooleanProperty onlyFirstAndLastTickLabelVisibleProperty() {
        if (null == this.onlyFirstAndLastTickLabelVisible) {
            this.onlyFirstAndLastTickLabelVisible = new BooleanPropertyBase(this._onlyFirstAndLastTickLabelVisible){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "onlyFirstAndLastTickLabelVisible";
                }
            };
        }
        return this.onlyFirstAndLastTickLabelVisible;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
            this.tickLabelFormatString = "%." + Integer.toString(this.getDecimals()) + "f";
            this.redraw();
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    Axis.this.tickLabelFormatString = "%." + Integer.toString(Axis.this.getDecimals()) + "f";
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "locale";
                }
            };
            this._locale = null;
        }
        return this.locale;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 12, DECIMALS);
            this.tickLabelFormatString = "%." + Integer.toString(this._decimals) + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimals() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 12, this.get()));
                    Axis.this.tickLabelFormatString = "%." + Integer.toString(this.get()) + "f";
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public TickLabelOrientation getTickLabelOrientation() {
        return null == this.tickLabelOrientation ? this._tickLabelOrientation : (TickLabelOrientation)((Object)this.tickLabelOrientation.get());
    }

    public void setTickLabelOrientation(TickLabelOrientation ORIENTATION) {
        if (null == this.tickLabelOrientation) {
            this._tickLabelOrientation = ORIENTATION;
            this.redraw();
        } else {
            this.tickLabelOrientation.set((Object)ORIENTATION);
        }
    }

    public ObjectProperty<TickLabelOrientation> tickLabelOrientationProperty() {
        if (null == this.tickLabelOrientation) {
            this.tickLabelOrientation = new ObjectPropertyBase<TickLabelOrientation>(this._tickLabelOrientation){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "tickLabelOrientation";
                }
            };
            this._tickLabelOrientation = null;
        }
        return this.tickLabelOrientation;
    }

    public ZoneId getZoneId() {
        return null == this.zoneId ? this._zoneId : (ZoneId)this.zoneId.get();
    }

    public void setZoneId(ZoneId ZONE_ID) {
        if (null == this.zoneId) {
            this._zoneId = ZONE_ID;
            this.redraw();
        } else {
            this.zoneId.set((Object)ZONE_ID);
        }
    }

    public ObjectProperty<ZoneId> zoneIdProperty() {
        if (null == this.zoneId) {
            this.zoneId = new ObjectPropertyBase<ZoneId>(this._zoneId){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "zoneId";
                }
            };
            this._zoneId = null;
        }
        return this.zoneId;
    }

    public String getDateTimeFormatPattern() {
        return null == this.dateTimeFormatPattern ? this._dateTimeFormatPattern : (String)this.dateTimeFormatPattern.get();
    }

    public void setDateTimeFormatPattern(String PATTERN) {
        if (null == this.dateTimeFormatPattern) {
            this._dateTimeFormatPattern = PATTERN;
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(PATTERN);
            this.redraw();
        } else {
            this.dateTimeFormatPattern.set((Object)PATTERN);
        }
    }

    public StringProperty dateTimeFormatPatternProperty() {
        if (null == this.dateTimeFormatPattern) {
            this.dateTimeFormatPattern = new StringPropertyBase(this._dateTimeFormatPattern){

                protected void invalidated() {
                    Axis.this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.get());
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "dateTimeFormat";
                }
            };
            this._dateTimeFormatPattern = null;
        }
        return this.dateTimeFormatPattern;
    }

    public StringConverter<Number> getNumberFormatter() {
        return this.numberFormatter;
    }

    public void setNumberFormatter(StringConverter<Number> FORMATTER) {
        this.numberFormatter = FORMATTER;
        this.redraw();
    }

    public TickLabelFormat getTickLabelFormat() {
        return null == this.tickLabelFormat ? this._tickLabelFormat : (TickLabelFormat)((Object)this.tickLabelFormat.get());
    }

    public void setTickLabelFormat(TickLabelFormat FORMAT) {
        if (null == this.tickLabelFormat) {
            this._tickLabelFormat = FORMAT;
            this.redraw();
        } else {
            this.tickLabelFormat.set((Object)FORMAT);
        }
    }

    public ObjectProperty<TickLabelFormat> tickLabelFormatProperty() {
        if (null == this.tickLabelFormat) {
            this.tickLabelFormat = new ObjectPropertyBase<TickLabelFormat>(this._tickLabelFormat){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "tickLabelFormat";
                }
            };
            this._tickLabelFormat = null;
        }
        return this.tickLabelFormat;
    }

    public boolean isAutoTitleFontSize() {
        return null == this.autoTitleFontSize ? this._autoTitleFontSize : this.autoTitleFontSize.get();
    }

    public void setAutoTitleFontSize(boolean AUTO) {
        if (null == this.autoTitleFontSize) {
            this._autoTitleFontSize = AUTO;
            this.redraw();
        } else {
            this.autoTitleFontSize.set(AUTO);
        }
    }

    public BooleanProperty autoTitleFontSizeProperty() {
        if (null == this.autoTitleFontSize) {
            this.autoTitleFontSize = new BooleanPropertyBase(this._autoTitleFontSize){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "autoTitleFontSize";
                }
            };
        }
        return this.autoTitleFontSize;
    }

    public boolean isAutoFontSize() {
        return null == this.autoFontSize ? this._autoFontSize : this.autoFontSize.get();
    }

    public void setAutoFontSize(boolean AUTO) {
        if (null == this.autoFontSize) {
            this._autoFontSize = AUTO;
            this.redraw();
        } else {
            this.autoFontSize.set(AUTO);
        }
    }

    public BooleanProperty autoFontSizeProperty() {
        if (null == this.autoFontSize) {
            this.autoFontSize = new BooleanPropertyBase(this._autoFontSize){

                protected void invalidated() {
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "autoFontSize";
                }
            };
        }
        return this.autoFontSize;
    }

    public double getTickLabelFontSize() {
        return null == this.tickLabelFontSize ? this._tickLabelFontSize : this.tickLabelFontSize.get();
    }

    public void setTickLabelFontSize(double SIZE) {
        if (null == this.tickLabelFontSize) {
            this._tickLabelFontSize = SIZE;
            this.tickLabelFont = Fonts.latoLight((double)SIZE);
            this.redraw();
        } else {
            this.tickLabelFontSize.set(SIZE);
        }
    }

    public DoubleProperty tickLabelFontSizeProperty() {
        if (null == this.tickLabelFontSize) {
            this.tickLabelFontSize = new DoublePropertyBase(this._tickLabelFontSize){

                protected void invalidated() {
                    Axis.this.tickLabelFont = Fonts.latoLight((double)this.get());
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "tickLabelFontSize";
                }
            };
        }
        return this.tickLabelFontSize;
    }

    public double getTitleFontSize() {
        return null == this.titleFontSize ? this._titleFontSize : this.titleFontSize.get();
    }

    public void setTitleFontSize(double SIZE) {
        if (null == this.titleFontSize) {
            this._titleFontSize = SIZE;
            this.titleFont = Fonts.latoRegular((double)this._titleFontSize);
            this.redraw();
        } else {
            this.titleFontSize.set(SIZE);
        }
    }

    public DoubleProperty titleFontSizeProperty() {
        if (null == this.titleFontSize) {
            this.titleFontSize = new DoublePropertyBase(this._titleFontSize){

                protected void invalidated() {
                    Axis.this.titleFont = Fonts.latoRegular((double)this.get());
                    Axis.this.redraw();
                }

                public Object getBean() {
                    return Axis.this;
                }

                public String getName() {
                    return "titleFontSize";
                }
            };
        }
        return this.titleFontSize;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(String ... CATEGORIES) {
        this.setCategories(Arrays.asList(CATEGORIES));
    }

    public void setCategories(List<String> CATEGORIES) {
        this.categories.clear();
        CATEGORIES.forEach(category -> this.categories.add((String)category));
        this.redraw();
    }

    public boolean isValueOnAxis(Double VALUE) {
        return Double.compare(VALUE, this.getMinValue()) >= 0 && Double.compare(VALUE, this.getMaxValue()) <= 0;
    }

    public boolean isValueOnAxis(LocalDateTime DATE_TIME) {
        return DATE_TIME.isAfter(this.getStart()) && DATE_TIME.isBefore(this.getEnd());
    }

    public void setMinMax(double MIN_VALUE, double MAX_VALUE) {
        this.setMinValue(MIN_VALUE);
        this.setMaxValue(MAX_VALUE);
        this.resize();
    }

    public void setStartEnd(LocalDateTime start, LocalDateTime end) {
        this.setStart(start);
        this.setEnd(end);
        this.resize();
    }

    public void setStartEnd(Instant start, Instant end) {
        this.setStart(start);
        this.setEnd(end);
        this.resize();
    }

    public void setStartEnd(Instant start, Instant end, ZoneId zoneId) {
        this.setStart(start, zoneId);
        this.setEnd(end, zoneId);
        this.resize();
    }

    public void setStartEnd(long startEpochSeconds, long endEpochSeconds, ZoneId zoneId) {
        if (startEpochSeconds < Instant.MIN.getEpochSecond()) {
            throw new IllegalArgumentException("Start cannot be before " + Instant.MIN.getEpochSecond());
        }
        if (endEpochSeconds > Instant.MAX.getEpochSecond()) {
            throw new IllegalArgumentException("End cannot be after " + Instant.MAX.getEpochSecond());
        }
        if (startEpochSeconds > endEpochSeconds) {
            throw new IllegalArgumentException("Start cannot be after end");
        }
        if (endEpochSeconds < startEpochSeconds) {
            throw new IllegalArgumentException("End cannot be before start");
        }
        this.setStart(startEpochSeconds, zoneId);
        this.setEnd(endEpochSeconds, zoneId);
        this.resize();
    }

    public double getRange() {
        return this.getMaxValue() - this.getMinValue();
    }

    public void setTickMarkColor(Color COLOR) {
        this.setMinorTickMarkColor(COLOR);
        this.setMediumTickMarkColor(COLOR);
        this.setMajorTickMarkColor(COLOR);
    }

    public void setTickMarksVisible(boolean VISIBLE) {
        this.setMinorTickMarksVisible(VISIBLE);
        this.setMediumTickMarksVisible(VISIBLE);
        this.setMajorTickMarksVisible(VISIBLE);
    }

    public void shift(double VALUE) {
        this.setMinMax(this.getMinValue() + VALUE, this.getMaxValue() + VALUE);
    }

    public double getValueForDisplay(double posInAxis) {
        return posInAxis / this.width * Helper.calcNiceNumber(this.getMaxValue() - this.getMinValue(), false) + this.getMinValue();
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public Bounds getAxisBounds() {
        return this.axisBounds;
    }

    public void dispose() {
        this.removeChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, this.evtEvtObserver);
    }

    private void calcAutoScale() {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(this.getMaxValue() - this.getMinValue(), false);
        this.setMajorTickSpace(Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true));
        this.setMinorTickSpace(Helper.calcNiceNumber(this.getMajorTickSpace() / (maxNoOfMinorTicks - 1.0), true));
        double niceMinValue = Math.floor(this.getMinValue() / this.getMajorTickSpace()) * this.getMajorTickSpace();
        double niceMaxValue = Math.ceil(this.getMaxValue() / this.getMajorTickSpace()) * this.getMajorTickSpace();
        this.setMinValue(niceMinValue);
        this.setMaxValue(niceMaxValue);
    }

    private void calcScale() {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        if (this.getMajorTickSpace() == 10.0) {
            this.setMajorTickSpace(Helper.calcNiceNumber(this.getRange() / (maxNoOfMajorTicks - 1.0), false));
        }
        if (this.getMinorTickSpace() == 1.0) {
            this.setMinorTickSpace(Helper.calcNiceNumber(this.getMajorTickSpace() / (maxNoOfMinorTicks - 1.0), false));
        }
    }

    private double calcTextWidth(Font FONT, String TEXT) {
        Text text = new Text(TEXT);
        text.setFont(FONT);
        double width = text.getBoundsInParent().getWidth();
        text = null;
        return width;
    }

    private double toNumericValue(LocalDateTime DATE) {
        return Helper.toMillis(DATE, Helper.getZoneOffset(this.getZoneId()));
    }

    private LocalDateTime toRealValue(double VALUE) {
        return this.toLocalDateTime((long)VALUE);
    }

    private LocalDateTime toLocalDateTime(long SECONDS) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(SECONDS), ZoneId.systemDefault());
    }

    private List<LocalDateTime> createTickValues(double WIDTH, LocalDateTime START, LocalDateTime END) {
        ArrayList<LocalDateTime> dateList = new ArrayList<LocalDateTime>();
        LocalDateTime dateTime = LocalDateTime.now();
        if (null == START || null == END) {
            return dateList;
        }
        double majorTickSpace = 100.0;
        double noOfTicks = WIDTH / majorTickSpace;
        ArrayList<LocalDateTime> previousDateList = new ArrayList<LocalDateTime>();
        Helper.Interval previousInterval = Helper.Interval.values()[0];
        for (Helper.Interval interval : Helper.Interval.values()) {
            dateTime = LocalDateTime.of(START.toLocalDate(), START.toLocalTime());
            dateList.clear();
            previousDateList.clear();
            this.currentInterval = interval;
            while (dateTime.isBefore(END)) {
                dateList.add(dateTime);
                dateTime = dateTime.plus(interval.getAmount(), interval.getInterval());
            }
            if ((double)dateList.size() > noOfTicks) {
                dateTime = LocalDateTime.of(START.toLocalDate(), START.toLocalTime());
                while (dateTime.isBefore(END) || dateTime.isEqual(END)) {
                    previousDateList.add(dateTime);
                    dateTime = dateTime.plus(previousInterval.getAmount(), previousInterval.getInterval());
                }
                break;
            }
            previousInterval = interval;
        }
        if ((double)previousDateList.size() - noOfTicks > noOfTicks - (double)dateList.size()) {
            dateList = previousDateList;
            this.currentInterval = previousInterval;
        }
        dateList.add(END);
        List<LocalDateTime> evenDateList = this.makeDatesEven(dateList, dateTime);
        if (evenDateList.size() > 2) {
            LocalDateTime secondDate = evenDateList.get(1);
            LocalDateTime thirdDate = evenDateList.get(2);
            LocalDateTime lastDate = evenDateList.get(dateList.size() - 2);
            LocalDateTime previousLastDate = evenDateList.get(dateList.size() - 3);
            if (secondDate.toEpochSecond(ZoneOffset.ofHours(0)) - START.toEpochSecond(ZoneOffset.ofHours(0)) < thirdDate.toEpochSecond(ZoneOffset.ofHours(0)) - secondDate.toEpochSecond(ZoneOffset.ofHours(0))) {
                evenDateList.remove(secondDate);
            }
            if ((double)(END.toEpochSecond(ZoneOffset.ofHours(0)) - lastDate.toEpochSecond(ZoneOffset.ofHours(0))) < (double)lastDate.toEpochSecond(ZoneOffset.ofHours(0)) - (double)previousLastDate.toEpochSecond(ZoneOffset.ofHours(0)) * 0.5) {
                evenDateList.remove(lastDate);
            }
        }
        return evenDateList;
    }

    private List<LocalDateTime> makeDatesEven(List<LocalDateTime> dates, LocalDateTime dateTime) {
        if (dates.size() > 2) {
            ArrayList<LocalDateTime> evenDates = new ArrayList<LocalDateTime>();
            for (int i = 0; i < dates.size(); ++i) {
                dateTime = dates.get(i);
                switch (this.currentInterval.getInterval()) {
                    case YEARS: {
                        if (i != 0 && i != dates.size() - 1) {
                            dateTime.withMonth(1);
                            dateTime.withDayOfMonth(1);
                        }
                        dateTime.withHour(0);
                        dateTime.withMinute(0);
                        dateTime.withSecond(0);
                        dateTime.withNano(6000000);
                        break;
                    }
                    case MONTHS: {
                        if (i != 0 && i != dates.size() - 1) {
                            dateTime.withDayOfMonth(1);
                        }
                        dateTime.withHour(0);
                        dateTime.withMinute(0);
                        dateTime.withSecond(0);
                        dateTime.withNano(5000000);
                        break;
                    }
                    case WEEKS: {
                        dateTime.withHour(0);
                        dateTime.withMinute(0);
                        dateTime.withSecond(0);
                        dateTime.withNano(4000000);
                        break;
                    }
                    case DAYS: {
                        dateTime.withHour(0);
                        dateTime.withMinute(0);
                        dateTime.withSecond(0);
                        dateTime.withNano(3000000);
                        break;
                    }
                    case HOURS: {
                        if (i != 0 && i != dates.size() - 1) {
                            dateTime.withMinute(0);
                            dateTime.withSecond(0);
                        }
                        dateTime.withNano(2000000);
                        break;
                    }
                    case MINUTES: {
                        if (i != 0 && i != dates.size() - 1) {
                            dateTime.withSecond(0);
                        }
                        dateTime.withNano(1000000);
                        break;
                    }
                    case SECONDS: {
                        dateTime.withSecond(0);
                    }
                }
                evenDates.add(dateTime);
            }
            return evenDates;
        }
        return dates;
    }

    private String formatNumber(Locale locale, double number) {
        if (this.numberFormatter == null) {
            return String.format(locale, this.tickLabelFormatString, number);
        }
        return this.numberFormatter.toString((Object)number);
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    private void drawAxis() {
        double maxMinorTickMarkLength;
        double maxMediumTickMarkLength;
        double maxMajorTickMarkLength;
        double textPosition;
        double maxPosition;
        double minPosition;
        double minorLineWidth;
        if (Double.compare(this.stepSize, 0.0) <= 0) {
            return;
        }
        this.stepSize = Orientation.VERTICAL == this.getOrientation() ? Math.abs(this.height / this.getRange()) : Math.abs(this.width / this.getRange());
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        if (this.isAutoScale()) {
            double niceRange = Helper.calcNiceNumber(this.getMaxValue() - this.getMinValue(), false);
            this.setMajorTickSpace(Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true));
            this.setMinorTickSpace(Helper.calcNiceNumber(this.getMajorTickSpace() / (maxNoOfMinorTicks - 1.0), true));
        } else {
            if (this.getMajorTickSpace() == 10.0) {
                this.setMajorTickSpace(Helper.calcNiceNumber(this.getRange() / (maxNoOfMajorTicks - 1.0), false));
            }
            if (this.getMinorTickSpace() == 1.0) {
                this.setMinorTickSpace(Helper.calcNiceNumber(this.getMajorTickSpace() / (maxNoOfMinorTicks - 1.0), false));
            }
        }
        this.axisCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.axisCtx.setFill((Paint)this.getAxisBackgroundColor());
        this.axisCtx.fillRect(0.0, 0.0, this.width, this.height);
        this.axisCtx.setFont(this.tickLabelFont);
        this.axisCtx.setTextBaseline(VPos.CENTER);
        AxisType axisType = this.getType();
        boolean isAutoScale = this.isAutoScale();
        double minValue = this.getMinValue();
        double maxValue = this.getMaxValue();
        boolean tickLabelsVisible = this.getTickLabelsVisible();
        boolean isOnlyFirstAndLastTickLabelVisible = this.isOnlyFirstAndLastTickLabelVisible();
        double tickLabelFontSize = this.getTickLabelFontSize();
        TickLabelFormat tickLabelFormat = this.getTickLabelFormat();
        Color tickLabelColor = this.getTickLabelColor();
        Color zeroColor = this.getZeroColor();
        Color majorTickMarkColor = this.getMajorTickMarkColor();
        boolean majorTickMarksVisible = this.getMajorTickMarksVisible();
        Color mediumTickMarkColor = this.getMediumTickMarkColor();
        boolean mediumTickMarksVisible = this.getMediumTickMarksVisible();
        Color minorTickMarkColor = this.getMinorTickMarkColor();
        boolean minorTickMarksVisible = this.getMinorTickMarksVisible();
        boolean sameTickMarkLength = this.getSameTickMarkLength();
        double majorLineWidth = this.size * 0.007 < 1.0 ? 1.0 : this.size * 0.007;
        double mediumLineWidth = this.size * 0.006 < 0.75 ? 0.75 : this.size * 0.005;
        double d = minorLineWidth = this.size * 0.005 < 0.5 ? 0.5 : this.size * 0.003;
        if (Orientation.VERTICAL == this.getOrientation()) {
            minPosition = 0.0;
            maxPosition = this.height;
            textPosition = this.width * 0.3;
            maxMajorTickMarkLength = sameTickMarkLength ? this.width * 0.175 : this.width * 0.2;
            maxMediumTickMarkLength = this.width * 0.175;
            maxMinorTickMarkLength = sameTickMarkLength ? this.width * 0.175 : this.width * 0.1;
        } else {
            minPosition = 0.0;
            maxPosition = this.width;
            textPosition = this.height * 0.5;
            maxMajorTickMarkLength = sameTickMarkLength ? this.height * 0.175 : this.height * 0.2;
            maxMediumTickMarkLength = this.height * 0.175;
            maxMinorTickMarkLength = sameTickMarkLength ? this.height * 0.175 : this.height * 0.1;
        }
        Locale locale = this.getLocale();
        Orientation orientation = this.getOrientation();
        Position position = this.getPosition();
        double anchorX = Position.LEFT == position || Position.CENTER == position ? 0.0 : this.getZeroPosition();
        double anchorXPlusOffset = anchorX + this.width;
        double anchorY = Position.BOTTOM == position || Position.CENTER == position ? 0.0 : this.getZeroPosition();
        double anchorYPlusOffset = anchorY + this.height;
        if (Position.RIGHT == position) {
            anchorX = 0.0;
        }
        if (AxisType.LINEAR == axisType || AxisType.TEXT == axisType) {
            boolean fullRange = minValue < 0.0 && maxValue > 0.0;
            double minorTickSpace = this.getMinorTickSpace();
            double majorTickSpace = this.getMajorTickSpace();
            double tmpStepSize = minorTickSpace;
            BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
            BigDecimal majorTickSpaceBD = BigDecimal.valueOf(majorTickSpace);
            BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
            BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
            BigDecimal counterBD = BigDecimal.valueOf(minValue);
            double counter = minValue;
            double range = this.getRange();
            int noOfCategories = this.categories.size();
            this.axisCtx.setStroke((Paint)this.getAxisColor());
            this.axisCtx.setLineWidth(majorLineWidth);
            if (Orientation.VERTICAL == orientation) {
                switch (position) {
                    case LEFT: {
                        this.axisCtx.strokeLine(anchorXPlusOffset, minPosition, anchorXPlusOffset, maxPosition);
                        break;
                    }
                    case RIGHT: {
                        this.axisCtx.strokeLine(anchorX, minPosition, anchorX, maxPosition);
                        break;
                    }
                    default: {
                        this.axisCtx.strokeLine(anchorX, minPosition, anchorX, maxPosition);
                        break;
                    }
                }
            } else {
                switch (position) {
                    case BOTTOM: {
                        this.axisCtx.strokeLine(minPosition, anchorY, maxPosition, anchorY);
                        break;
                    }
                    case TOP: {
                        this.axisCtx.strokeLine(minPosition, anchorYPlusOffset, maxPosition, anchorYPlusOffset);
                        break;
                    }
                    default: {
                        this.axisCtx.strokeLine(minPosition, anchorY, maxPosition, anchorY);
                    }
                }
            }
            BigDecimal tmpStepBD = new BigDecimal(tmpStepSize);
            tmpStepBD = tmpStepBD.setScale(6, RoundingMode.HALF_UP);
            double tmpStep = tmpStepBD.doubleValue();
            int tickMarkCounter = 0;
            int tickLabelCounter = 0;
            double i = 0.0;
            while (Double.compare(-range - tmpStep, i) <= 0) {
                double maxTextWidth;
                double textPointY;
                double textPointX;
                double outerPointY;
                double outerPointX;
                double minorPointY;
                double minorPointX;
                double mediumPointY;
                double mediumPointX;
                double innerPointY;
                double innerPointX;
                double fixedPosition = (counter - minValue) * this.stepSize;
                if (Orientation.VERTICAL == orientation) {
                    if (Position.LEFT == position) {
                        innerPointX = anchorXPlusOffset - maxMajorTickMarkLength;
                        innerPointY = fixedPosition;
                        mediumPointX = anchorXPlusOffset - maxMediumTickMarkLength;
                        mediumPointY = fixedPosition;
                        minorPointX = anchorXPlusOffset - maxMinorTickMarkLength;
                        minorPointY = fixedPosition;
                        outerPointX = anchorXPlusOffset;
                        outerPointY = fixedPosition;
                        textPointX = anchorXPlusOffset - textPosition;
                        textPointY = fixedPosition;
                        maxTextWidth = 0.6 * this.width;
                    } else if (Position.RIGHT == position) {
                        innerPointX = anchorX + maxMajorTickMarkLength;
                        innerPointY = fixedPosition;
                        mediumPointX = anchorX + maxMediumTickMarkLength;
                        mediumPointY = fixedPosition;
                        minorPointX = anchorX + maxMinorTickMarkLength;
                        minorPointY = fixedPosition;
                        outerPointX = anchorX;
                        outerPointY = fixedPosition;
                        textPointX = this.width;
                        textPointY = fixedPosition;
                        maxTextWidth = textPosition;
                    } else {
                        innerPointX = anchorX + maxMajorTickMarkLength;
                        innerPointY = fixedPosition;
                        mediumPointX = anchorX + maxMediumTickMarkLength;
                        mediumPointY = fixedPosition;
                        minorPointX = anchorX + maxMinorTickMarkLength;
                        minorPointY = fixedPosition;
                        outerPointX = anchorX;
                        outerPointY = fixedPosition;
                        textPointX = anchorXPlusOffset;
                        textPointY = fixedPosition;
                        maxTextWidth = textPosition;
                    }
                } else if (Position.BOTTOM == position) {
                    innerPointX = fixedPosition;
                    innerPointY = anchorY + maxMajorTickMarkLength;
                    mediumPointX = fixedPosition;
                    mediumPointY = anchorY + maxMediumTickMarkLength;
                    minorPointX = fixedPosition;
                    minorPointY = anchorY + maxMinorTickMarkLength;
                    outerPointX = fixedPosition;
                    outerPointY = anchorY;
                    textPointX = fixedPosition;
                    textPointY = innerPointY + textPosition - tickLabelFontSize * 0.8;
                    maxTextWidth = majorTickSpace * this.stepSize;
                } else if (Position.TOP == position) {
                    innerPointX = fixedPosition;
                    innerPointY = anchorYPlusOffset - maxMajorTickMarkLength;
                    mediumPointX = fixedPosition;
                    mediumPointY = anchorYPlusOffset - maxMediumTickMarkLength;
                    minorPointX = fixedPosition;
                    minorPointY = anchorYPlusOffset - maxMinorTickMarkLength;
                    outerPointX = fixedPosition;
                    outerPointY = anchorYPlusOffset;
                    textPointX = fixedPosition;
                    textPointY = innerPointY - textPosition + tickLabelFontSize * 0.5;
                    maxTextWidth = majorTickSpace * this.stepSize;
                } else {
                    innerPointX = fixedPosition;
                    innerPointY = anchorY + maxMajorTickMarkLength;
                    mediumPointX = fixedPosition;
                    mediumPointY = anchorY + maxMediumTickMarkLength;
                    minorPointX = fixedPosition;
                    minorPointY = anchorY + maxMinorTickMarkLength;
                    outerPointX = fixedPosition;
                    outerPointY = anchorY;
                    textPointX = fixedPosition;
                    textPointY = innerPointY + textPosition - tickLabelFontSize * 0.8;
                    maxTextWidth = majorTickSpace * this.stepSize;
                }
                if (Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                    isMinValue = Double.compare(minValue, counter) == 0;
                    boolean bl = isMaxValue = Double.compare(maxValue, counter) == 0;
                    if (Orientation.VERTICAL == orientation) {
                        isZero = Double.compare(0.0, maxValue - counter + minValue) == 0;
                    } else {
                        boolean bl2 = isZero = Double.compare(0.0, counter) == 0;
                    }
                    if (isZero) {
                        this.setZeroPosition(fixedPosition);
                    }
                    if (majorTickMarksVisible) {
                        this.drawTickMark(fullRange && isZero ? zeroColor : majorTickMarkColor, majorLineWidth, innerPointX, innerPointY, outerPointX, outerPointY);
                    } else if (minorTickMarksVisible) {
                        this.drawTickMark(fullRange && isZero ? zeroColor : minorTickMarkColor, minorLineWidth, minorPointX, minorPointY, outerPointX, outerPointY);
                    }
                    if (tickLabelsVisible && tickLabelFontSize > 6.0) {
                        if (AxisType.LINEAR == axisType) {
                            tickLabelString = TickLabelFormat.NUMBER == tickLabelFormat ? (Orientation.HORIZONTAL == orientation ? this.formatNumber(locale, minValue - i) : this.formatNumber(locale, maxValue - counter + minValue)) : (Orientation.HORIZONTAL == orientation ? Helper.secondsToHHMMString(Helper.toSeconds(Helper.toRealValue(minValue - i), Helper.getZoneOffset())) : this.formatNumber(locale, maxValue - counter + minValue));
                        } else if (AxisType.TEXT == axisType) {
                            tickLabelString = tickLabelCounter < noOfCategories ? this.categories.get(tickLabelCounter) : "";
                            tickLabelCounter = isAutoScale ? (tickLabelCounter += (int)majorTickSpace) : ++tickLabelCounter;
                        } else {
                            tickLabelString = this.dateTimeFormatter.format(this.toLocalDateTime((long)(minValue - i) * 1000L));
                        }
                        this.drawTickLabel(isOnlyFirstAndLastTickLabelVisible, isZero, isMinValue, isMaxValue, fullRange, zeroColor, tickLabelColor, textPointX, textPointY, maxTextWidth, tickLabelString, orientation);
                    }
                } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                    this.drawTickMark(mediumTickMarkColor, mediumLineWidth, mediumPointX, mediumPointY, outerPointX, outerPointY);
                } else if (minorTickMarksVisible && Double.compare(counterBD.setScale(12, RoundingMode.HALF_UP).remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0) {
                    this.drawTickMark(minorTickMarkColor, minorLineWidth, minorPointX, minorPointY, outerPointX, outerPointY);
                } else if (!isAutoScale && tickMarkCounter % 10 == 0) {
                    isMinValue = Double.compare(minValue, counter) == 0;
                    boolean bl = isMaxValue = Double.compare(maxValue, counter) == 0;
                    if (Orientation.VERTICAL == orientation) {
                        isZero = Double.compare(0.0, maxValue - counter + minValue) == 0;
                    } else {
                        boolean bl3 = isZero = Double.compare(0.0, counter) == 0;
                    }
                    if (isZero) {
                        this.setZeroPosition(fixedPosition);
                    }
                    if (minorTickMarksVisible) {
                        this.drawTickMark(fullRange && isZero ? zeroColor : minorTickMarkColor, minorLineWidth, innerPointX, innerPointY, outerPointX, outerPointY);
                    }
                    if (tickLabelsVisible) {
                        tickLabelString = TickLabelFormat.NUMBER == this.getTickLabelFormat() ? (Orientation.HORIZONTAL == orientation ? this.formatNumber(locale, minValue - i) : this.formatNumber(locale, maxValue - counter + minValue)) : (Orientation.HORIZONTAL == orientation ? Helper.secondsToHHMMString(Helper.toSeconds(Helper.toRealValue(minValue - i), Helper.getZoneOffset())) : this.formatNumber(locale, maxValue - counter + minValue));
                        this.drawTickLabel(isOnlyFirstAndLastTickLabelVisible, isZero, isMinValue, isMaxValue, fullRange, zeroColor, tickLabelColor, textPointX, textPointY, maxTextWidth, tickLabelString, orientation);
                    }
                } else if (tickMarkCounter % 1 == 0 && minorTickMarksVisible) {
                    this.drawTickMark(minorTickMarkColor, minorLineWidth, minorPointX, minorPointY, outerPointX, outerPointY);
                }
                if (!((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > maxValue)) {
                    i -= tmpStep;
                    continue;
                }
                break;
            }
        } else if (AxisType.LOGARITHMIC == axisType) {
            double section;
            this.tickLabelFormatString = "%6.0e";
            double logLowerBound = Math.log10(this.getMinValue());
            double logUpperBound = Math.log10(this.getMaxValue());
            if (Orientation.VERTICAL == orientation) {
                section = this.height / logUpperBound;
                if (Position.LEFT == position) {
                    this.axisCtx.strokeLine(anchorXPlusOffset, minPosition, anchorXPlusOffset, maxPosition);
                } else if (Position.RIGHT == position) {
                    this.axisCtx.strokeLine(anchorX, minPosition, anchorX, maxPosition);
                }
            } else {
                section = this.width / logUpperBound;
                if (Position.BOTTOM == position) {
                    this.axisCtx.strokeLine(minPosition, anchorY, maxPosition, anchorY);
                } else if (Position.TOP == position) {
                    this.axisCtx.strokeLine(minPosition, anchorYPlusOffset, maxPosition, anchorYPlusOffset);
                }
            }
            for (double i = 0.0; i <= logUpperBound; i += 1.0) {
                for (double j = 1.0; j <= 9.0; j += 1.0) {
                    double maxTextWidth;
                    double textPointY;
                    double textPointX;
                    double outerPointY;
                    double outerPointX;
                    double minorPointY;
                    double minorPointX;
                    double innerPointY;
                    double innerPointX;
                    boolean isMaxValue;
                    boolean isMinValue;
                    double stepSize;
                    BigDecimal value = new BigDecimal(j * Math.pow(10.0, i));
                    double d2 = stepSize = i > 0.0 ? Math.log10(value.doubleValue()) % i : Math.log10(value.doubleValue());
                    if (Orientation.VERTICAL == orientation) {
                        isMinValue = Double.compare(i, logUpperBound) == 0;
                        isMaxValue = i == 0.0;
                        fixedPosition = maxPosition - i * section - stepSize * section;
                        if (Position.LEFT == position) {
                            innerPointX = anchorXPlusOffset - maxMajorTickMarkLength;
                            innerPointY = fixedPosition;
                            minorPointX = anchorXPlusOffset - maxMinorTickMarkLength;
                            minorPointY = fixedPosition;
                            outerPointX = anchorXPlusOffset;
                            outerPointY = fixedPosition;
                            textPointX = anchorXPlusOffset - textPosition;
                            textPointY = fixedPosition;
                            maxTextWidth = 0.6 * this.width;
                        } else {
                            innerPointX = anchorX + maxMajorTickMarkLength;
                            innerPointY = fixedPosition;
                            minorPointX = anchorX + maxMinorTickMarkLength;
                            minorPointY = fixedPosition;
                            outerPointX = anchorX;
                            outerPointY = fixedPosition;
                            textPointX = anchorXPlusOffset;
                            textPointY = fixedPosition;
                            maxTextWidth = this.width;
                        }
                    } else {
                        isMinValue = i == 0.0;
                        isMaxValue = Double.compare(i, logUpperBound) == 0;
                        fixedPosition = i * section + stepSize * section;
                        if (Position.BOTTOM == position) {
                            innerPointX = fixedPosition;
                            innerPointY = anchorY + maxMajorTickMarkLength;
                            minorPointX = fixedPosition;
                            minorPointY = anchorY + maxMinorTickMarkLength;
                            outerPointX = fixedPosition;
                            outerPointY = anchorY;
                            textPointX = fixedPosition;
                            textPointY = anchorY + textPosition - tickLabelFontSize * 0.2;
                            maxTextWidth = section;
                        } else {
                            innerPointX = fixedPosition;
                            innerPointY = anchorYPlusOffset - maxMajorTickMarkLength;
                            minorPointX = fixedPosition;
                            minorPointY = anchorYPlusOffset - maxMinorTickMarkLength;
                            outerPointX = fixedPosition;
                            outerPointY = anchorYPlusOffset;
                            textPointX = fixedPosition;
                            textPointY = anchorY - textPosition + tickLabelFontSize * 0.5;
                            maxTextWidth = section;
                        }
                    }
                    if (Helper.isPowerOf10(value.intValue())) {
                        if (majorTickMarksVisible) {
                            this.drawTickMark(majorTickMarkColor, majorLineWidth, innerPointX, innerPointY, outerPointX, outerPointY);
                        } else if (minorTickMarksVisible) {
                            this.drawTickMark(minorTickMarkColor, minorLineWidth, minorPointX, minorPointY, outerPointX, outerPointY);
                        }
                        if (!tickLabelsVisible) continue;
                        this.axisCtx.setFill((Paint)tickLabelColor);
                        if (Orientation.VERTICAL == orientation) {
                            this.axisCtx.setTextAlign(TextAlignment.RIGHT);
                        }
                        this.drawTickLabel(isOnlyFirstAndLastTickLabelVisible, false, isMinValue, isMaxValue, false, zeroColor, tickLabelColor, textPointX, textPointY, maxTextWidth, this.formatNumber(locale, value.doubleValue()), orientation);
                        continue;
                    }
                    if (!minorTickMarksVisible) continue;
                    this.drawTickMark(minorTickMarkColor, minorLineWidth, minorPointX, minorPointY, outerPointX, outerPointY);
                }
            }
        }
        this.drawAxisTitle(orientation, position);
    }

    private void drawTimeAxis() {
        double maxPosition;
        double minPosition;
        double minorLineWidth;
        if (Double.compare(this.stepSize, 0.0) <= 0) {
            return;
        }
        this.axisCtx.setFill((Paint)this.getAxisBackgroundColor());
        this.axisCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.axisCtx.setFont(this.tickLabelFont);
        this.axisCtx.setTextBaseline(VPos.CENTER);
        double minValue = Helper.toNumericValue(this.getStart());
        double maxValue = Helper.toNumericValue(this.getEnd());
        boolean tickLabelsVisible = this.getTickLabelsVisible();
        boolean mediumTickLabelsVisible = this.getMediumTimeAxisTickLabelsVisible();
        boolean isOnlyFirstAndLastTickLabelVisible = this.isOnlyFirstAndLastTickLabelVisible();
        double tickLabelFontSize = this.getTickLabelFontSize();
        Color tickLabelColor = this.getTickLabelColor();
        Color majorTickMarkColor = this.getMajorTickMarkColor();
        boolean majorTickMarksVisible = this.getMajorTickMarksVisible();
        Color mediumTickMarkColor = this.getMediumTickMarkColor();
        boolean mediumTickMarksVisible = this.getMediumTickMarksVisible();
        Color minorTickMarkColor = this.getMinorTickMarkColor();
        boolean minorTickMarksVisible = this.getMinorTickMarksVisible();
        boolean sameTickMarkLength = this.getSameTickMarkLength();
        double majorLineWidth = this.size * 0.007 < 1.0 ? 1.0 : this.size * 0.007;
        double mediumLineWidth = this.size * 0.006 < 0.75 ? 0.75 : this.size * 0.005;
        double d = minorLineWidth = this.size * 0.005 < 0.5 ? 0.5 : this.size * 0.003;
        if (Orientation.VERTICAL == this.getOrientation()) {
            minPosition = 0.0;
            maxPosition = this.height;
        } else {
            minPosition = 0.0;
            maxPosition = this.width;
        }
        Orientation orientation = this.getOrientation();
        Position position = this.getPosition();
        double anchorX = Position.LEFT == position ? 0.0 : this.getZeroPosition();
        double anchorXPlusOffset = anchorX + this.width;
        double anchorY = Position.BOTTOM == position ? 0.0 : this.getZeroPosition();
        double anchorYPlusOffset = anchorY + this.height;
        this.createTickValues(this.width, this.getStart(), this.getEnd());
        long minValueInSeconds = this.getStart().toEpochSecond(Helper.getZoneOffset());
        long maxValueInSeconds = this.getEnd().toEpochSecond(Helper.getZoneOffset());
        long rangeInSeconds = Duration.between(this.getStart(), this.getEnd()).getSeconds();
        double stepSize = Orientation.VERTICAL == orientation ? this.height / (double)rangeInSeconds : this.width / (double)rangeInSeconds;
        long majorTickSpace = this.currentInterval.getMajorTickSpace();
        long mediumTickSpace = this.currentInterval.getMediumTickSpace();
        long minorTickSpace = this.currentInterval.getMinorTickSpace();
        long counter = minValueInSeconds;
        this.axisCtx.setLineWidth(majorLineWidth);
        if (Orientation.VERTICAL == orientation) {
            switch (position) {
                case LEFT: {
                    this.axisCtx.strokeLine(anchorXPlusOffset, minPosition, anchorXPlusOffset, maxPosition);
                    break;
                }
                case RIGHT: {
                    this.axisCtx.strokeLine(anchorX, minPosition, anchorX, maxPosition);
                    break;
                }
                default: {
                    this.axisCtx.strokeLine(anchorX, minPosition, anchorX, maxPosition);
                    break;
                }
            }
        } else {
            switch (position) {
                case BOTTOM: {
                    this.axisCtx.strokeLine(minPosition, anchorY, maxPosition, anchorY);
                    break;
                }
                case TOP: {
                    this.axisCtx.strokeLine(minPosition, anchorYPlusOffset, maxPosition, anchorYPlusOffset);
                    break;
                }
                default: {
                    this.axisCtx.strokeLine(minPosition, anchorY, maxPosition, anchorY);
                }
            }
        }
        double majorTickMarkLengthFactor = sameTickMarkLength ? 0.4 : 0.5;
        double mediumTickMarkLengthFactor = 0.4;
        double minorTickMarkLengthFactor = sameTickMarkLength ? 0.4 : 0.3;
        double majorTickMarkLength = Orientation.VERTICAL == orientation ? majorTickMarkLengthFactor * this.width : majorTickMarkLengthFactor * this.height;
        double mediumTickMarkLength = Orientation.VERTICAL == orientation ? mediumTickMarkLengthFactor * this.width : mediumTickMarkLengthFactor * this.height;
        double minorTickMarkLength = Orientation.VERTICAL == orientation ? minorTickMarkLengthFactor * this.width : minorTickMarkLengthFactor * this.height;
        for (long i = minValueInSeconds; i <= maxValueInSeconds; ++i) {
            double maxTextWidth;
            double textPointY;
            double textPointX;
            double outerPointY;
            double outerPointX;
            double minorPointY;
            double minorPointX;
            double mediumPointY;
            double mediumPointX;
            double innerPointY;
            double innerPointX;
            double fixedPosition = (double)(counter - minValueInSeconds) * stepSize;
            if (Orientation.VERTICAL == orientation) {
                if (Position.LEFT == position) {
                    innerPointX = anchorXPlusOffset - majorTickMarkLength;
                    innerPointY = fixedPosition;
                    mediumPointX = anchorXPlusOffset - mediumTickMarkLength;
                    mediumPointY = fixedPosition;
                    minorPointX = anchorXPlusOffset - minorTickMarkLength;
                    minorPointY = fixedPosition;
                    outerPointX = anchorXPlusOffset;
                    outerPointY = fixedPosition;
                    textPointX = anchorXPlusOffset - 0.6 * this.width;
                    textPointY = fixedPosition;
                    maxTextWidth = 0.6 * this.width;
                } else if (Position.RIGHT == position) {
                    innerPointX = anchorX + majorTickMarkLength;
                    innerPointY = fixedPosition;
                    mediumPointX = anchorX + mediumTickMarkLength;
                    mediumPointY = fixedPosition;
                    minorPointX = anchorX + minorTickMarkLength;
                    minorPointY = fixedPosition;
                    outerPointX = anchorX;
                    outerPointY = fixedPosition;
                    textPointX = anchorXPlusOffset;
                    textPointY = fixedPosition;
                    maxTextWidth = this.width;
                } else {
                    innerPointX = anchorX - 0.25 * this.width;
                    innerPointY = fixedPosition;
                    mediumPointX = anchorX - 0.2 * this.width;
                    mediumPointY = fixedPosition;
                    minorPointX = anchorX - 0.15 * this.width;
                    minorPointY = fixedPosition;
                    outerPointX = anchorX;
                    outerPointY = fixedPosition;
                    textPointX = anchorXPlusOffset;
                    textPointY = fixedPosition;
                    maxTextWidth = this.width;
                }
            } else if (Position.BOTTOM == position) {
                innerPointX = fixedPosition;
                innerPointY = anchorY + majorTickMarkLength;
                mediumPointX = fixedPosition;
                mediumPointY = anchorY + mediumTickMarkLength;
                minorPointX = fixedPosition;
                minorPointY = anchorY + minorTickMarkLength;
                outerPointX = fixedPosition;
                outerPointY = anchorY;
                textPointX = fixedPosition;
                textPointY = anchorY + 0.8 * this.height;
                maxTextWidth = (double)majorTickSpace * stepSize;
            } else if (Position.TOP == position) {
                innerPointX = fixedPosition;
                innerPointY = anchorYPlusOffset - majorTickMarkLength;
                mediumPointX = fixedPosition;
                mediumPointY = anchorYPlusOffset - mediumTickMarkLength;
                minorPointX = fixedPosition;
                minorPointY = anchorYPlusOffset - minorTickMarkLength;
                outerPointX = fixedPosition;
                outerPointY = anchorYPlusOffset;
                textPointX = fixedPosition;
                textPointY = anchorY + 0.2 * this.height;
                maxTextWidth = (double)majorTickSpace * stepSize;
            } else {
                innerPointX = fixedPosition;
                innerPointY = anchorY - 0.25 * this.height;
                mediumPointX = fixedPosition;
                mediumPointY = anchorY - 0.2 * this.height;
                minorPointX = fixedPosition;
                minorPointY = anchorY - 0.15 * this.height;
                outerPointX = fixedPosition;
                outerPointY = anchorY;
                textPointX = fixedPosition;
                textPointY = anchorY + 0.2 * this.height;
                maxTextWidth = (double)majorTickSpace * stepSize;
            }
            if (i % majorTickSpace == 0L) {
                boolean isMaxValue;
                boolean isMinValue = i == minValueInSeconds;
                boolean bl = isMaxValue = i == maxValueInSeconds;
                if (majorTickMarksVisible) {
                    this.axisCtx.setStroke((Paint)majorTickMarkColor);
                    this.axisCtx.setLineWidth(majorLineWidth);
                    this.axisCtx.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                } else if (minorTickMarksVisible) {
                    this.axisCtx.setStroke((Paint)minorTickMarkColor);
                    this.axisCtx.setLineWidth(minorLineWidth);
                    this.axisCtx.strokeLine(minorPointX, minorPointY, outerPointX, outerPointY);
                }
                if (tickLabelsVisible && tickLabelFontSize > 6.0) {
                    if (!isOnlyFirstAndLastTickLabelVisible) {
                        this.axisCtx.setFill((Paint)tickLabelColor);
                    } else if (isMinValue || isMaxValue) {
                        this.axisCtx.setFill((Paint)tickLabelColor);
                    } else {
                        this.axisCtx.setFill((Paint)Color.TRANSPARENT);
                    }
                    if (Orientation.VERTICAL == orientation) {
                        this.axisCtx.setTextAlign(TextAlignment.RIGHT);
                        if (isMinValue) {
                            this.axisCtx.fillText(this.dateTimeFormatter.format(this.toLocalDateTime((long)(minValue - (double)i) * 1000L)), textPointX, textPointY + this.size * 0.15, maxTextWidth);
                        } else if (isMaxValue) {
                            this.axisCtx.fillText(this.dateTimeFormatter.format(this.toLocalDateTime((long)(minValue - (double)i) * 1000L)), textPointX, textPointY - this.size * 0.15, maxTextWidth);
                        } else {
                            this.axisCtx.fillText(this.dateTimeFormatter.format(this.toLocalDateTime((long)(minValue - (double)i) * 1000L)), textPointX, textPointY, maxTextWidth);
                        }
                    } else {
                        if (isMinValue) {
                            this.axisCtx.setTextAlign(TextAlignment.LEFT);
                        } else if (isMaxValue) {
                            this.axisCtx.setTextAlign(TextAlignment.RIGHT);
                        } else {
                            this.axisCtx.setTextAlign(TextAlignment.CENTER);
                            currentDateTime = this.toLocalDateTime(i);
                            halfLabelWidth = this.calcTextWidth(this.tickLabelFont, this.dateTimeFormatter.format(currentDateTime)) * 0.5;
                            if (textPointX - halfLabelWidth < 0.0) {
                                textPointX = halfLabelWidth;
                            } else if (textPointX + halfLabelWidth > this.width) {
                                textPointX = this.width - halfLabelWidth;
                            }
                        }
                        this.drawTickLabel(isOnlyFirstAndLastTickLabelVisible, false, isMinValue, isMaxValue, false, majorTickMarkColor, tickLabelColor, textPointX, textPointY, maxTextWidth, this.dateTimeFormatter.format(this.toLocalDateTime(i)), orientation);
                    }
                }
            } else if (mediumTickMarksVisible && i % mediumTickSpace == 0L) {
                this.axisCtx.setStroke((Paint)mediumTickMarkColor);
                this.axisCtx.setLineWidth(mediumLineWidth);
                this.axisCtx.strokeLine(mediumPointX, mediumPointY, outerPointX, outerPointY);
                if (tickLabelsVisible && mediumTickLabelsVisible && tickLabelFontSize > 6.0) {
                    this.axisCtx.setFill((Paint)this.getTickLabelColor());
                    if (Orientation.VERTICAL == orientation) {
                        this.axisCtx.setTextAlign(TextAlignment.RIGHT);
                        this.axisCtx.fillText(this.dateTimeFormatter.format(this.toLocalDateTime((long)(minValue - (double)i) * 1000L)), textPointX, textPointY, maxTextWidth);
                    } else {
                        this.axisCtx.setTextAlign(TextAlignment.CENTER);
                        currentDateTime = this.toLocalDateTime(i);
                        halfLabelWidth = this.calcTextWidth(this.tickLabelFont, this.dateTimeFormatter.format(currentDateTime)) * 0.5;
                        if (textPointX - halfLabelWidth < 0.0) {
                            textPointX = halfLabelWidth;
                        } else if (textPointX + halfLabelWidth > this.width) {
                            textPointX = this.width - halfLabelWidth;
                        }
                        this.drawTickLabel(isOnlyFirstAndLastTickLabelVisible, false, false, false, false, majorTickMarkColor, tickLabelColor, textPointX, textPointY, maxTextWidth, this.dateTimeFormatter.format(this.toLocalDateTime(i)), orientation);
                    }
                }
            } else if (minorTickMarksVisible && i % minorTickSpace == 0L) {
                this.axisCtx.setStroke((Paint)minorTickMarkColor);
                this.axisCtx.setLineWidth(minorLineWidth);
                this.axisCtx.strokeLine(minorPointX, minorPointY, outerPointX, outerPointY);
            }
            if ((double)(++counter) > maxValue) break;
        }
        this.drawAxisTitle(orientation, position);
    }

    private void drawAxisTitle(Orientation ORIENTATION, Position POSITION) {
        double titleFontSize = this.getTitleFontSize();
        this.axisCtx.setFont(this.titleFont);
        this.axisCtx.setFill((Paint)this.getTitleColor());
        this.axisCtx.setTextAlign(TextAlignment.CENTER);
        this.axisCtx.setTextBaseline(VPos.CENTER);
        if (Orientation.HORIZONTAL == ORIENTATION) {
            switch (POSITION) {
                case TOP: {
                    this.axisCtx.fillText(this.getTitle(), this.width * 0.5, titleFontSize * 0.5);
                    break;
                }
                case BOTTOM: {
                    this.axisCtx.fillText(this.getTitle(), this.width * 0.5, this.height - titleFontSize * 0.5);
                }
            }
        } else {
            switch (POSITION) {
                case LEFT: {
                    this.axisCtx.save();
                    this.axisCtx.translate(titleFontSize * 0.5, this.height * 0.5);
                    this.axisCtx.rotate(270.0);
                    this.axisCtx.fillText(this.getTitle(), 0.0, 0.0);
                    this.axisCtx.restore();
                    break;
                }
                case RIGHT: {
                    this.axisCtx.save();
                    this.axisCtx.translate(this.width - titleFontSize * 0.5, this.height * 0.5);
                    this.axisCtx.rotate(90.0);
                    this.axisCtx.fillText(this.getTitle(), 0.0, 0.0);
                    this.axisCtx.restore();
                }
            }
        }
    }

    private void drawTickMark(Color COLOR, double LINE_WIDTH, double START_X, double START_Y, double END_X, double END_Y) {
        this.axisCtx.setStroke((Paint)COLOR);
        this.axisCtx.setLineWidth(LINE_WIDTH);
        this.axisCtx.strokeLine(START_X, START_Y, END_X, END_Y);
    }

    private void drawTickLabel(boolean ONLY_FIRST_AND_LAST_VISIBLE, boolean IS_ZERO, boolean IS_MIN, boolean IS_MAX, boolean FULL_RANGE, Color ZERO_COLOR, Color COLOR, double TEXT_X, double TEXT_Y, double MAX_WIDTH, String TEXT, Orientation ORIENTATION) {
        if (!ONLY_FIRST_AND_LAST_VISIBLE) {
            if (IS_ZERO) {
                this.axisCtx.setFill((Paint)(FULL_RANGE ? ZERO_COLOR : COLOR));
            } else {
                this.axisCtx.setFill((Paint)COLOR);
            }
        } else if (IS_MIN || IS_MAX) {
            if (IS_ZERO) {
                this.axisCtx.setFill((Paint)(FULL_RANGE ? ZERO_COLOR : COLOR));
            } else {
                this.axisCtx.setFill((Paint)COLOR);
            }
        } else {
            this.axisCtx.setFill((Paint)Color.TRANSPARENT);
        }
        if (Orientation.VERTICAL == ORIENTATION) {
            this.axisCtx.setTextAlign(TextAlignment.RIGHT);
            double fontSize = this.getTickLabelFontSize();
            double textY = TEXT_Y < fontSize ? fontSize * 0.5 : (TEXT_Y > this.height - fontSize ? this.height - fontSize * 0.5 : TEXT_Y);
            this.axisCtx.fillText(TEXT, TEXT_X, textY, MAX_WIDTH);
        } else {
            if (IS_MIN) {
                this.axisCtx.setTextAlign(TextAlignment.LEFT);
            } else if (IS_MAX) {
                this.axisCtx.setTextAlign(TextAlignment.RIGHT);
            } else {
                this.axisCtx.setTextAlign(TextAlignment.CENTER);
            }
            double tickLabelWidth = this.calcTextWidth(this.tickLabelFont, TEXT);
            if (this.axisCtx.getTextAlign() == TextAlignment.CENTER && TEXT_X + tickLabelWidth * 0.5 > this.width) {
                this.axisCtx.fillText(TEXT, this.width - tickLabelWidth * 0.5, TEXT_Y, MAX_WIDTH);
            } else {
                this.axisCtx.fillText(TEXT, TEXT_X, TEXT_Y, MAX_WIDTH);
            }
        }
    }

    public void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double aspectRatio = this.width / this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            if (this.isAutoTitleFontSize()) {
                this.setTitleFontSize(Helper.clamp(8.0, 24.0, 0.175 * this.size));
            }
            if (this.isAutoFontSize()) {
                this.setTickLabelFontSize(Helper.clamp(8.0, 24.0, 0.175 * this.size));
            }
            this.axisBounds.set(this.getInsets().getLeft(), this.getInsets().getTop(), this.width, this.height);
            if (Orientation.VERTICAL == this.getOrientation()) {
                this.width = this.height * aspectRatio;
                this.size = this.width < this.height ? this.width : this.height;
                this.stepSize = Math.abs(this.height / this.getRange());
            } else {
                this.height = this.width / aspectRatio;
                this.size = this.width < this.height ? this.width : this.height;
                this.stepSize = Math.abs(this.width / this.getRange());
            }
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setMinSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate(this.axisBounds.getX(), this.axisBounds.getY());
            this.axisCanvas.setWidth(this.width);
            this.axisCanvas.setHeight(this.height);
            this.redraw();
        }
    }

    protected void redraw() {
        if (AxisType.TIME == this.getType()) {
            this.drawTimeAxis();
        } else {
            if (this.isAutoScale()) {
                this.calcAutoScale();
            } else {
                this.calcScale();
            }
            this.drawAxis();
        }
    }
}

