/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Category;
import eu.hansolo.fx.charts.PanelBarChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class PanelBarChartBuilder<B extends PanelBarChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private List<? extends Category> categories;

    protected PanelBarChartBuilder(List<? extends Category> categories) {
        this.categories = categories;
    }

    public static final PanelBarChartBuilder create(List<? extends Category> categories) {
        if (null == categories) {
            throw new IllegalArgumentException("categories cannot be null");
        }
        return new PanelBarChartBuilder(categories);
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B nameColor(Color COLOR) {
        this.properties.put("nameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B listOfSeries(ChartItemSeries<ChartItem> ... SERIES) {
        return this.listOfSeries(Arrays.asList(SERIES));
    }

    public final B listOfSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        this.properties.put("chartItemSeriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B chartBackground(Color COLOR) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B categoryNameColor(Color COLOR) {
        this.properties.put("categoryNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B categorySumColor(Color COLOR) {
        this.properties.put("categorySumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B seriesNameColor(Color COLOR) {
        this.properties.put("seriesNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B seriesSumColor(Color COLOR) {
        this.properties.put("seriesSumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B gridColor(Color COLOR) {
        this.properties.put("gridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B colorByCategory(boolean COLOR_BY_CATEGORY) {
        this.properties.put("colorByCategory", (Property)new SimpleBooleanProperty(COLOR_BY_CATEGORY));
        return (B)this;
    }

    public final B comparisonEnabled(boolean ENABLED) {
        this.properties.put("comparisonEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B comparisonName(String NAME) {
        this.properties.put("comparisonName", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B comparisonNameColor(Color COLOR) {
        this.properties.put("comparisonNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B comparisonListOfSeries(ChartItemSeries<ChartItem> ... SERIES) {
        return this.comparisonListOfSeries(Arrays.asList(SERIES));
    }

    public final B comparisonListOfSeries(List<ChartItemSeries<ChartItem>> SERIES) {
        this.properties.put("comparisonChartItemSeriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B comparisonCategorySumColor(Color COLOR) {
        this.properties.put("comparisonCategorySumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B comparisonSeriesNameColor(Color COLOR) {
        this.properties.put("comparisonSeriesNameColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B comparisonSeriesSumColor(Color COLOR) {
        this.properties.put("comparisonSeriesSumColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final PanelBarChart build() {
        ArrayList<ChartItemSeries<ChartItem>> listOfSeries = new ArrayList<ChartItemSeries<ChartItem>>();
        if (this.properties.keySet().contains("chartItemSeriesList")) {
            listOfSeries.addAll((Collection)((ObjectProperty)this.properties.get("chartItemSeriesList")).get());
        }
        PanelBarChart panelBarChart = new PanelBarChart(this.categories, listOfSeries);
        ArrayList<ChartItemSeries<ChartItem>> comparisonListOfSeries = new ArrayList<ChartItemSeries<ChartItem>>();
        if (this.properties.keySet().contains("comparisonChartItemSeriesList")) {
            comparisonListOfSeries.addAll((Collection)((ObjectProperty)this.properties.get("comparisonChartItemSeriesList")).get());
        }
        panelBarChart.setComparisonListOfSeries(comparisonListOfSeries);
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    panelBarChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    panelBarChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    panelBarChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    panelBarChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    panelBarChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    panelBarChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    panelBarChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    panelBarChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    panelBarChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    panelBarChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    panelBarChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    panelBarChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    panelBarChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    panelBarChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    panelBarChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    panelBarChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "chartBackground": {
                    panelBarChart.setChartBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "name": {
                    panelBarChart.setName((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "nameColor": {
                    panelBarChart.setNameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "categoryNameColor": {
                    panelBarChart.setCategoryNameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "categorySumColor": {
                    panelBarChart.setCategorySumColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesNameColor": {
                    panelBarChart.setSeriesNameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesSumColor": {
                    panelBarChart.setSeriesSumColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "gridColor": {
                    panelBarChart.setGridColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "colorByCategory": {
                    panelBarChart.setColorByCategory(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "comparisonEnabled": {
                    panelBarChart.setComparisonEnabled(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "comparisonName": {
                    panelBarChart.setComparisonName((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "comparisonNameColor": {
                    panelBarChart.setComparisonNameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "comparisonCategorySumColor": {
                    panelBarChart.setComparisonCategorySumColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "comparisonSeriesNameColor": {
                    panelBarChart.setComparisonSeriesNameColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "comparisonSeriesSumColor": {
                    panelBarChart.setComparisonSeriesSumColor((Color)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return panelBarChart;
    }
}

