/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.forcedirectedgraph;

import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolboxfx.font.Fonts;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;

public class InfoPopup
extends Popup {
    public static long MAX_TIMEOUT = 10000L;
    public static int MAX_DECIMALS = 6;
    public static Color DEFAULT_BACKGROUND_COLOR = Color.rgb((int)0, (int)0, (int)0, (double)0.75);
    public static Color DEFAULT_TEXT_COLOR = Color.WHITE;
    private HBox hBox;
    private Text itemText;
    private Text valueText;
    private Line line;
    private Text itemNameText;
    private Text itemValueText;
    private FadeTransition fadeIn;
    private FadeTransition fadeOut;
    private PauseTransition delay;
    private Color _backgroundColor = DEFAULT_BACKGROUND_COLOR;
    private ObjectProperty<Color> backgroundColor;
    private Color _textColor = DEFAULT_TEXT_COLOR;
    private ObjectProperty<Color> textColor;
    private long _timeout = 4000L;
    private LongProperty timeout;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private String _unit = "";
    private StringProperty unit;
    private String formatString = "%." + this._decimals + "f " + this._unit;
    private Font regularFont;
    private Font lightFont;
    private VBox vBoxTitles;
    private VBox vBoxValues;
    private int rowCount;

    public InfoPopup() {
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        this.setAutoFix(true);
        this.rowCount = 2;
        this.fadeIn = new FadeTransition(Duration.millis((double)200.0), (Node)this.hBox);
        this.fadeIn.setFromValue(0.0);
        this.fadeIn.setToValue(0.75);
        this.fadeOut = new FadeTransition(Duration.millis((double)200.0), (Node)this.hBox);
        this.fadeOut.setFromValue(0.75);
        this.fadeOut.setToValue(0.0);
        this.fadeOut.setOnFinished(e -> this.hide());
        this.delay = new PauseTransition(Duration.millis((double)this._timeout));
        this.delay.setOnFinished(e -> this.animatedHide());
    }

    private void initGraphics() {
        this.regularFont = Fonts.opensansRegular((double)9.0);
        this.lightFont = Fonts.opensansLight((double)9.0);
        this.itemText = new Text("NAME");
        this.itemText.setFill((Paint)this._textColor);
        this.itemText.setFont(this.regularFont);
        this.itemNameText = new Text("-");
        this.itemNameText.setFill((Paint)this._textColor);
        this.itemNameText.setFont(this.regularFont);
        this.line = new Line(0.0, 0.0, 0.0, 56.0);
        this.line.setStroke((Paint)this._textColor);
        this.vBoxTitles = new VBox(2.0, new Node[]{this.itemText});
        this.vBoxTitles.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)this.itemText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
        this.vBoxValues = new VBox(2.0, new Node[]{this.itemNameText});
        this.vBoxValues.setAlignment(Pos.CENTER_RIGHT);
        VBox.setMargin((Node)this.itemNameText, (Insets)new Insets(3.0, 0.0, 0.0, 0.0));
        HBox.setHgrow((Node)this.vBoxValues, (Priority)Priority.ALWAYS);
        this.hBox = new HBox(5.0, new Node[]{this.vBoxTitles, this.line, this.vBoxValues});
        this.hBox.setPrefSize(120.0, 69.0);
        this.hBox.setPadding(new Insets(5.0));
        this.hBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this._backgroundColor, new CornerRadii(3.0), Insets.EMPTY)}));
        this.hBox.setMouseTransparent(true);
        this.getContent().addAll((Object[])new Node[]{this.hBox});
    }

    private void addLine(String title, String value) {
        ++this.rowCount;
        Text titleText = new Text(title);
        titleText.setFill((Paint)this._textColor);
        titleText.setFont(this.regularFont);
        Text valueText = new Text(value);
        valueText.setFill((Paint)this._textColor);
        valueText.setFont(this.regularFont);
        this.vBoxTitles.getChildren().add((Object)titleText);
        this.vBoxValues.getChildren().add((Object)valueText);
        Helper.enableNode((Node)titleText, true);
        Helper.enableNode((Node)valueText, true);
    }

    public void clearPopup() {
        this.vBoxTitles.getChildren().clear();
        this.vBoxValues.getChildren().clear();
        this.rowCount = 0;
    }

    private void registerListeners() {
    }

    private void setToRows() {
        this.setHeight(this.rowCount * 19);
        this.line.setEndY((double)(this.rowCount * 18 - 12));
        this.hBox.setPrefHeight((double)(this.rowCount * 18));
        this.hBox.setMinHeight((double)(this.rowCount * 18));
        this.hBox.setMaxHeight((double)(this.rowCount * 18));
    }

    private void updateTextColor(Color COLOR) {
        this.itemText.setFill((Paint)COLOR);
        this.valueText.setFill((Paint)COLOR);
        this.line.setStroke((Paint)COLOR);
        this.itemNameText.setFill((Paint)COLOR);
        this.itemValueText.setFill((Paint)COLOR);
    }

    public void animatedShow(Window WINDOW) {
        this.show(WINDOW);
        this.fadeIn.play();
        this.delay.playFromStart();
    }

    public void animatedHide() {
        this.fadeOut.play();
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.hBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this._backgroundColor, new CornerRadii(3.0), Insets.EMPTY)}));
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    InfoPopup.this.hBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.get(), new CornerRadii(3.0), Insets.EMPTY)}));
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.updateTextColor(this._textColor);
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    InfoPopup.this.updateTextColor((Color)this.get());
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public long getTimeout() {
        return null == this.timeout ? this._timeout : this.timeout.get();
    }

    public void setTimeout(long TIMEOUT) {
        if (null == this.timeout) {
            this._timeout = Helper.clamp(0L, MAX_TIMEOUT, TIMEOUT);
        } else {
            this.timeout.set(TIMEOUT);
        }
    }

    public LongProperty timeoutProperty() {
        if (null == this.timeout) {
            this.timeout = new LongPropertyBase(this._timeout){

                protected void invalidated() {
                    Helper.clamp(0L, MAX_TIMEOUT, this.get());
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "timeout";
                }
            };
        }
        return this.timeout;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this._decimals + "f " + this.getUnit();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, MAX_DECIMALS, this.get()));
                    InfoPopup.this.formatString = "%." + this.get() + "f " + InfoPopup.this._unit;
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
            this.formatString = "%." + this.getDecimals() + "f " + this._unit;
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    InfoPopup.this.formatString = "%." + InfoPopup.this.getDecimals() + "f " + this.get();
                }

                public Object getBean() {
                    return InfoPopup.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public void update(String[] names, String[] values) {
        if (names.length == 0) {
            this.setOpacity(0.0);
        } else {
            int i;
            this.clearPopup();
            for (i = 0; i < names.length; ++i) {
                this.addLine(names[i], values[i]);
            }
            this.setToRows();
            i = 0;
            for (Node node : this.vBoxTitles.getChildren()) {
                if (i >= names.length) continue;
                ((Text)node).setText(names[i]);
                ++i;
            }
            i = 0;
            for (Node node : this.vBoxValues.getChildren()) {
                if (i >= values.length) continue;
                ((Text)node).setText(values[i]);
                ++i;
            }
            this.setOpacity(1.0);
        }
    }

    public void update(String name, String value) {
        String[] names = new String[]{name};
        String[] values = new String[]{value};
        this.update(names, values);
    }
}

