/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.tools.LineStyle;
import eu.hansolo.fx.charts.tools.Marker;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class MarkerBuilder<B extends MarkerBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private Axis axis;
    private double value;

    protected MarkerBuilder(Axis axis, double value) {
        this.axis = axis;
        this.value = value;
    }

    public static final MarkerBuilder create(Axis axis, double value) {
        return new MarkerBuilder(axis, value);
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)stroke));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", (Property)new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B text(String text) {
        this.properties.put("text", (Property)new SimpleStringProperty(text));
        return (B)this;
    }

    public final B textFill(Color textFill) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)textFill));
        return (B)this;
    }

    public final B fromatString(String formatString) {
        this.properties.put("formatString", (Property)new SimpleStringProperty(formatString));
        return (B)this;
    }

    public final B lineStyle(LineStyle lineStyle) {
        this.properties.put("lineStyle", (Property)new SimpleObjectProperty((Object)lineStyle));
        return (B)this;
    }

    public final Marker build() {
        Marker marker = new Marker(this.axis, this.value);
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "stroke": {
                    marker.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "lineWidth": {
                    marker.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "text": {
                    marker.setText((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "textFill": {
                    marker.setTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "formatString": {
                    marker.setFormatString((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "lineStyle": {
                    marker.setLineStyle((LineStyle)((Object)((ObjectProperty)this.properties.get(key)).get()));
                }
            }
        }
        return marker;
    }
}

