/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import eu.hansolo.fx.charts.voronoi.ArraySet;
import eu.hansolo.fx.charts.voronoi.Graph;
import eu.hansolo.fx.charts.voronoi.Triangle;
import eu.hansolo.fx.charts.voronoi.VPoint;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Triangulation
extends AbstractSet<Triangle> {
    private static Logger logger = LoggerFactory.getLogger(Triangulation.class);
    private Triangle mostRecent;
    private Graph<Triangle> triGraph = new Graph();

    public Triangulation(Triangle triangle) {
        this.triGraph.addNode(triangle);
        this.mostRecent = triangle;
    }

    public boolean contains(Triangle triangle) {
        return this.triGraph.getNodes().contains(triangle);
    }

    public Triangle neighborOpposite(VPoint site, Triangle triangle) {
        if (!triangle.contains(site)) {
            throw new IllegalArgumentException("Bad vertex; not in triangle");
        }
        for (Triangle neighbor : this.triGraph.getNeighbours(triangle)) {
            if (neighbor.contains(site)) continue;
            return neighbor;
        }
        return null;
    }

    public Set<Triangle> neighbors(Triangle triangle) {
        return this.triGraph.getNeighbours(triangle);
    }

    public List<Triangle> surroundingTriangles(VPoint site, Triangle triangle) {
        if (!triangle.contains(site)) {
            throw new IllegalArgumentException("Site not in triangle");
        }
        ArrayList<Triangle> list = new ArrayList<Triangle>();
        Triangle start = triangle;
        VPoint guide = triangle.getVertexButNot(site);
        do {
            list.add(triangle);
            Triangle previous = triangle;
            triangle = this.neighborOpposite(guide, triangle);
            guide = previous.getVertexButNot(site, guide);
        } while (triangle != start);
        return list;
    }

    public Triangle locate(VPoint point) {
        Triangle triangle = this.mostRecent;
        if (!this.contains(triangle)) {
            triangle = null;
        }
        HashSet<Triangle> visited = new HashSet<Triangle>();
        while (triangle != null) {
            if (visited.contains(triangle)) {
                logger.debug("Warning: Caught in a locate loop");
                break;
            }
            visited.add(triangle);
            VPoint corner = point.isOutside(triangle.toArray(new VPoint[0]));
            if (corner == null) {
                return triangle;
            }
            triangle = this.neighborOpposite(corner, triangle);
        }
        logger.debug("Warning: Checking all triangles for " + String.valueOf(point));
        for (Triangle tri : this) {
            if (point.isOutside(tri.toArray(new VPoint[0])) != null) continue;
            return tri;
        }
        logger.debug("Warning: No triangle holds " + String.valueOf(point));
        return null;
    }

    public void place(VPoint point) {
        Triangle triangle = this.locate(point);
        if (triangle == null) {
            throw new IllegalArgumentException("No containing triangle");
        }
        if (triangle.contains(point)) {
            return;
        }
        Set<Triangle> cavity = this.getCavity(point, triangle);
        this.mostRecent = this.update(point, cavity);
    }

    private Set<Triangle> getCavity(VPoint site, Triangle triangle) {
        HashSet<Triangle> encroached = new HashSet<Triangle>();
        LinkedList<Triangle> toBeChecked = new LinkedList<Triangle>();
        HashSet<Triangle> marked = new HashSet<Triangle>();
        toBeChecked.add(triangle);
        marked.add(triangle);
        while (!toBeChecked.isEmpty()) {
            triangle = (Triangle)toBeChecked.remove();
            if (site.vsCircumCircle(triangle.toArray(new VPoint[0])) == 1) continue;
            encroached.add(triangle);
            for (Triangle neighbor : this.triGraph.getNeighbours(triangle)) {
                if (marked.contains(neighbor)) continue;
                marked.add(neighbor);
                toBeChecked.add(neighbor);
            }
        }
        return encroached;
    }

    private Triangle update(VPoint site, Set<Triangle> cavity) {
        HashSet<ArraySet<VPoint>> boundary = new HashSet<ArraySet<VPoint>>();
        HashSet<Triangle> theTriangles = new HashSet<Triangle>();
        for (Triangle triangle : cavity) {
            theTriangles.addAll(this.neighbors(triangle));
            for (VPoint vertex : triangle) {
                ArraySet<VPoint> facet = triangle.facetOpposite(vertex);
                if (boundary.contains(facet)) {
                    boundary.remove(facet);
                    continue;
                }
                boundary.add(facet);
            }
        }
        theTriangles.removeAll(cavity);
        for (Triangle triangle : cavity) {
            this.triGraph.removeNode(triangle);
        }
        HashSet<Triangle> newTriangles = new HashSet<Triangle>();
        for (Set set : boundary) {
            set.add(site);
            Triangle tri = new Triangle(set);
            this.triGraph.addNode(tri);
            newTriangles.add(tri);
        }
        theTriangles.addAll(newTriangles);
        for (Triangle triangle : newTriangles) {
            for (Triangle other : theTriangles) {
                if (!triangle.isNeighbor(other)) continue;
                this.triGraph.addConnection(triangle, other);
            }
        }
        return (Triangle)newTriangles.iterator().next();
    }

    @Override
    public Iterator<Triangle> iterator() {
        return this.triGraph.getNodes().iterator();
    }

    @Override
    public int size() {
        return this.triGraph.getNodes().size();
    }

    @Override
    public String toString() {
        return "Triangulation with " + this.size() + " triangles";
    }
}

