/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.wafermap.ClassConfig;
import eu.hansolo.fx.charts.wafermap.Die;
import eu.hansolo.fx.charts.wafermap.DieMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class DieMapBuilder<B extends DieMapBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected DieMapBuilder() {
    }

    public static final DieMapBuilder create() {
        return new DieMapBuilder();
    }

    public final B die(Die die) {
        this.properties.put("die", (Property)new SimpleObjectProperty((Object)die));
        return (B)this;
    }

    public final B dieFill(Color dieFill) {
        this.properties.put("dieFill", (Property)new SimpleObjectProperty((Object)dieFill));
        return (B)this;
    }

    public final B dieStroke(Color dieStroke) {
        this.properties.put("dieStroke", (Property)new SimpleObjectProperty((Object)dieStroke));
        return (B)this;
    }

    public final B defectFill(Color defectFill) {
        this.properties.put("defectFill", (Property)new SimpleObjectProperty((Object)defectFill));
        return (B)this;
    }

    public final B defectStroke(Color defectStroke) {
        this.properties.put("defectStroke", (Property)new SimpleObjectProperty((Object)defectStroke));
        return (B)this;
    }

    public final B dieTextFill(Color dieTextFill) {
        this.properties.put("dieTextFill", (Property)new SimpleObjectProperty((Object)dieTextFill));
        return (B)this;
    }

    public final B dieTextVisible(boolean dieTextVisible) {
        this.properties.put("dieTextVisible", (Property)new SimpleBooleanProperty(dieTextVisible));
        return (B)this;
    }

    public final B densityColorsVisible(boolean densityColorsVisible) {
        this.properties.put("densityColorsVisible", (Property)new SimpleBooleanProperty(densityColorsVisible));
        return (B)this;
    }

    public final B classConfigMap(Map<Integer, ClassConfig> classConfigMap) {
        this.properties.put("classConfigMap", (Property)new SimpleObjectProperty(classConfigMap));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxHeight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxHeight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final DieMap build() {
        DieMap dieMap = new DieMap();
        if (this.properties.keySet().contains("die")) {
            dieMap.setDie((Die)((ObjectProperty)this.properties.get("die")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    dieMap.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    dieMap.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    dieMap.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    dieMap.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    dieMap.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    dieMap.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    dieMap.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    dieMap.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    dieMap.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    dieMap.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    dieMap.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    dieMap.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    dieMap.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    dieMap.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    dieMap.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    dieMap.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "waferFill": {
                    dieMap.setDieFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "waferStroke": {
                    dieMap.setDieStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "defectFill": {
                    dieMap.setDefectFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "defectStroke": {
                    dieMap.setDefectStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "dieTextFill": {
                    dieMap.setDieTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "dieTextVisible": {
                    dieMap.setDieTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "densityColorsVisible": {
                    dieMap.setDensityColorsVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "classConfigMap": {
                    dieMap.setClassConfigMap((Map)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return dieMap;
    }
}

