/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.wafermap.Defect;
import eu.hansolo.fx.charts.wafermap.DefectClass;
import eu.hansolo.fx.charts.wafermap.DefectRecordField;
import eu.hansolo.fx.charts.wafermap.Die;
import eu.hansolo.fx.charts.wafermap.KLAParser;
import eu.hansolo.fx.charts.wafermap.OrientationMarkLocation;
import eu.hansolo.fx.charts.wafermap.SampleOrientationMarkType;
import eu.hansolo.fx.charts.wafermap.SampleTest;
import eu.hansolo.fx.charts.wafermap.SampleType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class KLA {
    private int id = -1;
    private int fileVersionMajor = -1;
    private int fileVersionMinor = -1;
    private LocalDateTime fileTimestamp = LocalDateTime.MIN;
    private String inspectionStationIdPart1 = "";
    private String inspectionStationIdPart2 = "";
    private String inspectionStationIdPart3 = "";
    private SampleType sampleType = SampleType.WAFER;
    private LocalDateTime resultTimestamp = LocalDateTime.MIN;
    private String lotID = "";
    private double sampleSize = -1.0;
    private String setupIdName = "";
    private LocalDateTime setupIdTimestamp = LocalDateTime.MIN;
    private String stepID = "";
    private SampleOrientationMarkType sampleOrientationMarkType = SampleOrientationMarkType.NOTCH;
    private OrientationMarkLocation orientationMarkLocation = OrientationMarkLocation.NONE;
    private double diePitchX = -1.0;
    private double diePitchY = -1.0;
    private double dieOriginX = -1.0;
    private double dieOriginY = -1.0;
    private String waferId = "";
    private int slot = -1;
    private double sampleCenterLocationX = -1.0;
    private double sampleCenterLocationY = -1.0;
    private int inspectionTest = -1;
    private double areaPerTest = -1.0;
    private String defectRecordSpec = "";
    private String summarySpec = "";
    private int testNo = -1;
    private int numberOfDefects = -1;
    private double defectDensity = -1.0;
    private int numberOfDies = -1;
    private int numberOfDefectDies = -1;
    private String waferStatus = "";
    private String filename = "";
    private List<DefectClass> classes = new LinkedList<DefectClass>();
    private List<SampleTest> sampleTestPlan = new LinkedList<SampleTest>();
    private List<Defect> defects = new ArrayList<Defect>();
    private Map<String, Die> dies = new HashMap<String, Die>();
    private int diesMinX = -1;
    private int diesMaxX = -1;
    private int diesMinY = -1;
    private int diesMaxY = -1;
    private int maxDefectsPerDie = -1;
    private Map<Integer, DefectRecordField> defectFieldMap = new HashMap<Integer, DefectRecordField>();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getFileVersionMajor() {
        return this.fileVersionMajor;
    }

    public void setFileVersionMajor(int fileVersionMajor) {
        this.fileVersionMajor = fileVersionMajor;
    }

    public int getFileVersionMinor() {
        return this.fileVersionMinor;
    }

    public void setFileVersionMinor(int fileVersionMinor) {
        this.fileVersionMinor = fileVersionMinor;
    }

    public LocalDateTime getFileTimestamp() {
        return this.fileTimestamp;
    }

    public void setFileTimestamp(LocalDateTime fileTimestamp) {
        this.fileTimestamp = fileTimestamp;
    }

    public String getInspectionStationIdPart1() {
        return this.inspectionStationIdPart1;
    }

    public void setInspectionStationIdPart1(String inspectionStationIdPart1) {
        this.inspectionStationIdPart1 = inspectionStationIdPart1;
    }

    public String getInspectionStationIdPart2() {
        return this.inspectionStationIdPart2;
    }

    public void setInspectionStationIdPart2(String inspectionStationIdPart2) {
        this.inspectionStationIdPart2 = inspectionStationIdPart2;
    }

    public String getInspectionStationIdPart3() {
        return this.inspectionStationIdPart3;
    }

    public void setInspectionStationIdPart3(String inspectionStationIdPart3) {
        this.inspectionStationIdPart3 = inspectionStationIdPart3;
    }

    public SampleType getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleType sampleType) {
        this.sampleType = sampleType;
    }

    public LocalDateTime getResultTimestamp() {
        return this.resultTimestamp;
    }

    public void setResultTimestamp(LocalDateTime resultTimestamp) {
        this.resultTimestamp = resultTimestamp;
    }

    public String getLotID() {
        return this.lotID;
    }

    public void setLotID(String lotID) {
        this.lotID = lotID;
    }

    public double getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(double sampleSize) {
        this.sampleSize = sampleSize;
    }

    public String getSetupIdName() {
        return this.setupIdName;
    }

    public void setSetupIdName(String setupIdName) {
        this.setupIdName = setupIdName;
    }

    public LocalDateTime getSetupIdTimestamp() {
        return this.setupIdTimestamp;
    }

    public void setSetupIdTimestamp(LocalDateTime setupIdTimestamp) {
        this.setupIdTimestamp = setupIdTimestamp;
    }

    public String getStepID() {
        return this.stepID;
    }

    public void setStepID(String stepID) {
        this.stepID = stepID;
    }

    public SampleOrientationMarkType getSampleOrientationMarkType() {
        return this.sampleOrientationMarkType;
    }

    public void setSampleOrientationMarkType(SampleOrientationMarkType sampleOrientationMarkType) {
        this.sampleOrientationMarkType = sampleOrientationMarkType;
    }

    public OrientationMarkLocation getOrientationMarkLocation() {
        return this.orientationMarkLocation;
    }

    public void setOrientationMarkLocation(OrientationMarkLocation orientationMarkLocation) {
        this.orientationMarkLocation = orientationMarkLocation;
    }

    public double getDiePitchX() {
        return this.diePitchX;
    }

    public void setDiePitchX(double diePitchX) {
        this.diePitchX = diePitchX;
    }

    public double getDiePitchY() {
        return this.diePitchY;
    }

    public void setDiePitchY(double diePitchY) {
        this.diePitchY = diePitchY;
    }

    public double getDieOriginX() {
        return this.dieOriginX;
    }

    public void setDieOriginX(double dieOriginX) {
        this.dieOriginX = dieOriginX;
    }

    public double getDieOriginY() {
        return this.dieOriginY;
    }

    public void setDieOriginY(double dieOriginY) {
        this.dieOriginY = dieOriginY;
    }

    public String getWaferId() {
        return this.waferId;
    }

    public void setWaferId(String waferId) {
        this.waferId = waferId;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public double getSampleCenterLocationX() {
        return this.sampleCenterLocationX;
    }

    public void setSampleCenterLocationX(double sampleCenterLocationX) {
        this.sampleCenterLocationX = sampleCenterLocationX;
    }

    public double getSampleCenterLocationY() {
        return this.sampleCenterLocationY;
    }

    public void setSampleCenterLocationY(double sampleCenterLocationY) {
        this.sampleCenterLocationY = sampleCenterLocationY;
    }

    public int getInspectionTest() {
        return this.inspectionTest;
    }

    public void setInspectionTest(int inspectionTest) {
        this.inspectionTest = inspectionTest;
    }

    public double getAreaPerTest() {
        return this.areaPerTest;
    }

    public void setAreaPerTest(double areaPerTest) {
        this.areaPerTest = areaPerTest;
    }

    public String getDefectRecordSpec() {
        return this.defectRecordSpec;
    }

    public void setDefectRecordSpec(String defectRecordSpec) {
        this.defectRecordSpec = defectRecordSpec;
    }

    public String getSummarySpec() {
        return this.summarySpec;
    }

    public void setSummarySpec(String summarySpec) {
        this.summarySpec = summarySpec;
    }

    public int getTestNo() {
        return this.testNo;
    }

    public void setTestNo(int testNo) {
        this.testNo = testNo;
    }

    public int getNumberOfDefects() {
        return this.numberOfDefects;
    }

    public void setNumberOfDefects(int numberOfDefects) {
        this.numberOfDefects = numberOfDefects;
    }

    public double getDefectDensity() {
        return this.defectDensity;
    }

    public void setDefectDensity(double defectDensity) {
        this.defectDensity = defectDensity;
    }

    public int getNumberOfDies() {
        return this.numberOfDies;
    }

    public void setNumberOfDies(int numberOfDies) {
        this.numberOfDies = numberOfDies;
    }

    public int getNumberOfDefectDies() {
        return this.numberOfDefectDies;
    }

    public void setNumberOfDefectDies(int numberOfDefectDies) {
        this.numberOfDefectDies = numberOfDefectDies;
    }

    public String getWaferStatus() {
        return this.waferStatus;
    }

    public void setWaferStatus(String waferStatus) {
        this.waferStatus = waferStatus;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<DefectClass> getClasses() {
        return this.classes;
    }

    public void setClasses(List<DefectClass> classes) {
        this.classes = classes;
    }

    public List<SampleTest> getSampleTestPlan() {
        return this.sampleTestPlan;
    }

    public void setSampleTestPlan(List<SampleTest> sampleTestPlan) {
        this.sampleTestPlan = sampleTestPlan;
    }

    public List<Defect> getDefects() {
        return this.defects;
    }

    public void setDefects(List<Defect> defects) {
        this.defects = defects;
    }

    public Map<String, Die> getDies() {
        return this.dies;
    }

    public void createDieMap() {
        double offsetX = this.getSampleCenterLocationX() / 1000.0;
        double offsetY = this.getSampleCenterLocationY() / 1000.0;
        double radius = this.sampleSize / 2.0;
        double originX = this.sampleSize / 2.0;
        double originY = this.sampleSize / 2.0;
        double originU = originX - offsetX;
        double originV = originY - offsetY;
        double dieSizeX = this.getDiePitchX() / 1000.0;
        double dieSizeY = this.getDiePitchY() / 1000.0;
        this.diesMinX = (int)(originU / dieSizeX);
        this.diesMaxX = (int)((this.sampleSize - originU) / dieSizeX);
        this.diesMinY = (int)(originV / dieSizeY + dieSizeY);
        this.diesMaxY = (int)((this.sampleSize - originV) / dieSizeY);
        AtomicInteger dieCountX = new AtomicInteger(-this.diesMinX);
        AtomicInteger dieCountY = new AtomicInteger(this.diesMaxY + 2);
        double startX = originX - (double)this.diesMinX * dieSizeX - offsetX;
        double startY = originY + (double)this.diesMaxY * dieSizeY + offsetY;
        this.dies.clear();
        double maxX = originU + radius;
        double maxY = originV - (double)this.diesMinY * dieSizeY - dieSizeY;
        for (double dieX = startX; dieX <= maxX; dieX += dieSizeX) {
            double dieOriginX = originX - dieX;
            for (double dieY = startY; dieY >= maxY; dieY -= dieSizeY) {
                double dieOriginY = originY - dieY - dieSizeY;
                double dieUpperLeft = Math.sqrt(dieOriginX * dieOriginX + dieOriginY * dieOriginY);
                double dieUpperRight = Math.sqrt((dieOriginX - dieSizeX) * (dieOriginX - dieSizeX) + dieOriginY * dieOriginY);
                double dieLowerLeft = Math.sqrt(dieOriginX * dieOriginX + (dieOriginY - dieSizeY) * (dieOriginY - dieSizeY));
                double dieLowerRight = Math.sqrt((dieOriginX - dieSizeX) * (dieOriginX - dieSizeX) + (dieOriginY - dieSizeY) * (dieOriginY - dieSizeY));
                if (dieUpperLeft <= radius && dieUpperRight <= radius && dieLowerLeft <= radius && dieLowerRight <= radius) {
                    String dieLabel = String.valueOf(dieCountX) + "/" + -dieCountY.get();
                    Die die = new Die(dieCountX.get(), dieCountY.get(), this.id, dieX, dieY + dieSizeY, dieSizeX, dieSizeY, dieLabel.toString(), offsetX, offsetY);
                    die.setDefects(this.defects.stream().filter(defect -> defect.getIndexX() == dieCountX.get() && defect.getIndexY() == dieCountY.get()).collect(Collectors.toList()));
                    this.dies.put(dieLabel.toString(), die);
                }
                dieCountY.decrementAndGet();
            }
            dieCountY.set(this.diesMaxY + 2);
            dieCountX.incrementAndGet();
        }
        this.maxDefectsPerDie = this.dies.values().isEmpty() ? 0 : Collections.max(this.dies.values(), Comparator.comparing(d -> d.getNoOfDefects())).getNoOfDefects();
        for (Defect defect2 : this.defects) {
            Optional<DefectClass> optDefectClass = this.classes.stream().filter(clazz -> clazz.getId() == defect2.getClassNumber()).findFirst();
            if (optDefectClass.isPresent()) {
                optDefectClass.get().setUsed(true);
            }
            if (!this.dies.containsKey(defect2.getLabel())) continue;
            double defectXAbsolute = dieSizeX * (double)defect2.getIndexX() + defect2.getXRel();
            double defectYAbsolute = dieSizeY * (double)defect2.getIndexY() + defect2.getYRel();
            defect2.setXAbsolute(defectXAbsolute);
            defect2.setYAbsolute(defectYAbsolute);
        }
    }

    public int getMaxDefectsPerDie() {
        return this.maxDefectsPerDie;
    }

    public void setDefectFieldMap(Map<Integer, DefectRecordField> defectFieldMap) {
        this.defectFieldMap.clear();
        this.defectFieldMap.putAll(defectFieldMap);
    }

    public String toString() {
        StringBuilder defectRecordSpecBuilder = new StringBuilder();
        defectRecordSpecBuilder.append("DefectRecordSpec").append(" ").append(this.defectFieldMap.size()).append(" ");
        this.defectFieldMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> defectRecordSpecBuilder.append(((DefectRecordField)((Object)((Object)entry.getValue()))).name).append(" "));
        defectRecordSpecBuilder.setLength(defectRecordSpecBuilder.length() - 1);
        defectRecordSpecBuilder.append(";");
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("FileVersion").append(" ").append(this.fileVersionMajor).append(" ").append(this.fileVersionMinor).append(";").append("\n").append("FileTimestamp").append(" ").append(KLAParser.DTF.format(this.fileTimestamp)).append(";").append("\n").append("InspectionStationID").append(" ").append("\"").append(this.inspectionStationIdPart1).append("\"").append(" ").append("\"").append(this.inspectionStationIdPart2).append("\"").append(" ").append("\"").append(this.inspectionStationIdPart3).append("\"").append(";").append("\n").append("SampleType").append(" ").append(this.sampleType.name()).append(";").append("\n").append("ResultTimestamp").append(" ").append(KLAParser.DTF.format(this.resultTimestamp)).append(";").append("\n").append("LotID").append(" ").append("\"").append(this.lotID).append("\"").append(";").append("\n").append("SampleSize").append(" ").append("1").append(" ").append(String.format(Locale.US, "%.0f", this.sampleSize)).append(";").append("\n").append("SetupID").append(" ").append("\"").append(this.setupIdName).append("\"").append(" ").append(KLAParser.DTF.format(this.setupIdTimestamp)).append(";").append("\n").append("StepID").append(" ").append("\"").append(this.stepID).append("\"").append(";").append("\n").append("SampleOrientationMarkType").append(" ").append(this.sampleOrientationMarkType.name()).append(";").append("\n").append("OrientationMarkLocation").append(" ").append(this.orientationMarkLocation.name()).append(";").append("\n").append("DiePitch").append(" ").append(String.format(Locale.US, "%.10e", this.diePitchX)).append(" ").append(String.format(Locale.US, "%.10e", this.diePitchY)).append(";").append("\n").append("DieOrigin").append(" ").append(String.format(Locale.US, "%.6f", this.dieOriginX)).append(" ").append(String.format(Locale.US, "%.6f", this.dieOriginY)).append(";").append("\n").append("WaferID").append(" ").append("\"").append(this.waferId).append("\"").append(";").append("\n").append("Slot").append(" ").append(this.slot).append(";").append("\n").append("SampleCenterLocation").append(" ").append(String.format(Locale.US, "%.10e", this.sampleCenterLocationX)).append(" ").append(String.format(Locale.US, "%.10e", this.sampleCenterLocationY)).append(";").append("\n").append("ClassLookup").append(" ").append(this.classes.size()).append("\n");
        this.classes.forEach(defectClass -> msgBuilder.append(defectClass.toString()).append("\n"));
        msgBuilder.setLength(msgBuilder.length() - 1);
        msgBuilder.append(";").append("\n").append("InspectionTest").append(" ").append(this.inspectionTest).append(";").append("\n").append("SampleTestPlan").append(" ").append(this.sampleTestPlan.size()).append("\n");
        this.sampleTestPlan.forEach(sampleTest -> msgBuilder.append(sampleTest.toString()).append("\n"));
        msgBuilder.setLength(msgBuilder.length() - 1);
        msgBuilder.append(";").append("\n").append("AreaPerTest").append(" ").append(String.format(Locale.US, "%.10e", this.areaPerTest)).append(";").append("\n").append((CharSequence)defectRecordSpecBuilder).append("\n").append("DefectList").append("\n");
        this.defects.forEach(defect -> msgBuilder.append(defect.toString()).append("\n"));
        msgBuilder.setLength(msgBuilder.length() - 2);
        msgBuilder.append(";").append("\n").append("SummarySpec").append(" ").append(this.summarySpec).append(";").append("\n").append("SummaryList").append("\n").append(" ").append(this.testNo).append(" ").append(this.numberOfDefects).append(" ").append(String.format(Locale.US, "%.6f", this.defectDensity)).append(" ").append(this.numberOfDies).append(" ").append(this.numberOfDefectDies).append(";").append("\n");
        if (!this.waferStatus.isEmpty()) {
            msgBuilder.append("WaferStatus").append(" ").append(this.waferStatus).append(";").append("\n");
        }
        msgBuilder.append("EndOfFile").append(";");
        return msgBuilder.toString();
    }
}

