/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry.transform;

import eu.hansolo.fx.geometry.BaseBounds;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.tools.NonInvertibleTransformException;
import eu.hansolo.fx.geometry.transform.Affine;
import eu.hansolo.fx.geometry.transform.Identity;
import eu.hansolo.fx.geometry.transform.Translate;
import eu.hansolo.toolboxfx.geom.Point;

public abstract class BaseTransform {
    public static final BaseTransform IDENTITY_TRANSFORM = new Identity();
    protected static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int TYPE_AFFINE_3D = 128;
    public static final int TYPE_AFFINE2D_MASK = 127;

    static void degreeError(Degree maxSupported) {
        throw new InternalError("does not support higher than " + String.valueOf((Object)maxSupported) + " operations");
    }

    public static BaseTransform getInstance(BaseTransform tx) {
        if (tx.isIdentity()) {
            return IDENTITY_TRANSFORM;
        }
        if (tx.isTranslateOrIdentity()) {
            return new Translate(tx);
        }
        return new Affine(tx);
    }

    public static BaseTransform getInstance(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (mxx == 1.0 && myx == 0.0 && mxy == 0.0 && myy == 1.0) {
            return BaseTransform.getTranslateInstance(mxt, myt);
        }
        return new Affine(mxx, myx, mxy, myy, mxt, myt);
    }

    public static BaseTransform getTranslateInstance(double mxt, double myt) {
        if (mxt == 0.0 && myt == 0.0) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate(mxt, myt);
    }

    public static BaseTransform getScaleInstance(double mxx, double myy) {
        return BaseTransform.getInstance(mxx, 0.0, 0.0, myy, 0.0, 0.0);
    }

    public static BaseTransform getRotateInstance(double theta, double x, double y) {
        Affine a = new Affine();
        a.setToRotation(theta, x, y);
        return a;
    }

    public abstract Degree getDegree();

    public abstract int getType();

    public abstract boolean isIdentity();

    public abstract boolean isTranslateOrIdentity();

    public abstract double getDeterminant();

    public double getMxx() {
        return 1.0;
    }

    public double getMxy() {
        return 0.0;
    }

    public double getMxz() {
        return 0.0;
    }

    public double getMxt() {
        return 0.0;
    }

    public double getMyx() {
        return 0.0;
    }

    public double getMyy() {
        return 1.0;
    }

    public double getMyz() {
        return 0.0;
    }

    public double getMyt() {
        return 0.0;
    }

    public double getMzx() {
        return 0.0;
    }

    public double getMzy() {
        return 0.0;
    }

    public double getMzz() {
        return 1.0;
    }

    public double getMzt() {
        return 0.0;
    }

    public abstract Point transform(Point var1, Point var2);

    public abstract Point inverseTransform(Point var1, Point var2) throws NonInvertibleTransformException;

    public abstract void transform(double[] var1, int var2, double[] var3, int var4, int var5);

    public abstract void deltaTransform(double[] var1, int var2, double[] var3, int var4, int var5);

    public abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4, int var5) throws NonInvertibleTransformException;

    public abstract void inverseDeltaTransform(double[] var1, int var2, double[] var3, int var4, int var5) throws NonInvertibleTransformException;

    public abstract BaseBounds transform(BaseBounds var1, BaseBounds var2);

    public abstract void transform(Rectangle var1, Rectangle var2);

    public abstract BaseBounds inverseTransform(BaseBounds var1, BaseBounds var2) throws NonInvertibleTransformException;

    public abstract void inverseTransform(Rectangle var1, Rectangle var2) throws NonInvertibleTransformException;

    public abstract Shape createTransformedShape(Shape var1);

    public abstract void setToIdentity();

    public abstract void setTransform(BaseTransform var1);

    public abstract void invert() throws NonInvertibleTransformException;

    public abstract void restoreTransform(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void restoreTransform(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);

    public abstract BaseTransform deriveWithTranslation(double var1, double var3);

    public abstract BaseTransform deriveWithPreTranslation(double var1, double var3);

    public abstract BaseTransform deriveWithConcatenation(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract BaseTransform deriveWithPreConcatenation(BaseTransform var1);

    public abstract BaseTransform deriveWithConcatenation(BaseTransform var1);

    public abstract BaseTransform deriveWithNewTransform(BaseTransform var1);

    public abstract BaseTransform createInverse() throws NonInvertibleTransformException;

    public abstract BaseTransform copy();

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseTransform)) {
            return false;
        }
        BaseTransform a = (BaseTransform)obj;
        return this.getMxx() == a.getMxx() && this.getMxy() == a.getMxy() && this.getMxz() == a.getMxz() && this.getMxt() == a.getMxt() && this.getMyx() == a.getMyx() && this.getMyy() == a.getMyy() && this.getMyz() == a.getMyz() && this.getMyt() == a.getMyt() && this.getMzx() == a.getMzx() && this.getMzy() == a.getMzy() && this.getMzz() == a.getMzz() && this.getMzt() == a.getMzt();
    }

    static Point makePoint(Point src, Point dst) {
        if (dst == null) {
            dst = new Point();
        }
        return dst;
    }

    public static enum Degree {
        IDENTITY,
        TRANSLATE,
        AFFINE;

    }
}

