/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.PropertyManager;
import eu.hansolo.fx.countries.RegionPane;
import eu.hansolo.fx.countries.RegionPaneBuilder;
import eu.hansolo.fx.countries.tools.BusinessRegion;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.CLocationBuilder;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.countries.tools.ConnectionBuilder;
import eu.hansolo.fx.countries.tools.ConnectionPartType;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.PoiBuilder;
import eu.hansolo.toolboxfx.geom.PoiSize;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class DemoRegionPane
extends Application {
    public static final String VERSION = PropertyManager.INSTANCE.getVersionNumber();
    private RegionPane regionPane;
    private List<Point> heatmapSpots;

    public void init() {
        BusinessRegion region = BusinessRegion.EUROPEAN_UNION;
        List<Poi> capitals = Helper.getCapitals().stream().filter(city -> region.getCountries().contains((Object)city.country())).map(city -> PoiBuilder.create().lat(city.lat()).lon(city.lon()).name(city.name()).fill(Color.CYAN).pointSize(PoiSize.NORMAL).build()).collect(Collectors.toList());
        CLocation fmo = ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name("FMO")).latitude(52.1307)).longitude(7.6941)).connectionPartType(ConnectionPartType.SOURCE)).build();
        CLocation arn = ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name("ARN")).latitude(59.6498)).longitude(17.9238)).connectionPartType(ConnectionPartType.TARGET)).build();
        CLocation mad = ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name("MAD")).latitude(40.4983)).longitude(-3.5676)).connectionPartType(ConnectionPartType.SOURCE)).build();
        CLocation lis = ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name("LIS")).latitude(38.7756)).longitude(-9.1354)).connectionPartType(ConnectionPartType.SOURCE)).build();
        Connection madToArn = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(mad, arn).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.MAGENTA)).build();
        Connection lisToArn = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(lis, arn).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.YELLOW)).build();
        Connection fmoToArn = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(fmo, arn).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.CYAN)).build();
        this.heatmapSpots = Helper.getCities().stream().filter(city -> region.getCountries().contains((Object)city.country())).filter(city -> !city.isCapital()).filter(city -> city.population() > 200000L).map(city -> new Point(city.lon(), city.lat())).collect(Collectors.toList());
        this.regionPane = ((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)((RegionPaneBuilder)RegionPaneBuilder.create(region).poisVisible(true)).poiTextVisible(true)).heatmapVisible(true)).heatmapSpotRadius(5.0)).heatmapOpacityDistribution(OpacityDistribution.LINEAR)).heatmapSpots(this.heatmapSpots)).pois(capitals)).connections(List.of(fmoToArn, madToArn, lisToArn))).overlayVisible(true)).hoverEnabled(true)).selectionEnabled(true)).build();
        this.regionPane.selectedCountryProperty().addListener((o, ov, nv) -> System.out.println(nv));
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.regionPane});
        pane.setPrefSize(600.0, 400.0);
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("RegionPane Version: " + VERSION);
        stage.setScene(scene);
        stage.show();
        stage.centerOnScreen();
    }

    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    public static void main(String[] args) {
        DemoRegionPane.launch((String[])args);
    }
}

