/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.evt.CountryEvt;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.CRegion;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.countries.tools.Constants;
import eu.hansolo.fx.countries.tools.CountryPath;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.HeatMap;
import eu.hansolo.fx.heatmap.HeatMapBuilder;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.PoiSize;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class RegionPane
extends Region
implements EvtObserver<CountryEvt<Connection>> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static double aspectRatio;
    private double size;
    private double width;
    private double height;
    private Canvas overlay;
    private GraphicsContext overlayCtx;
    private HeatMap heatmap;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private Group group;
    private CRegion region;
    private Map<Country, List<CountryPath>> countryPaths;
    private Collection<CountryPath> paths;
    private ObservableList<Connection> connections;
    private double regionOffsetX;
    private double regionOffsetY;
    private double scaleX;
    private double scaleY;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private double _lineWidth;
    private DoubleProperty lineWidth;
    private Color _poiFill;
    private ObjectProperty<Color> poiFill;
    private Color _poiStroke;
    private ObjectProperty<Color> poiStroke;
    private Color _poiTextFill;
    private ObjectProperty<Color> poiTextFill;
    private boolean _poisVisible;
    private BooleanProperty poisVisible;
    private boolean _poiTextVisible;
    private BooleanProperty poiTextVisible;
    private boolean _hoverEnabled;
    private BooleanProperty hoverEnabled;
    private boolean _selectionEnabled;
    private BooleanProperty selectionEnabled;
    private Country _selectedCountry;
    private ObjectProperty<Country> selectedCountry;
    private Country formerSelectedCountry;
    private Color _hoverColor;
    private ObjectProperty<Color> hoverColor;
    private Color _pressedColor;
    private ObjectProperty<Color> pressedColor;
    private Color _selectedColor;
    private ObjectProperty<Color> selectedColor;
    private ObservableList<Poi> pois;
    private List<Point> heatmapSpots;
    private BooleanBinding showing;
    private ListChangeListener<Poi> poiListChangeListener;
    private ListChangeListener<Connection> connectionListChangeListener;
    protected EventHandler<MouseEvent> _mouseEnterHandler;
    protected EventHandler<MouseEvent> _mousePressHandler;
    protected EventHandler<MouseEvent> _mouseReleaseHandler;
    protected EventHandler<MouseEvent> _mouseExitHandler;
    private EventHandler<MouseEvent> mouseEnterHandler;
    private EventHandler<MouseEvent> mousePressHandler;
    private EventHandler<MouseEvent> mouseReleaseHandler;
    private EventHandler<MouseEvent> mouseExitHandler;

    public RegionPane(CRegion region) {
        this.region = region;
        this.paths = new ArrayList<CountryPath>();
        this.connections = FXCollections.observableArrayList();
        this._fill = Constants.FILL;
        this._stroke = Constants.STROKE;
        this._lineWidth = 1.0;
        this._poiFill = Constants.POI_FILL;
        this._poiStroke = Color.TRANSPARENT;
        this._poisVisible = false;
        this._poiTextVisible = false;
        this._poiTextFill = Constants.TEXT_FILL;
        this._hoverEnabled = false;
        this._selectionEnabled = false;
        this._selectedCountry = null;
        this.formerSelectedCountry = null;
        this._hoverColor = Color.web((String)"#3b5b6b");
        this._pressedColor = Color.DARKBLUE;
        this._selectedColor = Color.web((String)"#28596f");
        this.pois = FXCollections.observableArrayList();
        this.heatmapSpots = new ArrayList<Point>();
        this.poiListChangeListener = c -> {
            while (c.next()) {
                if (c.wasAdded() || !c.wasRemoved()) continue;
            }
            this.redraw();
        };
        this.connectionListChangeListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(connection -> connection.addEvtObserver(this));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(connection -> connection.removeEvtObserver(this));
            }
            if (this.overlay.isVisible()) {
                this.redrawOverlay();
            }
        };
        this._mouseEnterHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseEnterHandler);
        this._mousePressHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mousePressHandler);
        this._mouseReleaseHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseReleaseHandler);
        this._mouseExitHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseExitHandler);
        List<Point> regionBounds = region.getRegionBounds();
        Point upperLeft = Helper.latLonToXY(regionBounds.get(0));
        Point lowerRight = Helper.latLonToXY(regionBounds.get(1));
        this.regionOffsetX = upperLeft.getX();
        this.regionOffsetY = upperLeft.getY();
        aspectRatio = (lowerRight.getY() - upperLeft.getY()) / (lowerRight.getX() - upperLeft.getX());
        this.initGraphics();
        this.registerListeners();
    }

    private void initRegion() {
        List<Point> regionBounds = this.region.getRegionBounds();
        Point upperLeft = Helper.latLonToXY(regionBounds.get(0));
        Point lowerRight = Helper.latLonToXY(regionBounds.get(1));
        this.regionOffsetX = upperLeft.getX();
        this.regionOffsetY = upperLeft.getY();
        aspectRatio = (lowerRight.getY() - upperLeft.getY()) / (lowerRight.getX() - upperLeft.getX());
        this.pois.clear();
        this.heatmapSpots.clear();
        this.heatmap.clearHeatMap();
        double scaledLineWidth = this.getLineWidth() / this.scaleX;
        this.countryPaths = this.region.getCountryPaths();
        this.paths = this.region.getPaths();
        this.paths.forEach(path -> {
            path.setFill((Paint)this.getFill());
            path.setStroke((Paint)this.getStroke());
            path.setStrokeWidth(scaledLineWidth);
            path.setTranslateX(-this.regionOffsetX);
            path.setTranslateY(-this.regionOffsetY);
            path.setStrokeLineCap(StrokeLineCap.ROUND);
            path.setStrokeLineJoin(StrokeLineJoin.ROUND);
            path.setOnMouseEntered((EventHandler)new WeakEventHandler(this._mouseEnterHandler));
            path.setOnMousePressed((EventHandler)new WeakEventHandler(this._mousePressHandler));
            path.setOnMouseReleased((EventHandler)new WeakEventHandler(this._mouseReleaseHandler));
            path.setOnMouseExited((EventHandler)new WeakEventHandler(this._mouseExitHandler));
        });
        this.group.getChildren().setAll(this.paths);
        this.layoutChildren();
        this.resize();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.overlay = new Canvas(250.0, 250.0);
        this.overlayCtx = this.overlay.getGraphicsContext2D();
        this.overlay.setMouseTransparent(true);
        this.overlay.setVisible(false);
        this.overlay.setManaged(false);
        this.heatmap = HeatMapBuilder.create().prefSize(1009.0, 665.0).colorMapping((Mapping)ColorMapping.INFRARED_4).spotRadius(5.0).fadeColors(true).opacityDistribution(OpacityDistribution.LINEAR).heatMapOpacity(0.75).build();
        this.heatmap.setVisible(false);
        this.heatmap.setManaged(false);
        this.heatmap.setMouseTransparent(true);
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.canvas.setMouseTransparent(true);
        this.countryPaths = this.region.getCountryPaths();
        this.paths = this.region.getPaths();
        this.paths.forEach(path -> {
            path.setFill((Paint)this.getFill());
            path.setStroke((Paint)this.getStroke());
            path.setStrokeWidth(this.getLineWidth());
            path.setTranslateX(-this.regionOffsetX);
            path.setTranslateY(-this.regionOffsetY);
            path.setStrokeLineCap(StrokeLineCap.ROUND);
            path.setStrokeLineJoin(StrokeLineJoin.ROUND);
            path.setOnMouseEntered((EventHandler)new WeakEventHandler(this._mouseEnterHandler));
            path.setOnMousePressed((EventHandler)new WeakEventHandler(this._mousePressHandler));
            path.setOnMouseReleased((EventHandler)new WeakEventHandler(this._mouseReleaseHandler));
            path.setOnMouseExited((EventHandler)new WeakEventHandler(this._mouseExitHandler));
        });
        this.group = new Group();
        this.group.getChildren().addAll(this.paths);
        this.pane = new Pane(new Node[]{this.group});
        this.setBackground((Paint)Constants.BACKGROUND);
        this.getChildren().setAll((Object[])new Node[]{this.pane, this.canvas, this.heatmap, this.overlay});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.pois.addListener(this.poiListChangeListener);
        this.connections.addListener(this.connectionListChangeListener);
        if (null != this.getScene()) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (null == nv1) {
                    return;
                }
                if (null != this.getScene().getWindow()) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (null == nv2) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, (Observable[])new Observable[]{this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty()});
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                this.resize();
                this.heatmap.clearHeatMap();
                ArrayList scaledSpots = new ArrayList();
                this.heatmapSpots.forEach(spot -> {
                    Point p = Helper.latLonToXY(spot);
                    double x = (p.getX() - this.regionOffsetX) * this.scaleX;
                    double y = (p.getY() - this.regionOffsetY) * this.scaleY;
                    scaledSpots.add(new Point(x, y));
                });
                this.heatmap.setSpots(scaledSpots);
            }
        });
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 4096.0;
    }

    protected double computeMaxHeight(double width) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public CRegion getRegion() {
        return this.region;
    }

    public void setCountry(CRegion region) {
        this.region = region;
        this.initRegion();
    }

    public void setBackground(Paint paint) {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color fill) {
        if (null == this.fill) {
            this._fill = fill;
            this.countryPaths.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(countryPath -> countryPath.setFill((Paint)(null == ((Country)((Object)((Object)((Object)entry.getKey())))).getFill() ? fill : ((Country)((Object)((Object)((Object)entry.getKey())))).getFill()))));
        } else {
            this.fill.set((Object)fill);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    RegionPane.this.countryPaths.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(countryPath -> countryPath.setFill((Paint)(null == ((Country)((Object)((Object)((Object)entry.getKey())))).getFill() ? (Paint)this.get() : ((Country)((Object)((Object)((Object)entry.getKey())))).getFill()))));
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color stroke) {
        if (null == this.stroke) {
            this._stroke = stroke;
            this.countryPaths.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(countryPath -> countryPath.setStroke((Paint)(null == ((Country)((Object)((Object)((Object)entry.getKey())))).getStroke() ? stroke : ((Country)((Object)((Object)((Object)entry.getKey())))).getStroke()))));
        } else {
            this.stroke.set((Object)stroke);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    RegionPane.this.countryPaths.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(countryPath -> countryPath.setStroke((Paint)(null == ((Country)((Object)((Object)((Object)entry.getKey())))).getStroke() ? (Paint)this.get() : ((Country)((Object)((Object)((Object)entry.getKey())))).getStroke()))));
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public double getLineWidth() {
        return null == this.lineWidth ? this._lineWidth : this.lineWidth.get();
    }

    public void setLineWidth(double lineWidth) {
        if (null == this.lineWidth) {
            this._lineWidth = lineWidth;
            this.countryPaths.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(countryPath -> countryPath.setStrokeWidth(lineWidth)));
        } else {
            this.lineWidth.set(lineWidth);
        }
    }

    public DoubleProperty lineWidthProperty() {
        if (null == this.lineWidth) {
            this.lineWidth = new DoublePropertyBase(this._lineWidth){

                protected void invalidated() {
                    RegionPane.this.countryPaths.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(countryPath -> countryPath.setStrokeWidth(this.get())));
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "lineWidth";
                }
            };
        }
        return this.lineWidth;
    }

    public Color getPoiFill() {
        return null == this.poiFill ? this._poiFill : (Color)this.poiFill.get();
    }

    public void setPoiFill(Color poiFill) {
        if (null == this.poiFill) {
            this._poiFill = poiFill;
            this.redraw();
        } else {
            this.poiFill.set((Object)poiFill);
        }
    }

    public ObjectProperty<Color> poiFillProperty() {
        if (null == this.poiFill) {
            this.poiFill = new ObjectPropertyBase<Color>(this._poiFill){

                protected void invalidated() {
                    RegionPane.this.redraw();
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "poiFill";
                }
            };
            this._poiFill = null;
        }
        return this.poiFill;
    }

    public Color getPoiStroke() {
        return null == this.poiStroke ? this._poiStroke : (Color)this.poiStroke.get();
    }

    public void setPoiStroke(Color poiStroke) {
        if (null == this.poiStroke) {
            this._poiStroke = poiStroke;
            this.redraw();
        } else {
            this.poiStroke.set((Object)poiStroke);
        }
    }

    public ObjectProperty<Color> poiStrokeProperty() {
        if (null == this.poiStroke) {
            this.poiStroke = new ObjectPropertyBase<Color>(this._poiStroke){

                protected void invalidated() {
                    RegionPane.this.redraw();
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "poiStroke";
                }
            };
            this._poiStroke = null;
        }
        return this.poiStroke;
    }

    public boolean getPoisVisible() {
        return null == this.poisVisible ? this._poisVisible : this.poisVisible.get();
    }

    public void setPoisVisible(boolean poisVisible) {
        if (null == this.poisVisible) {
            this._poisVisible = poisVisible;
            this.redraw();
        } else {
            this.poisVisible.set(poisVisible);
        }
    }

    public BooleanProperty poisVisibleProperty() {
        if (null == this.poisVisible) {
            this.poisVisible = new BooleanPropertyBase(this._poisVisible){

                protected void invalidated() {
                    RegionPane.this.redraw();
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "poisVisible";
                }
            };
        }
        return this.poisVisible;
    }

    public boolean getPoiTextVisible() {
        return null == this.poiTextVisible ? this._poiTextVisible : this.poiTextVisible.get();
    }

    public void setPoiTextVisible(boolean poiTextVisible) {
        if (null == this.poiTextVisible) {
            this._poiTextVisible = poiTextVisible;
            this.redraw();
        } else {
            this.poiTextVisible.set(poiTextVisible);
        }
    }

    public BooleanProperty poiTextVisibleProperty() {
        if (null == this.poiTextVisible) {
            this.poiTextVisible = new BooleanPropertyBase(this._poiTextVisible){

                protected void invalidated() {
                    RegionPane.this.redraw();
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "poiTextVisible";
                }
            };
        }
        return this.poiTextVisible;
    }

    public Color getPoiTextFill() {
        return null == this.poiTextFill ? this._poiTextFill : (Color)this.poiTextFill.get();
    }

    public void setPoiTextFill(Color poiTextFill) {
        if (null == this.poiTextFill) {
            this._poiTextFill = poiTextFill;
            this.redraw();
        } else {
            this.poiTextFill.set((Object)poiTextFill);
        }
    }

    public ObjectProperty<Color> poiTextFillProperty() {
        if (null == this.poiTextFill) {
            this.poiTextFill = new ObjectPropertyBase<Color>(this._poiTextFill){

                protected void invalidated() {
                    RegionPane.this.redraw();
                }

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "poiTextFill";
                }
            };
            this._poiTextFill = null;
        }
        return this.poiTextFill;
    }

    public List<Poi> getPois() {
        return Collections.unmodifiableList(this.pois);
    }

    public void addPoi(Poi poi) {
        if (!this.pois.contains((Object)poi)) {
            this.pois.add((Object)poi);
        }
    }

    public void removePoi(Poi poi) {
        if (this.pois.contains((Object)poi)) {
            this.pois.remove((Object)poi);
        }
    }

    public void addPois(List<Poi> pois) {
        this.pois.removeListener(this.poiListChangeListener);
        pois.forEach(poi -> this.addPoi((Poi)poi));
        this.pois.addListener(this.poiListChangeListener);
        this.redraw();
    }

    public void removePois(List<Poi> pois) {
        this.pois.removeListener(this.poiListChangeListener);
        pois.forEach(poi -> this.removePoi((Poi)poi));
        this.pois.addListener(this.poiListChangeListener);
        this.redraw();
    }

    public void setPois(List<Poi> pois) {
        this.pois.removeListener(this.poiListChangeListener);
        this.pois.setAll(pois);
        this.pois.addListener(this.poiListChangeListener);
        this.redraw();
    }

    public void clearPois() {
        this.pois.clear();
    }

    public List<Connection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public void addConnection(Connection connection) {
        if (!this.connections.contains((Object)connection)) {
            this.connections.add((Object)connection);
        }
    }

    public void removeConnection(Connection connection) {
        if (this.connections.contains((Object)connection)) {
            this.connections.remove((Object)connection);
        }
    }

    public void addConnections(List<Connection> connections) {
        this.connections.removeListener(this.connectionListChangeListener);
        connections.forEach(connection -> {
            connection.addEvtObserver(this);
            this.addConnection((Connection)connection);
        });
        this.connections.addListener(this.connectionListChangeListener);
        this.redraw();
    }

    public void removeConnections(List<Connection> connections) {
        this.connections.removeListener(this.connectionListChangeListener);
        connections.forEach(connection -> {
            connection.removeEvtObserver(this);
            this.removeConnection((Connection)connection);
        });
        this.connections.addListener(this.connectionListChangeListener);
        this.redraw();
    }

    public void setConnections(List<Connection> connections) {
        this.connections.removeListener(this.connectionListChangeListener);
        connections.forEach(connection -> connection.addEvtObserver(this));
        this.connections.setAll(connections);
        this.connections.addListener(this.connectionListChangeListener);
        this.redraw();
    }

    public void clearConnections() {
        this.connections.clear();
    }

    public boolean isShowing() {
        return null != this.showing && this.showing.get();
    }

    public BooleanBinding showingProperty() {
        return this.showing;
    }

    public boolean isHoverEnabled() {
        return null == this.hoverEnabled ? this._hoverEnabled : this.hoverEnabled.get();
    }

    public void setHoverEnabled(boolean hoverEnabled) {
        if (null == this.hoverEnabled) {
            this._hoverEnabled = hoverEnabled;
        } else {
            this.hoverEnabled.set(hoverEnabled);
        }
    }

    public BooleanProperty hoverEnabledProperty() {
        if (null == this.hoverEnabled) {
            this.hoverEnabled = new BooleanPropertyBase(this._hoverEnabled){

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "hoverEnabled";
                }
            };
        }
        return this.hoverEnabled;
    }

    public boolean isSelectionEnabled() {
        return null == this.selectionEnabled ? this._selectionEnabled : this.selectionEnabled.get();
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        if (null == this.selectionEnabled) {
            this._selectionEnabled = selectionEnabled;
        } else {
            this.selectionEnabled.set(selectionEnabled);
        }
    }

    public BooleanProperty selectionEnabledProperty() {
        if (null == this.selectionEnabled) {
            this.selectionEnabled = new BooleanPropertyBase(){

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "selectionEnabled";
                }
            };
        }
        return this.selectionEnabled;
    }

    public Country getSelectedCountry() {
        return null == this.selectedCountry ? this._selectedCountry : (Country)((Object)this.selectedCountry.get());
    }

    public void setSelectedCountry(Country selectedCountry) {
        if (null == this.selectedCountry) {
            this._selectedCountry = selectedCountry;
        } else {
            this.selectedCountry.set((Object)selectedCountry);
        }
    }

    public ObjectProperty<Country> selectedCountryProperty() {
        if (null == this.selectedCountry) {
            this.selectedCountry = new ObjectPropertyBase<Country>(this._selectedCountry){

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "selectedCountry";
                }
            };
            this._selectedCountry = null;
        }
        return this.selectedCountry;
    }

    public Color getHoverColor() {
        return null == this.hoverColor ? this._hoverColor : (Color)this.hoverColor.getValue();
    }

    public void setHoverColor(Color hoverColor) {
        if (null == this.hoverColor) {
            this._hoverColor = hoverColor;
        } else {
            this.hoverColor.setValue((Object)hoverColor);
        }
    }

    public ObjectProperty<Color> hoverColorProperty() {
        if (null == this.hoverColor) {
            this.hoverColor = new ObjectPropertyBase<Color>(this._hoverColor){

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "hoverColor";
                }
            };
            this._hoverColor = null;
        }
        return this.hoverColor;
    }

    public Color getPressedColor() {
        return null == this.pressedColor ? this._pressedColor : (Color)this.pressedColor.getValue();
    }

    public void setPressedColor(Color pressedColor) {
        if (null == this.pressedColor) {
            this._pressedColor = pressedColor;
        } else {
            this.pressedColor.setValue((Object)pressedColor);
        }
    }

    public ObjectProperty<Color> pressedColorProperty() {
        if (null == this.pressedColor) {
            this.pressedColor = new ObjectPropertyBase<Color>(this._pressedColor){

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "pressedColor";
                }
            };
            this._pressedColor = null;
        }
        return this.pressedColor;
    }

    public Color getSelectedColor() {
        return null == this.selectedColor ? this._selectedColor : (Color)this.selectedColor.getValue();
    }

    public void setSelectedColor(Color selectedColor) {
        if (null == this.selectedColor) {
            this._selectedColor = selectedColor;
        } else {
            this.selectedColor.setValue((Object)selectedColor);
        }
    }

    public ObjectProperty<Color> selectedColorProperty() {
        if (null == this.selectedColor) {
            this.selectedColor = new ObjectPropertyBase<Color>(this._selectedColor){

                public Object getBean() {
                    return RegionPane.this;
                }

                public String getName() {
                    return "selectedColor";
                }
            };
            this._selectedColor = null;
        }
        return this.selectedColor;
    }

    public void setMouseEnterHandler(EventHandler<MouseEvent> handler) {
        this.mouseEnterHandler = handler;
    }

    public void setMousePressHandler(EventHandler<MouseEvent> handler) {
        this.mousePressHandler = handler;
    }

    public void setMouseReleaseHandler(EventHandler<MouseEvent> handler) {
        this.mouseReleaseHandler = handler;
    }

    public void setMouseExitHandler(EventHandler<MouseEvent> handler) {
        this.mouseExitHandler = handler;
    }

    public boolean isHeatmapVisible() {
        return this.heatmap.isVisible();
    }

    public void setHeatmapVisible(boolean heatmapVisible) {
        this.heatmap.setManaged(heatmapVisible);
        this.heatmap.setVisible(heatmapVisible);
        if (heatmapVisible) {
            this.redraw();
        }
    }

    public boolean isOverlayVisible() {
        return this.overlay.isVisible();
    }

    public void setOverlayVisible(boolean overlayVisible) {
        this.overlay.setManaged(overlayVisible);
        this.overlay.setVisible(overlayVisible);
        if (overlayVisible) {
            this.redrawOverlay();
        }
    }

    public Mapping getHeatmapColorMapping() {
        return this.heatmap.getColorMapping();
    }

    public void setHeatmapColorMapping(Mapping colorMapping) {
        Platform.runLater(() -> this.heatmap.setColorMapping(colorMapping));
    }

    public double getHeatmapSpotRadius() {
        return this.heatmap.getSpotRadius();
    }

    public void setHeatmapSpotRadius(double spotRadius) {
        this.heatmap.setSpotRadius(spotRadius);
    }

    public boolean isHeatmapFadeColors() {
        return this.heatmap.isFadeColors();
    }

    public void setHeatmapFadeColors(boolean fadeColors) {
        Platform.runLater(() -> this.heatmap.setFadeColors(fadeColors));
    }

    public OpacityDistribution getHeatmapOpacityDistribution() {
        return this.heatmap.getOpacityDistribution();
    }

    public void setHeatmapOpacityDistribution(OpacityDistribution opacityDistribution) {
        this.heatmap.setOpacityDistribution(opacityDistribution);
    }

    public double getHeatmapOpacity() {
        return this.heatmap.getOpacity();
    }

    public void setHeatmapOpacity(double opacity) {
        this.heatmap.setOpacity(opacity);
    }

    public List<Point> getHeatmapSpots() {
        return this.heatmapSpots;
    }

    public void setHeatmapSpots(List<Point> spots) {
        this.heatmapSpots.clear();
        this.heatmapSpots.addAll(spots);
        Platform.runLater(() -> {
            ArrayList scaledSpots = new ArrayList();
            this.heatmapSpots.forEach(spot -> {
                Point p = Helper.latLonToXY(spot);
                double x = (p.getX() - this.regionOffsetX) * this.scaleX;
                double y = (p.getY() - this.regionOffsetY) * this.scaleY;
                scaledSpots.add(new Point(x, y));
            });
            this.heatmap.setSpots(scaledSpots);
        });
        this.redraw();
    }

    public void addHeatmapSpot(Point spot) {
        if (this.heatmapSpots.contains(spot)) {
            return;
        }
        this.heatmapSpots.add(spot);
        Platform.runLater(() -> {
            Point p = Helper.latLonToXY(spot);
            double x = (p.getX() - this.regionOffsetX) * this.scaleX;
            double y = (p.getY() - this.regionOffsetY) * this.scaleY;
            this.heatmap.addSpot(x, y);
        });
        this.redraw();
    }

    public void clearHeatmap() {
        this.heatmapSpots.clear();
        this.heatmap.clearHeatMap();
    }

    private void handleMouseEvent(MouseEvent event, EventHandler<MouseEvent> handler) {
        CountryPath countryPath = (CountryPath)((Object)event.getSource());
        String countryName = countryPath.getName();
        Country country = Country.valueOf(countryName);
        List<CountryPath> paths = this.countryPaths.get((Object)country);
        EventType type = event.getEventType();
        if (MouseEvent.MOUSE_ENTERED == type) {
            if (this.isHoverEnabled()) {
                Color color = this.isSelectionEnabled() && country.equals((Object)this.getSelectedCountry()) ? this.getSelectedColor() : this.getHoverColor();
                for (SVGPath sVGPath : paths) {
                    sVGPath.setFill((Paint)color);
                }
            }
        } else if (MouseEvent.MOUSE_PRESSED == type) {
            if (this.isSelectionEnabled()) {
                Color color;
                if (null == this.getSelectedCountry()) {
                    this.setSelectedCountry(country);
                    color = this.getSelectedColor();
                } else {
                    color = null == this.getSelectedCountry().getFill() ? this.getFill() : this.getSelectedCountry().getFill();
                }
                for (SVGPath sVGPath : this.countryPaths.get((Object)this.getSelectedCountry())) {
                    sVGPath.setFill((Paint)color);
                }
            } else if (this.isHoverEnabled()) {
                for (SVGPath sVGPath : paths) {
                    sVGPath.setFill((Paint)this.getPressedColor());
                }
            }
        } else if (MouseEvent.MOUSE_RELEASED == type) {
            Color color;
            if (this.isSelectionEnabled()) {
                if (this.formerSelectedCountry == country) {
                    this.setSelectedCountry(null);
                    color = null == country.getFill() ? this.getFill() : country.getFill();
                } else {
                    this.setSelectedCountry(country);
                    color = this.getSelectedColor();
                }
                this.formerSelectedCountry = this.getSelectedCountry();
            } else {
                color = this.getHoverColor();
            }
            if (this.isHoverEnabled()) {
                for (SVGPath sVGPath : paths) {
                    sVGPath.setFill((Paint)color);
                }
            }
        } else if (MouseEvent.MOUSE_EXITED == type && this.isHoverEnabled()) {
            Color color = this.isSelectionEnabled() && country.equals((Object)this.getSelectedCountry()) ? this.getSelectedColor() : this.getFill();
            for (SVGPath sVGPath : paths) {
                sVGPath.setFill((Paint)(null == country.getFill() || country == this.getSelectedCountry() ? color : country.getFill()));
            }
        }
        if (null != handler) {
            handler.handle((Event)event);
        }
    }

    public void handle(CountryEvt<Connection> evt) {
        EvtType type = evt.getEvtType();
        if (type.equals(CountryEvt.UPDATE)) {
            if (this.overlay.isVisible()) {
                this.redrawOverlay();
            }
        } else if (type.equals(CountryEvt.SELECTED) && this.overlay.isVisible()) {
            this.redrawOverlay();
        }
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (aspectRatio * this.width > this.height) {
            this.width = 1.0 / (aspectRatio / this.height);
        } else if (1.0 / (aspectRatio / this.height) > this.width) {
            this.height = aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.scaleX = this.width / this.pane.getWidth();
            this.scaleY = this.height / this.pane.getHeight();
            double scaledLineWidth = this.getLineWidth() / this.scaleX;
            double relocateX = (this.getWidth() - this.pane.getWidth()) * 0.5;
            double relocateY = (this.getHeight() - this.pane.getHeight()) * 0.5;
            this.pane.setCache(true);
            this.pane.setCacheHint(CacheHint.SCALE);
            this.pane.setScaleX(this.scaleX);
            this.pane.setScaleY(this.scaleY);
            this.pane.setCache(false);
            this.paths.forEach(path -> path.setStrokeWidth(scaledLineWidth));
            this.pane.relocate(relocateX, relocateY);
            this.canvas.setWidth(this.pane.getWidth() * this.scaleX);
            this.canvas.setHeight(this.pane.getHeight() * this.scaleY);
            this.canvas.relocate((this.getWidth() - this.canvas.getWidth()) * 0.5, (this.getHeight() - this.canvas.getHeight()) * 0.5);
            this.heatmap.setFitWidth(this.pane.getWidth() * this.scaleX);
            this.heatmap.setFitHeight(this.pane.getHeight() * this.scaleY);
            this.heatmap.relocate((this.getWidth() - this.canvas.getWidth()) * 0.5, (this.getHeight() - this.canvas.getHeight()) * 0.5);
            this.overlay.setWidth(this.pane.getWidth() * this.scaleX);
            this.overlay.setHeight(this.pane.getHeight() * this.scaleY);
            this.overlay.relocate((this.getWidth() - this.overlay.getWidth()) * 0.5, (this.getHeight() - this.overlay.getHeight()) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        double fontsize = this.size * 0.015;
        this.ctx.clearRect(0.0, 0.0, width, height);
        this.ctx.setFont(Fonts.opensansLight((double)fontsize));
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        if (this.getPoisVisible()) {
            HashMap points = new HashMap();
            this.pois.forEach(poi -> {
                this.ctx.setFill((Paint)(null == poi.getFill() ? this.getPoiFill() : poi.getFill()));
                this.ctx.setStroke((Paint)(null == poi.getStroke() ? this.getPoiStroke() : poi.getStroke()));
                Point p = Helper.latLonToXY(poi.getLonLat());
                double x = (p.getX() - this.regionOffsetX) * this.scaleX;
                double y = (p.getY() - this.regionOffsetY) * this.scaleY;
                if (null == poi.getImage() && null == poi.getSvgPath()) {
                    double r;
                    double d = switch (poi.getPoiSize()) {
                        case PoiSize.TINY -> {
                            r = 0.5;
                            yield 1.0;
                        }
                        case PoiSize.SMALL -> {
                            r = 1.0;
                            yield 2.0;
                        }
                        case PoiSize.NORMAL -> {
                            r = 1.5;
                            yield 3.0;
                        }
                        case PoiSize.BIG -> {
                            r = 2.5;
                            yield 5.0;
                        }
                        case PoiSize.HUGE -> {
                            r = 4.0;
                            yield 8.0;
                        }
                        default -> {
                            r = 1.0;
                            yield 2.0;
                        }
                    };
                    if (d >= 1.0) {
                        this.ctx.fillOval(x - r, y - r, d, d);
                    }
                } else {
                    if (null != poi.getImage()) {
                        Image img = poi.getImage();
                        this.ctx.drawImage(img, x - img.getWidth() * 0.5, y - img.getHeight() * 0.5, img.getWidth(), img.getHeight());
                    }
                    if (null != poi.getSvgPath() && null != poi.getSvgPathDim()) {
                        this.ctx.save();
                        this.ctx.translate(x - poi.getSvgPathDim().getWidth() * 0.5, y - poi.getSvgPathDim().getHeight() * 0.5);
                        this.ctx.beginPath();
                        this.ctx.appendSVGPath(poi.getSvgPath());
                        this.ctx.closePath();
                        this.ctx.setFill((Paint)Color.LIME);
                        this.ctx.fill();
                        this.ctx.stroke();
                        this.ctx.restore();
                    }
                }
                points.put(poi, new Point(x, y));
            });
            if (this.getPoiTextVisible() && fontsize > 6.0) {
                this.ctx.setFill((Paint)this.getPoiTextFill());
                points.entrySet().forEach(entry -> this.ctx.fillText(((Poi)entry.getKey()).getName(), ((Point)entry.getValue()).getX(), ((Point)entry.getValue()).getY() - fontsize));
            }
        }
        if (this.overlay.isVisible()) {
            this.redrawOverlay();
        }
    }

    private void redrawOverlay() {
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        this.overlayCtx.clearRect(0.0, 0.0, width, height);
        for (Connection connection : this.connections) {
            Point cp2;
            Point cp1;
            CLocation p1 = connection.getTargetLocation();
            CLocation p2 = connection.getSourceLocation();
            if (null == p1 || null == p2) continue;
            Point xy1 = Helper.latLonToXY(p1.getLatitude(), p1.getLongitude());
            Point xy2 = Helper.latLonToXY(p2.getLatitude(), p2.getLongitude());
            Point midPoint = Helper.getMidPoint(xy1, xy2);
            Point midPoint1 = Helper.getMidPoint(xy1, midPoint);
            Point midPoint2 = Helper.getMidPoint(xy2, midPoint);
            Point rotCp1 = Helper.getMidPoint(xy1, midPoint2);
            Point rotCp2 = Helper.getMidPoint(midPoint1, xy2);
            double cpAngle = Helper.getControlPointAngle(xy1, xy2);
            xy1.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            xy1.scaleBy(this.scaleX, this.scaleY);
            xy2.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            xy2.scaleBy(this.scaleX, this.scaleY);
            midPoint.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            midPoint.scaleBy(this.scaleX, this.scaleY);
            midPoint1.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            midPoint1.scaleBy(this.scaleX, this.scaleY);
            midPoint2.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            midPoint2.scaleBy(this.scaleX, this.scaleY);
            rotCp1.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            rotCp1.scaleBy(this.scaleX, this.scaleY);
            rotCp2.translateBy(-this.regionOffsetX, -this.regionOffsetY);
            rotCp2.scaleBy(this.scaleX, this.scaleY);
            if (xy2.getX() > xy1.getX()) {
                cp1 = Helper.rotatePointAroundRotationCenter(rotCp1, xy1, -cpAngle);
                cp2 = Helper.rotatePointAroundRotationCenter(rotCp2, xy2, cpAngle);
                this.overlayCtx.beginPath();
                this.overlayCtx.moveTo(xy1.getX(), xy1.getY());
                this.overlayCtx.bezierCurveTo(cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), xy2.getX(), xy2.getY());
            } else {
                cp1 = Helper.rotatePointAroundRotationCenter(rotCp1, xy1, cpAngle);
                cp2 = Helper.rotatePointAroundRotationCenter(rotCp2, xy2, -cpAngle);
                this.overlayCtx.beginPath();
                this.overlayCtx.moveTo(xy2.getX(), xy2.getY());
                this.overlayCtx.bezierCurveTo(cp2.getX(), cp2.getY(), cp1.getX(), cp1.getY(), xy1.getX(), xy1.getY());
            }
            this.overlayCtx.setLineWidth(connection.getLineWidth());
            if (connection.getGradientFill()) {
                LinearGradient gradient = new LinearGradient(xy1.getX(), xy1.getY(), xy2.getX(), xy2.getY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, connection.getTargetColor()), new Stop(0.5, connection.getSourceColor()), new Stop(1.0, connection.getSourceColor())});
                this.overlayCtx.setStroke((Paint)gradient);
            } else {
                this.overlayCtx.setStroke((Paint)(connection.isSelected() ? connection.getSelectedStroke() : connection.getStroke()));
            }
            this.overlayCtx.stroke();
            Point pointNearStart = Helper.getCubicBezierXYatT(xy1, cp1, cp2, xy2, 0.01);
            double dx = xy1.getX() - pointNearStart.getX();
            double dy = xy1.getY() - pointNearStart.getY();
            double angleAtEnd = Math.toDegrees(Math.atan2(dy, dx));
            if (!connection.getArrowsVisible()) continue;
            double arrowSize = connection.getLineWidth() * 1.5;
            this.overlayCtx.beginPath();
            this.overlayCtx.save();
            if (connection.getGradientFill()) {
                this.overlayCtx.setFill((Paint)connection.getTargetColor());
            } else {
                this.overlayCtx.setFill((Paint)(connection.isSelected() ? connection.getSelectedStroke() : connection.getStroke()));
            }
            this.overlayCtx.translate(xy1.getX(), xy1.getY());
            this.overlayCtx.rotate(angleAtEnd);
            this.overlayCtx.moveTo(-arrowSize * 3.0, 0.0);
            this.overlayCtx.lineTo(-arrowSize * 3.0, -arrowSize * 2.0);
            this.overlayCtx.lineTo(0.0, 0.0);
            this.overlayCtx.lineTo(-arrowSize * 3.0, arrowSize * 2.0);
            this.overlayCtx.lineTo(-arrowSize * 3.0, 0.0);
            this.overlayCtx.closePath();
            this.overlayCtx.fill();
            this.overlayCtx.restore();
        }
    }
}

