/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.WorldPane;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class WorldPaneBuilder<B extends WorldPaneBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();

    protected WorldPaneBuilder() {
    }

    public static final WorldPaneBuilder create() {
        return new WorldPaneBuilder();
    }

    public final B background(Paint paint) {
        this.properties.put("background", new SimpleObjectProperty<Paint>(paint));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", new SimpleObjectProperty<Color>(fill));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", new SimpleObjectProperty<Color>(stroke));
        return (B)this;
    }

    public final B poiFill(Color poiFill) {
        this.properties.put("poiFill", new SimpleObjectProperty<Color>(poiFill));
        return (B)this;
    }

    public final B poiStroke(Color poiStroke) {
        this.properties.put("poiStroke", new SimpleObjectProperty<Color>(poiStroke));
        return (B)this;
    }

    public final B poiTextFill(Color poiTextFill) {
        this.properties.put("poiTextFill", new SimpleObjectProperty<Color>(poiTextFill));
        return (B)this;
    }

    public final B poisVisible(boolean poisVisible) {
        this.properties.put("poisVisible", new SimpleBooleanProperty(poisVisible));
        return (B)this;
    }

    public final B poiTextVisible(boolean poiTextVisible) {
        this.properties.put("poiTextVisible", new SimpleBooleanProperty(poiTextVisible));
        return (B)this;
    }

    public final B pois(List<Poi> pois) {
        this.properties.put("pois", new SimpleObjectProperty<List<Poi>>(pois));
        return (B)this;
    }

    public final B heatmapVisible(boolean heatmapVisible) {
        this.properties.put("heatmapVisible", new SimpleBooleanProperty(heatmapVisible));
        return (B)this;
    }

    public final B heatmapSpots(List<Point> heatmapSpots) {
        this.properties.put("heatmapSpots", new SimpleObjectProperty<List<Point>>(heatmapSpots));
        return (B)this;
    }

    public final B heatmapColorMapping(Mapping heatmapColorMapping) {
        this.properties.put("heatmapColorMapping", new SimpleObjectProperty<Mapping>(heatmapColorMapping));
        return (B)this;
    }

    public final B heatmapSpotRadius(double heatmapSpotRadius) {
        this.properties.put("heatmapSpotRadius", new SimpleDoubleProperty(heatmapSpotRadius));
        return (B)this;
    }

    public final B heatmapFadeColors(boolean heatmapFadeColors) {
        this.properties.put("heatmapFadeColors", new SimpleBooleanProperty(heatmapFadeColors));
        return (B)this;
    }

    public final B heatmapOpacityDistribution(OpacityDistribution heatmapOpacityDistribution) {
        this.properties.put("heatmapOpacityDistribution", new SimpleObjectProperty<OpacityDistribution>(heatmapOpacityDistribution));
        return (B)this;
    }

    public final B heatmapOpacity(double heatmapOpacity) {
        this.properties.put("heatmapOpacity", new SimpleDoubleProperty(heatmapOpacity));
        return (B)this;
    }

    public final B connections(List<Connection> connections) {
        this.properties.put("connections", new SimpleObjectProperty<List<Connection>>(connections));
        return (B)this;
    }

    public final B overlayVisible(boolean overlayVisible) {
        this.properties.put("overlayVisible", new SimpleBooleanProperty(overlayVisible));
        return (B)this;
    }

    public final B hoverEnabled(boolean hoverEnabled) {
        this.properties.put("hoverEnabled", new SimpleBooleanProperty(hoverEnabled));
        return (B)this;
    }

    public final B selectionEnabled(boolean selectionEnabled) {
        this.properties.put("selectionEnabled", new SimpleBooleanProperty(selectionEnabled));
        return (B)this;
    }

    public final B hoverColor(Color hoverColor) {
        this.properties.put("hoverColor", new SimpleObjectProperty<Color>(hoverColor));
        return (B)this;
    }

    public final B pressedColor(Color pressedColor) {
        this.properties.put("pressedColor", new SimpleObjectProperty<Color>(pressedColor));
        return (B)this;
    }

    public final B selectedColor(Color selectedColor) {
        this.properties.put("selectedColor", new SimpleObjectProperty<Color>(selectedColor));
        return (B)this;
    }

    public final B mouseEnterHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseEnterHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B mousePressHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mousePressHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B mouseReleaseHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseReleaseHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B mouseExitHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseExitHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxheight) {
        this.properties.put("maxHeight", new SimpleDoubleProperty(maxheight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", new SimpleObjectProperty<Insets>(insets));
        return (B)this;
    }

    public final WorldPane build() {
        WorldPane worldPane = new WorldPane();
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    worldPane.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    worldPane.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    worldPane.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    worldPane.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    worldPane.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    worldPane.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    worldPane.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    worldPane.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    worldPane.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    worldPane.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    worldPane.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    worldPane.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    worldPane.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    worldPane.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    worldPane.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    worldPane.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "backgroundColor": {
                    worldPane.setBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "fill": {
                    worldPane.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "stroke": {
                    worldPane.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "lineWidth": {
                    worldPane.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiFill": {
                    worldPane.setPoiFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiStroke": {
                    worldPane.setPoiStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiTextFill": {
                    worldPane.setPoiTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "poisVisible": {
                    worldPane.setPoisVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "poiTextVisible": {
                    worldPane.setPoiTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "pois": {
                    worldPane.addPois((List)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapVisible": {
                    worldPane.setHeatmapVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapSpots": {
                    worldPane.setHeatmapSpots((List)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapColorMapping": {
                    worldPane.setHeatmapColorMapping((Mapping)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapSpotRadius": {
                    worldPane.setHeatmapSpotRadius(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapFadeColors": {
                    worldPane.setHeatmapFadeColors(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "heatmapOpacityDistribution": {
                    worldPane.setHeatmapOpacityDistribution((OpacityDistribution)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "heatmapOpacity": {
                    worldPane.setHeatmapOpacity(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "connections": {
                    worldPane.setConnections((List)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "overlayVisible": {
                    worldPane.setOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "hoverEnabled": {
                    worldPane.setHoverEnabled(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectionEnabled": {
                    worldPane.setSelectionEnabled(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "hoverColor": {
                    worldPane.setHoverColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "pressedColor": {
                    worldPane.setPressedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectedColor": {
                    worldPane.setSelectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "mouseEnterHandler": {
                    worldPane.setMouseEnterHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "mousePressHandler": {
                    worldPane.setMousePressHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "mouseReleaseHandler": {
                    worldPane.setMouseReleaseHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "mouseExitHandler": {
                    worldPane.setMouseExitHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                }
            }
        }
        return worldPane;
    }
}

