/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.heatmap;

import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolboxfx.HelperFX;
import eu.hansolo.toolboxfx.geom.Point;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javax.imageio.ImageIO;

public class HeatMap
extends ImageView {
    private static final SnapshotParameters SNAPSHOT_PARAMETERS = new SnapshotParameters();
    private int width;
    private int height;
    private double oldWidth;
    private double oldHeight;
    private double scaleX;
    private double scaleY;
    private List<Point> spotList;
    private Map<String, Image> spotImages;
    private Mapping colorMapping;
    private LinearGradient mappingGradient;
    private boolean fadeColors;
    private double spotRadius;
    private OpacityDistribution opacityDistribution;
    private Image spotImage;
    private Canvas canvas;
    private GraphicsContext ctx;
    private WritableImage monochromeImage;
    private WritableImage heatMap;

    public HeatMap() {
        this(100.0, 100.0, ColorMapping.LIME_YELLOW_RED, 15.5, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double width, double height) {
        this(width, height, ColorMapping.LIME_YELLOW_RED, 15.5, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double width, double height, Mapping colorMapping) {
        this(width, height, colorMapping, 15.5, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double width, double height, Mapping colorMapping, double spotRadius) {
        this(width, height, colorMapping, spotRadius, true, 0.5, OpacityDistribution.CUSTOM);
    }

    public HeatMap(double width, double height, Mapping colorMapping, double spotRadius, boolean fadeColors, double heatMapOpacity, OpacityDistribution opacityDistribution) {
        this.width = (int)Helper.clamp(10.0, 4096.0, width);
        this.height = (int)Helper.clamp(10.0, 4096.0, height);
        this.oldWidth = (int)Helper.clamp(10.0, 4096.0, width);
        this.oldHeight = (int)Helper.clamp(10.0, 4096.0, height);
        this.colorMapping = null == colorMapping ? ColorMapping.INFRARED_4 : colorMapping;
        this.spotRadius = Helper.clamp(1.0, 30.0, spotRadius);
        this.fadeColors = fadeColors;
        this.opacityDistribution = null == opacityDistribution ? OpacityDistribution.LINEAR : opacityDistribution;
        this.spotList = new ArrayList<Point>();
        this.spotImages = new HashMap<String, Image>();
        this.mappingGradient = this.colorMapping.getGradient();
        this.spotImage = this.createSpotImage(this.spotRadius, this.opacityDistribution);
        this.canvas = new Canvas(this.width, this.height);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.monochromeImage = new WritableImage(this.width, this.height);
        SNAPSHOT_PARAMETERS.setFill(Color.TRANSPARENT);
        this.setImage(this.heatMap);
        this.setMouseTransparent(true);
        this.setOpacity(heatMapOpacity);
        this.registerListeners();
    }

    public void registerListeners() {
        this.fitWidthProperty().addListener(o -> this.resize());
        this.fitHeightProperty().addListener(o -> this.resize());
    }

    public List<Point> getSpots() {
        return this.spotList;
    }

    public void setSpots(List<Point> spots) {
        this.spotList.clear();
        this.addSpots(spots);
    }

    public void addSpots(Point ... spots) {
        this.addSpots(Arrays.asList(spots));
    }

    public void addSpots(List<Point> spots) {
        this.spotList.addAll(spots);
        spots.forEach(spot -> this.ctx.drawImage(this.spotImage, spot.getX() - this.spotRadius, spot.getY() - this.spotRadius));
        this.updateHeatMap();
    }

    public void addSpot(double x, double y) {
        this.addSpot(new Point(x, y), this.spotImage, this.spotRadius, this.spotRadius);
    }

    public void addSpot(Point spot) {
        this.addSpot(spot, this.spotImage, this.spotRadius, this.spotRadius);
    }

    public void addSpot(double x, double y, double offsetX, double offsetY, double spotRadius, OpacityDistribution opacityDistribution) {
        this.spotRadius = spotRadius;
        this.opacityDistribution = opacityDistribution;
        this.spotImage = this.createSpotImage(spotRadius, opacityDistribution);
        this.addSpot(new Point(x, y), this.spotImage, offsetX, offsetY);
    }

    public void addSpot(double x, double y, Image spotImage, double offsetX, double offsetY) {
        this.addSpot(new Point(x, y), spotImage, offsetX, offsetY);
    }

    public void addSpot(Point spot, Image spotImage, double offsetX, double offsetY) {
        this.spotList.add(spot);
        this.ctx.drawImage(spotImage, spot.getX() - offsetX, spot.getY() - offsetY);
        this.updateHeatMap();
    }

    public void clearHeatMap() {
        this.spotList.clear();
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.monochromeImage = new WritableImage(this.width, this.height);
        this.updateHeatMap();
    }

    public Mapping getColorMapping() {
        return this.colorMapping;
    }

    public void setColorMapping(Mapping colorMapping) {
        this.colorMapping = colorMapping;
        this.mappingGradient = colorMapping.getGradient();
        this.updateHeatMap();
    }

    public boolean isFadeColors() {
        return this.fadeColors;
    }

    public void setFadeColors(boolean fadeColors) {
        this.fadeColors = fadeColors;
        this.updateHeatMap();
    }

    public double getSpotRadius() {
        return this.spotRadius;
    }

    public void setSpotRadius(double radius) {
        this.spotRadius = radius < 1.0 ? 1.0 : radius;
        this.spotImage = this.createSpotImage(this.spotRadius, this.opacityDistribution);
    }

    public OpacityDistribution getOpacityDistribution() {
        return this.opacityDistribution;
    }

    public void setOpacityDistribution(OpacityDistribution opacityDistribution) {
        this.opacityDistribution = opacityDistribution;
        this.spotImage = this.createSpotImage(this.spotRadius, this.opacityDistribution);
    }

    public void setSize(double width, double height) {
        this.setFitWidth(width);
        this.setFitHeight(height);
    }

    public void saveAsPng(String fileName) {
        this.saveAsPng(this, fileName + ".png");
    }

    public void saveAsPng(Node node, String fileName) {
        new Thread(() -> Platform.runLater(() -> {
            String target = System.getProperty("user.home") + "/Desktop/" + fileName + ".png";
            try {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage(node.snapshot(SNAPSHOT_PARAMETERS, null), null), "png", new File(target));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        })).start();
    }

    public Image createSpotImage(double radius, OpacityDistribution opacityDistribution) {
        double r;
        double d = r = radius < 1.0 ? 1.0 : radius;
        if (this.spotImages.containsKey(opacityDistribution.name() + r)) {
            return this.spotImages.get(opacityDistribution.name() + r);
        }
        Stop[] stops = new Stop[11];
        for (int i = 0; i < 11; ++i) {
            stops[i] = new Stop((double)i * 0.1, Color.rgb(255, 255, 255, opacityDistribution.getDistribution()[i]));
        }
        int diameter = (int)(r * 2.0);
        WritableImage raster = new WritableImage(diameter, diameter);
        PixelWriter pixelWriter = raster.getPixelWriter();
        double maxDistFactor = 1.0 / r;
        for (int y = 0; y < diameter; ++y) {
            block2: for (int x = 0; x < diameter; ++x) {
                double deltaX = r - (double)x;
                double deltaY = r - (double)y;
                double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                double fraction = maxDistFactor * distance;
                for (int i = 0; i < 10; ++i) {
                    if (!(fraction >= stops[i].getOffset()) || !(fraction <= stops[i + 1].getOffset())) continue;
                    Color pixelColor = (Color)Interpolator.LINEAR.interpolate(stops[i].getColor(), stops[i + 1].getColor(), (fraction - stops[i].getOffset()) / 0.1);
                    pixelWriter.setColor(x, y, pixelColor);
                    continue block2;
                }
            }
        }
        this.spotImages.put(opacityDistribution.name() + r, raster);
        return raster;
    }

    public void updateMonochromeMap(OpacityDistribution opacityDistribution) {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.spotImage = this.createSpotImage(this.spotRadius, opacityDistribution);
        this.spotList.forEach(spot -> this.ctx.drawImage(this.spotImage, spot.getX() - this.spotRadius, spot.getY() - this.spotRadius));
        this.updateHeatMap();
    }

    private void updateHeatMap() {
        if (!Platform.isFxApplicationThread()) {
            return;
        }
        this.canvas.snapshot(SNAPSHOT_PARAMETERS, this.monochromeImage);
        this.heatMap = new WritableImage(this.width, this.height);
        PixelWriter pixelWriter = this.heatMap.getPixelWriter();
        PixelReader pixelReader = this.monochromeImage.getPixelReader();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                Color colorFromMonoChromeImage = pixelReader.getColor(x, y);
                double brightness = colorFromMonoChromeImage.getOpacity();
                Color mappedColor = HelperFX.getColorAt(this.mappingGradient, brightness);
                pixelWriter.setColor(x, y, this.fadeColors ? Color.color(mappedColor.getRed(), mappedColor.getGreen(), mappedColor.getBlue(), brightness) : mappedColor);
            }
        }
        this.setImage(this.heatMap);
    }

    private void updateSpots() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.spotList.forEach(spot -> this.ctx.drawImage(this.spotImage, spot.getX() - this.spotRadius, spot.getY() - this.spotRadius));
    }

    private void resize() {
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.width = (int)this.getFitWidth();
        this.height = (int)this.getFitHeight();
        this.canvas.setWidth(this.width);
        this.canvas.setHeight(this.height);
        if (this.width > 0 && this.height > 0 && this.oldWidth > 0.0 && this.oldHeight > 0.0) {
            this.scaleX = (double)this.width / this.oldWidth;
            this.scaleY = (double)this.height / this.oldHeight;
            this.spotRadius *= this.scaleX;
            this.spotImage = this.createSpotImage(this.spotRadius, this.opacityDistribution);
            this.spotList.forEach(spot -> spot.scaleBy(this.scaleX, this.scaleY));
        }
    }
}

