/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.evt.type;

import eu.hansolo.toolbox.evt.EvtPriority;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.ChangeEvt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListChangeEvt<T>
extends ChangeEvt {
    public static final EvtType<ListChangeEvt> ANY = new EvtType<ChangeEvt>(ChangeEvt.ANY, "ANY");
    public static final EvtType<ListChangeEvt> CHANGED = new EvtType<ListChangeEvt>(ANY, "CHANGED");
    public static final EvtType<ListChangeEvt> ADDED = new EvtType<ListChangeEvt>(ANY, "ADDED");
    public static final EvtType<ListChangeEvt> REMOVED = new EvtType<ListChangeEvt>(ANY, "REMOVED");
    private final List<T> addedElements;
    private final List<T> removedElements;

    public ListChangeEvt(List<T> src, EvtType<ListChangeEvt> evtType, List<T> addedElements, List<T> removedElements) {
        super((Object)src, (EvtType<? extends ChangeEvt>)evtType);
        this.addedElements = null == addedElements ? List.of() : new ArrayList<T>(addedElements);
        this.removedElements = null == removedElements ? List.of() : new ArrayList<T>(removedElements);
    }

    public ListChangeEvt(List<T> src, EvtType<? extends ListChangeEvt<T>> evtType, EvtPriority priority, List<T> addedElements, List<T> removedElements) {
        super((Object)src, (EvtType<? extends ChangeEvt>)evtType, priority);
        this.addedElements = null == addedElements ? List.of() : new ArrayList<T>(addedElements);
        this.removedElements = null == removedElements ? List.of() : new ArrayList<T>(removedElements);
    }

    public EvtType<? extends ListChangeEvt<T>> getEvtType() {
        return super.getEvtType();
    }

    public List<T> getAddedElements() {
        return this.addedElements;
    }

    public List<T> getRemovedElements() {
        return this.removedElements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListChangeEvt that = (ListChangeEvt)o;
        return Objects.equals(this.addedElements, that.addedElements) && Objects.equals(this.removedElements, that.removedElements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.addedElements, this.removedElements);
    }
}

