/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.geo;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum CardinalDirection {
    N("North", "N", 348.75, 11.25),
    NNE("North North-East", "NNE", 11.25, 33.75),
    NE("North-East", "NE", 33.75, 56.25),
    ENE("East North-East", "ENE", 56.25, 78.75),
    E("East", "E", 78.75, 101.25),
    ESE("East South-East", "ESE", 101.25, 123.75),
    SE("South-East", "SE", 123.75, 146.25),
    SSE("South South-East", "SSE", 146.25, 168.75),
    S("South", "S", 168.75, 191.25),
    SSW("South South-West", "SSW", 191.25, 213.75),
    SW("South-West", "SW", 213.75, 236.25),
    WSW("West South-West", "WSW", 236.25, 258.75),
    W("West", "W", 258.75, 281.25),
    WNW("West North-West", "WNW", 281.25, 303.75),
    NW("North-West", "NW", 303.75, 326.25),
    NNW("North North-West", "NNW", 326.25, 348.75),
    NOT_FOUND("", "", -1.0, -1.0);

    public String direction;
    public String shortForm;
    public double from;
    public double to;

    private CardinalDirection(String direction, String shortForm, double from, double to) {
        this.direction = direction;
        this.shortForm = shortForm;
        this.from = from;
        this.to = to;
    }

    public static final List<CardinalDirection> getValues() {
        return Arrays.stream(CardinalDirection.values()).filter(v -> v != NOT_FOUND).collect(Collectors.toList());
    }

    public static final CardinalDirection fromText(String text) {
        if (null == text || text.isEmpty()) {
            return NOT_FOUND;
        }
        switch (text) {
            case "n": 
            case "N": 
            case "north": 
            case "NORTH": 
            case "North": {
                return N;
            }
            case "nne": 
            case "NNE": 
            case "north north-east": 
            case "NORTH NORTH-EAST": 
            case "North North-East": {
                return NNE;
            }
            case "ne": 
            case "NE": 
            case "north-east": 
            case "NORTH-EAST": 
            case "North-East": {
                return NE;
            }
            case "ene": 
            case "ENE": 
            case "east north-east": 
            case "EAST NORTH-EAST": 
            case "East North-East": {
                return ENE;
            }
            case "e": 
            case "E": 
            case "east": 
            case "EAST": 
            case "East": {
                return E;
            }
            case "ese": 
            case "ESE": 
            case "east south-east": 
            case "EAST SOUTH-EAST": 
            case "East South-East": {
                return ESE;
            }
            case "se": 
            case "SE": 
            case "south-east": 
            case "SOUTH-EAST": 
            case "South-East": {
                return SE;
            }
            case "sse": 
            case "SSE": 
            case "south south-east": 
            case "SOUTH SOUTH-EAST": 
            case "South South-East": {
                return SSE;
            }
            case "s": 
            case "S": 
            case "south": 
            case "SOUTH": 
            case "South": {
                return S;
            }
            case "ssw": 
            case "SSW": 
            case "south south-west": 
            case "SOUTH SOUTH-WEST": 
            case "South South-West": {
                return SSW;
            }
            case "sw": 
            case "SW": 
            case "south-west": 
            case "SOUTH-WEST": 
            case "South-West": {
                return SW;
            }
            case "wsw": 
            case "WSW": 
            case "west south-west": 
            case "WEST SOUTH-WEST": 
            case "West South-West": {
                return WSW;
            }
            case "w": 
            case "W": 
            case "west": 
            case "WEST": 
            case "West": {
                return W;
            }
            case "wnw": 
            case "WNW": 
            case "west north-west": 
            case "WEST NORTH-WEST": 
            case "West North-West": {
                return WNW;
            }
            case "nw": 
            case "NW": 
            case "north-west": 
            case "NORTH-WEST": 
            case "North-West": {
                return NW;
            }
            case "nnw": 
            case "NNW": 
            case "north north-west": 
            case "NORTH NORTH-WEST": 
            case "North-North-West": {
                return NNW;
            }
        }
        return NOT_FOUND;
    }
}

