/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.geo;

import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.GeoLocationChangeEvt;
import eu.hansolo.toolbox.geo.CardinalDirection;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class GeoLocation {
    private String id = UUID.randomUUID().toString();
    private long timestamp;
    private String name;
    private String info;
    private double latitude;
    private double longitude;
    private double altitude;
    private double accuracy;
    private Map<EvtType, List<EvtObserver<GeoLocationChangeEvt>>> observers;

    public GeoLocation() {
        this(Instant.now().getEpochSecond(), "", "", 0.0, 0.0, 0.0, 1.0);
    }

    public GeoLocation(long timestamp, String name, String info, double latitude, double longitude, double altitude, double accuracy) {
        this.timestamp = timestamp;
        this.name = name;
        this.info = info;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.accuracy = accuracy;
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<GeoLocationChangeEvt>>>();
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        GeoLocation oldLocation = this.getCopy();
        this.timestamp = timestamp;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.TIMESTAMP_CHANGED, oldLocation, this));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        GeoLocation oldLocation = this.getCopy();
        this.name = name;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.NAME_CHANGED, oldLocation, this));
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        GeoLocation oldLocation = this.getCopy();
        this.info = info;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.INFO_CHANGED, oldLocation, this));
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        GeoLocation oldLocation = this.getCopy();
        this.latitude = latitude;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        GeoLocation oldLocation = this.getCopy();
        this.longitude = longitude;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        GeoLocation oldLocation = this.getCopy();
        this.altitude = altitude;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.ALTITUDE_CHANGED, oldLocation, this));
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        GeoLocation oldLocation = this.getCopy();
        this.accuracy = accuracy;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.ACCURACY_CHANGED, oldLocation, this));
    }

    public void set(double latitude, double longitude) {
        GeoLocation oldLocation = this.getCopy();
        this.latitude = latitude;
        this.longitude = longitude;
        this.timestamp = Instant.now().getEpochSecond();
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public void set(double latitude, double longitude, double altitude, long timestamp) {
        GeoLocation oldLocation = this.getCopy();
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.timestamp = timestamp;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public void set(double latitude, double longitude, double altitude, long timestamp, double accuracy, String info) {
        GeoLocation oldLocation = this.getCopy();
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.timestamp = timestamp;
        this.accuracy = accuracy;
        this.info = info;
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public void set(GeoLocation location) {
        GeoLocation oldLocation = this.getCopy();
        this.latitude = location.getLatitude();
        this.longitude = location.getLongitude();
        this.altitude = location.getAltitude();
        this.timestamp = location.getTimestamp();
        this.accuracy = location.getAccuracy();
        this.name = location.getName();
        this.info = location.getInfo();
        this.fireGeoLocationEvent(new GeoLocationChangeEvt(this, GeoLocationChangeEvt.LOCATION_CHANGED, oldLocation, this));
    }

    public double getDistanceTo(GeoLocation location) {
        return Helper.calcDistanceInMeter(this, location);
    }

    public double getAltitudeDistanceTo(GeoLocation location) {
        return this.altitude - location.getAltitude();
    }

    public double getBearingTo(GeoLocation location) {
        return Helper.calcBearingInDegree(this, location);
    }

    public CardinalDirection getCardinalDirectionTo(GeoLocation location) {
        return Helper.getCardinalDirectionFromBearing(Helper.calcBearingInDegree(this, location));
    }

    public boolean isWithinRangeOf(GeoLocation location, double meters) {
        return this.getDistanceTo(location) < meters;
    }

    public GeoLocation getCopy() {
        return new GeoLocation(this.timestamp, this.name, this.info, this.latitude, this.longitude, this.altitude, this.accuracy);
    }

    public void dispose() {
        this.removeAllGeoLocationObservers();
    }

    public void addGeoLocationObserver(EvtType<? extends Evt> type, EvtObserver<GeoLocationChangeEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeGeoLocationObserver(EvtType<? extends Evt> type, EvtObserver<GeoLocationChangeEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllGeoLocationObservers() {
        this.observers.clear();
    }

    public void fireGeoLocationEvent(GeoLocationChangeEvt evt) {
        EvtType<? extends GeoLocationChangeEvt> type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(GeoLocationChangeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle(evt)));
        if (this.observers.containsKey(type)) {
            this.observers.get(type).forEach(observer -> observer.handle(evt));
        }
    }

    public boolean equals(Object other) {
        if (other instanceof GeoLocation) {
            GeoLocation location = (GeoLocation)other;
            return this.id.equals(location.getId());
        }
        return false;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "{" + "\"" + "id" + "\":" + "\"" + this.id + "\"" + "," + "\"" + "timestamp" + "\":" + this.timestamp + "," + "\"" + "name" + "\":" + "\"" + this.name + "\"" + "," + "\"" + "latitude" + "\":" + this.latitude + "," + "\"" + "longitude" + "\":" + this.longitude + "," + "\"" + "altitude" + "\":" + this.altitude + "," + "\"" + "accuracy" + "\":" + this.accuracy + "," + "\"" + "info" + "\":" + "\"" + this.info + "\"" + "}";
    }
}

