/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.Property;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class ReadOnlyProperty<T> {
    protected CopyOnWriteArrayList<EvtObserver<PropertyChangeEvt<T>>> observers;
    protected Object bean;
    protected String name;
    protected T initialValue;
    protected T value;
    protected Property<T> propertyToUpdate;
    protected boolean bidirectional;

    public ReadOnlyProperty() {
        this(null, null, null, null);
    }

    public ReadOnlyProperty(T value) {
        this(null, null, value, value);
    }

    public ReadOnlyProperty(Object bean, String name, T value) {
        this(bean, name, value, value);
    }

    public ReadOnlyProperty(Object bean, String name, T value, T initialValue) {
        this.bean = bean;
        this.name = name;
        this.value = value;
        this.initialValue = initialValue;
        this.propertyToUpdate = null;
        this.bidirectional = false;
    }

    public final T getValue() {
        return this.value;
    }

    public final T getInitialValue() {
        return this.initialValue;
    }

    public final boolean isSet() {
        return Objects.equals(this.getValue(), this.getInitialValue());
    }

    protected void willChange(T oldValue, T newValue) {
    }

    protected void didChange(T oldValue, T newValue) {
    }

    protected void invalidated() {
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.name;
    }

    protected void setPropertyToUpdate(Property<T> property) {
        this.propertyToUpdate = property;
        this.bidirectional = false;
    }

    protected void unsetPropertyToUpdate() {
        this.propertyToUpdate = null;
        this.bidirectional = false;
    }

    public void addOnChange(EvtObserver<PropertyChangeEvt<T>> observer) {
        this.addObserver(observer);
    }

    public void addObserver(EvtObserver<PropertyChangeEvt<T>> observer) {
        if (null == observer) {
            return;
        }
        if (null == this.observers) {
            this.observers = new CopyOnWriteArrayList();
        }
        if (this.observers.contains(observer)) {
            return;
        }
        this.observers.add(observer);
    }

    public void removeObserver(EvtObserver<PropertyChangeEvt<T>> observer) {
        if (null == this.observers || null == observer) {
            return;
        }
        if (this.observers.contains(observer)) {
            this.observers.remove(observer);
        }
    }

    public void removeAllObservers() {
        if (null == this.observers) {
            return;
        }
        this.observers.clear();
    }

    public void fireEvent(PropertyChangeEvt<T> evt) {
        if (null == this.observers || null == evt) {
            return;
        }
        this.observers.forEach((Consumer<EvtObserver<PropertyChangeEvt<T>>>)((Consumer<EvtObserver>)observer -> observer.handle(evt)));
    }
}

