/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public enum DateTimes {
    yyyy_MM_dd_HH_mm_ss_SSSS("yyyy-MM-dd HH:mm:ss.SSSS"),
    yyyy_MM_dd_HH_mm_ss("yyyy-MM-dd HH:mm:ss"),
    yyyy_MM_dd_HH_mm("yyyy-MM-dd HH:mm"),
    yyyy_MM_dd_HH("yyyy-MM-dd HH"),
    MM_dd_HH_mm_ss_SSSS("MM-dd HH:mm:ss.SSSS"),
    MM_dd_HH_mm_ss("MM-dd HH:mm:ss"),
    MM_dd_HH_mm("MM-dd HH:mm"),
    MM_dd_HH("MM-dd HH"),
    yyyyMMdd_HHmmss_SSSS("yyyyMMdd HHmmss.SSSS"),
    yyyyMMdd_HHmmss("yyyyMMdd HHmmss"),
    yyyyMMdd_HHmm("yyyyMMdd HHmm"),
    MMdd_HHmmss_SSSS("MMdd HHmmss.SSSS"),
    MMdd_HHmmss("MMdd HHmmss"),
    MMdd_HHmm("MMdd HHmm"),
    MMdd_HH("MMdd HH"),
    dd_MM_yyyy_HH_mm_ss_SSSS("dd-MM-yyyy HH:mm:ss.SSSS"),
    dd_MM_yyyy_HH_mm_ss("dd-MM-yyyy HH:mm:ss"),
    dd_MM_yyyy_HH_mm("dd-MM-yyyy HH:mm"),
    dd_MM_yyyy_HH("dd-MM-yyyy HH"),
    dd_MM_HH_mm_ss_SSSS("dd-MM HH:mm:ss.SSSS"),
    dd_MM_HH_mm_ss("dd-MM HH:mm:ss"),
    dd_MM_HH_mm("dd-MM HH:mm"),
    dd_MM_HH("dd-MM HH"),
    MM_dd_yyyy_HH_mm_ss_SSSS("MM-dd-yyyy HH:mm:ss.SSSS"),
    MM_dd_yyyy_HH_mm_ss("MM-dd-yyyy HH:mm:ss"),
    MM_dd_yyyy_HH_mm("MM-dd-yyyy HH:mm"),
    MM_dd_yyyy_HH("MM-dd-yyyy HH"),
    MMM_dd_yyyy_HH_mm_ss_SSSS("MMM dd, yyyy HH:mm:ss.SSSS"),
    MMM_dd_yyyy_HH_mm_ss("MMM dd, yyyy HH:mm:ss"),
    MMM_dd_yyyy_HH_mm("MMM dd, yyyy HH:mm"),
    MMM_dd_yyyy_HH("MMM dd, yyyy HH"),
    MMM_dd_HH_mm_ss_SSSS("MMM dd HH:mm:ss.SSSS"),
    MMM_dd_HH_mm_ss("MMM dd HH:mm:ss"),
    MMM_dd_HH_mm("MMM dd HH:mm"),
    MMM_dd_HH("MMM dd HH"),
    dd_MMMM_yyyy_HH_mm_ss_SSSS("dd MMMM yyyy HH:mm:ss.SSSS"),
    dd_MMMM_yyyy_HH_mm_ss("dd MMMM yyyy HH:mm:ss"),
    dd_MMMM_yyyy_HH_mm("dd MMMM yyyy HH:mm"),
    dd_MMMM_yyyy_HH("dd MMMM yyyy HH"),
    dd_MMMM_HH_mm_ss_SSSS("dd MMMM HH:mm:ss.SSSS"),
    dd_MMMM_HH_mm_ss("dd MMMM HH:mm:ss"),
    dd_MMMM_HH_mm("dd MMMM HH:mm"),
    dd_MMMM_HH("dd MMMM HH");

    private final DateTimeFormatter formatter;

    private DateTimes(String formatString) {
        this.formatter = DateTimeFormatter.ofPattern(formatString);
    }

    public String format(ZonedDateTime dateTime) {
        return this.formatter.format(dateTime);
    }

    public String format(ZonedDateTime zonedDateTime, ZoneId zoneId) {
        return this.format(zonedDateTime.toLocalDateTime(), zoneId);
    }

    public String format(LocalDateTime dateTime) {
        return this.format(dateTime, ZoneId.systemDefault());
    }

    public String format(LocalDateTime dateTime, ZoneId zoneId) {
        return this.format(ZonedDateTime.of(dateTime.toLocalDate(), dateTime.toLocalTime(), zoneId));
    }

    public static long toEpoch(ZonedDateTime zonedDateTime) {
        return DateTimes.toEpoch(zonedDateTime.toLocalDateTime());
    }

    public static long toEpoch(ZonedDateTime zonedDateTime, ZoneId zoneId) {
        return DateTimes.toEpoch(zonedDateTime.toLocalDateTime(), zoneId);
    }

    public static long toEpoch(LocalDateTime dateTime) {
        return DateTimes.toEpoch(dateTime, ZoneId.systemDefault());
    }

    public static long toEpoch(LocalDateTime dateTime, ZoneId zoneId) {
        return ZonedDateTime.of(dateTime, zoneId).toInstant().getEpochSecond();
    }

    public static ZonedDateTime fromEpoch(long epoch) {
        return DateTimes.fromEpoch(epoch, ZoneId.systemDefault());
    }

    public static ZonedDateTime fromEpoch(long epoch, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epoch), zoneId);
    }
}

