/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.time;

import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public enum Times {
    HH_mm_ss_SSSS("HH:mm:ss.SSSS"),
    HH_mm_ss("HH:mm:ss"),
    HH_mm("HH:mm"),
    HHmmss_SSSS("HHmmss.SSSS"),
    HHmmss("HHmmss"),
    HHmm("HHmm"),
    HH("HH");

    private final DateTimeFormatter formatter;

    private Times(String formatString) {
        this.formatter = DateTimeFormatter.ofPattern(formatString);
    }

    public LocalTime parse(String text) {
        return LocalTime.parse(text, this.formatter);
    }

    public Instant parseTime(String text) {
        return this.parseTime(text, ZoneId.systemDefault());
    }

    public Instant parseTime(String text, ZoneId zoneId) {
        return Instant.parse(text).atZone(zoneId).toInstant();
    }

    public String format(LocalTime time) {
        return this.formatter.format(time);
    }

    public String format(Instant time) {
        return this.format(time, ZoneId.systemDefault());
    }

    public String format(Instant time, ZoneId zoneId) {
        return this.format(time.atZone(zoneId).toLocalTime());
    }
}

