/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.flag.Flag;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.Cities;
import eu.hansolo.fx.countries.tools.CountryPath;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.fx.countries.tools.Records;
import eu.hansolo.toolboxfx.ValueObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;

public class CountryObj {
    private Country country;
    private ValueObject valueObject;
    private double value;
    private Color fill;
    private Color stroke;

    public CountryObj(Country country) {
        this.country = country;
        this.valueObject = null;
        this.value = 0.0;
        this.fill = null;
        this.stroke = null;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getName() {
        return this.country.name();
    }

    public String getIso2() {
        return this.country.name();
    }

    public ValueObject getValueObject() {
        return this.valueObject;
    }

    public void setValueObject(ValueObject valueObject) {
        this.valueObject = valueObject;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Color getFill() {
        return this.fill;
    }

    public void setFill(Color fill) {
        this.fill = fill;
    }

    public Color getStroke() {
        return this.stroke;
    }

    public void setStroke(Color stroke) {
        this.stroke = stroke;
    }

    public String getDisplayName() {
        return this.country.getDisplayName();
    }

    public CLocation getLocation() {
        return this.country.getLocation();
    }

    public Flag getFlag() {
        return Flag.getAsList().parallelStream().filter(flag -> flag.getIso2().equals(this.country.name())).findFirst().orElse(Flag.NOT_FOUND);
    }

    public Optional<Records.City> getCapital() {
        return Cities.INSTANCE.capitals().parallelStream().filter(city -> city.country() == this.country).findFirst();
    }

    public List<Records.City> getCities() {
        return Helper.getCities().stream().filter(city -> city.country() == this.country).collect(Collectors.toList());
    }

    public List<Records.Airport> getAirports() {
        return Helper.getAirports().entrySet().stream().filter(entry -> ((Records.Airport)entry.getValue()).country() == this.country).map(entry -> (Records.Airport)entry.getValue()).collect(Collectors.toList());
    }

    public List<Records.Airport2> getAirports2() {
        return Helper.getAirports2().entrySet().stream().filter(entry -> ((Records.Airport2)entry.getValue()).country() == this.country).map(entry -> (Records.Airport2)entry.getValue()).collect(Collectors.toList());
    }

    public List<CountryPath> getPaths() {
        CountryObj countryObj = this;
        return countryObj.country.getCountryPaths().get((Object)this.country);
    }

    public List<CountryPath> getCopyOfPaths() {
        CountryObj countryObj = this;
        return countryObj.country.getCopyOfCountryPaths().get((Object)this.country);
    }
}

