/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.WorldPane;
import eu.hansolo.fx.countries.WorldPaneBuilder;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.CLocationBuilder;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.countries.tools.ConnectionBuilder;
import eu.hansolo.fx.countries.tools.ConnectionPartType;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.fx.countries.tools.Records;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.PoiBuilder;
import eu.hansolo.toolboxfx.geom.PoiSize;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class DemoWorldPane
extends Application {
    private WorldPane worldPane;

    public void init() {
        List<Poi> capitals = Helper.getCapitals().stream().map(city -> PoiBuilder.create().lat(city.lat()).lon(city.lon()).name(city.name()).fill(Color.CYAN).pointSize(PoiSize.NORMAL).build()).collect(Collectors.toList());
        Map<String, Records.Airport> airports = Helper.getAirports();
        CLocation fmo = ((CLocationBuilder)airports.get("FMO").toLocationBuilder().connectionPartType(ConnectionPartType.SOURCE)).build();
        CLocation sin = ((CLocationBuilder)airports.get("SIN").toLocationBuilder().connectionPartType(ConnectionPartType.TARGET)).build();
        CLocation jfk = ((CLocationBuilder)airports.get("JFK").toLocationBuilder().connectionPartType(ConnectionPartType.SOURCE)).build();
        CLocation hnd = ((CLocationBuilder)airports.get("HND").toLocationBuilder().connectionPartType(ConnectionPartType.TARGET)).build();
        CLocation syd = ((CLocationBuilder)airports.get("SYD").toLocationBuilder().connectionPartType(ConnectionPartType.SOURCE)).build();
        CLocation sfo = ((CLocationBuilder)airports.get("SFO").toLocationBuilder().connectionPartType(ConnectionPartType.TARGET)).build();
        Connection fmoToSin = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(fmo, sin).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.CYAN)).build();
        Connection jfkToHnd = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(jfk, hnd).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.MAGENTA)).build();
        Connection sydToSfo = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(syd, sfo).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.YELLOW)).build();
        Map<String, Records.Airport2> airports2 = Helper.getAirports2();
        Records.Airport2 fmo2 = airports2.get("FMO");
        System.out.println(fmo2.name() + "   " + fmo2.iata() + "   " + fmo2.icao());
        ArrayList<Point> heatmapSpots = new ArrayList<Point>();
        Helper.getCities().stream().filter(city -> city.population() > 1000000L).forEach(city -> heatmapSpots.add(new Point(city.lon(), city.lat())));
        this.worldPane = ((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)((WorldPaneBuilder)WorldPaneBuilder.create().poisVisible(true)).poiTextVisible(true)).heatmapVisible(true)).heatmapSpotRadius(3.0)).heatmapOpacityDistribution(OpacityDistribution.LINEAR)).heatmapSpots(heatmapSpots)).pois(capitals)).connections(List.of(fmoToSin, jfkToHnd, sydToSfo))).overlayVisible(true)).hoverEnabled(true)).selectionEnabled(true)).build();
        this.worldPane.selectedCountryProperty().addListener((o, ov, nv) -> System.out.println(nv));
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.worldPane});
        pane.setPrefSize(800.0, 400.0);
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("WorldPane:");
        stage.setScene(scene);
        stage.show();
        stage.centerOnScreen();
    }

    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    public static void main(String[] args) {
        DemoWorldPane.launch((String[])args);
    }
}

