/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.heatmap;

import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.HeatMap;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;

public class HeatMapBuilder<B extends HeatMapBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();

    protected HeatMapBuilder() {
    }

    public static final HeatMapBuilder create() {
        return new HeatMapBuilder();
    }

    public final B prefSize(double width, double height) {
        return this.prefSize(new Dimension2D(width, height));
    }

    public final B prefSize(Dimension2D prefSize) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)prefSize));
        return (B)this;
    }

    public final B width(double width) {
        this.properties.put("width", (Property)new SimpleDoubleProperty(width));
        return (B)this;
    }

    public final B height(double height) {
        this.properties.put("height", (Property)new SimpleDoubleProperty(height));
        return (B)this;
    }

    public final B colorMapping(Mapping colorMapping) {
        this.properties.put("colorMapping", (Property)new SimpleObjectProperty((Object)colorMapping));
        return (B)this;
    }

    public final B spotRadius(double spotRadius) {
        this.properties.put("spotRadius", (Property)new SimpleDoubleProperty(spotRadius));
        return (B)this;
    }

    public final B fadeColors(boolean fadeColors) {
        this.properties.put("fadeColors", (Property)new SimpleBooleanProperty(fadeColors));
        return (B)this;
    }

    public final B heatMapOpacity(double heatMapOpacity) {
        this.properties.put("heatMapOpacity", (Property)new SimpleDoubleProperty(heatMapOpacity));
        return (B)this;
    }

    public final B opacityDistribution(OpacityDistribution opacityDistribution) {
        this.properties.put("opacityDistribution", (Property)new SimpleObjectProperty((Object)opacityDistribution));
        return (B)this;
    }

    public final HeatMap build() {
        double width = 400.0;
        double height = 400.0;
        Mapping colorMapping = ColorMapping.LIME_YELLOW_RED;
        double spotRadius = 15.5;
        boolean fadeColors = false;
        double heatMapOpacity = 0.5;
        OpacityDistribution opacityDistribution = OpacityDistribution.CUSTOM;
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            switch (entry.getKey()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)entry.getValue()).get();
                    width = dim.getWidth();
                    height = dim.getHeight();
                    break;
                }
                case "width": {
                    width = ((DoubleProperty)entry.getValue()).get();
                    break;
                }
                case "height": {
                    height = ((DoubleProperty)entry.getValue()).get();
                    break;
                }
                case "colorMapping": {
                    colorMapping = (Mapping)((ObjectProperty)entry.getValue()).get();
                    break;
                }
                case "spotRadius": {
                    spotRadius = ((DoubleProperty)entry.getValue()).get();
                    break;
                }
                case "fadeColors": {
                    fadeColors = ((BooleanProperty)entry.getValue()).get();
                    break;
                }
                case "heatMapOpacity": {
                    heatMapOpacity = ((DoubleProperty)entry.getValue()).get();
                    break;
                }
                case "opacityDistribution": {
                    opacityDistribution = (OpacityDistribution)((Object)((ObjectProperty)entry.getValue()).get());
                }
            }
        }
        return new HeatMap(width, height, colorMapping, spotRadius, fadeColors, heatMapOpacity, opacityDistribution);
    }
}

