/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.Bitness;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Architecture implements Api
{
    AARCH64("AARCH64", "aarch64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM64);
        }
    }
    ,
    AARCH32("AARCH32", "aarch32", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM, ARM32);
        }
    }
    ,
    ARM("ARM", "arm", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM32, AARCH32);
        }
    }
    ,
    ARM32("ARM32", "arm32", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(ARM, AARCH32);
        }
    }
    ,
    ARMHF("ARMHF", "armhf", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    ARMEL("ARMEL", "armel", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    ARM64("ARM64", "arm64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(AARCH64);
        }
    }
    ,
    MIPS("MIPS", "mips", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    MIPSEL("MIPS EL", "mipsel", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    PPC("Power PC", "ppc", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    PPC64("PPC64", "ppc64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    PPC64LE("PPC64LE", "ppc64le", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    RISCV64("RISCv64", "riscv64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    S390X("S390X", "s390x", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    SPARC("Sparc", "sparc", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    SPARCV9("Sparc V9", "sparcv9", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    X64("X64", "x64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(AMD64, X86_64);
        }
    }
    ,
    X32("X32", "x32", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, I386, I586, I686);
        }
    }
    ,
    I386("I386", "i386", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, X32, I586, I686);
        }
    }
    ,
    I586("I586", "i386", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, X32, I386, I686);
        }
    }
    ,
    I686("I686", "i386", Bitness.BIT_32, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X86, X32, I386, I686);
        }
    }
    ,
    X86("X86", "x86", Bitness.BIT_32, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X32, I386, I586, I686);
        }
    }
    ,
    X86_64("X86_64", "x86_64", Bitness.BIT_64, false){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X64, AMD64);
        }
    }
    ,
    AMD64("AMD64", "amd64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of(X64, X86_64);
        }
    }
    ,
    IA64("IA-64", "ia64", Bitness.BIT_64, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    NONE("-", "", Bitness.NONE, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    }
    ,
    NOT_FOUND("", "", Bitness.NOT_FOUND, true){

        @Override
        public List<Architecture> getSynonyms() {
            return List.of();
        }
    };

    private final String uiString;
    private final String apiString;
    private final Bitness bitness;
    private final boolean standard;

    private Architecture(String uiString, String apiString, Bitness bitness, boolean standard) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.bitness = bitness;
        this.standard = standard;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Architecture getDefault() {
        return NONE;
    }

    @Override
    public Architecture getNotFound() {
        return NOT_FOUND;
    }

    public Architecture[] getAll() {
        return (Architecture[])Arrays.stream(Architecture.values()).filter(Architecture::isStandard).toArray(Architecture[]::new);
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",\n").append("  \"").append("bitness").append("\"").append(":").append("\"").append(this.bitness.getApiString()).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",").append("\"").append("bitness").append("\"").append(":").append("\"").append(this.bitness.getApiString()).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static Architecture fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        return switch (text) {
            case "aarch64", "AARCH64" -> AARCH64;
            case "amd64", "AMD64", "_amd64" -> AMD64;
            case "aarch32", "AARCH32", "arm32", "ARM32", "armv6", "ARMV6", "armv7l", "ARMV7L", "armv7", "ARMV7", "arm", "ARM" -> ARM;
            case "armel", "ARMEL" -> ARMEL;
            case "armhf", "ARMHF" -> ARMHF;
            case "arm64", "ARM64", "armv8", "ARMV8" -> ARM64;
            case "mips", "MIPS" -> MIPS;
            case "mipsel", "MIPSEL" -> MIPSEL;
            case "ppc", "PPC" -> PPC;
            case "ppc64el", "PPC64EL", "ppc64le", "PPC64LE" -> PPC64LE;
            case "ppc64", "PPC64" -> PPC64;
            case "riscv64", "RISCV64", "risc-v", "RISC-V", "riscv", "RISCV" -> RISCV64;
            case "s390", "s390x", "S390X" -> S390X;
            case "sparc", "SPARC" -> SPARC;
            case "sparcv9", "SPARCV9" -> SPARCV9;
            case "x64", "X64", "x86-64", "X86-64", "x86_64", "X86_64", "x86lx64", "X86LX64" -> X64;
            case "x32", "x86", "X86", "286", "386", "486", "586", "686", "i386", "i486", "i586", "i686", "x86-32", "x86lx32", "X86LX32" -> X86;
            case "ia64", "IA64", "ia-64", "IA-64" -> IA64;
            default -> NOT_FOUND;
        };
    }

    public Bitness getBitness() {
        return this.bitness;
    }

    public boolean isStandard() {
        return this.standard;
    }

    public static List<Architecture> getAsList() {
        return Arrays.asList(Architecture.values());
    }

    public static List<String> getAcronyms(Architecture architecture) {
        switch (architecture.ordinal()) {
            case 0: {
                return List.of("aarch64", "AARCH64");
            }
            case 23: {
                return List.of("amd64", "AMD64");
            }
            case 2: {
                return List.of("aarch32", "AARCH32", "arm32", "ARM32", "armv6", "ARMV6", "armv7l", "ARMV7L", "armv7", "ARMV7", "arm", "ARM");
            }
            case 5: {
                return List.of("armel", "ARMEL");
            }
            case 4: {
                return List.of("armhf", "ARMHF");
            }
            case 6: {
                return List.of("arm64", "ARM64", "armv8", "ARMV8");
            }
            case 7: {
                return List.of("mips", "MIPS");
            }
            case 8: {
                return List.of("mipsel", "MIPSEL");
            }
            case 9: {
                return List.of("ppc", "PPC");
            }
            case 11: {
                return List.of("ppc64el", "PPC64EL", "ppc64le", "PPC64LE");
            }
            case 10: {
                return List.of("ppc64", "PPC64");
            }
            case 12: {
                return List.of("riscv64", "RISCV64", "risc-v", "RISC-V", "riscv", "RISCV", "risc_v", "RISC_V");
            }
            case 13: {
                return List.of("s390", "s390x", "S390X");
            }
            case 14: {
                return List.of("sparc", "SPARC");
            }
            case 15: {
                return List.of("sparcv9", "SPARCV9");
            }
            case 16: {
                return List.of("x64", "X64", "x86-64", "X86-64", "x86_64", "X86_64", "x86lx64", "X86LX64");
            }
            case 21: {
                return List.of("x32", "x86", "X86", "286", "386", "486", "586", "686", "i386", "i486", "i586", "i686", "x86-32", "x86lx32", "X86LX32");
            }
            case 24: {
                return List.of("ia64", "IA64", "ia-64", "IA-64", "ia_64", "IA_64");
            }
        }
        return new ArrayList<String>();
    }

    public abstract List<Architecture> getSynonyms();
}

