/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum ReleaseStatus implements Api
{
    GA("General Access", "ga", ""),
    EA("Early Access", "ea", "-ea"),
    NONE("-", "", ""),
    NOT_FOUND("", "", "");

    private final String uiString;
    private final String apiString;
    private final String preReleaseId;

    private ReleaseStatus(String uiString, String apiString, String preReleaseId) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.preReleaseId = preReleaseId;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public ReleaseStatus getDefault() {
        return NONE;
    }

    @Override
    public ReleaseStatus getNotFound() {
        return NOT_FOUND;
    }

    public ReleaseStatus[] getAll() {
        return ReleaseStatus.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public String getPreReleaseId() {
        return this.preReleaseId;
    }

    public static ReleaseStatus fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        return switch (text) {
            case "-ea", "-EA", "_ea", "_EA", "ea", "EA", "ea_", "EA_" -> EA;
            case "-ga", "-GA", "_ga", "_GA", "ga", "GA", "ga_", "GA_" -> GA;
            default -> NOT_FOUND;
        };
    }

    public static List<ReleaseStatus> getAsList() {
        return Arrays.asList(ReleaseStatus.values());
    }
}

