/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum TermOfSupport implements Api
{
    STS("short term stable", "sts"),
    MTS("mid term stable", "mts"),
    LTS("long term stable", "lts"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private TermOfSupport(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public TermOfSupport getDefault() {
        return NONE;
    }

    @Override
    public TermOfSupport getNotFound() {
        return NOT_FOUND;
    }

    public TermOfSupport[] getAll() {
        return TermOfSupport.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static TermOfSupport fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        return switch (text) {
            case "long_term_stable", "LongTermStable", "lts", "LTS", "Lts" -> LTS;
            case "mid_term_stable", "MidTermStable", "mts", "MTS", "Mts" -> MTS;
            case "short_term_stable", "ShortTermStable", "sts", "STS", "Sts" -> STS;
            default -> NOT_FOUND;
        };
    }

    public static List<TermOfSupport> getAsList() {
        return Arrays.asList(TermOfSupport.values());
    }
}

