/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.CVSS;
import eu.hansolo.jdktools.SeverityName;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum Severity implements Api
{
    LOW(SeverityName.LOW.name(), SeverityName.LOW.name().toLowerCase(Locale.ENGLISH), 0.0, 3.9, 0.1, 3.9, 0.1, 3.9, 2),
    MEDIUM(SeverityName.MEDIUM.name(), SeverityName.MEDIUM.name().toLowerCase(Locale.ENGLISH), 4.0, 6.9, 4.0, 6.9, 4.0, 6.9, 3),
    HIGH(SeverityName.HIGH.name(), SeverityName.HIGH.name().toLowerCase(Locale.ENGLISH), 7.0, 10.0, 7.0, 8.9, 7.0, 8.9, 4),
    CRITICAL(SeverityName.CRITICAL.name(), SeverityName.CRITICAL.name().toLowerCase(Locale.ENGLISH), 10.0, 10.0, 9.0, 10.0, 9.0, 10.0, 5),
    NONE("-", "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1),
    NOT_FOUND("", "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0);

    private final String uiString;
    private final String apiString;
    private final double minScoreV2;
    private final double maxScoreV2;
    private final double minScoreV3;
    private final double maxScoreV3;
    private final double minScoreV4;
    private final double maxScoreV4;
    private final Integer order;

    private Severity(String uiString, String apiString, double minScoreV2, double maxScoreV2, double minScoreV3, double maxScoreV3, double minScoreV4, double maxScoreV4, Integer order) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.minScoreV2 = minScoreV2;
        this.maxScoreV2 = maxScoreV2;
        this.minScoreV3 = minScoreV3;
        this.maxScoreV3 = maxScoreV3;
        this.minScoreV4 = minScoreV4;
        this.maxScoreV4 = maxScoreV4;
        this.order = order;
    }

    public double getMinScoreV2() {
        return this.minScoreV2;
    }

    public double getMaxScoreV2() {
        return this.maxScoreV2;
    }

    public double getMinScoreV3() {
        return this.minScoreV3;
    }

    public double getMaxScoreV3() {
        return this.maxScoreV3;
    }

    public double getMinScoreV4() {
        return this.minScoreV4;
    }

    public double getMaxScoreV4() {
        return this.maxScoreV4;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Severity getDefault() {
        return NONE;
    }

    @Override
    public Severity getNotFound() {
        return NOT_FOUND;
    }

    public Severity[] getAll() {
        return Severity.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static Severity fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "low": 
            case "LOW": 
            case "Low": {
                return LOW;
            }
            case "medium": 
            case "MEDIUM": 
            case "Medium": {
                return MEDIUM;
            }
            case "high": 
            case "HIGH": 
            case "High": {
                return HIGH;
            }
            case "critical": 
            case "CRITICAL": 
            case "Critical": {
                return CRITICAL;
            }
        }
        return NOT_FOUND;
    }

    public static Severity fromScore(double score, CVSS cvss) {
        switch (cvss) {
            case CVSSV2: {
                if (score >= 0.0 && score <= 3.9) {
                    return LOW;
                }
                if (score > 3.9 && score <= 6.9) {
                    return MEDIUM;
                }
                if (score > 6.9 && score <= 10.0) {
                    return HIGH;
                }
                return NOT_FOUND;
            }
            case CVSSV3: 
            case CVSSV4: {
                if (score <= 0.0) {
                    return NONE;
                }
                if (score > 0.0 && score <= 3.9) {
                    return LOW;
                }
                if (score > 3.9 && score <= 6.9) {
                    return MEDIUM;
                }
                if (score > 6.9 && score < 8.9) {
                    return HIGH;
                }
                if (score > 8.9 && score <= 10.0) {
                    return CRITICAL;
                }
                return NOT_FOUND;
            }
        }
        return NOT_FOUND;
    }

    public static List<Severity> getAsList() {
        return Arrays.asList(Severity.values());
    }

    public int compareToSeverity(Severity other) {
        return this.order.compareTo(other.order);
    }
}

