/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Tile tile;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        Image image = new Image("file:///Users/hansolo/Pictures/Avatar5.fw.png");
        this.tile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.IMAGE)).prefSize(400.0, 400.0)).title("ImageTile")).textVisible(true)).text("Gerrit Grunwald")).image(image)).imageMask(Tile.ImageMask.RECTANGULAR)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 2000000000L) {
                    double value = RND.nextDouble() * 100.0;
                    Test.this.tile.setValue(value);
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        HBox pane = new HBox(10.0, new Node[]{this.tile});
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("ImageTileSkin");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
        System.exit(0);
    }

    private void setData() {
        long start = System.currentTimeMillis();
        System.out.println(System.currentTimeMillis() - start + " ms");
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

