/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Alarm;
import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.TimeSection;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.RadarChart;
import eu.hansolo.tilesfx.chart.SunburstChart;
import eu.hansolo.tilesfx.chart.TilesFXSeries;
import eu.hansolo.tilesfx.events.AlarmEvent;
import eu.hansolo.tilesfx.events.AlarmEventListener;
import eu.hansolo.tilesfx.events.SwitchEvent;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.events.TileEventListener;
import eu.hansolo.tilesfx.events.TimeEvent;
import eu.hansolo.tilesfx.events.TimeEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.BarChartItem;
import eu.hansolo.tilesfx.skins.BarChartTileSkin;
import eu.hansolo.tilesfx.skins.BarGaugeTileSkin;
import eu.hansolo.tilesfx.skins.CalendarTileSkin;
import eu.hansolo.tilesfx.skins.CharacterTileSkin;
import eu.hansolo.tilesfx.skins.CircularProgressTileSkin;
import eu.hansolo.tilesfx.skins.ClockTileSkin;
import eu.hansolo.tilesfx.skins.CountryTileSkin;
import eu.hansolo.tilesfx.skins.CustomTileSkin;
import eu.hansolo.tilesfx.skins.DateTileSkin;
import eu.hansolo.tilesfx.skins.DonutChartTileSkin;
import eu.hansolo.tilesfx.skins.EphemerisTileSkin;
import eu.hansolo.tilesfx.skins.FlipTileSkin;
import eu.hansolo.tilesfx.skins.GaugeSparkLineTileSkin;
import eu.hansolo.tilesfx.skins.GaugeTileSkin;
import eu.hansolo.tilesfx.skins.HighLowTileSkin;
import eu.hansolo.tilesfx.skins.ImageTileSkin;
import eu.hansolo.tilesfx.skins.LeaderBoardItem;
import eu.hansolo.tilesfx.skins.LeaderBoardTileSkin;
import eu.hansolo.tilesfx.skins.MapTileSkin;
import eu.hansolo.tilesfx.skins.MatrixTileSkin;
import eu.hansolo.tilesfx.skins.NumberTileSkin;
import eu.hansolo.tilesfx.skins.PercentageTileSkin;
import eu.hansolo.tilesfx.skins.PlusMinusTileSkin;
import eu.hansolo.tilesfx.skins.RadarChartTileSkin;
import eu.hansolo.tilesfx.skins.RadialChartTileSkin;
import eu.hansolo.tilesfx.skins.RadialPercentageTileSkin;
import eu.hansolo.tilesfx.skins.SliderTileSkin;
import eu.hansolo.tilesfx.skins.SmoothAreaChartTileSkin;
import eu.hansolo.tilesfx.skins.SmoothedChartTileSkin;
import eu.hansolo.tilesfx.skins.SparkLineTileSkin;
import eu.hansolo.tilesfx.skins.StatusTileSkin;
import eu.hansolo.tilesfx.skins.StockTileSkin;
import eu.hansolo.tilesfx.skins.SunburstChartTileSkin;
import eu.hansolo.tilesfx.skins.SwitchSliderTileSkin;
import eu.hansolo.tilesfx.skins.SwitchTileSkin;
import eu.hansolo.tilesfx.skins.TextTileSkin;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.skins.TimeTileSkin;
import eu.hansolo.tilesfx.skins.TimerControlTileSkin;
import eu.hansolo.tilesfx.skins.WeatherTileSkin;
import eu.hansolo.tilesfx.skins.WorldMapTileSkin;
import eu.hansolo.tilesfx.tools.Country;
import eu.hansolo.tilesfx.tools.CountryGroup;
import eu.hansolo.tilesfx.tools.CountryPath;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Location;
import eu.hansolo.tilesfx.tools.MovingAverage;
import eu.hansolo.tilesfx.tools.SectionComparator;
import eu.hansolo.tilesfx.tools.TimeData;
import eu.hansolo.tilesfx.tools.TimeSectionComparator;
import eu.hansolo.tilesfx.weather.DarkSky;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.LongProperty;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class Tile
extends Control {
    public static final Color BACKGROUND = Color.rgb((int)42, (int)42, (int)42);
    public static final Color FOREGROUND = Color.rgb((int)223, (int)223, (int)223);
    public static final Color GRAY = TileColor.GRAY.color;
    public static final Color RED = TileColor.RED.color;
    public static final Color LIGHT_RED = TileColor.LIGHT_RED.color;
    public static final Color GREEN = TileColor.GREEN.color;
    public static final Color LIGHT_GREEN = TileColor.LIGHT_GREEN.color;
    public static final Color BLUE = TileColor.BLUE.color;
    public static final Color DARK_BLUE = TileColor.DARK_BLUE.color;
    public static final Color ORANGE = TileColor.ORANGE.color;
    public static final Color YELLOW_ORANGE = TileColor.YELLOW_ORANGE.color;
    public static final Color YELLOW = TileColor.YELLOW.color;
    public static final Color MAGENTA = TileColor.MAGENTA.color;
    public static final Color PINK = TileColor.PINK.color;
    public static final int SHORT_INTERVAL = 20;
    public static final int LONG_INTERVAL = 1000;
    private static final int MAX_NO_OF_DECIMALS = 3;
    private final TileEvent SHOW_NOTIFY_REGION_EVENT = new TileEvent(TileEvent.EventType.SHOW_NOTIFY_REGION);
    private final TileEvent HIDE_NOTIFY_REGION_EVENT = new TileEvent(TileEvent.EventType.HIDE_NOTIFY_REGION);
    private final TileEvent SHOW_INFO_REGION_EVENT = new TileEvent(TileEvent.EventType.SHOW_INFO_REGION);
    private final TileEvent HIDE_INFO_REGION_EVENT = new TileEvent(TileEvent.EventType.HIDE_INFO_REGION);
    private final TileEvent EXCEEDED_EVENT = new TileEvent(TileEvent.EventType.THRESHOLD_EXCEEDED);
    private final TileEvent UNDERRUN_EVENT = new TileEvent(TileEvent.EventType.THRESHOLD_UNDERRUN);
    private final TileEvent MAX_VALUE_EXCEEDED = new TileEvent(TileEvent.EventType.MAX_VALUE_EXCEEDED);
    private final TileEvent MIN_VALUE_UNDERRUN = new TileEvent(TileEvent.EventType.MIN_VALUE_UNDERRUN);
    private final TileEvent VALUE_IN_RANGE = new TileEvent(TileEvent.EventType.VALUE_IN_RANGE);
    private final TileEvent RECALC_EVENT = new TileEvent(TileEvent.EventType.RECALC);
    private final TileEvent REDRAW_EVENT = new TileEvent(TileEvent.EventType.REDRAW);
    private final TileEvent RESIZE_EVENT = new TileEvent(TileEvent.EventType.RESIZE);
    private final TileEvent VISIBILITY_EVENT = new TileEvent(TileEvent.EventType.VISIBILITY);
    private final TileEvent SECTION_EVENT = new TileEvent(TileEvent.EventType.SECTION);
    private final TileEvent SERIES_EVENT = new TileEvent(TileEvent.EventType.SERIES);
    private final TileEvent DATA_EVENT = new TileEvent(TileEvent.EventType.DATA);
    private final TileEvent ALERT_EVENT = new TileEvent(TileEvent.EventType.ALERT);
    private final TileEvent VALUE_EVENT = new TileEvent(TileEvent.EventType.VALUE);
    private final TileEvent FINISHED_EVENT = new TileEvent(TileEvent.EventType.FINISHED);
    private final TileEvent GRAPHIC_EVENT = new TileEvent(TileEvent.EventType.GRAPHIC);
    private final TileEvent AVERAGING_EVENT = new TileEvent(TileEvent.EventType.AVERAGING);
    private final TileEvent LOCATION_EVENT = new TileEvent(TileEvent.EventType.LOCATION);
    private final TileEvent TRACK_EVENT = new TileEvent(TileEvent.EventType.TRACK);
    private final TileEvent MAP_PROVIDER_EVENT = new TileEvent(TileEvent.EventType.MAP_PROVIDER);
    private final TileEvent FLIP_START_EVENT = new TileEvent(TileEvent.EventType.FLIP_START);
    private final TileEvent BKG_IMAGE_EVENT = new TileEvent(TileEvent.EventType.BACKGROUND_IMAGE);
    private final TileEvent REGIONS_ON_TOP_EVENT = new TileEvent(TileEvent.EventType.REGIONS_ON_TOP);
    private final TileEvent INFO_REGION_HANDLER_EVENT = new TileEvent(TileEvent.EventType.INFO_REGION_HANDLER);
    private Queue<TileEvent> tileEventQueue = new LinkedBlockingQueue<TileEvent>();
    private List<TileEventListener> tileEventListeners = new CopyOnWriteArrayList<TileEventListener>();
    private List<AlarmEventListener> alarmEventListeners = new CopyOnWriteArrayList<AlarmEventListener>();
    private List<TimeEventListener> timeEventListeners = new CopyOnWriteArrayList<TimeEventListener>();
    private BooleanBinding showing;
    private DoubleProperty value;
    private DoubleProperty oldValue;
    private DoubleProperty currentValue;
    private DoubleProperty formerValue;
    private double _minValue;
    private DoubleProperty minValue;
    private double _maxValue;
    private DoubleProperty maxValue;
    private double _range;
    private DoubleProperty range;
    private double _threshold;
    private DoubleProperty threshold;
    private double _referenceValue;
    private DoubleProperty referenceValue;
    private boolean _autoReferenceValue;
    private BooleanProperty autoReferenceValue;
    private String _title;
    private StringProperty title;
    private TextAlignment _titleAlignment;
    private ObjectProperty<TextAlignment> titleAlignment;
    private String _description;
    private StringProperty description;
    private Pos _descriptionAlignment;
    private ObjectProperty<Pos> descriptionAlignment;
    private String _unit;
    private StringProperty unit;
    private String oldFlipText;
    private String _flipText;
    private StringProperty flipText;
    private String _text;
    private StringProperty text;
    private TextAlignment _textAlignment;
    private ObjectProperty<TextAlignment> textAlignment;
    private boolean _active;
    private BooleanProperty active;
    private boolean _averagingEnabled;
    private BooleanProperty averagingEnabled;
    private int _averagingPeriod;
    private IntegerProperty averagingPeriod;
    private MovingAverage movingAverage;
    private ObservableList<Section> sections;
    private ObservableList<TilesFXSeries<String, Number>> series;
    private List<Stop> gradientStops;
    private ObjectProperty<ZonedDateTime> time;
    private LongProperty currentTime;
    private ZoneId zoneId;
    private int updateInterval;
    private ObservableList<TimeSection> timeSections;
    private LocalTime _duration;
    private ObjectProperty<LocalTime> duration;
    private ObservableList<BarChartItem> barChartItems;
    private ObservableList<LeaderBoardItem> leaderBoardItems;
    private ObjectProperty<Image> image;
    private ImageMask _imageMask;
    private ObjectProperty<ImageMask> imageMask;
    private ObjectProperty<Node> graphic;
    private Location _currentLocation;
    private ObjectProperty<Location> currentLocation;
    private ObservableList<Location> poiList;
    private ObservableList<ChartData> chartDataList;
    private List<Location> track;
    private TileColor _trackColor;
    private ObjectProperty<TileColor> trackColor;
    private MapProvider _mapProvider;
    private ObjectProperty<MapProvider> mapProvider;
    private List<String> characterList;
    private long flipTimeInMS;
    private SunburstChart sunburstChart;
    private SkinType skinType;
    private TextSize _textSize;
    private ObjectProperty<TextSize> textSize;
    private boolean _roundedCorners;
    private BooleanProperty roundedCorners;
    private boolean _startFromZero;
    private BooleanProperty startFromZero;
    private boolean _returnToZero;
    private BooleanProperty returnToZero;
    private double _minMeasuredValue;
    private DoubleProperty minMeasuredValue;
    private double _maxMeasuredValue;
    private DoubleProperty maxMeasuredValue;
    private boolean _minMeasuredValueVisible;
    private BooleanProperty minMeasuredValueVisible;
    private boolean _maxMeasuredValueVisible;
    private BooleanProperty maxMeasuredValueVisible;
    private boolean _oldValueVisible;
    private BooleanProperty oldValueVisible;
    private boolean _valueVisible;
    private BooleanProperty valueVisible;
    private Color _foregroundColor;
    private ObjectProperty<Color> foregroundColor;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;
    private Color _borderColor;
    private ObjectProperty<Color> borderColor;
    private double _borderWidth;
    private DoubleProperty borderWidth;
    private Color _activeColor;
    private ObjectProperty<Color> activeColor;
    private Color _knobColor;
    private ObjectProperty<Color> knobColor;
    private boolean _animated;
    private BooleanProperty animated;
    private long animationDuration;
    private double _startAngle;
    private DoubleProperty startAngle;
    private double _angleRange;
    private DoubleProperty angleRange;
    private double _angleStep;
    private DoubleProperty angleStep;
    private boolean _autoScale;
    private BooleanProperty autoScale;
    private boolean _shadowsEnabled;
    private BooleanProperty shadowsEnabled;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private int _decimals;
    private IntegerProperty decimals;
    private int _tickLabelDecimals;
    private IntegerProperty tickLabelDecimals;
    private Color _needleColor;
    private ObjectProperty<Color> needleColor;
    private Color _barColor;
    private ObjectProperty<Color> barColor;
    private Color _barBackgroundColor;
    private ObjectProperty<Color> barBackgroundColor;
    private Color _titleColor;
    private ObjectProperty<Color> titleColor;
    private Color _descriptionColor;
    private ObjectProperty<Color> descriptionColor;
    private Color _unitColor;
    private ObjectProperty<Color> unitColor;
    private Color _valueColor;
    private ObjectProperty<Color> valueColor;
    private Color _thresholdColor;
    private ObjectProperty<Color> thresholdColor;
    private boolean _checkSectionsForValue;
    private BooleanProperty checkSectionsForValue;
    private boolean _checkThreshold;
    private BooleanProperty checkThreshold;
    private boolean _innerShadowEnabled;
    private BooleanProperty innerShadowEnabled;
    private boolean _thresholdVisible;
    private BooleanProperty thresholdVisible;
    private boolean _averageVisible;
    private BooleanProperty averageVisible;
    private boolean _sectionsVisible;
    private BooleanProperty sectionsVisible;
    private boolean _sectionsAlwaysVisible;
    private BooleanProperty sectionsAlwaysVisible;
    private boolean _sectionTextVisible;
    private BooleanProperty sectionTextVisible;
    private boolean _sectionIconsVisible;
    private BooleanProperty sectionIconsVisible;
    private boolean _highlightSections;
    private BooleanProperty highlightSections;
    private Orientation _orientation;
    private ObjectProperty<Orientation> orientation;
    private boolean _keepAspect;
    private BooleanProperty keepAspect;
    private boolean _customFontEnabled;
    private BooleanProperty customFontEnabled;
    private Font _customFont;
    private ObjectProperty<Font> customFont;
    private boolean _alert;
    private BooleanProperty alert;
    private String _alertMessage;
    private StringProperty alertMessage;
    private boolean _smoothing;
    private BooleanProperty smoothing;
    private double increment;
    private double originalMinValue;
    private double originalMaxValue;
    private double originalThreshold;
    private Timeline timeline;
    private Instant lastCall;
    private boolean withinSpeedLimit;
    private boolean _discreteSeconds;
    private BooleanProperty discreteSeconds;
    private boolean _discreteMinutes;
    private BooleanProperty discreteMinutes;
    private boolean _discreteHours;
    private BooleanProperty discreteHours;
    private boolean _secondsVisible;
    private BooleanProperty secondsVisible;
    private boolean _textVisible;
    private BooleanProperty textVisible;
    private boolean _dateVisible;
    private BooleanProperty dateVisible;
    private boolean _running;
    private BooleanProperty running;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private Color _dateColor;
    private ObjectProperty<Color> dateColor;
    private Color _hourTickMarkColor;
    private ObjectProperty<Color> hourTickMarkColor;
    private Color _minuteTickMarkColor;
    private ObjectProperty<Color> minuteTickMarkColor;
    private Color _alarmColor;
    private ObjectProperty<Color> alarmColor;
    private boolean _hourTickMarksVisible;
    private BooleanProperty hourTickMarksVisible;
    private boolean _minuteTickMarksVisible;
    private BooleanProperty minuteTickMarksVisible;
    private Color _hourColor;
    private ObjectProperty<Color> hourColor;
    private Color _minuteColor;
    private ObjectProperty<Color> minuteColor;
    private Color _secondColor;
    private ObjectProperty<Color> secondColor;
    private boolean _alarmsEnabled;
    private BooleanProperty alarmsEnabled;
    private boolean _alarmsVisible;
    private BooleanProperty alarmsVisible;
    private ObservableList<Alarm> alarms;
    private List<Alarm> alarmsToRemove;
    private boolean _strokeWithGradient;
    private BooleanProperty strokeWithGradient;
    private boolean _fillWithGradient;
    private BooleanProperty fillWithGradient;
    private DarkSky darkSky;
    private String _tooltipText;
    private StringProperty tooltipText;
    private Tooltip tooltip;
    private Axis _xAxis;
    private ObjectProperty<Axis> xAxis;
    private Axis _yAxis;
    private ObjectProperty<Axis> yAxis;
    private RadarChart.Mode _radarChartMode;
    private ObjectProperty<RadarChart.Mode> radarChartMode;
    private Color _chartGridColor;
    private ObjectProperty<Color> chartGridColor;
    private Country _country;
    private ObjectProperty<Country> country;
    private CountryGroup _countryGroup;
    private ObjectProperty<CountryGroup> countryGroup;
    private boolean _sortedData;
    private BooleanProperty sortedData;
    private boolean _dataPointsVisible;
    private BooleanProperty dataPointsVisible;
    private boolean _snapToTicks;
    private BooleanProperty snapToTicks;
    private int _minorTickCount;
    private double _majorTickUnit;
    private int[] _matrixSize;
    private ChartType _chartType;
    private double _tooltipTimeout;
    private DoubleProperty tooltipTimeout;
    private Color _notifyRegionBackgroundColor;
    private Color _notifyRegionForegroundColor;
    private Color _infoRegionBackgroundColor;
    private Color _infoRegionForegroundColor;
    private String _infoRegionTooltipText;
    private Image _backgroundImage;
    private double _backgroundImageOpacity;
    private boolean _backgroundImageKeepAspect;
    private String _leftText;
    private StringProperty leftText;
    private String _middleText;
    private StringProperty middleText;
    private String _rightText;
    private StringProperty rightText;
    private double _leftValue;
    private DoubleProperty leftValue;
    private double _middleValue;
    private DoubleProperty middleValue;
    private double _rightValue;
    private DoubleProperty rightValue;
    private Node _leftGraphics;
    private ObjectProperty<Node> leftGraphics;
    private Node _middleGraphics;
    private ObjectProperty<Node> middleGraphics;
    private Node _rightGraphics;
    private ObjectProperty<Node> rightGraphics;
    private EventHandler<MouseEvent> infoRegionHandler;
    private volatile ScheduledFuture<?> periodicTickTask;
    private static ScheduledExecutorService periodicTickExecutorService;

    public Tile() {
        this(SkinType.GAUGE);
    }

    public Tile(@NamedArg(value="SKIN_TYPE") SkinType SKIN_TYPE) {
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.skinType = SKIN_TYPE;
        this.getStyleClass().add((Object)"tile");
        this.init();
        this.registerListeners();
    }

    private void init() {
        this._minValue = 0.0;
        this._maxValue = 100.0;
        this.value = new DoublePropertyBase(this._minValue){

            private void update() {
                double VALUE = this.get();
                Tile.this.withinSpeedLimit = !Instant.now().minusMillis(Tile.this.getAnimationDuration()).isBefore(Tile.this.lastCall);
                Tile.this.lastCall = Instant.now();
                if (Tile.this.isAnimated() && Tile.this.withinSpeedLimit) {
                    long animationDuration = Tile.this.isReturnToZero() ? (long)(0.2 * (double)Tile.this.getAnimationDuration()) : Tile.this.getAnimationDuration();
                    Tile.this.timeline.stop();
                    KeyValue KEY_VALUE = new KeyValue((WritableValue)Tile.this.currentValue, (Object)VALUE, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)animationDuration), new KeyValue[]{KEY_VALUE});
                    Tile.this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                    Tile.this.timeline.play();
                } else {
                    Tile.this.currentValue.set(VALUE);
                    Tile.this.fireTileEvent(Tile.this.FINISHED_EVENT);
                }
                if (Tile.this.isAveragingEnabled()) {
                    Tile.this.movingAverage.addData(new TimeData(VALUE));
                }
            }

            protected void invalidated() {
                this.update();
            }

            public void set(double VALUE) {
                if (Helper.equals(VALUE, Tile.this.getFormerValue())) {
                    this.update();
                }
                super.set(VALUE);
                Tile.this.fireTileEvent(Tile.this.VALUE_EVENT);
            }

            public Object getBean() {
                return Tile.this;
            }

            public String getName() {
                return "value";
            }
        };
        this.oldValue = new SimpleDoubleProperty((Object)this, "oldValue", this.value.get());
        this.currentValue = new DoublePropertyBase(this.value.get()){

            protected void invalidated() {
                double VALUE = this.get();
                if (Tile.this.isCheckThreshold()) {
                    double thrshld = Tile.this.getThreshold();
                    if (Tile.this.formerValue.get() < thrshld && VALUE > thrshld) {
                        Tile.this.fireTileEvent(Tile.this.EXCEEDED_EVENT);
                    } else if (Tile.this.formerValue.get() > thrshld && VALUE < thrshld) {
                        Tile.this.fireTileEvent(Tile.this.UNDERRUN_EVENT);
                    }
                }
                if (VALUE < Tile.this.getMinMeasuredValue()) {
                    Tile.this.setMinMeasuredValue(VALUE);
                } else if (VALUE > Tile.this.getMaxMeasuredValue()) {
                    Tile.this.setMaxMeasuredValue(VALUE);
                }
                Tile.this.formerValue.set(VALUE);
            }

            public void set(double VALUE) {
                super.set(VALUE);
            }

            public Object getBean() {
                return Tile.this;
            }

            public String getName() {
                return "currentValue";
            }
        };
        this.formerValue = new SimpleDoubleProperty((Object)this, "formerValue", this.value.get());
        this._range = this._maxValue - this._minValue;
        this._threshold = this._maxValue;
        this._referenceValue = this._minValue;
        this._autoReferenceValue = true;
        this.currentTime = new LongPropertyBase(this.getTime().toEpochSecond()){

            public Object getBean() {
                return Tile.this;
            }

            public String getName() {
                return "currentTime";
            }
        };
        this._title = "";
        this._titleAlignment = TextAlignment.LEFT;
        this._description = "";
        this._descriptionAlignment = Pos.TOP_RIGHT;
        this._unit = "";
        this.oldFlipText = "";
        this._flipText = "";
        this._active = false;
        this._text = "";
        this._textAlignment = TextAlignment.LEFT;
        this._averagingEnabled = false;
        this._averagingPeriod = 10;
        this._duration = LocalTime.of(1, 0);
        this._imageMask = ImageMask.NONE;
        this._currentLocation = new Location(0.0, 0.0);
        this._trackColor = TileColor.BLUE;
        this._mapProvider = MapProvider.BW;
        this.flipTimeInMS = 500L;
        this._textSize = TextSize.NORMAL;
        this._roundedCorners = true;
        this._startFromZero = false;
        this._returnToZero = false;
        this._minMeasuredValue = this._maxValue;
        this._maxMeasuredValue = this._minValue;
        this._minMeasuredValueVisible = false;
        this._maxMeasuredValueVisible = false;
        this._oldValueVisible = false;
        this._valueVisible = true;
        this._foregroundColor = FOREGROUND;
        this._backgroundColor = BACKGROUND;
        this._borderColor = Color.TRANSPARENT;
        this._borderWidth = 1.0;
        this._knobColor = FOREGROUND;
        this._activeColor = BLUE;
        this._animated = false;
        this.animationDuration = 800L;
        this._startAngle = 0.0;
        this._angleRange = 180.0;
        this._angleStep = this._angleRange / this._range;
        this._autoScale = true;
        this._shadowsEnabled = false;
        this._locale = Locale.US;
        this._numberFormat = NumberFormat.getInstance(this._locale);
        this._decimals = 1;
        this._tickLabelDecimals = 1;
        this._needleColor = FOREGROUND;
        this._hourColor = FOREGROUND;
        this._minuteColor = FOREGROUND;
        this._secondColor = FOREGROUND;
        this._barColor = BLUE;
        this._barBackgroundColor = BACKGROUND;
        this._titleColor = FOREGROUND;
        this._descriptionColor = FOREGROUND;
        this._unitColor = FOREGROUND;
        this._valueColor = FOREGROUND;
        this._textColor = FOREGROUND;
        this._dateColor = FOREGROUND;
        this._hourTickMarkColor = FOREGROUND;
        this._minuteTickMarkColor = FOREGROUND;
        this._alarmColor = FOREGROUND;
        this._thresholdColor = RED;
        this._checkSectionsForValue = false;
        this._checkThreshold = false;
        this._innerShadowEnabled = false;
        this._thresholdVisible = false;
        this._averageVisible = false;
        this._sectionsVisible = false;
        this._sectionsAlwaysVisible = false;
        this._sectionTextVisible = false;
        this._sectionIconsVisible = false;
        this._highlightSections = false;
        this._orientation = Orientation.HORIZONTAL;
        this._keepAspect = true;
        this._customFontEnabled = false;
        this._customFont = Fonts.latoRegular(12.0);
        this._alert = false;
        this._alertMessage = "";
        this._smoothing = false;
        this._secondsVisible = false;
        this._discreteSeconds = true;
        this._discreteMinutes = true;
        this._discreteHours = false;
        this._textVisible = true;
        this._dateVisible = false;
        this._running = false;
        this._hourTickMarksVisible = true;
        this._minuteTickMarksVisible = true;
        this._alarmsEnabled = false;
        this._alarmsVisible = false;
        this._strokeWithGradient = false;
        this._fillWithGradient = false;
        this.tooltip = new Tooltip(null);
        this._xAxis = new CategoryAxis();
        this._yAxis = new NumberAxis();
        this._radarChartMode = RadarChart.Mode.POLYGON;
        this._chartGridColor = GRAY;
        this._sortedData = true;
        this._dataPointsVisible = false;
        this._snapToTicks = false;
        this._minorTickCount = 0;
        this._majorTickUnit = 1.0;
        this._matrixSize = new int[]{30, 25};
        this._chartType = ChartType.LINE;
        this._tooltipTimeout = 2000.0;
        this._notifyRegionBackgroundColor = YELLOW;
        this._notifyRegionForegroundColor = BACKGROUND;
        this._infoRegionBackgroundColor = DARK_BLUE;
        this._infoRegionForegroundColor = FOREGROUND;
        this._infoRegionTooltipText = "";
        this._backgroundImage = null;
        this._backgroundImageOpacity = 0.2;
        this._backgroundImageKeepAspect = true;
        this._leftText = "";
        this._middleText = "";
        this._rightText = "";
        this._leftValue = 0.0;
        this._middleValue = 0.0;
        this._rightValue = 0.0;
        this._leftGraphics = null;
        this._middleGraphics = null;
        this._rightGraphics = null;
        this.updateInterval = 1000;
        this.increment = 1.0;
        this.originalMinValue = -1.7976931348623157E308;
        this.originalMaxValue = Double.MAX_VALUE;
        this.originalThreshold = Double.MAX_VALUE;
        this.lastCall = Instant.now();
        this.timeline = new Timeline();
        this.timeline.setOnFinished(e -> {
            if (this.isReturnToZero() && !Helper.equals(this.currentValue.get(), 0.0)) {
                KeyValue KEY_VALUE2 = new KeyValue((WritableValue)this.value, (Object)0, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                KeyFrame KEY_FRAME2 = new KeyFrame(Duration.millis((double)((long)(0.8 * (double)this.getAnimationDuration()))), new KeyValue[]{KEY_VALUE2});
                this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME2});
                this.timeline.play();
            }
            this.fireTileEvent(this.FINISHED_EVENT);
        });
    }

    private void registerListeners() {
        this.disabledProperty().addListener(o -> this.setOpacity(this.isDisabled() ? 0.4 : 1.0));
        this.valueProperty().addListener((o, ov, nv) -> this.oldValue.set(ov.doubleValue()));
        this.currentValueProperty().addListener(o -> {
            double currentValue = this.getCurrentValue();
            if (currentValue > this.getMaxValue()) {
                this.fireTileEvent(this.MAX_VALUE_EXCEEDED);
            } else if (currentValue < this.getMinValue()) {
                this.fireTileEvent(this.MIN_VALUE_UNDERRUN);
            } else {
                this.fireTileEvent(this.VALUE_IN_RANGE);
            }
        });
        if (null != this.getScene()) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (null == nv1) {
                    return;
                }
                if (null != this.getScene().getWindow()) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (null == nv2) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
    }

    public double getValue() {
        return this.value.get();
    }

    public void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public double getCurrentValue() {
        return this.currentValue.get();
    }

    public ReadOnlyDoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public double getOldValue() {
        return this.oldValue.get();
    }

    public ReadOnlyDoubleProperty oldValueProperty() {
        return this.oldValue;
    }

    public double getFormerValue() {
        return this.formerValue.get();
    }

    public ReadOnlyDoubleProperty formerValueProperty() {
        return this.formerValue;
    }

    public double getMinValue() {
        return null == this.minValue ? this._minValue : this.minValue.get();
    }

    public void setMinValue(double VALUE) {
        if (Animation.Status.RUNNING == this.timeline.getStatus()) {
            this.timeline.jumpTo(Duration.ONE);
        }
        if (null == this.minValue) {
            if (VALUE > this.getMaxValue()) {
                this.setMaxValue(VALUE);
            }
            this._minValue = Helper.clamp(-1.7976931348623157E308, this.getMaxValue(), VALUE);
            this.setRange(this.getMaxValue() - this._minValue);
            if (Helper.equals(this.originalMinValue, -1.7976931348623157E308)) {
                this.originalMinValue = this._minValue;
            }
            if (this.isStartFromZero() && this._minValue < 0.0) {
                this.setValue(0.0);
            }
            if (Helper.equals(this.originalThreshold, this.getThreshold())) {
                this.setThreshold(Helper.clamp(this._minValue, this.getMaxValue(), this.originalThreshold));
            }
            this.fireTileEvent(this.RECALC_EVENT);
            if (!this.valueProperty().isBound()) {
                this.setValue(Helper.clamp(this.getMinValue(), this.getMaxValue(), this.getValue()));
            }
        } else {
            this.minValue.set(VALUE);
        }
    }

    public DoubleProperty minValueProperty() {
        if (null == this.minValue) {
            this.minValue = new DoublePropertyBase(this._minValue){

                protected void invalidated() {
                    double value = this.get();
                    if (value > Tile.this.getMaxValue()) {
                        Tile.this.setMaxValue(value);
                    }
                    Tile.this.setRange(Tile.this.getMaxValue() - value);
                    if (Helper.equals(Tile.this.originalMinValue, -1.7976931348623157E308)) {
                        Tile.this.originalMinValue = value;
                    }
                    if (Tile.this.isStartFromZero() && Tile.this._minValue < 0.0) {
                        Tile.this.setValue(0.0);
                    }
                    if (Helper.lessThan(Tile.this.originalThreshold, Tile.this.getThreshold())) {
                        Tile.this.setThreshold(Helper.clamp(value, Tile.this.getMaxValue(), Tile.this.originalThreshold));
                    }
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                    if (!Tile.this.valueProperty().isBound()) {
                        Tile.this.setValue(Helper.clamp(Tile.this.getMinValue(), Tile.this.getMaxValue(), Tile.this.getValue()));
                    }
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "minValue";
                }
            };
        }
        return this.minValue;
    }

    public double getMaxValue() {
        return null == this.maxValue ? this._maxValue : this.maxValue.get();
    }

    public void setMaxValue(double VALUE) {
        if (Animation.Status.RUNNING == this.timeline.getStatus()) {
            this.timeline.jumpTo(Duration.ONE);
        }
        if (null == this.maxValue) {
            if (VALUE < this.getMinValue()) {
                this.setMinValue(VALUE);
            }
            this._maxValue = Helper.clamp(this.getMinValue(), Double.MAX_VALUE, VALUE);
            this.setRange(this._maxValue - this.getMinValue());
            if (Helper.equals(this.originalMaxValue, Double.MAX_VALUE)) {
                this.originalMaxValue = this._maxValue;
            }
            if (Helper.biggerThan(this.originalThreshold, this.getThreshold())) {
                this.setThreshold(Helper.clamp(this.getMinValue(), this._maxValue, this.originalThreshold));
            }
            this.fireTileEvent(this.RECALC_EVENT);
            if (!this.valueProperty().isBound()) {
                this.setValue(Helper.clamp(this.getMinValue(), this.getMaxValue(), this.getValue()));
            }
        } else {
            this.maxValue.set(VALUE);
        }
    }

    public DoubleProperty maxValueProperty() {
        if (null == this.maxValue) {
            this.maxValue = new DoublePropertyBase(this._maxValue){

                protected void invalidated() {
                    double VALUE = this.get();
                    if (VALUE < Tile.this.getMinValue()) {
                        Tile.this.setMinValue(VALUE);
                    }
                    Tile.this.setRange(VALUE - Tile.this.getMinValue());
                    if (Helper.equals(Tile.this.originalMaxValue, Double.MAX_VALUE)) {
                        Tile.this.originalMaxValue = VALUE;
                    }
                    if (Helper.biggerThan(Tile.this.originalThreshold, Tile.this.getThreshold())) {
                        Tile.this.setThreshold(Helper.clamp(Tile.this.getMinValue(), VALUE, Tile.this.originalThreshold));
                    }
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                    if (!Tile.this.valueProperty().isBound()) {
                        Tile.this.setValue(Helper.clamp(Tile.this.getMinValue(), Tile.this.getMaxValue(), Tile.this.getValue()));
                    }
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "maxValue";
                }
            };
        }
        return this.maxValue;
    }

    public double getRange() {
        return null == this.range ? this._range : this.range.get();
    }

    private void setRange(double RANGE) {
        if (null == this.range) {
            this._range = RANGE;
            this.setAngleStep(this.getAngleRange() / RANGE);
        } else {
            this.range.set(RANGE);
        }
    }

    public ReadOnlyDoubleProperty rangeProperty() {
        if (null == this.range) {
            this.range = new DoublePropertyBase(this.getMaxValue() - this.getMinValue()){

                protected void invalidated() {
                    Tile.this.setAngleStep(Tile.this.getAngleRange() / this.get());
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "range";
                }
            };
        }
        return this.range;
    }

    public double getThreshold() {
        return null == this.threshold ? this._threshold : this.threshold.get();
    }

    public void setThreshold(double THRESHOLD) {
        this.originalThreshold = THRESHOLD;
        if (null == this.threshold) {
            this._threshold = Helper.clamp(this.getMinValue(), this.getMaxValue(), THRESHOLD);
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.threshold.set(THRESHOLD);
        }
    }

    public DoubleProperty tresholdProperty() {
        if (null == this.threshold) {
            this.threshold = new DoublePropertyBase(this._threshold){

                protected void invalidated() {
                    double THRESHOLD = this.get();
                    if (THRESHOLD < Tile.this.getMinValue() || THRESHOLD > Tile.this.getMaxValue()) {
                        this.set(Helper.clamp(Tile.this.getMinValue(), Tile.this.getMaxValue(), THRESHOLD));
                    }
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "threshold";
                }
            };
        }
        return this.threshold;
    }

    public double getReferenceValue() {
        return null == this.referenceValue ? this._referenceValue : this.referenceValue.get();
    }

    public void setReferenceValue(double VALUE) {
        if (null == this.referenceValue) {
            this._referenceValue = VALUE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.referenceValue.set(VALUE);
        }
    }

    public DoubleProperty referenceValueProperty() {
        if (null == this.referenceValue) {
            this.referenceValue = new DoublePropertyBase(this._referenceValue){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "referenceValue";
                }
            };
        }
        return this.referenceValue;
    }

    public boolean isAutoReferenceValue() {
        return null == this.autoReferenceValue ? this._autoReferenceValue : this.autoReferenceValue.get();
    }

    public void setAutoReferenceValue(boolean AUTO_REFERENCE_VALUE) {
        if (null == this.autoReferenceValue) {
            this._autoReferenceValue = AUTO_REFERENCE_VALUE;
        } else {
            this.autoReferenceValue.set(AUTO_REFERENCE_VALUE);
        }
    }

    public BooleanProperty autoReferenceValueProperty() {
        if (null == this.autoReferenceValue) {
            this.autoReferenceValue = new BooleanPropertyBase(this._autoReferenceValue){

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "autoReferenceValue";
                }
            };
        }
        return this.autoReferenceValue;
    }

    public SunburstChart getSunburstChart() {
        if (null == this.sunburstChart) {
            this.sunburstChart = new SunburstChart();
        }
        return this.sunburstChart;
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = null == TITLE ? "" : TITLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set("");
                    }
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public TextAlignment getTitleAlignment() {
        return null == this.titleAlignment ? this._titleAlignment : (TextAlignment)this.titleAlignment.get();
    }

    public void setTitleAlignment(TextAlignment ALIGNMENT) {
        if (null == this.titleAlignment) {
            this._titleAlignment = ALIGNMENT;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.titleAlignment.set((Object)ALIGNMENT);
        }
    }

    public ObjectProperty<TextAlignment> titleAlignmentProperty() {
        if (null == this.titleAlignment) {
            this.titleAlignment = new ObjectPropertyBase<TextAlignment>(this._titleAlignment){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "titleAlignment";
                }
            };
            this._titleAlignment = null;
        }
        return this.titleAlignment;
    }

    public String getDescription() {
        return null == this.description ? this._description : (String)this.description.get();
    }

    public void setDescription(String DESCRIPTION) {
        if (null == this.description) {
            this._description = DESCRIPTION;
            this.fireTileEvent(this.VISIBILITY_EVENT);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.description.set((Object)DESCRIPTION);
        }
    }

    public StringProperty descriptionProperty() {
        if (null == this.description) {
            this.description = new StringPropertyBase(this._description){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "description";
                }
            };
            this._description = null;
        }
        return this.description;
    }

    public Pos getDescriptionAlignment() {
        return null == this.descriptionAlignment ? this._descriptionAlignment : (Pos)this.descriptionAlignment.get();
    }

    public void setDescriptionAlignment(Pos ALIGNMENT) {
        if (null == this.descriptionAlignment) {
            this._descriptionAlignment = ALIGNMENT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.descriptionAlignment.set((Object)ALIGNMENT);
        }
    }

    public ObjectProperty<Pos> descriptionAlignmentProperty() {
        if (null == this.descriptionAlignment) {
            this.descriptionAlignment = new ObjectPropertyBase<Pos>(this._descriptionAlignment){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "descriptionAlignment";
                }
            };
            this._descriptionAlignment = null;
        }
        return this.descriptionAlignment;
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
            this.fireTileEvent(this.VISIBILITY_EVENT);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public String getFlipText() {
        return null == this.flipText ? this._flipText : (String)this.flipText.get();
    }

    public void setFlipText(String TEXT) {
        if (null == this.flipText) {
            this._flipText = TEXT;
            if (!this.oldFlipText.equals(this._flipText)) {
                this.fireTileEvent(this.FLIP_START_EVENT);
            }
            this.oldFlipText = this._flipText;
        } else {
            this.flipText.set((Object)TEXT);
        }
    }

    public StringProperty flipTextProperty() {
        if (null == this.flipText) {
            this.flipText = new StringPropertyBase(this._flipText){

                protected void invalidated() {
                    if (!Tile.this.oldFlipText.equals(this.get())) {
                        Tile.this.fireTileEvent(Tile.this.FLIP_START_EVENT);
                    }
                    Tile.this.oldFlipText = this.get();
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "flipText";
                }
            };
            this._flipText = null;
        }
        return this.flipText;
    }

    public boolean isActive() {
        return null == this.active ? this._active : this.active.get();
    }

    public void setActive(boolean SELECTED) {
        if (null == this.active) {
            this._active = SELECTED;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.active.set(SELECTED);
        }
    }

    public BooleanProperty activeProperty() {
        if (null == this.active) {
            this.active = new BooleanPropertyBase(this._active){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "active";
                }
            };
        }
        return this.active;
    }

    public MovingAverage getMovingAverage() {
        if (null == this.movingAverage) {
            this.movingAverage = new MovingAverage(this.getAveragingPeriod());
        }
        return this.movingAverage;
    }

    public boolean isAveragingEnabled() {
        return null == this.averagingEnabled ? this._averagingEnabled : this.averagingEnabled.get();
    }

    public void setAveragingEnabled(boolean ENABLED) {
        if (null == this.averagingEnabled) {
            this._averagingEnabled = ENABLED;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.averagingEnabled.set(ENABLED);
        }
    }

    public BooleanProperty averagingEnabledProperty() {
        if (null == this.averagingEnabled) {
            this.averagingEnabled = new BooleanPropertyBase(this._averagingEnabled){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "averagingEnabled";
                }
            };
        }
        return this.averagingEnabled;
    }

    public int getAveragingPeriod() {
        return null == this.averagingPeriod ? this._averagingPeriod : this.averagingPeriod.get();
    }

    public void setAveragingPeriod(int PERIOD) {
        if (null == this.averagingPeriod) {
            this._averagingPeriod = Helper.clamp(0, 2073600, PERIOD);
            this.getMovingAverage().setPeriod(this._averagingPeriod);
            if (null == this.showing) {
                return;
            }
            this.fireTileEvent(this.AVERAGING_EVENT);
        } else {
            this.averagingPeriod.set(Helper.clamp(0, 2073600, PERIOD));
        }
    }

    public IntegerProperty averagingPeriodProperty() {
        if (null == this.averagingPeriod) {
            this.averagingPeriod = new IntegerPropertyBase(this._averagingPeriod){

                protected void invalidated() {
                    Tile.this.getMovingAverage().setPeriod(this.get());
                    Tile.this.fireTileEvent(Tile.this.AVERAGING_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "averagingPeriod";
                }
            };
        }
        return this.averagingPeriod;
    }

    public Queue<TimeData> getAveragingWindow() {
        return this.movingAverage.getWindow();
    }

    public double getAverage() {
        return this.movingAverage.getAverage();
    }

    public double getTimeBasedAverageOf(java.time.Duration DURATION) {
        return this.movingAverage.getTimeBasedAverageOf(DURATION);
    }

    public LocalTime getDuration() {
        return null == this.duration ? this._duration : (LocalTime)this.duration.get();
    }

    public void setDuration(LocalTime DURATION) {
        if (null == this.duration) {
            this._duration = DURATION;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.duration.set((Object)DURATION);
        }
    }

    public ObjectProperty<LocalTime> durationProperty() {
        if (null == this.duration) {
            this.duration = new ObjectPropertyBase<LocalTime>(this._duration){

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "duration";
                }
            };
            this._duration = null;
        }
        return this.duration;
    }

    public ObservableList<Section> getSections() {
        if (null == this.sections) {
            this.sections = FXCollections.observableArrayList();
        }
        return this.sections;
    }

    public void setSections(List<Section> SECTIONS) {
        this.getSections().setAll(SECTIONS);
        this.getSections().sort((Comparator)new SectionComparator());
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public void addSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.getSections().add((Object)SECTION);
        this.getSections().sort((Comparator)new SectionComparator());
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public void removeSection(Section SECTION) {
        if (null == SECTION) {
            return;
        }
        this.getSections().remove((Object)SECTION);
        this.getSections().sort((Comparator)new SectionComparator());
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public void clearSections() {
        this.getSections().clear();
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public ObservableList<XYChart.Series<String, Number>> getSeries() {
        return this.getTilesFXSeries().stream().map(tilesFxSeries -> tilesFxSeries.getSeries()).collect(Collectors.toCollection(FXCollections::observableArrayList));
    }

    public void setSeries(List<XYChart.Series<String, Number>> SERIES) {
        SERIES.forEach(series -> this.addTilesFXSeries(new TilesFXSeries<String, Number>((XYChart.Series<String, Number>)series)));
    }

    public void setSeries(XYChart.Series<String, Number> ... SERIES) {
        this.setSeries(Arrays.asList(SERIES));
    }

    public void addSeries(XYChart.Series<String, Number> SERIES) {
        this.addTilesFXSeries(new TilesFXSeries<String, Number>(SERIES));
    }

    public void removeSeries(XYChart.Series<String, Number> SERIES) {
        TilesFXSeries seriesToRemove = this.series.stream().filter(tilesFxSeries -> tilesFxSeries.getSeries().equals(SERIES)).findFirst().orElse(null);
        if (null == seriesToRemove) {
            return;
        }
        this.series.removeAll((Object[])new TilesFXSeries[]{seriesToRemove});
    }

    public void clearSeries() {
        this.clearTilesFXSeries();
    }

    public ObservableList<TilesFXSeries<String, Number>> getTilesFXSeries() {
        if (null == this.series) {
            this.series = FXCollections.observableArrayList();
        }
        return this.series;
    }

    public void setTilesFXSeries(List<TilesFXSeries<String, Number>> SERIES) {
        this.getTilesFXSeries().setAll(SERIES);
        this.fireTileEvent(this.SERIES_EVENT);
    }

    public void setTilesFXSeries(TilesFXSeries<String, Number> ... SERIES) {
        this.setTilesFXSeries(Arrays.asList(SERIES));
    }

    public void addTilesFXSeries(TilesFXSeries<String, Number> SERIES) {
        if (null == SERIES) {
            return;
        }
        this.getTilesFXSeries().add(SERIES);
        this.fireTileEvent(this.SERIES_EVENT);
    }

    public void removeTilesFXSeries(TilesFXSeries<String, Number> SERIES) {
        if (null == SERIES) {
            return;
        }
        if (this.getTilesFXSeries().contains(SERIES)) {
            this.getTilesFXSeries().remove(SERIES);
            this.fireTileEvent(this.SERIES_EVENT);
        }
    }

    public void clearTilesFXSeries() {
        this.getTilesFXSeries().clear();
        this.fireTileEvent(this.SERIES_EVENT);
    }

    public ObservableList<BarChartItem> getBarChartItems() {
        if (null == this.barChartItems) {
            this.barChartItems = FXCollections.observableArrayList();
        }
        return this.barChartItems;
    }

    public void setBarChartItems(List<BarChartItem> ITEMS) {
        this.getBarChartItems().setAll(ITEMS);
        this.fireTileEvent(this.DATA_EVENT);
    }

    public void setBarChartItems(BarChartItem ... ITEMS) {
        this.setBarChartItems(Arrays.asList(ITEMS));
    }

    public void addBarChartItem(BarChartItem ITEM) {
        if (null == ITEM) {
            return;
        }
        this.getBarChartItems().add((Object)ITEM);
        this.fireTileEvent(this.DATA_EVENT);
    }

    public void removeBarChartItem(BarChartItem ITEM) {
        if (null == ITEM) {
            return;
        }
        this.getBarChartItems().remove((Object)ITEM);
        this.fireTileEvent(this.DATA_EVENT);
    }

    public void clearBarChartItems() {
        this.getBarChartItems().clear();
        this.fireTileEvent(this.DATA_EVENT);
    }

    public ObservableList<LeaderBoardItem> getLeaderBoardItems() {
        if (null == this.leaderBoardItems) {
            this.leaderBoardItems = FXCollections.observableArrayList();
        }
        return this.leaderBoardItems;
    }

    public void setLeaderBoardItems(List<LeaderBoardItem> ITEMS) {
        this.getLeaderBoardItems().setAll(ITEMS);
        this.fireTileEvent(this.DATA_EVENT);
    }

    public void setLeaderBoardItems(LeaderBoardItem ... ITEMS) {
        this.setLeaderBoardItems(Arrays.asList(ITEMS));
    }

    public void addLeaderBoardItem(LeaderBoardItem ITEM) {
        if (null == ITEM) {
            return;
        }
        this.getLeaderBoardItems().add((Object)ITEM);
        this.fireTileEvent(this.DATA_EVENT);
    }

    public void removeLeaderBoardItem(LeaderBoardItem ITEM) {
        if (null == ITEM) {
            return;
        }
        this.getLeaderBoardItems().remove((Object)ITEM);
        this.fireTileEvent(this.DATA_EVENT);
    }

    public void clearLeaderBoardItems() {
        this.getLeaderBoardItems().clear();
        this.fireTileEvent(this.DATA_EVENT);
    }

    public List<Stop> getGradientStops() {
        if (null == this.gradientStops) {
            this.gradientStops = new ArrayList<Stop>(4);
        }
        return this.gradientStops;
    }

    public void setGradientStops(Stop ... STOPS) {
        this.setGradientStops(Arrays.asList(STOPS));
    }

    public void setGradientStops(List<Stop> STOPS) {
        this.getGradientStops().clear();
        this.getGradientStops().addAll(STOPS);
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public Image getImage() {
        return null == this.image ? null : (Image)this.image.get();
    }

    public void setImage(Image IMAGE) {
        this.imageProperty().set((Object)IMAGE);
    }

    public ObjectProperty<Image> imageProperty() {
        if (null == this.image) {
            this.image = new ObjectPropertyBase<Image>(){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "image";
                }
            };
        }
        return this.image;
    }

    public ImageMask getImageMask() {
        return null == this.imageMask ? this._imageMask : (ImageMask)((Object)this.imageMask.get());
    }

    public void setImageMask(ImageMask MASK) {
        if (null == this.imageMask) {
            this._imageMask = MASK;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.imageMask.set((Object)MASK);
        }
    }

    public ObjectProperty<ImageMask> imageMaskProperty() {
        if (null == this.imageMask) {
            this.imageMask = new ObjectPropertyBase<ImageMask>(this._imageMask){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "imageMask";
                }
            };
            this._imageMask = null;
        }
        return this.imageMask;
    }

    public Node getGraphic() {
        return null == this.graphic ? null : (Node)this.graphic.get();
    }

    public void setGraphic(Node GRAPHIC) {
        this.graphicProperty().set((Object)GRAPHIC);
    }

    public ObjectProperty<Node> graphicProperty() {
        if (null == this.graphic) {
            this.graphic = new ObjectPropertyBase<Node>(){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.GRAPHIC_EVENT);
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public Location getCurrentLocation() {
        return null == this.currentLocation ? this._currentLocation : (Location)this.currentLocation.get();
    }

    public void setCurrentLocation(Location LOCATION) {
        if (null == this.currentLocation) {
            this._currentLocation = LOCATION;
            this.fireTileEvent(this.LOCATION_EVENT);
        } else {
            this.currentLocation.set((Object)LOCATION);
        }
    }

    public ObjectProperty<Location> currentLocationProperty() {
        if (null == this.currentLocation) {
            this.currentLocation = new ObjectPropertyBase<Location>(this._currentLocation){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.LOCATION_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "currentLocation";
                }
            };
            this._currentLocation = null;
        }
        return this.currentLocation;
    }

    public void updateLocation(double LATITUDE, double LONGITUDE) {
        this.getCurrentLocation().set(LATITUDE, LONGITUDE);
        this.fireTileEvent(this.LOCATION_EVENT);
    }

    public ObservableList<Location> getPoiList() {
        if (null == this.poiList) {
            this.poiList = FXCollections.observableArrayList();
        }
        return this.poiList;
    }

    public void setPoiList(List<Location> POI_LIST) {
        this.getPoiList().setAll(POI_LIST);
    }

    public void setPoiLocations(Location ... LOCATIONS) {
        this.setPoiList(Arrays.asList(LOCATIONS));
    }

    public void addPoiLocation(Location LOCATION) {
        if (null == LOCATION) {
            return;
        }
        if (!this.getPoiList().contains((Object)LOCATION)) {
            this.getPoiList().add((Object)LOCATION);
        }
    }

    public void removePoiLocation(Location LOCATION) {
        if (null == LOCATION) {
            return;
        }
        if (this.getPoiList().contains((Object)LOCATION)) {
            this.getPoiList().remove((Object)LOCATION);
        }
    }

    public void clearPoiLocations() {
        this.getPoiList().clear();
        this.fireTileEvent(this.DATA_EVENT);
    }

    public List<Location> getTrack() {
        if (null == this.track) {
            this.track = new ArrayList<Location>();
        }
        return this.track;
    }

    public void setTrack(Location ... LOCATIONS) {
        this.setTrack(Arrays.asList(LOCATIONS));
    }

    public void setTrack(List<Location> LOCATIONS) {
        this.getTrack().clear();
        this.getTrack().addAll(LOCATIONS);
        this.fireTileEvent(this.TRACK_EVENT);
    }

    public void clearTrack() {
        this.getTrack().clear();
        this.fireTileEvent(this.TRACK_EVENT);
    }

    public TileColor getTrackColor() {
        return null == this.trackColor ? this._trackColor : (TileColor)((Object)this.trackColor.get());
    }

    public void setTrackColor(TileColor COLOR) {
        if (null == this.trackColor) {
            this._trackColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.trackColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<TileColor> trackColorProperty() {
        if (null == this.trackColor) {
            this.trackColor = new ObjectPropertyBase<TileColor>(this._trackColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "trackColor";
                }
            };
            this._trackColor = null;
        }
        return this.trackColor;
    }

    public MapProvider getMapProvider() {
        return null == this.mapProvider ? this._mapProvider : (MapProvider)((Object)this.mapProvider.get());
    }

    public void setMapProvider(MapProvider PROVIDER) {
        if (null == this.mapProvider) {
            this._mapProvider = PROVIDER;
            this.fireTileEvent(this.MAP_PROVIDER_EVENT);
        } else {
            this.mapProvider.set((Object)PROVIDER);
        }
    }

    public ObjectProperty<MapProvider> mapProviderProperty() {
        if (null == this.mapProvider) {
            this.mapProvider = new ObjectPropertyBase<MapProvider>(this._mapProvider){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.MAP_PROVIDER_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "mapProvider";
                }
            };
            this._mapProvider = null;
        }
        return this.mapProvider;
    }

    public List<String> getCharacterList() {
        if (null == this.characterList) {
            this.characterList = new ArrayList<String>();
        }
        return this.characterList;
    }

    public void setCharacters(String ... CHARACTERS) {
        this.getCharacterList().clear();
        Arrays.stream(CHARACTERS).filter(Objects::nonNull).filter(character -> !character.isEmpty()).forEach(character -> this.getCharacterList().add((String)character));
    }

    public long getFlipTimeInMS() {
        return this.flipTimeInMS;
    }

    public void setFlipTimeInMS(long FLIP_TIME) {
        this.flipTimeInMS = Helper.clamp(0L, 2000L, FLIP_TIME);
    }

    public ObservableList<ChartData> getChartData() {
        if (null == this.chartDataList) {
            this.chartDataList = FXCollections.observableArrayList();
        }
        return this.chartDataList;
    }

    public void addChartData(ChartData ... DATA) {
        this.addChartData(Arrays.asList(DATA));
    }

    public void addChartData(List<ChartData> DATA) {
        this.getChartData().addAll(DATA);
        this.updateChartData();
    }

    public void setChartData(ChartData ... DATA) {
        this.setChartData(Arrays.asList(DATA));
    }

    public void setChartData(List<ChartData> DATA) {
        this.getChartData().setAll(DATA);
        this.updateChartData();
    }

    public void removeChartData(ChartData DATA) {
        this.getChartData().remove((Object)DATA);
    }

    public void clearChartData() {
        this.getChartData().clear();
    }

    private void updateChartData() {
        this.getChartData().forEach(chartData -> {
            chartData.setAnimated(this.isAnimated());
            chartData.setAnimationDuration(this.getAnimationDuration());
        });
    }

    public void setForegroundBaseColor(Color COLOR) {
        if (null == this.titleColor) {
            this._titleColor = COLOR;
        } else {
            this.titleColor.set((Object)COLOR);
        }
        if (null == this.descriptionColor) {
            this._descriptionColor = COLOR;
        } else {
            this.descriptionColor.set((Object)COLOR);
        }
        if (null == this.unitColor) {
            this._unitColor = COLOR;
        } else {
            this.unitColor.set((Object)COLOR);
        }
        if (null == this.valueColor) {
            this._valueColor = COLOR;
        } else {
            this.valueColor.set((Object)COLOR);
        }
        if (null == this.textColor) {
            this._textColor = COLOR;
        } else {
            this.textColor.set((Object)COLOR);
        }
        if (null == this.foregroundColor) {
            this._foregroundColor = COLOR;
        } else {
            this.foregroundColor.set((Object)COLOR);
        }
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public TextSize getTextSize() {
        return null == this.textSize ? this._textSize : (TextSize)((Object)this.textSize.get());
    }

    public void setTextSize(TextSize SIZE) {
        if (null == this.textSize) {
            this._textSize = SIZE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.textSize.set((Object)SIZE);
        }
    }

    public ObjectProperty<TextSize> textSizeProperty() {
        if (null == this.textSize) {
            this.textSize = new ObjectPropertyBase<TextSize>(this._textSize){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "textSize";
                }
            };
        }
        return this.textSize;
    }

    public boolean getRoundedCorners() {
        return null == this.roundedCorners ? this._roundedCorners : this.roundedCorners.get();
    }

    public void setRoundedCorners(boolean ROUNDED) {
        if (null == this.roundedCorners) {
            this._roundedCorners = ROUNDED;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.roundedCorners.set(ROUNDED);
        }
    }

    public BooleanProperty roundedCornersProperty() {
        if (null == this.roundedCorners) {
            this.roundedCorners = new BooleanPropertyBase(this._roundedCorners){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "roundedCorners";
                }
            };
        }
        return this.roundedCorners;
    }

    public boolean isStartFromZero() {
        return null == this.startFromZero ? this._startFromZero : this.startFromZero.get();
    }

    public void setStartFromZero(boolean IS_TRUE) {
        if (null == this.startFromZero) {
            this._startFromZero = IS_TRUE;
            this.setValue(IS_TRUE && this.getMinValue() < 0.0 ? 0.0 : this.getMinValue());
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.startFromZero.set(IS_TRUE);
        }
    }

    public BooleanProperty startFromZeroProperty() {
        if (null == this.startFromZero) {
            this.startFromZero = new BooleanPropertyBase(this._startFromZero){

                protected void invalidated() {
                    Tile.this.setValue(this.get() && Tile.this.getMinValue() < 0.0 ? 0.0 : Tile.this.getMinValue());
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "startFromZero";
                }
            };
        }
        return this.startFromZero;
    }

    public boolean isReturnToZero() {
        return null == this.returnToZero ? this._returnToZero : this.returnToZero.get();
    }

    public void setReturnToZero(boolean IS_TRUE) {
        if (null == this.returnToZero) {
            this._returnToZero = Double.compare(this.getMinValue(), 0.0) <= 0 && IS_TRUE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.returnToZero.set(IS_TRUE);
        }
    }

    public BooleanProperty returnToZeroProperty() {
        if (null == this.returnToZero) {
            this.returnToZero = new BooleanPropertyBase(this._returnToZero){

                protected void invalidated() {
                    if (Helper.biggerThan(Tile.this.getMaxValue(), 0.0)) {
                        this.set(false);
                    }
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "returnToZero";
                }
            };
        }
        return this.returnToZero;
    }

    public double getMinMeasuredValue() {
        return null == this.minMeasuredValue ? this._minMeasuredValue : this.minMeasuredValue.get();
    }

    public void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        if (null == this.minMeasuredValue) {
            this._minMeasuredValue = MIN_MEASURED_VALUE;
        } else {
            this.minMeasuredValue.set(MIN_MEASURED_VALUE);
        }
    }

    public ReadOnlyDoubleProperty minMeasuredValueProperty() {
        if (null == this.minMeasuredValue) {
            this.minMeasuredValue = new SimpleDoubleProperty((Object)this, "minMeasuredValue", this._minMeasuredValue);
        }
        return this.minMeasuredValue;
    }

    public double getMaxMeasuredValue() {
        return null == this.maxMeasuredValue ? this._maxMeasuredValue : this.maxMeasuredValue.get();
    }

    public void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        if (null == this.maxMeasuredValue) {
            this._maxMeasuredValue = MAX_MEASURED_VALUE;
        } else {
            this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
        }
    }

    public ReadOnlyDoubleProperty maxMeasuredValueProperty() {
        if (null == this.maxMeasuredValue) {
            this.maxMeasuredValue = new SimpleDoubleProperty((Object)this, "maxMeasuredValue", this._maxMeasuredValue);
        }
        return this.maxMeasuredValue;
    }

    public void resetMeasuredValues() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public boolean isMinMeasuredValueVisible() {
        return null == this.minMeasuredValueVisible ? this._minMeasuredValueVisible : this.minMeasuredValueVisible.get();
    }

    public void setMinMeasuredValueVisible(boolean VISIBLE) {
        if (null == this.minMeasuredValueVisible) {
            this._minMeasuredValueVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.minMeasuredValueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty minMeasuredValueVisibleProperty() {
        if (null == this.minMeasuredValueVisible) {
            this.minMeasuredValueVisible = new BooleanPropertyBase(this._minMeasuredValueVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "minMeasuredValueVisible";
                }
            };
        }
        return this.minMeasuredValueVisible;
    }

    public boolean isMaxMeasuredValueVisible() {
        return null == this.maxMeasuredValueVisible ? this._maxMeasuredValueVisible : this.maxMeasuredValueVisible.get();
    }

    public void setMaxMeasuredValueVisible(boolean VISIBLE) {
        if (null == this.maxMeasuredValueVisible) {
            this._maxMeasuredValueVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.maxMeasuredValueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty maxMeasuredValueVisibleProperty() {
        if (null == this.maxMeasuredValueVisible) {
            this.maxMeasuredValueVisible = new BooleanPropertyBase(this._maxMeasuredValueVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "maxMeasuredValueVisible";
                }
            };
        }
        return this.maxMeasuredValueVisible;
    }

    public boolean isOldValueVisible() {
        return null == this.oldValueVisible ? this._oldValueVisible : this.oldValueVisible.get();
    }

    public void setOldValueVisible(boolean VISIBLE) {
        if (null == this.oldValueVisible) {
            this._oldValueVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.oldValueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty oldValueVisibleProperty() {
        if (null == this.oldValueVisible) {
            this.oldValueVisible = new BooleanPropertyBase(this._oldValueVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "oldValueVisible";
                }
            };
        }
        return this.oldValueVisible;
    }

    public boolean isValueVisible() {
        return null == this.valueVisible ? this._valueVisible : this.valueVisible.get();
    }

    public void setValueVisible(boolean VISIBLE) {
        if (null == this.valueVisible) {
            this._valueVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.valueVisible.set(VISIBLE);
        }
    }

    public BooleanProperty valueVisibleProperty() {
        if (null == this.valueVisible) {
            this.valueVisible = new BooleanPropertyBase(this._valueVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "valueVisible";
                }
            };
        }
        return this.valueVisible;
    }

    public Color getForegroundColor() {
        return null == this.foregroundColor ? this._foregroundColor : (Color)this.foregroundColor.get();
    }

    public void setForegroundColor(Color COLOR) {
        if (null == this.foregroundColor) {
            this._foregroundColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.foregroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> foregroundColorProperty() {
        if (null == this.foregroundColor) {
            this.foregroundColor = new ObjectPropertyBase<Color>(this._foregroundColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "foregroundColor";
                }
            };
            this._foregroundColor = null;
        }
        return this.foregroundColor;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return null == this.borderColor ? this._borderColor : (Color)this.borderColor.get();
    }

    public void setBorderColor(Color PAINT) {
        if (null == this.borderColor) {
            this._borderColor = PAINT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.borderColor.set((Object)PAINT);
        }
    }

    public ObjectProperty<Color> borderColorProperty() {
        if (null == this.borderColor) {
            this.borderColor = new ObjectPropertyBase<Color>(this._borderColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "borderColor";
                }
            };
            this._borderColor = null;
        }
        return this.borderColor;
    }

    public double getBorderWidth() {
        return null == this.borderWidth ? this._borderWidth : this.borderWidth.get();
    }

    public void setBorderWidth(double WIDTH) {
        if (null == this.borderWidth) {
            this._borderWidth = Helper.clamp(0.0, 50.0, WIDTH);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.borderWidth.set(WIDTH);
        }
    }

    public DoubleProperty borderWidthProperty() {
        if (null == this.borderWidth) {
            this.borderWidth = new DoublePropertyBase(this._borderWidth){

                protected void invalidated() {
                    double WIDTH = this.get();
                    if (WIDTH < 0.0 || WIDTH > 50.0) {
                        this.set(Helper.clamp(0.0, 50.0, WIDTH));
                    }
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "borderWidth";
                }
            };
        }
        return this.borderWidth;
    }

    public Color getKnobColor() {
        return null == this.knobColor ? this._knobColor : (Color)this.knobColor.get();
    }

    public void setKnobColor(Color COLOR) {
        if (null == this.knobColor) {
            this._knobColor = COLOR;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.knobColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> knobColorProperty() {
        if (null == this.knobColor) {
            this.knobColor = new ObjectPropertyBase<Color>(this._knobColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "knobColor";
                }
            };
            this._knobColor = null;
        }
        return this.knobColor;
    }

    public Color getActiveColor() {
        return null == this.activeColor ? this._activeColor : (Color)this.activeColor.get();
    }

    public void setActiveColor(Color COLOR) {
        if (null == this.activeColor) {
            this._activeColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.activeColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> activeColorProperty() {
        if (null == this.activeColor) {
            this.activeColor = new ObjectPropertyBase<Color>(this._activeColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "activeColor";
                }
            };
            this._activeColor = null;
        }
        return this.activeColor;
    }

    public boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
            this.updateChartData();
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new BooleanPropertyBase(this._animated){

                protected void invalidated() {
                    Tile.this.updateChartData();
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "animated";
                }
            };
        }
        return this.animated;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(long ANIMATION_DURATION) {
        this.animationDuration = Helper.clamp(10L, 10000L, ANIMATION_DURATION);
    }

    public double getStartAngle() {
        return null == this.startAngle ? this._startAngle : this.startAngle.get();
    }

    public void setStartAngle(double ANGLE) {
        if (null == this.startAngle) {
            this._startAngle = Helper.clamp(0.0, 360.0, ANGLE);
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.startAngle.set(ANGLE);
        }
    }

    public DoubleProperty startAngleProperty() {
        if (null == this.startAngle) {
            this.startAngle = new DoublePropertyBase(this._startAngle){

                protected void invalidated() {
                    double ANGLE = this.get();
                    if (ANGLE < 0.0 || ANGLE > 360.0) {
                        this.set(Helper.clamp(0.0, 360.0, ANGLE));
                    }
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public double getAngleRange() {
        return null == this.angleRange ? this._angleRange : this.angleRange.get();
    }

    public void setAngleRange(double RANGE) {
        double tmpAngleRange = Helper.clamp(0.0, 360.0, RANGE);
        if (null == this.angleRange) {
            this._angleRange = tmpAngleRange;
            this.setAngleStep(tmpAngleRange / this.getRange());
            if (this.isAutoScale()) {
                this.calcAutoScale();
            }
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.angleRange.set(tmpAngleRange);
        }
    }

    public DoubleProperty angleRangeProperty() {
        if (null == this.angleRange) {
            this.angleRange = new DoublePropertyBase(this._angleRange){

                protected void invalidated() {
                    double ANGLE_RANGE = this.get();
                    if (ANGLE_RANGE < 0.0 || ANGLE_RANGE > 360.0) {
                        this.set(Helper.clamp(0.0, 360.0, ANGLE_RANGE));
                    }
                    Tile.this.setAngleStep(this.get() / Tile.this.getRange());
                    if (Tile.this.isAutoScale()) {
                        Tile.this.calcAutoScale();
                    }
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "angleRange";
                }
            };
        }
        return this.angleRange;
    }

    public double getAngleStep() {
        return null == this.angleStep ? this._angleStep : this.angleStep.get();
    }

    private void setAngleStep(double STEP) {
        if (null == this.angleStep) {
            this._angleStep = STEP;
        } else {
            this.angleStep.set(STEP);
        }
    }

    public ReadOnlyDoubleProperty angleStepProperty() {
        if (null == this.angleStep) {
            this.angleStep = new SimpleDoubleProperty((Object)this, "angleStep", this._angleStep);
        }
        return this.angleStep;
    }

    public boolean isAutoScale() {
        return null == this.autoScale ? this._autoScale : this.autoScale.get();
    }

    public void setAutoScale(boolean AUTO_SCALE) {
        if (null == this.autoScale) {
            this._autoScale = AUTO_SCALE;
            if (this._autoScale) {
                this.originalMinValue = this.getMinValue();
                this.originalMaxValue = this.getMaxValue();
                this.calcAutoScale();
            } else {
                this.setMinValue(Helper.equals(-1.7976931348623157E308, this.originalMinValue) ? this.getMinValue() : this.originalMinValue);
                this.setMaxValue(Helper.equals(Double.MAX_VALUE, this.originalMaxValue) ? this.getMaxValue() : this.originalMaxValue);
            }
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.autoScale.set(AUTO_SCALE);
        }
    }

    public BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new BooleanPropertyBase(this._autoScale){

                protected void invalidated() {
                    if (this.get()) {
                        Tile.this.calcAutoScale();
                    } else {
                        Tile.this.setMinValue(Tile.this.originalMinValue);
                        Tile.this.setMaxValue(Tile.this.originalMaxValue);
                    }
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "autoScale";
                }
            };
        }
        return this.autoScale;
    }

    public boolean isShadowsEnabled() {
        return null == this.shadowsEnabled ? this._shadowsEnabled : this.shadowsEnabled.get();
    }

    public void setShadowsEnabled(boolean ENABLED) {
        if (null == this.shadowsEnabled) {
            this._shadowsEnabled = ENABLED;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.shadowsEnabled.set(ENABLED);
        }
    }

    public BooleanProperty shadowsEnabledProperty() {
        if (null == this.shadowsEnabled) {
            this.shadowsEnabled = new BooleanPropertyBase(this._shadowsEnabled){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "shadowsEnabled";
                }
            };
        }
        return this.shadowsEnabled;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = null == LOCALE ? Locale.US : LOCALE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(Locale.US);
                    }
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "locale";
                }
            };
            this._locale = null;
        }
        return this.locale;
    }

    public NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)this.numberFormat.get();
    }

    public void setNumberFormat(NumberFormat FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = null == FORMAT ? NumberFormat.getInstance(this.getLocale()) : FORMAT;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.numberFormat.set((Object)FORMAT);
        }
    }

    public ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new ObjectPropertyBase<NumberFormat>(this._numberFormat){

                protected void invalidated() {
                    if (null == this.get()) {
                        this.set(NumberFormat.getInstance(Tile.this.getLocale()));
                    }
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "numberFormat";
                }
            };
            this._numberFormat = null;
        }
        return this.numberFormat;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 3, DECIMALS);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    int VALUE = this.get();
                    if (VALUE < 0 || VALUE > 3) {
                        this.set(Helper.clamp(0, 3, VALUE));
                    }
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public int getTickLabelDecimals() {
        return null == this.tickLabelDecimals ? this._tickLabelDecimals : this.tickLabelDecimals.get();
    }

    public void setTickLabelDecimals(int DECIMALS) {
        if (null == this.tickLabelDecimals) {
            this._tickLabelDecimals = Helper.clamp(0, 3, DECIMALS);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.tickLabelDecimals.set(DECIMALS);
        }
    }

    public IntegerProperty tickLabelDecimalsProperty() {
        if (null == this.tickLabelDecimals) {
            this.tickLabelDecimals = new IntegerPropertyBase(this._tickLabelDecimals){

                protected void invalidated() {
                    int VALUE = this.get();
                    if (VALUE < 0 || VALUE > 3) {
                        this.set(Helper.clamp(0, 3, VALUE));
                    }
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "tickLabelDecimals";
                }
            };
        }
        return this.tickLabelDecimals;
    }

    public Color getNeedleColor() {
        return null == this.needleColor ? this._needleColor : (Color)this.needleColor.get();
    }

    public void setNeedleColor(Color COLOR) {
        if (null == this.needleColor) {
            this._needleColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.needleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> needleColorProperty() {
        if (null == this.needleColor) {
            this.needleColor = new ObjectPropertyBase<Color>(this._needleColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "needleColor";
                }
            };
            this._needleColor = null;
        }
        return this.needleColor;
    }

    public Color getBarColor() {
        return null == this.barColor ? this._barColor : (Color)this.barColor.get();
    }

    public void setBarColor(Color COLOR) {
        if (null == this.barColor) {
            this._barColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.barColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> barColorProperty() {
        if (null == this.barColor) {
            this.barColor = new ObjectPropertyBase<Color>(this._barColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "barColor";
                }
            };
            this._barColor = null;
        }
        return this.barColor;
    }

    public Color getBarBackgroundColor() {
        return null == this.barBackgroundColor ? this._barBackgroundColor : (Color)this.barBackgroundColor.get();
    }

    public void setBarBackgroundColor(Color COLOR) {
        if (null == this.barBackgroundColor) {
            this._barBackgroundColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.barBackgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> barBackgroundColorProperty() {
        if (null == this.barBackgroundColor) {
            this.barBackgroundColor = new ObjectPropertyBase<Color>(this._barBackgroundColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "barBackgroundColor";
                }
            };
            this._barBackgroundColor = null;
        }
        return this.barBackgroundColor;
    }

    public Color getTitleColor() {
        return null == this.titleColor ? this._titleColor : (Color)this.titleColor.get();
    }

    public void setTitleColor(Color COLOR) {
        if (null == this.titleColor) {
            this._titleColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.titleColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> titleColorProperty() {
        if (null == this.titleColor) {
            this.titleColor = new ObjectPropertyBase<Color>(this._titleColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "titleColor";
                }
            };
            this._titleColor = null;
        }
        return this.titleColor;
    }

    public Color getDescriptionColor() {
        return null == this.descriptionColor ? this._descriptionColor : (Color)this.descriptionColor.get();
    }

    public void setDescriptionColor(Color COLOR) {
        if (null == this.descriptionColor) {
            this._descriptionColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.descriptionColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> descriptionColorProperty() {
        if (null == this.descriptionColor) {
            this.descriptionColor = new ObjectPropertyBase<Color>(this._descriptionColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "descriptionColor";
                }
            };
            this._descriptionColor = null;
        }
        return this.descriptionColor;
    }

    public Color getUnitColor() {
        return null == this.unitColor ? this._unitColor : (Color)this.unitColor.get();
    }

    public void setUnitColor(Color COLOR) {
        if (null == this.unitColor) {
            this._unitColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.unitColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> unitColorProperty() {
        if (null == this.unitColor) {
            this.unitColor = new ObjectPropertyBase<Color>(this._unitColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "unitColor";
                }
            };
            this._unitColor = null;
        }
        return this.unitColor;
    }

    public Color getValueColor() {
        return null == this.valueColor ? this._valueColor : (Color)this.valueColor.get();
    }

    public void setValueColor(Color COLOR) {
        if (null == this.valueColor) {
            this._valueColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.valueColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> valueColorProperty() {
        if (null == this.valueColor) {
            this.valueColor = new ObjectPropertyBase<Color>(this._valueColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "valueColor";
                }
            };
            this._valueColor = null;
        }
        return this.valueColor;
    }

    public Color getThresholdColor() {
        return null == this.thresholdColor ? this._thresholdColor : (Color)this.thresholdColor.get();
    }

    public void setThresholdColor(Color COLOR) {
        if (null == this.thresholdColor) {
            this._thresholdColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.thresholdColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> thresholdColorProperty() {
        if (null == this.thresholdColor) {
            this.thresholdColor = new ObjectPropertyBase<Color>(this._thresholdColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "thresholdColor";
                }
            };
            this._thresholdColor = null;
        }
        return this.thresholdColor;
    }

    public boolean getCheckSectionsForValue() {
        return null == this.checkSectionsForValue ? this._checkSectionsForValue : this.checkSectionsForValue.get();
    }

    public void setCheckSectionsForValue(boolean CHECK) {
        if (null == this.checkSectionsForValue) {
            this._checkSectionsForValue = CHECK;
        } else {
            this.checkSectionsForValue.set(CHECK);
        }
    }

    public BooleanProperty checkSectionsForValueProperty() {
        if (null == this.checkSectionsForValue) {
            this.checkSectionsForValue = new SimpleBooleanProperty((Object)this, "checkSectionsForValue", this._checkSectionsForValue);
        }
        return this.checkSectionsForValue;
    }

    public boolean isCheckThreshold() {
        return null == this.checkThreshold ? this._checkThreshold : this.checkThreshold.get();
    }

    public void setCheckThreshold(boolean CHECK) {
        if (null == this.checkThreshold) {
            this._checkThreshold = CHECK;
        } else {
            this.checkThreshold.set(CHECK);
        }
    }

    public BooleanProperty checkThresholdProperty() {
        if (null == this.checkThreshold) {
            this.checkThreshold = new SimpleBooleanProperty((Object)this, "checkThreshold", this._checkThreshold);
        }
        return this.checkThreshold;
    }

    public boolean isInnerShadowEnabled() {
        return null == this.innerShadowEnabled ? this._innerShadowEnabled : this.innerShadowEnabled.get();
    }

    public void setInnerShadowEnabled(boolean ENABLED) {
        if (null == this.innerShadowEnabled) {
            this._innerShadowEnabled = ENABLED;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.innerShadowEnabled.set(ENABLED);
        }
    }

    public BooleanProperty innerShadowEnabledProperty() {
        if (null == this.innerShadowEnabled) {
            this.innerShadowEnabled = new BooleanPropertyBase(this._innerShadowEnabled){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "innerShadowEnabled";
                }
            };
        }
        return this.innerShadowEnabled;
    }

    public boolean isThresholdVisible() {
        return null == this.thresholdVisible ? this._thresholdVisible : this.thresholdVisible.get();
    }

    public void setThresholdVisible(boolean VISIBLE) {
        if (null == this.thresholdVisible) {
            this._thresholdVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.thresholdVisible.set(VISIBLE);
        }
    }

    public BooleanProperty thresholdVisibleProperty() {
        if (null == this.thresholdVisible) {
            this.thresholdVisible = new BooleanPropertyBase(this._thresholdVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "thresholdVisible";
                }
            };
        }
        return this.thresholdVisible;
    }

    public boolean isAverageVisible() {
        return null == this.averageVisible ? this._averageVisible : this.averageVisible.get();
    }

    public void setAverageVisible(boolean VISIBLE) {
        if (null == this.averageVisible) {
            this._averageVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.averageVisible.set(VISIBLE);
        }
    }

    public BooleanProperty averageVisibleProperty() {
        if (null == this.averageVisible) {
            this.averageVisible = new BooleanPropertyBase(){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "averageVisible";
                }
            };
        }
        return this.averageVisible;
    }

    public boolean getSectionsVisible() {
        return null == this.sectionsVisible ? this._sectionsVisible : this.sectionsVisible.get();
    }

    public void setSectionsVisible(boolean VISIBLE) {
        if (null == this.sectionsVisible) {
            this._sectionsVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.sectionsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionsVisibleProperty() {
        if (null == this.sectionsVisible) {
            this.sectionsVisible = new BooleanPropertyBase(this._sectionsVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "sectionsVisible";
                }
            };
        }
        return this.sectionsVisible;
    }

    public boolean getSectionsAlwaysVisible() {
        return null == this.sectionsAlwaysVisible ? this._sectionsAlwaysVisible : this.sectionsAlwaysVisible.get();
    }

    public void setSectionsAlwaysVisible(boolean VISIBLE) {
        if (null == this.sectionsAlwaysVisible) {
            this._sectionsAlwaysVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.sectionsAlwaysVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionsAlwaysVisibleProperty() {
        if (null == this.sectionsAlwaysVisible) {
            this.sectionsAlwaysVisible = new BooleanPropertyBase(this._sectionsAlwaysVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "sectionsAlwaysVisible";
                }
            };
        }
        return this.sectionsAlwaysVisible;
    }

    public boolean isSectionTextVisible() {
        return null == this.sectionTextVisible ? this._sectionTextVisible : this.sectionTextVisible.get();
    }

    public void setSectionTextVisible(boolean VISIBLE) {
        if (null == this.sectionTextVisible) {
            this._sectionTextVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.sectionTextVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionTextVisibleProperty() {
        if (null == this.sectionTextVisible) {
            this.sectionTextVisible = new BooleanPropertyBase(this._sectionTextVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "sectionTextVisible";
                }
            };
        }
        return this.sectionTextVisible;
    }

    public boolean getSectionIconsVisible() {
        return null == this.sectionIconsVisible ? this._sectionIconsVisible : this.sectionIconsVisible.get();
    }

    public void setSectionIconsVisible(boolean VISIBLE) {
        if (null == this.sectionIconsVisible) {
            this._sectionIconsVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.sectionIconsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty sectionIconsVisibleProperty() {
        if (null == this.sectionIconsVisible) {
            this.sectionIconsVisible = new BooleanPropertyBase(this._sectionIconsVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "sectionIconsVisible";
                }
            };
        }
        return this.sectionIconsVisible;
    }

    public boolean isHighlightSections() {
        return null == this.highlightSections ? this._highlightSections : this.highlightSections.get();
    }

    public void setHighlightSections(boolean HIGHLIGHT) {
        if (null == this.highlightSections) {
            this._highlightSections = HIGHLIGHT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.highlightSections.set(HIGHLIGHT);
        }
    }

    public BooleanProperty highlightSectionsProperty() {
        if (null == this.highlightSections) {
            this.highlightSections = new BooleanPropertyBase(this._highlightSections){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "highlightSections";
                }
            };
        }
        return this.highlightSections;
    }

    public Orientation getOrientation() {
        return null == this.orientation ? this._orientation : (Orientation)this.orientation.get();
    }

    public void setOrientation(Orientation ORIENTATION) {
        if (null == this.orientation) {
            this._orientation = ORIENTATION;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.orientation.set((Object)ORIENTATION);
        }
    }

    public ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new ObjectPropertyBase<Orientation>(this._orientation){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "orientation";
                }
            };
            this._orientation = null;
        }
        return this.orientation;
    }

    public boolean isKeepAspect() {
        return null == this.keepAspect ? this._keepAspect : this.keepAspect.get();
    }

    public void setKeepAspect(boolean KEEP) {
        if (null == this.keepAspect) {
            this._keepAspect = KEEP;
        } else {
            this.keepAspect.set(KEEP);
        }
    }

    public BooleanProperty keepAspectProperty() {
        if (null == this.keepAspect) {
            this.keepAspect = new SimpleBooleanProperty((Object)this, "keepAspect", this._keepAspect);
        }
        return this.keepAspect;
    }

    public boolean isAlert() {
        return null == this.alert ? this._alert : this.alert.get();
    }

    public void setAlert(boolean ALERT) {
        if (null == this.alert) {
            this._alert = ALERT;
            this.fireTileEvent(this.ALERT_EVENT);
        } else {
            this.alert.set(ALERT);
        }
    }

    public BooleanProperty alertProperty() {
        if (null == this.alert) {
            this.alert = new BooleanPropertyBase(this._alert){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.ALERT_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "alert";
                }
            };
        }
        return this.alert;
    }

    public String getAlertMessage() {
        return null == this.alertMessage ? this._alertMessage : (String)this.alertMessage.get();
    }

    public void setAlertMessage(String MESSAGE) {
        if (null == this.alertMessage) {
            this._alertMessage = MESSAGE;
            this.fireTileEvent(this.ALERT_EVENT);
        } else {
            this.alertMessage.set((Object)MESSAGE);
        }
    }

    public StringProperty alertMessageProperty() {
        if (null == this.alertMessage) {
            this.alertMessage = new StringPropertyBase(this._alertMessage){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.ALERT_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "alertMessage";
                }
            };
            this._alertMessage = null;
        }
        return this.alertMessage;
    }

    public boolean isSmoothing() {
        return null == this.smoothing ? this._smoothing : this.smoothing.get();
    }

    public void setSmoothing(boolean SMOOTHING) {
        if (null == this.smoothing) {
            this._smoothing = SMOOTHING;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.smoothing.set(SMOOTHING);
        }
    }

    public BooleanProperty smoothingProperty() {
        if (null == this.smoothing) {
            this.smoothing = new BooleanPropertyBase(this._smoothing){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "smoothing";
                }
            };
        }
        return this.smoothing;
    }

    public void calcAutoScale() {
        double maxNoOfMajorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(this.getRange(), false);
        double majorTickSpace = Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        double niceMinValue = Math.floor(this.getMinValue() / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(this.getMaxValue() / majorTickSpace) * majorTickSpace;
        this.setMinValue(niceMinValue);
        this.setMaxValue(niceMaxValue);
    }

    public ZonedDateTime getTime() {
        if (null == this.time) {
            final ZonedDateTime now = ZonedDateTime.now();
            this.time = new ObjectPropertyBase<ZonedDateTime>(now){

                protected void invalidated() {
                    Tile.this.zoneId = ((ZonedDateTime)this.get()).getZone();
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                    if (!Tile.this.isRunning() && Tile.this.isAnimated()) {
                        long animationDuration = Tile.this.getAnimationDuration();
                        Tile.this.timeline.stop();
                        KeyValue KEY_VALUE = new KeyValue((WritableValue)Tile.this.currentTime, (Object)now.toEpochSecond());
                        KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)animationDuration), new KeyValue[]{KEY_VALUE});
                        Tile.this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                        Tile.this.timeline.setOnFinished(e -> Tile.this.fireTileEvent(Tile.this.FINISHED_EVENT));
                        Tile.this.timeline.play();
                    } else {
                        Tile.this.currentTime.set(now.toEpochSecond());
                        Tile.this.fireTileEvent(Tile.this.FINISHED_EVENT);
                    }
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "time";
                }
            };
        }
        return (ZonedDateTime)this.time.get();
    }

    public void setTime(ZonedDateTime TIME) {
        this.time.set((Object)TIME);
    }

    public void setTime(long EPOCH_SECONDS) {
        this.time.set((Object)ZonedDateTime.ofInstant(Instant.ofEpochSecond(EPOCH_SECONDS), this.getZoneId()));
    }

    public ObjectProperty<ZonedDateTime> timeProperty() {
        return this.time;
    }

    public long getCurrentTime() {
        return this.currentTime.get();
    }

    public ReadOnlyLongProperty currentTimeProperty() {
        return this.currentTime;
    }

    public ZoneId getZoneId() {
        if (null == this.zoneId) {
            this.zoneId = this.getTime().getZone();
        }
        return this.zoneId;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new StringPropertyBase(this._text){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "text";
                }
            };
            this._text = null;
        }
        return this.text;
    }

    public TextAlignment getTextAlignment() {
        return null == this.textAlignment ? this._textAlignment : (TextAlignment)this.textAlignment.get();
    }

    public void setTextAlignment(TextAlignment ALIGNMENT) {
        if (null == this.textAlignment) {
            this._textAlignment = ALIGNMENT;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.textAlignment.set((Object)ALIGNMENT);
        }
    }

    public ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (null == this.textAlignment) {
            this.textAlignment = new ObjectPropertyBase<TextAlignment>(this._textAlignment){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "textAlignment";
                }
            };
            this._textAlignment = null;
        }
        return this.textAlignment;
    }

    public ObservableList<TimeSection> getTimeSections() {
        if (null == this.timeSections) {
            this.timeSections = FXCollections.observableArrayList();
        }
        return this.timeSections;
    }

    public void setTimeSections(List<TimeSection> SECTIONS) {
        this.getTimeSections().setAll(SECTIONS);
        this.getTimeSections().sort((Comparator)new TimeSectionComparator());
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public void setTimeSections(TimeSection ... SECTIONS) {
        this.setTimeSections(Arrays.asList(SECTIONS));
    }

    public void addTimeSection(TimeSection SECTION) {
        if (null == SECTION) {
            return;
        }
        this.getTimeSections().add((Object)SECTION);
        this.getTimeSections().sort((Comparator)new TimeSectionComparator());
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public void removeTimeSection(TimeSection SECTION) {
        if (null == SECTION) {
            return;
        }
        this.getTimeSections().remove((Object)SECTION);
        this.getTimeSections().sort((Comparator)new TimeSectionComparator());
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public void clearTimeSections() {
        this.getTimeSections().clear();
        this.fireTileEvent(this.SECTION_EVENT);
    }

    public boolean isDiscreteSeconds() {
        return null == this.discreteSeconds ? this._discreteSeconds : this.discreteSeconds.get();
    }

    public void setDiscreteSeconds(boolean DISCRETE) {
        if (null == this.discreteSeconds) {
            this._discreteSeconds = DISCRETE;
            this.stopTask(this.periodicTickTask);
            if (this.isAnimated()) {
                return;
            }
            this.scheduleTickTask();
        } else {
            this.discreteSeconds.set(DISCRETE);
        }
    }

    public BooleanProperty discreteSecondsProperty() {
        if (null == this.discreteSeconds) {
            this.discreteSeconds = new BooleanPropertyBase(){

                protected void invalidated() {
                    Tile.this.stopTask(Tile.this.periodicTickTask);
                    if (Tile.this.isAnimated()) {
                        return;
                    }
                    Tile.this.scheduleTickTask();
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "discreteSeconds";
                }
            };
        }
        return this.discreteSeconds;
    }

    public boolean isDiscreteMinutes() {
        return null == this.discreteMinutes ? this._discreteMinutes : this.discreteMinutes.get();
    }

    public void setDiscreteMinutes(boolean DISCRETE) {
        if (null == this.discreteMinutes) {
            this._discreteMinutes = DISCRETE;
            this.stopTask(this.periodicTickTask);
            if (this.isAnimated()) {
                return;
            }
            this.scheduleTickTask();
        } else {
            this.discreteMinutes.set(DISCRETE);
        }
    }

    public BooleanProperty discreteMinutesProperty() {
        if (null == this.discreteMinutes) {
            this.discreteMinutes = new BooleanPropertyBase(){

                protected void invalidated() {
                    Tile.this.stopTask(Tile.this.periodicTickTask);
                    if (Tile.this.isAnimated()) {
                        return;
                    }
                    Tile.this.scheduleTickTask();
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "discreteMinutes";
                }
            };
        }
        return this.discreteMinutes;
    }

    public boolean isDiscreteHours() {
        return null == this.discreteHours ? this._discreteHours : this.discreteHours.get();
    }

    public void setDiscreteHours(boolean DISCRETE) {
        if (null == this.discreteHours) {
            this._discreteHours = DISCRETE;
        } else {
            this.discreteHours.set(DISCRETE);
        }
    }

    public BooleanProperty discreteHoursProperty() {
        if (null == this.discreteHours) {
            this.discreteHours = new SimpleBooleanProperty((Object)this, "discreteHours", this._discreteHours);
        }
        return this.discreteHours;
    }

    public boolean isSecondsVisible() {
        return null == this.secondsVisible ? this._secondsVisible : this.secondsVisible.get();
    }

    public void setSecondsVisible(boolean VISIBLE) {
        if (null == this.secondsVisible) {
            this._secondsVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.secondsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty secondsVisibleProperty() {
        if (null == this.secondsVisible) {
            this.secondsVisible = new BooleanPropertyBase(this._secondsVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "secondsVisible";
                }
            };
        }
        return this.secondsVisible;
    }

    public boolean isTextVisible() {
        return null == this.textVisible ? this._textVisible : this.textVisible.get();
    }

    public void setTextVisible(boolean VISIBLE) {
        if (null == this.textVisible) {
            this._textVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.textVisible.set(VISIBLE);
        }
    }

    public BooleanProperty textVisibleProperty() {
        if (null == this.textVisible) {
            this.textVisible = new BooleanPropertyBase(this._textVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "textVisible";
                }
            };
        }
        return this.textVisible;
    }

    public boolean isDateVisible() {
        return null == this.dateVisible ? this._dateVisible : this.dateVisible.get();
    }

    public void setDateVisible(boolean VISIBLE) {
        if (null == this.dateVisible) {
            this._dateVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.dateVisible.set(VISIBLE);
        }
    }

    public BooleanProperty dateVisibleProperty() {
        if (null == this.dateVisible) {
            this.dateVisible = new BooleanPropertyBase(this._dateVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "dateVisible";
                }
            };
        }
        return this.dateVisible;
    }

    public boolean isRunning() {
        return null == this.running ? this._running : this.running.get();
    }

    public void setRunning(boolean RUNNING) {
        if (null == this.running) {
            this._running = RUNNING;
            if (RUNNING && !this.isAnimated()) {
                this.scheduleTickTask();
            } else {
                this.stopTask(this.periodicTickTask);
            }
        } else {
            this.running.set(RUNNING);
        }
    }

    public BooleanProperty runningProperty() {
        if (null == this.running) {
            this.running = new BooleanPropertyBase(this._running){

                protected void invalidated() {
                    if (this.get() && !Tile.this.isAnimated()) {
                        Tile.this.scheduleTickTask();
                    } else {
                        Tile.this.stopTask(Tile.this.periodicTickTask);
                    }
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "running";
                }
            };
        }
        return this.running;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public Color getDateColor() {
        return null == this.dateColor ? this._dateColor : (Color)this.dateColor.get();
    }

    public void setDateColor(Color COLOR) {
        if (null == this.dateColor) {
            this._dateColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.dateColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> dateColorProperty() {
        if (null == this.dateColor) {
            this.dateColor = new ObjectPropertyBase<Color>(this._dateColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "dateColor";
                }
            };
            this._dateColor = null;
        }
        return this.dateColor;
    }

    public Color getHourTickMarkColor() {
        return null == this.hourTickMarkColor ? this._hourTickMarkColor : (Color)this.hourTickMarkColor.get();
    }

    public void setHourTickMarkColor(Color COLOR) {
        if (null == this.hourTickMarkColor) {
            this._hourTickMarkColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.hourTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> hourTickMarkColorProperty() {
        if (null == this.hourTickMarkColor) {
            this.hourTickMarkColor = new ObjectPropertyBase<Color>(this._hourTickMarkColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "hourTickMarkColor";
                }
            };
            this._hourTickMarkColor = null;
        }
        return this.hourTickMarkColor;
    }

    public Color getMinuteTickMarkColor() {
        return null == this.minuteTickMarkColor ? this._minuteTickMarkColor : (Color)this.minuteTickMarkColor.get();
    }

    public void setMinuteTickMarkColor(Color COLOR) {
        if (null == this.minuteTickMarkColor) {
            this._minuteTickMarkColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.minuteTickMarkColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> minuteTickMarkColorProperty() {
        if (null == this.minuteTickMarkColor) {
            this.minuteTickMarkColor = new ObjectPropertyBase<Color>(this._minuteTickMarkColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "minuteTickMarkColor";
                }
            };
            this._minuteTickMarkColor = null;
        }
        return this.minuteTickMarkColor;
    }

    public Color getAlarmColor() {
        return null == this.alarmColor ? this._alarmColor : (Color)this.alarmColor.get();
    }

    public void setAlarmColor(Color COLOR) {
        if (null == this.alarmColor) {
            this._alarmColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.alarmColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> alarmColorProperty() {
        if (null == this.alarmColor) {
            this.alarmColor = new ObjectPropertyBase<Color>(this._alarmColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "alarmColor";
                }
            };
            this._alarmColor = null;
        }
        return this.alarmColor;
    }

    public boolean isHourTickMarksVisible() {
        return null == this.hourTickMarksVisible ? this._hourTickMarksVisible : this.hourTickMarksVisible.get();
    }

    public void setHourTickMarksVisible(boolean VISIBLE) {
        if (null == this.hourTickMarksVisible) {
            this._hourTickMarksVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.hourTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty hourTickMarksVisibleProperty() {
        if (null == this.hourTickMarksVisible) {
            this.hourTickMarksVisible = new BooleanPropertyBase(this._hourTickMarksVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "hourTickMarksVisible";
                }
            };
        }
        return this.hourTickMarksVisible;
    }

    public boolean isMinuteTickMarksVisible() {
        return null == this.minuteTickMarksVisible ? this._minuteTickMarksVisible : this.minuteTickMarksVisible.get();
    }

    public void setMinuteTickMarksVisible(boolean VISIBLE) {
        if (null == this.minuteTickMarksVisible) {
            this._minuteTickMarksVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.minuteTickMarksVisible.set(VISIBLE);
        }
    }

    public BooleanProperty minuteTickMarksVisibleProperty() {
        if (null == this.minuteTickMarksVisible) {
            this.minuteTickMarksVisible = new BooleanPropertyBase(this._minuteTickMarksVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "minuteTickMarksVisible";
                }
            };
        }
        return this.minuteTickMarksVisible;
    }

    public Color getHourColor() {
        return null == this.hourColor ? this._hourColor : (Color)this.hourColor.get();
    }

    public void setHourColor(Color COLOR) {
        if (null == this.hourColor) {
            this._hourColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.hourColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> hourColorProperty() {
        if (null == this.hourColor) {
            this.hourColor = new ObjectPropertyBase<Color>(this._hourColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "hourColor";
                }
            };
            this._hourColor = null;
        }
        return this.hourColor;
    }

    public Color getMinuteColor() {
        return null == this.minuteColor ? this._minuteColor : (Color)this.minuteColor.get();
    }

    public void setMinuteColor(Color COLOR) {
        if (null == this.minuteColor) {
            this._minuteColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.minuteColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> minuteColorProperty() {
        if (null == this.minuteColor) {
            this.minuteColor = new ObjectPropertyBase<Color>(this._minuteColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "minuteColor";
                }
            };
            this._minuteColor = null;
        }
        return this.minuteColor;
    }

    public Color getSecondColor() {
        return null == this.secondColor ? this._secondColor : (Color)this.secondColor.get();
    }

    public void setSecondColor(Color COLOR) {
        if (null == this.secondColor) {
            this._secondColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.secondColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> secondColorProperty() {
        if (null == this.secondColor) {
            this.secondColor = new ObjectPropertyBase<Color>(this._secondColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "secondColor";
                }
            };
            this._secondColor = null;
        }
        return this.secondColor;
    }

    public boolean isAlarmsEnabled() {
        return null == this.alarmsEnabled ? this._alarmsEnabled : this.alarmsEnabled.get();
    }

    public void setAlarmsEnabled(boolean CHECK) {
        if (null == this.alarmsEnabled) {
            this._alarmsEnabled = CHECK;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.alarmsEnabled.set(CHECK);
        }
    }

    public BooleanProperty alarmsEnabledProperty() {
        if (null == this.alarmsEnabled) {
            this.alarmsEnabled = new BooleanPropertyBase(this._alarmsEnabled){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "alarmsEnabled";
                }
            };
        }
        return this.alarmsEnabled;
    }

    public boolean isAlarmsVisible() {
        return null == this.alarmsVisible ? this._alarmsVisible : this.alarmsVisible.get();
    }

    public void setAlarmsVisible(boolean VISIBLE) {
        if (null == this.alarmsVisible) {
            this._alarmsVisible = VISIBLE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.alarmsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty alarmsVisibleProperty() {
        if (null == this.alarmsVisible) {
            this.alarmsVisible = new BooleanPropertyBase(this._alarmsVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "alarmsVisible";
                }
            };
        }
        return this.alarmsVisible;
    }

    public ObservableList<Alarm> getAlarms() {
        if (null == this.alarms) {
            this.alarms = FXCollections.observableArrayList();
        }
        return this.alarms;
    }

    public void setAlarms(List<Alarm> ALARMS) {
        this.getAlarms().setAll(ALARMS);
    }

    public void setAlarms(Alarm ... ALARMS) {
        this.setAlarms(Arrays.asList(ALARMS));
    }

    public void addAlarm(Alarm ALARM) {
        if (!this.getAlarms().contains((Object)ALARM)) {
            this.getAlarms().add((Object)ALARM);
        }
    }

    public void removeAlarm(Alarm ALARM) {
        if (this.getAlarms().contains((Object)ALARM)) {
            this.getAlarms().remove((Object)ALARM);
        }
    }

    public void clearAlarms() {
        this.getAlarms().clear();
    }

    public String getTooltipText() {
        return null == this.tooltipText ? this._tooltipText : (String)this.tooltipText.get();
    }

    public void setTooltipText(String TEXT) {
        if (null == this.tooltipText) {
            this.tooltip.setText(TEXT);
            if (null == TEXT || TEXT.isEmpty()) {
                this.setTooltip(null);
            } else {
                this.setTooltip(this.tooltip);
            }
        } else {
            this.tooltipText.set((Object)TEXT);
        }
    }

    public StringProperty tooltipTextProperty() {
        if (null == this.tooltipText) {
            this.tooltipText = new StringPropertyBase(){

                protected void invalidated() {
                    Tile.this.tooltip.setText(this.get());
                    if (null == this.get() || this.get().isEmpty()) {
                        Tile.this.setTooltip(null);
                    } else {
                        Tile.this.setTooltip(Tile.this.tooltip);
                    }
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "tooltipText";
                }
            };
            this._tooltipText = null;
        }
        return this.tooltipText;
    }

    public Axis getXAxis() {
        return null == this.xAxis ? this._xAxis : (Axis)this.xAxis.get();
    }

    public void setXAxis(Axis AXIS) {
        if (null == this.xAxis) {
            this._xAxis = AXIS;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.xAxis.set((Object)AXIS);
        }
    }

    public ObjectProperty<Axis> xAxisProperty() {
        if (null == this.xAxis) {
            this.xAxis = new ObjectPropertyBase<Axis>(this._xAxis){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "xAxis";
                }
            };
            this._xAxis = null;
        }
        return this.xAxis;
    }

    public Axis getYAxis() {
        return null == this.yAxis ? this._yAxis : (Axis)this.yAxis.get();
    }

    public void setYAxis(Axis AXIS) {
        if (null == this.yAxis) {
            this._yAxis = AXIS;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.yAxis.set((Object)AXIS);
        }
    }

    public ObjectProperty<Axis> yAxisProperty() {
        if (null == this.yAxis) {
            this.yAxis = new ObjectPropertyBase<Axis>(this._yAxis){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "yAxis";
                }
            };
            this._yAxis = null;
        }
        return this.yAxis;
    }

    public RadarChart.Mode getRadarChartMode() {
        return null == this.radarChartMode ? this._radarChartMode : (RadarChart.Mode)((Object)this.radarChartMode.get());
    }

    public void setRadarChartMode(RadarChart.Mode MODE) {
        if (null == this.radarChartMode) {
            this._radarChartMode = MODE;
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.radarChartMode.set((Object)MODE);
        }
    }

    public ObjectProperty<RadarChart.Mode> radarChartModeProperty() {
        if (null == this.radarChartMode) {
            this.radarChartMode = new ObjectPropertyBase<RadarChart.Mode>(this._radarChartMode){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "radarChartMode";
                }
            };
            this._radarChartMode = null;
        }
        return this.radarChartMode;
    }

    public Color getChartGridColor() {
        return null == this.chartGridColor ? this._chartGridColor : (Color)this.chartGridColor.get();
    }

    public void setChartGridColor(Color COLOR) {
        if (null == this.chartGridColor) {
            this._chartGridColor = COLOR;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.chartGridColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> chartGridColorProperty() {
        if (null == this.chartGridColor) {
            this.chartGridColor = new ObjectPropertyBase<Color>(this._chartGridColor){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "chartGridColor";
                }
            };
            this._chartGridColor = null;
        }
        return this.chartGridColor;
    }

    public Country getCountry() {
        if (null == this._country && null == this.country) {
            this._country = Country.DE;
        }
        return null == this.country ? this._country : (Country)((Object)this.country.get());
    }

    public void setCountry(Country COUNTRY) {
        if (null == this.country) {
            this._country = COUNTRY;
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.country.set((Object)COUNTRY);
        }
    }

    public ObjectProperty<Country> countryProperty() {
        if (null == this.country) {
            this.country = new ObjectPropertyBase<Country>(this._country){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "country";
                }
            };
            this._country = null;
        }
        return this.country;
    }

    public CountryGroup getCountryGroup() {
        if (null == this._countryGroup && null == this.countryGroup) {
            this._countryGroup = Helper.EU;
        }
        return null == this.countryGroup ? this._countryGroup : (CountryGroup)this.countryGroup.get();
    }

    public void setCountryGroup(CountryGroup GROUP) {
        if (null == this.countryGroup) {
            this._countryGroup = GROUP;
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.countryGroup.set((Object)GROUP);
        }
    }

    public ObjectProperty<CountryGroup> countryGroupProperty() {
        if (null == this.countryGroup) {
            this.countryGroup = new ObjectPropertyBase<CountryGroup>(this._countryGroup){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "countryGroup";
                }
            };
            this._countryGroup = null;
        }
        return this.countryGroup;
    }

    public boolean isSortedData() {
        return null == this.sortedData ? this._sortedData : this.sortedData.get();
    }

    public void setSortedData(boolean SORTED) {
        if (null == this.sortedData) {
            this._sortedData = SORTED;
            this.fireTileEvent(this.DATA_EVENT);
        } else {
            this.sortedData.set(SORTED);
        }
    }

    public BooleanProperty sortedDataProperty() {
        if (null == this.sortedData) {
            this.sortedData = new BooleanPropertyBase(this._sortedData){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.DATA_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "sortedData";
                }
            };
        }
        return this.sortedData;
    }

    public boolean getDataPointsVisible() {
        return null == this.dataPointsVisible ? this._dataPointsVisible : this.dataPointsVisible.get();
    }

    public void setDataPointsVisible(boolean VISIBLE) {
        if (null == this.dataPointsVisible) {
            this._dataPointsVisible = VISIBLE;
            this.fireTileEvent(this.VISIBILITY_EVENT);
        } else {
            this.dataPointsVisible.set(VISIBLE);
        }
    }

    public BooleanProperty dataPointsVisibleProperty() {
        if (null == this.dataPointsVisible) {
            this.dataPointsVisible = new BooleanPropertyBase(this._dataPointsVisible){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.VISIBILITY_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "dataPointsVisible";
                }
            };
        }
        return this.dataPointsVisible;
    }

    public boolean isSnapToTicks() {
        return null == this.snapToTicks ? this._snapToTicks : this.snapToTicks.get();
    }

    public void setSnapToTicks(boolean SNAP) {
        if (null == this.snapToTicks) {
            this._snapToTicks = SNAP;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.snapToTicks.set(SNAP);
        }
    }

    public BooleanProperty snapToTicksProperty() {
        if (null == this.snapToTicks) {
            this.snapToTicks = new BooleanPropertyBase(this._snapToTicks){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "snapToTicks";
                }
            };
        }
        return this.snapToTicks;
    }

    public int getMinorTickCount() {
        return this._minorTickCount;
    }

    public void setMinorTickCount(int MINOR_TICK_COUNT) {
        this._minorTickCount = Helper.clamp(0, 10, MINOR_TICK_COUNT);
    }

    public double getMajorTickUnit() {
        return this._majorTickUnit;
    }

    public void setMajorTickUnit(double MAJOR_TICK_UNIT) {
        this._majorTickUnit = Double.compare(MAJOR_TICK_UNIT, 0.0) <= 0 ? 0.25 : MAJOR_TICK_UNIT;
    }

    public int[] getMatrixSize() {
        return this._matrixSize;
    }

    public void setMatrixSize(int[] COLUMNS_AND_ROWS) {
        this.setMatrixSize(COLUMNS_AND_ROWS[0], COLUMNS_AND_ROWS[1]);
    }

    public void setMatrixSize(int COLUMNS, int ROWS) {
        this._matrixSize = new int[]{Helper.clamp(2, 1000, COLUMNS), Helper.clamp(2, 1000, ROWS)};
        this.fireTileEvent(this.RECALC_EVENT);
    }

    public ChartType getChartType() {
        return this._chartType;
    }

    public void setChartType(ChartType TYPE) {
        this._chartType = TYPE;
        this.fireTileEvent(this.SERIES_EVENT);
    }

    public double getTooltipTimeout() {
        return null == this.tooltipTimeout ? this._tooltipTimeout : this.tooltipTimeout.get();
    }

    public void setTooltipTimeout(double TIMEOUT) {
        if (null == this.tooltipTimeout) {
            this._tooltipTimeout = Helper.clamp(0.0, 10000.0, TIMEOUT);
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.tooltipTimeout.set(TIMEOUT);
        }
    }

    public DoubleProperty tooltipTimeoutProperty() {
        if (null == this.tooltipTimeout) {
            this.tooltipTimeout = new DoublePropertyBase(this._tooltipTimeout){

                protected void invalidated() {
                    this.set(Helper.clamp(0.0, 10000.0, this.get()));
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "tootipTimeout";
                }
            };
        }
        return this.tooltipTimeout;
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setIncrement(double INCREMENT) {
        this.increment = Helper.clamp(0.0, 10.0, INCREMENT);
    }

    public boolean isCustomFontEnabled() {
        return null == this.customFontEnabled ? this._customFontEnabled : this.customFontEnabled.get();
    }

    public void setCustomFontEnabled(boolean ENABLED) {
        if (null == this.customFontEnabled) {
            this._customFontEnabled = ENABLED;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.customFontEnabled.set(ENABLED);
        }
    }

    public BooleanProperty customFontEnabledProperty() {
        if (null == this.customFontEnabled) {
            this.customFontEnabled = new BooleanPropertyBase(this._customFontEnabled){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "customFontEnabled";
                }
            };
        }
        return this.customFontEnabled;
    }

    public Font getCustomFont() {
        return null == this.customFont ? this._customFont : (Font)this.customFont.get();
    }

    public void setCustomFont(Font FONT) {
        if (null == this.customFont) {
            this._customFont = FONT;
            this.fireTileEvent(this.RESIZE_EVENT);
        } else {
            this.customFont.set((Object)FONT);
        }
    }

    public ObjectProperty<Font> customFontProperty() {
        if (null == this.customFont) {
            this.customFont = new ObjectPropertyBase<Font>(){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RESIZE_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "customFont";
                }
            };
            this._customFont = null;
        }
        return this.customFont;
    }

    public Map<String, List<CountryPath>> getCountryPaths() {
        return Helper.getLoresCountryPaths();
    }

    public boolean isStrokeWithGradient() {
        return null == this.strokeWithGradient ? this._strokeWithGradient : this.strokeWithGradient.get();
    }

    public void setStrokeWithGradient(boolean STROKE_WITH_GRADIENT) {
        if (null == this.strokeWithGradient) {
            this._strokeWithGradient = STROKE_WITH_GRADIENT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.strokeWithGradient.set(STROKE_WITH_GRADIENT);
        }
    }

    public BooleanProperty strokeWithGradientProperty() {
        if (null == this.strokeWithGradient) {
            this.strokeWithGradient = new BooleanPropertyBase(this._strokeWithGradient){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "strokeWithGradient";
                }
            };
        }
        return this.strokeWithGradient;
    }

    public boolean isFillWithGradient() {
        return null == this.fillWithGradient ? this._fillWithGradient : this.fillWithGradient.get();
    }

    public void setFillWithGradient(boolean FILL_WITH_GRADIENT) {
        if (null == this.fillWithGradient) {
            this._fillWithGradient = FILL_WITH_GRADIENT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.fillWithGradient.set(FILL_WITH_GRADIENT);
        }
    }

    public BooleanProperty fillWithGradientProperty() {
        if (null == this.fillWithGradient) {
            this.fillWithGradient = new BooleanPropertyBase(this._fillWithGradient){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "fillWithGradient";
                }
            };
        }
        return this.fillWithGradient;
    }

    public DarkSky getDarkSky() {
        return this.darkSky;
    }

    public void setDarkSky(DarkSky DARK_SKY) {
        this.darkSky = DARK_SKY;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public void updateWeather() {
        if (null == this.darkSky) {
            return;
        }
        if (!this.darkSky.update()) {
            throw new IllegalArgumentException("Do you use a valid DarkSKY API key?");
        }
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public Color getNotifyRegionBackgroundColor() {
        return this._notifyRegionBackgroundColor;
    }

    public void setNotifyRegionBackgroundColor(Color COLOR) {
        this._notifyRegionBackgroundColor = COLOR;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public Color getNotifyRegionForegroundColor() {
        return this._notifyRegionForegroundColor;
    }

    public void setNotifyRegionForegroundColor(Color COLOR) {
        this._notifyRegionForegroundColor = COLOR;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public Color getInfoRegionBackgroundColor() {
        return this._infoRegionBackgroundColor;
    }

    public void setInfoRegionBackgroundColor(Color COLOR) {
        this._infoRegionBackgroundColor = COLOR;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public Color getInfoRegionForegroundColor() {
        return this._infoRegionForegroundColor;
    }

    public void setInfoRegionForegroundColor(Color COLOR) {
        this._infoRegionForegroundColor = COLOR;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public String getInfoRegionTooltipText() {
        return this._infoRegionTooltipText;
    }

    public void setInfoRegionTooltipText(String TEXT) {
        this._infoRegionTooltipText = TEXT;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public Image getBackgroundImage() {
        return this._backgroundImage;
    }

    public void setBackgroundImage(Image IMAGE) {
        this._backgroundImage = IMAGE;
        this.fireTileEvent(this.BKG_IMAGE_EVENT);
    }

    public double getBackgroundImageOpacity() {
        return this._backgroundImageOpacity;
    }

    public void setBackgroundImageOpacity(double OPACITY) {
        this._backgroundImageOpacity = Helper.clamp(0.0, 1.0, OPACITY);
        if (null == this._backgroundImage) {
            return;
        }
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public boolean getBackgroundImageKeepAspect() {
        return this._backgroundImageKeepAspect;
    }

    public void setBackgroundImageKeepAspect(boolean KEEP_ASPECT) {
        this._backgroundImageKeepAspect = KEEP_ASPECT;
        this.fireTileEvent(this.REDRAW_EVENT);
    }

    public String getLeftText() {
        return null == this.leftText ? this._leftText : (String)this.leftText.get();
    }

    public void setLeftText(String TEXT) {
        if (null == this.leftText) {
            this._leftText = TEXT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.leftText.set((Object)TEXT);
        }
    }

    public StringProperty leftTextProperty() {
        if (null == this.leftText) {
            this.leftText = new StringPropertyBase(this._leftText){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "leftText";
                }
            };
            this._leftText = null;
        }
        return this.leftText;
    }

    public String getMiddleText() {
        return null == this.middleText ? this._middleText : (String)this.middleText.get();
    }

    public void setMiddleText(String TEXT) {
        if (null == this.middleText) {
            this._middleText = TEXT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.middleText.set((Object)TEXT);
        }
    }

    public StringProperty middleTextProperty() {
        if (null == this.middleText) {
            this.middleText = new StringPropertyBase(this._middleText){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "middleText";
                }
            };
            this._middleText = null;
        }
        return this.middleText;
    }

    public String getRightText() {
        return null == this.rightText ? this._rightText : (String)this.rightText.get();
    }

    public void setRightText(String TEXT) {
        if (null == this.rightText) {
            this._rightText = TEXT;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.rightText.set((Object)TEXT);
        }
    }

    public StringProperty rightTextProperty() {
        if (null == this.rightText) {
            this.rightText = new StringPropertyBase(this._rightText){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "rightText";
                }
            };
            this._rightText = null;
        }
        return this.rightText;
    }

    public double getLeftValue() {
        return null == this.leftValue ? this._leftValue : this.leftValue.get();
    }

    public void setLeftValue(double VALUE) {
        if (null == this.leftValue) {
            this._leftValue = VALUE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.leftValue.set(VALUE);
        }
    }

    public DoubleProperty leftValueProperty() {
        if (null == this.leftValue) {
            this.leftValue = new DoublePropertyBase(this._leftValue){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "leftValue";
                }
            };
        }
        return this.leftValue;
    }

    public double getMiddleValue() {
        return null == this.middleValue ? this._middleValue : this.middleValue.get();
    }

    public void setMiddleValue(double VALUE) {
        if (null == this.middleValue) {
            this._middleValue = VALUE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.middleValue.set(VALUE);
        }
    }

    public DoubleProperty middleValueProperty() {
        if (null == this.middleValue) {
            this.middleValue = new DoublePropertyBase(this._middleValue){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "middleValue";
                }
            };
        }
        return this.middleValue;
    }

    public double getRightValue() {
        return null == this.rightValue ? this._rightValue : this.rightValue.get();
    }

    public void setRightValue(double VALUE) {
        if (null == this.rightValue) {
            this._rightValue = VALUE;
            this.fireTileEvent(this.REDRAW_EVENT);
        } else {
            this.rightValue.set(VALUE);
        }
    }

    public DoubleProperty rightValueProperty() {
        if (null == this.rightValue) {
            this.rightValue = new DoublePropertyBase(this._rightValue){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.REDRAW_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "rightValue";
                }
            };
        }
        return this.rightValue;
    }

    public Node getLeftGraphics() {
        return null == this.leftGraphics ? this._leftGraphics : (Node)this.leftGraphics.get();
    }

    public void setLeftGraphics(Node NODE) {
        if (null == this.leftGraphics) {
            this._leftGraphics = NODE;
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.leftGraphics.set((Object)NODE);
        }
    }

    public ObjectProperty<Node> leftGraphicsProperty() {
        if (null == this.leftGraphics) {
            this.leftGraphics = new ObjectPropertyBase<Node>(this._leftGraphics){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "leftGraphics";
                }
            };
            this._leftGraphics = null;
        }
        return this.leftGraphics;
    }

    public Node getMiddleGraphics() {
        return null == this.middleGraphics ? this._middleGraphics : (Node)this.middleGraphics.get();
    }

    public void setMiddleGraphics(Node NODE) {
        if (null == this.middleGraphics) {
            this._middleGraphics = NODE;
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.middleGraphics.set((Object)NODE);
        }
    }

    public ObjectProperty<Node> middleGraphicsProperty() {
        if (null == this.middleGraphics) {
            this.middleGraphics = new ObjectPropertyBase<Node>(this._middleGraphics){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "middleGraphics";
                }
            };
            this._middleGraphics = null;
        }
        return this.middleGraphics;
    }

    public Node getRightGraphics() {
        return null == this.rightGraphics ? this._rightGraphics : (Node)this.rightGraphics.get();
    }

    public void setRightGraphics(Node NODE) {
        if (null == this.rightGraphics) {
            this._rightGraphics = NODE;
            this.fireTileEvent(this.RECALC_EVENT);
        } else {
            this.rightGraphics.set((Object)NODE);
        }
    }

    public ObjectProperty<Node> rightGraphicsProperty() {
        if (null == this.rightGraphics) {
            this.rightGraphics = new ObjectPropertyBase<Node>(this._rightGraphics){

                protected void invalidated() {
                    Tile.this.fireTileEvent(Tile.this.RECALC_EVENT);
                }

                public Object getBean() {
                    return Tile.this;
                }

                public String getName() {
                    return "rightGraphics";
                }
            };
            this._rightGraphics = null;
        }
        return this.rightGraphics;
    }

    public void showNotifyRegion(boolean SHOW) {
        this.fireTileEvent(SHOW ? this.SHOW_NOTIFY_REGION_EVENT : this.HIDE_NOTIFY_REGION_EVENT);
    }

    public void showInfoRegion(boolean SHOW) {
        this.fireTileEvent(SHOW ? this.SHOW_INFO_REGION_EVENT : this.HIDE_INFO_REGION_EVENT);
    }

    public EventHandler<MouseEvent> getInfoRegionHandler() {
        return this.infoRegionHandler;
    }

    public void setInfoRegionEventHandler(EventHandler<MouseEvent> HANDLER) {
        this.infoRegionHandler = HANDLER;
        this.fireTileEvent(this.INFO_REGION_HANDLER_EVENT);
    }

    public boolean isShowing() {
        return null == this.showing ? false : this.showing.get();
    }

    private Properties readProperties(String FILE_NAME) {
        ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
        Properties PROPERTIES = new Properties();
        try (InputStream resourceStream = LOADER.getResourceAsStream(FILE_NAME);){
            PROPERTIES.load(resourceStream);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return PROPERTIES;
    }

    private void checkAlarms(ZonedDateTime TIME) {
        if (null == this.alarmsToRemove) {
            this.alarmsToRemove = new ArrayList<Alarm>();
        }
        this.alarmsToRemove.clear();
        for (Alarm alarm : this.alarms) {
            ZonedDateTime ALARM_TIME = alarm.getTime();
            switch (alarm.getRepetition()) {
                case ONCE: {
                    if (!TIME.isAfter(ALARM_TIME)) break;
                    if (alarm.isArmed()) {
                        this.fireAlarmEvent(new AlarmEvent(alarm));
                        alarm.executeCommand();
                    }
                    this.alarmsToRemove.add(alarm);
                    break;
                }
                case HALF_HOURLY: {
                    if (ALARM_TIME.getMinute() != TIME.getMinute() && ALARM_TIME.plusMinutes(30L).getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent(alarm));
                    alarm.executeCommand();
                    break;
                }
                case HOURLY: {
                    if (ALARM_TIME.getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent(alarm));
                    alarm.executeCommand();
                    break;
                }
                case DAILY: {
                    if (ALARM_TIME.getHour() != TIME.getHour() || ALARM_TIME.getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent(alarm));
                    alarm.executeCommand();
                    break;
                }
                case WEEKLY: {
                    if (ALARM_TIME.getDayOfWeek() != TIME.getDayOfWeek() || ALARM_TIME.getHour() != TIME.getHour() || ALARM_TIME.getMinute() != TIME.getMinute() || ALARM_TIME.getSecond() != TIME.getSecond() || !alarm.isArmed()) break;
                    this.fireAlarmEvent(new AlarmEvent(alarm));
                    alarm.executeCommand();
                }
            }
        }
        for (Alarm alarm : this.alarmsToRemove) {
            this.removeAlarm(alarm);
        }
    }

    private void tick() {
        Platform.runLater(() -> {
            ZonedDateTime oldTime = this.getTime();
            this.setTime(this.getTime().plus(java.time.Duration.ofMillis(this.updateInterval)));
            ZonedDateTime now = (ZonedDateTime)this.time.get();
            if (this.isAlarmsEnabled()) {
                this.checkAlarms(now);
            }
            if (this.getCheckSectionsForValue() && this.timeSections != null) {
                for (TimeSection timeSection : this.timeSections) {
                    timeSection.checkForTimeAndDate(now);
                }
            }
            if (this.timeEventListeners.isEmpty()) {
                return;
            }
            if (oldTime.getSecond() != now.getSecond()) {
                this.fireTimeEvent(new TimeEvent((Object)this, now, TimeEvent.TimeEventType.SECOND));
            }
            if (oldTime.getMinute() != now.getMinute()) {
                this.fireTimeEvent(new TimeEvent((Object)this, now, TimeEvent.TimeEventType.MINUTE));
            }
            if (oldTime.getHour() != now.getHour()) {
                this.fireTimeEvent(new TimeEvent((Object)this, now, TimeEvent.TimeEventType.HOUR));
            }
        });
    }

    private synchronized void enableTickExecutorService() {
        if (null == periodicTickExecutorService) {
            periodicTickExecutorService = new ScheduledThreadPoolExecutor(1, Tile.getThreadFactory("TileTick", true));
        }
    }

    private synchronized void scheduleTickTask() {
        this.enableTickExecutorService();
        this.stopTask(this.periodicTickTask);
        this.updateInterval = this.isDiscreteMinutes() && this.isDiscreteSeconds() ? 1000 : 20;
        this.periodicTickTask = periodicTickExecutorService.scheduleAtFixedRate(() -> this.tick(), 0L, this.updateInterval, TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    public void stop() {
        if (null != this.periodicTickTask) {
            this.stopTask(this.periodicTickTask);
        }
        if (null != periodicTickExecutorService) {
            periodicTickExecutorService.shutdownNow();
        }
    }

    private void createShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
    }

    public void setOnTileEvent(TileEventListener LISTENER) {
        this.addTileEventListener(LISTENER);
    }

    public void addTileEventListener(TileEventListener LISTENER) {
        if (!this.tileEventListeners.contains(LISTENER)) {
            this.tileEventListeners.add(LISTENER);
        }
    }

    public void removeTileEventListener(TileEventListener LISTENER) {
        if (this.tileEventListeners.contains(LISTENER)) {
            this.tileEventListeners.remove(LISTENER);
        }
    }

    public void removeAllTileEventListeners() {
        this.tileEventListeners.clear();
    }

    public void fireTileEvent(TileEvent EVENT) {
        if (null != this.showing && this.showing.get()) {
            for (TileEventListener listener : this.tileEventListeners) {
                listener.onTileEvent(EVENT);
            }
        } else {
            this.tileEventQueue.add(EVENT);
        }
    }

    public void setOnAlarm(AlarmEventListener LISTENER) {
        this.addAlarmEventListener(LISTENER);
    }

    public void addAlarmEventListener(AlarmEventListener LISTENER) {
        if (!this.alarmEventListeners.contains(LISTENER)) {
            this.alarmEventListeners.add(LISTENER);
        }
    }

    public void removeAlarmEventListener(AlarmEventListener LISTENER) {
        if (this.alarmEventListeners.contains(LISTENER)) {
            this.alarmEventListeners.remove(LISTENER);
        }
    }

    public void removeAllAlarmEventListeners() {
        this.alarmEventListeners.clear();
    }

    public void fireAlarmEvent(AlarmEvent EVENT) {
        for (AlarmEventListener listener : this.alarmEventListeners) {
            listener.onAlarmEvent(EVENT);
        }
    }

    public void setOnTimeEvent(TimeEventListener LISTENER) {
        this.addTimeEventListener(LISTENER);
    }

    public void addTimeEventListener(TimeEventListener LISTENER) {
        if (!this.timeEventListeners.contains(LISTENER)) {
            this.timeEventListeners.add(LISTENER);
        }
    }

    public void removeTimeEventListener(TimeEventListener LISTENER) {
        if (this.timeEventListeners.contains(LISTENER)) {
            this.timeEventListeners.remove(LISTENER);
        }
    }

    public void removeAllTimeEventListeners() {
        this.timeEventListeners.clear();
    }

    public void fireTimeEvent(TimeEvent EVENT) {
        for (TimeEventListener listener : this.timeEventListeners) {
            listener.onTimeEvent(EVENT);
        }
    }

    public void setOnSwitchPressed(EventHandler<SwitchEvent> HANDLER) {
        this.addEventHandler(SwitchEvent.SWITCH_PRESSED, HANDLER);
    }

    public void removeOnSwitchPressed(EventHandler<SwitchEvent> HANDLER) {
        this.removeEventHandler(SwitchEvent.SWITCH_PRESSED, HANDLER);
    }

    public void setOnSwitchReleased(EventHandler<SwitchEvent> HANDLER) {
        this.addEventHandler(SwitchEvent.SWITCH_RELEASED, HANDLER);
    }

    public void removeOnSwitchReleased(EventHandler<SwitchEvent> HANDLER) {
        this.removeEventHandler(SwitchEvent.SWITCH_RELEASED, HANDLER);
    }

    private void setupBinding() {
        this.showing = Bindings.createBooleanBinding(() -> {
            if (this.getScene() != null && this.getScene().getWindow() != null) {
                return this.getScene().getWindow().isShowing();
            }
            return false;
        }, (Observable[])new Observable[]{this.sceneProperty(), this.getScene().windowProperty(), this.getScene().getWindow().showingProperty()});
        this.showing.addListener(o -> {
            if (this.showing.get()) {
                while (this.tileEventQueue.peek() != null) {
                    TileEvent event = this.tileEventQueue.poll();
                    for (TileEventListener listener : this.tileEventListeners) {
                        listener.onTileEvent(event);
                    }
                }
            }
            this.fireTileEvent(this.REGIONS_ON_TOP_EVENT);
            this.fireTileEvent(this.RESIZE_EVENT);
        });
    }

    protected Skin createDefaultSkin() {
        switch (this.skinType) {
            case SMOOTHED_CHART: {
                return new SmoothedChartTileSkin(this);
            }
            case BAR_CHART: {
                return new BarChartTileSkin(this);
            }
            case CLOCK: {
                return new ClockTileSkin(this);
            }
            case GAUGE: {
                return new GaugeTileSkin(this);
            }
            case HIGH_LOW: {
                return new HighLowTileSkin(this);
            }
            case PERCENTAGE: {
                return new PercentageTileSkin(this);
            }
            case PLUS_MINUS: {
                return new PlusMinusTileSkin(this);
            }
            case SLIDER: {
                return new SliderTileSkin(this);
            }
            case SPARK_LINE: {
                return new SparkLineTileSkin(this);
            }
            case SWITCH: {
                return new SwitchTileSkin(this);
            }
            case WORLDMAP: {
                return new WorldMapTileSkin(this);
            }
            case TIMER_CONTROL: {
                return new TimerControlTileSkin(this);
            }
            case NUMBER: {
                return new NumberTileSkin(this);
            }
            case TEXT: {
                return new TextTileSkin(this);
            }
            case WEATHER: {
                return new WeatherTileSkin(this);
            }
            case TIME: {
                return new TimeTileSkin(this);
            }
            case CUSTOM: {
                return new CustomTileSkin(this);
            }
            case LEADER_BOARD: {
                return new LeaderBoardTileSkin(this);
            }
            case MAP: {
                return new MapTileSkin(this);
            }
            case RADIAL_CHART: {
                return new RadialChartTileSkin(this);
            }
            case DONUT_CHART: {
                return new DonutChartTileSkin(this);
            }
            case CIRCULAR_PROGRESS: {
                return new CircularProgressTileSkin(this);
            }
            case STOCK: {
                return new StockTileSkin(this);
            }
            case GAUGE_SPARK_LINE: {
                return new GaugeSparkLineTileSkin(this);
            }
            case SMOOTH_AREA_CHART: {
                return new SmoothAreaChartTileSkin(this);
            }
            case RADAR_CHART: {
                return new RadarChartTileSkin(this);
            }
            case COUNTRY: {
                return new CountryTileSkin(this);
            }
            case EPHEMERIS: {
                return new EphemerisTileSkin(this);
            }
            case CHARACTER: {
                return new CharacterTileSkin(this);
            }
            case FLIP: {
                return new FlipTileSkin(this);
            }
            case SWITCH_SLIDER: {
                return new SwitchSliderTileSkin(this);
            }
            case DATE: {
                return new DateTileSkin(this);
            }
            case CALENDAR: {
                return new CalendarTileSkin(this);
            }
            case SUNBURST: {
                return new SunburstChartTileSkin(this);
            }
            case MATRIX: {
                return new MatrixTileSkin(this);
            }
            case RADIAL_PERCENTAGE: {
                return new RadialPercentageTileSkin(this);
            }
            case STATUS: {
                return new StatusTileSkin(this);
            }
            case BAR_GAUGE: {
                return new BarGaugeTileSkin(this);
            }
            case IMAGE: {
                return new ImageTileSkin(this);
            }
        }
        return new TileSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("tilesfx.css").toExternalForm();
    }

    private void presetTileParameters(SkinType SKIN_TYPE) {
        switch (SKIN_TYPE) {
            case SMOOTHED_CHART: {
                break;
            }
            case BAR_CHART: {
                break;
            }
            case CLOCK: {
                break;
            }
            case GAUGE: {
                this.setAnimated(true);
                this.setTickLabelDecimals(0);
                this.setBarColor(FOREGROUND);
                this.setThresholdColor(BLUE);
                this.setThresholdVisible(true);
                break;
            }
            case HIGH_LOW: {
                this.setMaxValue(Double.MAX_VALUE);
                this.setDecimals(2);
                this.setTickLabelDecimals(1);
                break;
            }
            case PERCENTAGE: {
                this.setAnimated(true);
                this.setThresholdColor(GRAY);
                this.setTickLabelDecimals(0);
                break;
            }
            case PLUS_MINUS: {
                break;
            }
            case SLIDER: {
                this.setBarBackgroundColor(FOREGROUND);
                break;
            }
            case SPARK_LINE: {
                this.setTextVisible(false);
                this.setAnimated(false);
                this.setAveragingEnabled(true);
                this.setAveragingPeriod(10);
                this.setDecimals(0);
                this.setTickLabelDecimals(0);
                break;
            }
            case SWITCH: {
                break;
            }
            case WORLDMAP: {
                this.setPrefSize(380.0, 250.0);
                break;
            }
            case TIMER_CONTROL: {
                this.setSectionsVisible(true);
                this.setHighlightSections(true);
                this.setCheckSectionsForValue(true);
                break;
            }
            case NUMBER: {
                break;
            }
            case TEXT: {
                break;
            }
            case WEATHER: {
                break;
            }
            case TIME: {
                break;
            }
            case CUSTOM: {
                break;
            }
            case LEADER_BOARD: {
                break;
            }
            case MAP: {
                break;
            }
            case RADIAL_CHART: {
                this.setAnimated(true);
                break;
            }
            case DONUT_CHART: {
                this.setAnimated(true);
                break;
            }
            case CIRCULAR_PROGRESS: {
                this.setBarBackgroundColor(this.getBackgroundColor().brighter());
                this.setAnimated(true);
                break;
            }
            case STOCK: {
                this.setAnimated(false);
                this.setAveragingPeriod(720);
                this.setAveragingEnabled(true);
                this.setDecimals(2);
                this.setTickLabelDecimals(2);
                this.setThresholdColor(GRAY);
                this.setTextVisible(false);
                break;
            }
            case GAUGE_SPARK_LINE: {
                this.setBarColor(BLUE);
                this.setAngleRange(270.0);
                break;
            }
            case SMOOTH_AREA_CHART: {
                this.setSmoothing(true);
                this.setChartType(ChartType.AREA);
                break;
            }
            case RADAR_CHART: {
                break;
            }
            case COUNTRY: {
                break;
            }
            case EPHEMERIS: {
                break;
            }
            case CHARACTER: {
                break;
            }
            case FLIP: {
                break;
            }
            case SWITCH_SLIDER: {
                this.setBarBackgroundColor(FOREGROUND);
                break;
            }
            case DATE: {
                this.setTitleAlignment(TextAlignment.CENTER);
                this.setTextAlignment(TextAlignment.CENTER);
                break;
            }
            case CALENDAR: {
                this.setTitleAlignment(TextAlignment.CENTER);
                this.setTextAlignment(TextAlignment.CENTER);
                break;
            }
            case SUNBURST: {
                break;
            }
            case MATRIX: {
                break;
            }
            case RADIAL_PERCENTAGE: {
                this.setBarBackgroundColor(this.getBackgroundColor().brighter());
                this.setAnimated(true);
                break;
            }
            case STATUS: {
                this.setDescriptionAlignment(Pos.TOP_CENTER);
                break;
            }
            case BAR_GAUGE: {
                this.setBarBackgroundColor(BACKGROUND.brighter());
                this.setBarColor(BLUE);
                this.setAngleRange(180.0);
                this.setTickLabelDecimals(0);
                break;
            }
            case IMAGE: {
                this.setTextAlignment(TextAlignment.CENTER);
                break;
            }
        }
    }

    public SkinType getSkinType() {
        return this.skinType;
    }

    public void setSkinType(SkinType SKIN_TYPE) {
        this.skinType = SKIN_TYPE;
        switch (SKIN_TYPE) {
            case SMOOTHED_CHART: {
                this.setSkin(new SmoothedChartTileSkin(this));
                break;
            }
            case BAR_CHART: {
                this.setSkin(new BarChartTileSkin(this));
                break;
            }
            case CLOCK: {
                this.setSkin(new ClockTileSkin(this));
                break;
            }
            case GAUGE: {
                this.setSkin(new GaugeTileSkin(this));
                break;
            }
            case HIGH_LOW: {
                this.setSkin(new HighLowTileSkin(this));
                break;
            }
            case PERCENTAGE: {
                this.setSkin(new PercentageTileSkin(this));
                break;
            }
            case PLUS_MINUS: {
                this.setSkin(new PlusMinusTileSkin(this));
                break;
            }
            case SLIDER: {
                this.setSkin(new SliderTileSkin(this));
                break;
            }
            case SPARK_LINE: {
                this.setSkin(new SparkLineTileSkin(this));
                break;
            }
            case SWITCH: {
                this.setSkin(new SwitchTileSkin(this));
                break;
            }
            case WORLDMAP: {
                this.setSkin(new WorldMapTileSkin(this));
                break;
            }
            case TIMER_CONTROL: {
                this.setSkin(new TimerControlTileSkin(this));
                break;
            }
            case NUMBER: {
                this.setSkin(new NumberTileSkin(this));
                break;
            }
            case TEXT: {
                this.setSkin(new TextTileSkin(this));
                break;
            }
            case WEATHER: {
                this.setSkin(new WeatherTileSkin(this));
                break;
            }
            case TIME: {
                this.setSkin(new TimeTileSkin(this));
                break;
            }
            case CUSTOM: {
                this.setSkin(new CustomTileSkin(this));
                break;
            }
            case LEADER_BOARD: {
                this.setSkin(new LeaderBoardTileSkin(this));
                break;
            }
            case RADIAL_CHART: {
                this.setSkin(new RadialChartTileSkin(this));
                break;
            }
            case DONUT_CHART: {
                this.setSkin(new DonutChartTileSkin(this));
                break;
            }
            case CIRCULAR_PROGRESS: {
                this.setSkin(new CircularProgressTileSkin(this));
                break;
            }
            case STOCK: {
                this.setSkin(new StockTileSkin(this));
                break;
            }
            case GAUGE_SPARK_LINE: {
                this.setSkin(new GaugeSparkLineTileSkin(this));
                break;
            }
            case SMOOTH_AREA_CHART: {
                this.setSkin(new SmoothAreaChartTileSkin(this));
                break;
            }
            case RADAR_CHART: {
                this.setSkin(new RadarChartTileSkin(this));
                break;
            }
            case COUNTRY: {
                this.setSkin(new CountryTileSkin(this));
                break;
            }
            case EPHEMERIS: {
                this.setSkin(new EphemerisTileSkin(this));
                break;
            }
            case CHARACTER: {
                this.setSkin(new CharacterTileSkin(this));
                break;
            }
            case FLIP: {
                this.setSkin(new FlipTileSkin(this));
                break;
            }
            case SWITCH_SLIDER: {
                this.setSkin(new SwitchSliderTileSkin(this));
                break;
            }
            case DATE: {
                this.setSkin(new DateTileSkin(this));
                break;
            }
            case CALENDAR: {
                this.setSkin(new CalendarTileSkin(this));
                break;
            }
            case SUNBURST: {
                this.setSkin(new SunburstChartTileSkin(this));
                break;
            }
            case MATRIX: {
                this.setSkin(new MatrixTileSkin(this));
                break;
            }
            case RADIAL_PERCENTAGE: {
                this.setSkin(new RadialPercentageTileSkin(this));
                break;
            }
            case STATUS: {
                this.setSkin(new StatusTileSkin(this));
                break;
            }
            case BAR_GAUGE: {
                this.setSkin(new BarGaugeTileSkin(this));
                break;
            }
            case IMAGE: {
                this.setSkin(new ImageTileSkin(this));
                break;
            }
            default: {
                this.setSkin(new TileSkin(this));
            }
        }
        this.fireTileEvent(this.RESIZE_EVENT);
        this.presetTileParameters(SKIN_TYPE);
    }

    public static enum ImageMask {
        NONE,
        ROUND,
        RECTANGULAR;

    }

    public static enum ChartType {
        LINE,
        AREA;

    }

    public static enum MapProvider {
        BW("blackwhite"),
        STREET("street"),
        BRIGHT("bright"),
        DARK("dark"),
        SAT("sat"),
        TOPO("topo");

        public final String name;

        private MapProvider(String NAME) {
            this.name = NAME;
        }
    }

    public static enum TileColor {
        GRAY(Color.rgb((int)139, (int)144, (int)146), "GRAY"),
        RED(Color.rgb((int)229, (int)80, (int)76), "RED"),
        LIGHT_RED(Color.rgb((int)255, (int)84, (int)56), "LIGHT_RED"),
        GREEN(Color.rgb((int)143, (int)198, (int)94), "GREEN"),
        LIGHT_GREEN(Color.rgb((int)132, (int)228, (int)50), "LIGHT_GREEN"),
        BLUE(Color.rgb((int)55, (int)179, (int)252), "BLUE"),
        DARK_BLUE(Color.rgb((int)55, (int)94, (int)252), "DARK_BLUE"),
        ORANGE(Color.rgb((int)237, (int)162, (int)57), "ORANGE"),
        YELLOW_ORANGE(Color.rgb((int)229, (int)198, (int)76), "YELLOW_ORANGE"),
        YELLOW(Color.rgb((int)229, (int)229, (int)76), "YELLOW"),
        MAGENTA(Color.rgb((int)198, (int)75, (int)232), "MAGENTA"),
        PINK(Color.rgb((int)233, (int)14, (int)139), "PINK");

        public final Color color;
        public final String styleName;

        private TileColor(Color COLOR, String STYLE_NAME) {
            this.color = COLOR;
            this.styleName = STYLE_NAME;
        }
    }

    public static enum TextSize {
        SMALL(0.04),
        SMALLER(0.05),
        NORMAL(0.06),
        BIGGER(0.08);

        public final double factor;

        private TextSize(double FACTOR) {
            this.factor = FACTOR;
        }
    }

    public static enum SkinType {
        SMOOTHED_CHART("ChartTileSkin"),
        BAR_CHART("BarChartTileSkin"),
        CLOCK("ClockTileSkin"),
        GAUGE("GaugeTileSkin"),
        HIGH_LOW("HighLowTileSkin)"),
        PERCENTAGE("PercentageTileSkin"),
        PLUS_MINUS("PlusMinusTileSkin"),
        SLIDER("SliderTileSkin"),
        SPARK_LINE("SparkLineTileSkin"),
        SWITCH("SwitchTileSkin"),
        WORLDMAP("WorldMapTileSkin"),
        TIMER_CONTROL("TimerControlTileSkin"),
        NUMBER("NumberTileSkin"),
        TEXT("TextTileSkin"),
        WEATHER("WeatherTileSkin"),
        TIME("TimeTileSkin"),
        CUSTOM("CustomTileSkin"),
        LEADER_BOARD("LeaderBoardTileSkin"),
        MAP("MapTileSkin"),
        RADIAL_CHART("RadialChartTileSkin"),
        DONUT_CHART("DonutChartTileSkin"),
        CIRCULAR_PROGRESS("CircularProgressTileSkin"),
        STOCK("StockTileSkin"),
        GAUGE_SPARK_LINE("GaugeSparkLineTileSkin"),
        SMOOTH_AREA_CHART("SmoothAreaChartTileSkin"),
        RADAR_CHART("RadarChartTileSkin"),
        COUNTRY("CountryTileSkin"),
        EPHEMERIS("EphemerisTileSkin"),
        CHARACTER("CharacterTileSkin"),
        FLIP("FlipTileSkin"),
        SWITCH_SLIDER("SwitchSliderTileSkin"),
        DATE("DateTileSkin"),
        CALENDAR("CalendarTileSkin"),
        SUNBURST("SunburstTileSkin"),
        MATRIX("MatrixTileSkin"),
        RADIAL_PERCENTAGE("RadialPercentageTileSkin"),
        STATUS("StatusTileSkin"),
        BAR_GAUGE("BarGaugeTileSkin"),
        IMAGE("ImageTileSkin");

        public final String CLASS_NAME;

        private SkinType(String CLASS_NAME) {
            this.CLASS_NAME = CLASS_NAME;
        }
    }
}

