/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Location;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.WritableValue;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class ChartData
implements Comparable<ChartData> {
    private final ChartDataEvent UPDATE_EVENT = new ChartDataEvent(ChartDataEvent.EventType.UPDATE, this);
    private final ChartDataEvent FINISHED_EVENT = new ChartDataEvent(ChartDataEvent.EventType.FINISHED, this);
    private String name;
    private double value;
    private double oldValue;
    private Color fillColor;
    private Color strokeColor;
    private Color textColor;
    private Instant timestamp;
    private Location location;
    private boolean animated;
    private long animationDuration;
    private List<ChartDataEventListener> listenerList = new CopyOnWriteArrayList<ChartDataEventListener>();
    private DoubleProperty currentValue;
    private Timeline timeline;

    public ChartData() {
        this("", 0.0, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, Instant.now(), true, 800L);
    }

    public ChartData(String NAME) {
        this(NAME, 0.0, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, Instant.now(), true, 800L);
    }

    public ChartData(double VALUE) {
        this("", VALUE, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, Instant.now(), true, 800L);
    }

    public ChartData(double VALUE, Instant TIMESTAMP) {
        this("", VALUE, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, TIMESTAMP, true, 800L);
    }

    public ChartData(String NAME, Instant TIMESTAMP) {
        this(NAME, 0.0, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, TIMESTAMP, true, 800L);
    }

    public ChartData(String NAME, Color FILL_COLOR) {
        this(NAME, 0.0, FILL_COLOR, Color.TRANSPARENT, Tile.FOREGROUND, Instant.now(), true, 800L);
    }

    public ChartData(String NAME, double VALUE) {
        this(NAME, VALUE, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, Instant.now(), true, 800L);
    }

    public ChartData(String NAME, double VALUE, Instant TIMESTAMP) {
        this(NAME, VALUE, Tile.BLUE, Color.TRANSPARENT, Tile.FOREGROUND, TIMESTAMP, true, 800L);
    }

    public ChartData(String NAME, double VALUE, Color FILL_COLOR) {
        this(NAME, VALUE, FILL_COLOR, Color.TRANSPARENT, Tile.FOREGROUND, Instant.now(), true, 800L);
    }

    public ChartData(String NAME, double VALUE, Color FILL_COLOR, Instant TIMESTAMP) {
        this(NAME, VALUE, FILL_COLOR, Color.TRANSPARENT, Tile.FOREGROUND, TIMESTAMP, true, 800L);
    }

    public ChartData(String NAME, double VALUE, Color FILL_COLOR, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION) {
        this(NAME, VALUE, FILL_COLOR, Color.TRANSPARENT, Tile.FOREGROUND, TIMESTAMP, ANIMATED, ANIMATION_DURATION);
    }

    public ChartData(String NAME, double VALUE, Color FILL_COLOR, Color STROKE_COLOR, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION) {
        this(NAME, VALUE, FILL_COLOR, STROKE_COLOR, Tile.FOREGROUND, TIMESTAMP, ANIMATED, ANIMATION_DURATION);
    }

    public ChartData(String NAME, double VALUE, Color FILL_COLOR, Color STROKE_COLOR, Color TEXT_COLOR, Instant TIMESTAMP, boolean ANIMATED, long ANIMATION_DURATION) {
        this.name = NAME;
        this.value = VALUE;
        this.oldValue = 0.0;
        this.fillColor = FILL_COLOR;
        this.strokeColor = STROKE_COLOR;
        this.textColor = TEXT_COLOR;
        this.timestamp = TIMESTAMP;
        this.currentValue = new DoublePropertyBase(this.value){

            protected void invalidated() {
                ChartData.this.oldValue = ChartData.this.value;
                ChartData.this.value = this.get();
                ChartData.this.fireChartDataEvent(ChartData.this.UPDATE_EVENT);
            }

            public Object getBean() {
                return ChartData.this;
            }

            public String getName() {
                return "currentValue";
            }
        };
        this.timeline = new Timeline();
        this.animated = ANIMATED;
        this.animationDuration = ANIMATION_DURATION;
        this.timeline.setOnFinished(e -> this.fireChartDataEvent(this.FINISHED_EVENT));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String NAME) {
        this.name = NAME;
        if (null != this.location) {
            this.location.setName(NAME);
        }
        this.fireChartDataEvent(this.UPDATE_EVENT);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double VALUE) {
        if (this.animated) {
            this.timeline.stop();
            KeyValue kv1 = new KeyValue((WritableValue)this.currentValue, (Object)this.value, Interpolator.EASE_BOTH);
            KeyValue kv2 = new KeyValue((WritableValue)this.currentValue, (Object)VALUE, Interpolator.EASE_BOTH);
            KeyFrame kf1 = new KeyFrame(Duration.ZERO, new KeyValue[]{kv1});
            KeyFrame kf2 = new KeyFrame(Duration.millis((double)this.animationDuration), new KeyValue[]{kv2});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf1, kf2});
            this.timeline.play();
        } else {
            this.oldValue = this.value;
            this.value = VALUE;
            this.fireChartDataEvent(this.FINISHED_EVENT);
        }
    }

    public double getOldValue() {
        return this.oldValue;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color COLOR) {
        this.fillColor = COLOR;
        if (null != this.location) {
            this.location.setColor(COLOR);
        }
        this.fireChartDataEvent(this.UPDATE_EVENT);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color COLOR) {
        this.strokeColor = COLOR;
        this.fireChartDataEvent(this.UPDATE_EVENT);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color COLOR) {
        this.textColor = COLOR;
        this.fireChartDataEvent(this.UPDATE_EVENT);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Instant TIMESTAMP) {
        this.timestamp = TIMESTAMP;
        this.fireChartDataEvent(this.UPDATE_EVENT);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location LOCATION) {
        this.location = LOCATION;
        this.location.setName(this.getName());
        this.location.setColor(this.getFillColor());
        this.fireChartDataEvent(this.UPDATE_EVENT);
    }

    public ZonedDateTime getTimestampAdDateTime() {
        return this.getTimestampAsDateTime(ZoneId.systemDefault());
    }

    public ZonedDateTime getTimestampAsDateTime(ZoneId ZONE_ID) {
        return ZonedDateTime.ofInstant(this.timestamp, ZONE_ID);
    }

    public LocalDate getTimestampAsLocalDate() {
        return this.getTimestampAsLocalDate(ZoneId.systemDefault());
    }

    public LocalDate getTimestampAsLocalDate(ZoneId ZONE_ID) {
        return this.getTimestampAsDateTime(ZONE_ID).toLocalDate();
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean ANIMATED) {
        this.animated = ANIMATED;
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(long DURATION) {
        this.animationDuration = Helper.clamp(10L, 10000L, DURATION);
    }

    public String toString() {
        return "{\n" + "  \"name\":" + this.name + ",\n" + "  \"value\":" + this.value + ",\n" + "  \"fillColor\":" + this.fillColor.toString().replace("0x", "#") + ",\n" + "  \"strokeColor\":" + this.strokeColor.toString().replace("0x", "#") + ",\n" + "  \"timestamp\":" + this.timestamp.toEpochMilli() + ",\n" + "}";
    }

    @Override
    public int compareTo(ChartData DATA) {
        return Double.compare(this.getValue(), DATA.getValue());
    }

    public void setOnChartDataEvent(ChartDataEventListener LISTENER) {
        this.addChartDataEventListener(LISTENER);
    }

    public void addChartDataEventListener(ChartDataEventListener LISTENER) {
        if (!this.listenerList.contains(LISTENER)) {
            this.listenerList.add(LISTENER);
        }
    }

    public void removeChartDataEventListener(ChartDataEventListener LISTENER) {
        if (this.listenerList.contains(LISTENER)) {
            this.listenerList.remove(LISTENER);
        }
    }

    public void fireChartDataEvent(ChartDataEvent EVENT) {
        for (ChartDataEventListener listener : this.listenerList) {
            listener.onChartDataEvent(EVENT);
        }
    }
}

