/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.tools.Location;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class ChartDataBuilder<B extends ChartDataBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected ChartDataBuilder() {
    }

    public static final ChartDataBuilder create() {
        return new ChartDataBuilder();
    }

    public final B name(String NAME) {
        this.properties.put("name", (Property)new SimpleStringProperty(NAME));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B timestamp(Instant TIMESTAMP) {
        this.properties.put("timestamp", (Property)new SimpleObjectProperty((Object)TIMESTAMP));
        return (B)this;
    }

    public final B timestamp(ZonedDateTime TIMESTAMP) {
        this.properties.put("timestamp", (Property)new SimpleObjectProperty((Object)TIMESTAMP.toInstant()));
        return (B)this;
    }

    public final B location(Location LOCATION) {
        this.properties.put("location", (Property)new SimpleObjectProperty((Object)LOCATION));
        return (B)this;
    }

    public final B fillColor(Color COLOR) {
        this.properties.put("fillColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B strokeColor(Color COLOR) {
        this.properties.put("strokeColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B animated(boolean ANIMATED) {
        this.properties.put("animated", (Property)new SimpleBooleanProperty(ANIMATED));
        return (B)this;
    }

    public final B onChartDataEvent(ChartDataEventListener HANDLER) {
        this.properties.put("onChartDataEvent", (Property)new SimpleObjectProperty((Object)HANDLER));
        return (B)this;
    }

    public final ChartData build() {
        ChartData DATA = new ChartData();
        for (String key : this.properties.keySet()) {
            if ("name".equals(key)) {
                DATA.setName((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                DATA.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timestamp".equals(key)) {
                DATA.setTimestamp((Instant)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("location".equals(key)) {
                DATA.setLocation((Location)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fillColor".equals(key)) {
                DATA.setFillColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("strokeColor".equals(key)) {
                DATA.setStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                DATA.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animated".equals(key)) {
                DATA.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"onChartDataEvent".equals(key)) continue;
            DATA.setOnChartDataEvent((ChartDataEventListener)((ObjectProperty)this.properties.get(key)).get());
        }
        return DATA;
    }
}

