/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class RadarChart
extends Region {
    private static final int MIN_NO_OF_SECTORS = 4;
    private static final int MAX_NO_OF_SECTORS = 128;
    private static final double PREFERRED_WIDTH = 120.0;
    private static final double PREFERRED_HEIGHT = 120.0;
    private static final double MINIMUM_WIDTH = 10.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private Pane pane;
    private Canvas chartCanvas;
    private GraphicsContext chartCtx;
    private Canvas overlayCanvas;
    private GraphicsContext overlayCtx;
    private Text unitText;
    private Text minValueText;
    private Text legend1Text;
    private Text legend2Text;
    private Text legend3Text;
    private Text legend4Text;
    private Text maxValueText;
    private DropShadow dropShadow;
    private double legendStep;
    private int decimals = 0;
    private String formatString;
    private int _noOfSectors = 4;
    private IntegerProperty noOfSectors;
    private double angleStep;
    private ObservableList<ChartData> data;
    private double _minValue = 0.0;
    private DoubleProperty minValue;
    private double _maxValue = 100.0;
    private DoubleProperty maxValue;
    private double _threshold = 100.0;
    private DoubleProperty threshold;
    private double _range = 100.0;
    private DoubleProperty range;
    private String _unit = "";
    private StringProperty unit;
    private boolean _legendVisible = false;
    private BooleanProperty legendVisible;
    private boolean _thresholdVisible = false;
    private BooleanProperty thresholdVisible;
    private ObservableList<Stop> gradientStops;
    private List<Stop> stops;
    private boolean _smoothing = false;
    private Color _chartBackgroundColor;
    private ObjectProperty<Color> chartBackgroundColor;
    private Color _chartForegroundColor;
    private ObjectProperty<Color> chartForegroundColor;
    private Color _chartTextColor;
    private ObjectProperty<Color> chartTextColor;
    private Color _gridColor;
    private ObjectProperty<Color> gridColor;
    private Paint _chartFill;
    private ObjectProperty<Paint> chartFill;
    private Color _thresholdColor;
    private ObjectProperty<Color> thresholdColor;
    private Mode _mode = Mode.POLYGON;
    private ObjectProperty<Mode> mode;
    private double legendScaleFactor = 1.0;
    private InvalidationListener resizeListener;
    private ListChangeListener<Stop> gradientListener;

    public RadarChart() {
        this(null);
    }

    public RadarChart(List<ChartData> DATA) {
        this.gradientStops = FXCollections.observableArrayList();
        this.formatString = "%." + this.decimals + "f";
        this.data = FXCollections.observableArrayList();
        this._chartBackgroundColor = Color.TRANSPARENT;
        this._chartForegroundColor = Tile.FOREGROUND;
        this._chartTextColor = Tile.FOREGROUND;
        this._gridColor = Tile.GRAY;
        this._chartFill = Tile.BLUE;
        this._thresholdColor = Tile.LIGHT_RED;
        this.resizeListener = o -> this.resize();
        this.gradientListener = change -> {
            this.stops.clear();
            for (Stop stop : this.getGradientStops()) {
                if (Double.compare(stop.getOffset(), 0.0) == 0) {
                    this.stops.add(new Stop(0.0, stop.getColor()));
                }
                this.stops.add(new Stop(stop.getOffset() * 0.69924 + 0.285, stop.getColor()));
            }
            this.redraw();
        };
        this.init();
        this.initGraphics();
        this.initData(DATA);
        this.registerListeners();
    }

    private void initData(List<ChartData> DATA) {
        if (null == DATA || DATA.isEmpty()) {
            for (int i = 0; i < this.getNoOfSectors() + 1; ++i) {
                this.addData(new ChartData(0.0));
            }
        } else {
            this.setData(DATA);
        }
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(120.0, 120.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(10.0, 10.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.stops = new ArrayList<Stop>(16);
        for (Stop stop : this.getGradientStops()) {
            if (Double.compare(stop.getOffset(), 0.0) == 0) {
                this.stops.add(new Stop(0.0, stop.getColor()));
            }
            this.stops.add(new Stop(stop.getOffset() * 0.69924 + 0.285, stop.getColor()));
        }
        this.chartCanvas = new Canvas(120.0, 120.0);
        this.chartCtx = this.chartCanvas.getGraphicsContext2D();
        this.overlayCanvas = new Canvas(120.0, 120.0);
        this.overlayCtx = this.overlayCanvas.getGraphicsContext2D();
        this.unitText = new Text(this.getUnit());
        this.unitText.setTextAlignment(TextAlignment.CENTER);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFont(Fonts.latoLight(5.3999999999999995));
        this.legendStep = (this.getMaxValue() - this.getMinValue()) / 5.0;
        this.dropShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.BLACK, 5.0, 0.0, 0.0, 0.0);
        this.minValueText = new Text(String.format(Locale.US, this.formatString, this.getMinValue()));
        this.minValueText.setTextAlignment(TextAlignment.CENTER);
        this.minValueText.setTextOrigin(VPos.CENTER);
        this.minValueText.setVisible(this.isLegendVisible());
        this.minValueText.setEffect((Effect)this.dropShadow);
        this.legend1Text = new Text(String.format(Locale.US, this.formatString, this.getMinValue() + this.legendStep));
        this.legend1Text.setTextAlignment(TextAlignment.CENTER);
        this.legend1Text.setTextOrigin(VPos.CENTER);
        this.legend1Text.setVisible(this.isLegendVisible());
        this.legend1Text.setEffect((Effect)this.dropShadow);
        this.legend2Text = new Text(String.format(Locale.US, this.formatString, this.getMinValue() + this.legendStep * 2.0));
        this.legend2Text.setTextAlignment(TextAlignment.CENTER);
        this.legend2Text.setTextOrigin(VPos.CENTER);
        this.legend2Text.setVisible(this.isLegendVisible());
        this.legend2Text.setEffect((Effect)this.dropShadow);
        this.legend3Text = new Text(String.format(Locale.US, this.formatString, this.getMinValue() + this.legendStep * 3.0));
        this.legend3Text.setTextAlignment(TextAlignment.CENTER);
        this.legend3Text.setTextOrigin(VPos.CENTER);
        this.legend3Text.setVisible(this.isLegendVisible());
        this.legend3Text.setEffect((Effect)this.dropShadow);
        this.legend4Text = new Text(String.format(Locale.US, this.formatString, this.getMinValue() + this.legendStep * 3.0));
        this.legend4Text.setTextAlignment(TextAlignment.CENTER);
        this.legend4Text.setTextOrigin(VPos.CENTER);
        this.legend4Text.setVisible(this.isLegendVisible());
        this.legend4Text.setEffect((Effect)this.dropShadow);
        this.maxValueText = new Text(String.format(Locale.US, this.formatString, this.getMaxValue()));
        this.maxValueText.setTextAlignment(TextAlignment.CENTER);
        this.maxValueText.setTextOrigin(VPos.CENTER);
        this.maxValueText.setVisible(this.isLegendVisible());
        this.maxValueText.setEffect((Effect)this.dropShadow);
        this.pane = new Pane(new Node[]{this.chartCanvas, this.overlayCanvas, this.unitText, this.minValueText, this.legend1Text, this.legend2Text, this.legend3Text, this.legend4Text, this.maxValueText});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.getChartBackgroundColor(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(this.resizeListener);
        this.heightProperty().addListener(this.resizeListener);
        this.gradientStops.addListener(this.gradientListener);
    }

    public void dispose() {
        this.widthProperty().removeListener(this.resizeListener);
        this.heightProperty().removeListener(this.resizeListener);
        this.gradientStops.removeListener(this.gradientListener);
    }

    public double getMinValue() {
        return null == this.minValue ? this._minValue : this.minValue.get();
    }

    public void setMinValue(double VALUE) {
        if (null == this.minValue) {
            this._minValue = Helper.clamp(-1.7976931348623157E308, this.getMaxValue(), VALUE);
            this.setRange(this.getMaxValue() - this._minValue);
            this.redraw();
        } else {
            this.minValue.set(VALUE);
        }
    }

    public ReadOnlyDoubleProperty minValueProperty() {
        if (null == this.minValue) {
            this.minValue = new DoublePropertyBase(this._minValue){

                public void set(double MIN_VALUE) {
                    super.set(Helper.clamp(-1.7976931348623157E308, RadarChart.this.getMaxValue(), MIN_VALUE));
                    RadarChart.this.setRange(RadarChart.this.getMaxValue() - this.get());
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "minValue";
                }
            };
        }
        return this.minValue;
    }

    public double getMaxValue() {
        return null == this.maxValue ? this._maxValue : this.maxValue.get();
    }

    public void setMaxValue(double VALUE) {
        if (null == this.maxValue) {
            this._maxValue = Helper.clamp(this.getMinValue(), Double.MAX_VALUE, VALUE);
            this.setRange(this._maxValue - this.getMinValue());
            this.redraw();
        } else {
            this.maxValue.set(VALUE);
        }
    }

    public ReadOnlyDoubleProperty maxValueProperty() {
        if (null == this.maxValue) {
            this.maxValue = new DoublePropertyBase(this._maxValue){

                protected void invalidated() {
                    this.set(Helper.clamp(RadarChart.this.getMinValue(), Double.MAX_VALUE, this.get()));
                    RadarChart.this.setRange(RadarChart.this._maxValue - RadarChart.this.getMinValue());
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "maxValue";
                }
            };
        }
        return this.maxValue;
    }

    public double getRange() {
        return null == this.range ? this._range : this.range.get();
    }

    private void setRange(double VALUE) {
        if (null == this.range) {
            this._range = VALUE;
        } else {
            this.range.set(VALUE);
        }
    }

    public ReadOnlyDoubleProperty rangeProperty() {
        if (null == this.range) {
            this.range = new DoublePropertyBase(this._range){

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "range";
                }
            };
        }
        return this.range;
    }

    public double getThreshold() {
        return null == this.threshold ? this._threshold : this.threshold.get();
    }

    public void setThreshold(double VALUE) {
        if (null == this.threshold) {
            this._threshold = Helper.clamp(this.getMinValue(), this.getMaxValue(), VALUE);
            this.setRange(this.getMaxValue() - VALUE);
            this.drawOverlay();
        } else {
            this.threshold.set(VALUE);
        }
    }

    public DoubleProperty thresholdProperty() {
        if (null == this.threshold) {
            this.threshold = new DoublePropertyBase(this._threshold){

                protected void invalidated() {
                    this.set(Helper.clamp(RadarChart.this.getMinValue(), RadarChart.this.getMaxValue(), this.get()));
                    RadarChart.this.setRange(RadarChart.this.getMaxValue() - this.get());
                    RadarChart.this.drawOverlay();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "threshold";
                }
            };
        }
        return this.threshold;
    }

    public int getNoOfSectors() {
        return null == this.noOfSectors ? this._noOfSectors : this.noOfSectors.get();
    }

    public void setNoOfSectors(int SECTORS) {
        if (null == this.noOfSectors) {
            this._noOfSectors = Helper.clamp(1, 128, SECTORS);
            this.angleStep = 360.0 / (double)this._noOfSectors;
            this.redraw();
        } else {
            this.noOfSectors.set(SECTORS);
        }
    }

    public IntegerProperty noOfSectorsProperty() {
        if (null == this.noOfSectors) {
            this.noOfSectors = new IntegerPropertyBase(this._noOfSectors){

                public void set(int SECTORS) {
                    super.set(Helper.clamp(1, 128, SECTORS));
                    RadarChart.this.angleStep = 360.0 / (double)this.get();
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "noOfSectors";
                }
            };
        }
        return this.noOfSectors;
    }

    public boolean isThresholdVisible() {
        return null == this.thresholdVisible ? this._thresholdVisible : this.thresholdVisible.get();
    }

    public void setThresholdVisible(boolean VISIBLE) {
        if (null == this.thresholdVisible) {
            this._thresholdVisible = VISIBLE;
            this.redraw();
        } else {
            this.thresholdVisible.set(VISIBLE);
        }
    }

    public BooleanProperty thresholdVisibleProperty() {
        if (null == this.thresholdVisible) {
            this.thresholdVisible = new BooleanPropertyBase(this._thresholdVisible){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "thresholdVisible";
                }
            };
        }
        return this.thresholdVisible;
    }

    public ObservableList<Stop> getGradientStops() {
        return this.gradientStops;
    }

    public void setGradientStops(List<Stop> STOPS) {
        this.gradientStops.setAll(STOPS);
    }

    public void setGradientStops(Stop ... STOPS) {
        this.gradientStops.setAll((Object[])STOPS);
    }

    public void addGradientStop(Stop STOP) {
        this.gradientStops.add((Object)STOP);
    }

    public String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public void setUnit(String TEXT) {
        if (null == this.unit) {
            this._unit = TEXT;
            this.redraw();
        } else {
            this.unit.set((Object)TEXT);
        }
    }

    public StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new StringPropertyBase(this._unit){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "unit";
                }
            };
            this._unit = null;
        }
        return this.unit;
    }

    public boolean isLegendVisible() {
        return null == this.legendVisible ? this._legendVisible : this.legendVisible.get();
    }

    public void setLegendVisible(boolean VISIBLE) {
        if (null == this.legendVisible) {
            this._legendVisible = VISIBLE;
            this.redraw();
        } else {
            this.legendVisible.set(VISIBLE);
        }
    }

    public BooleanProperty legendVisibleProperty() {
        if (null == this.legendVisible) {
            this.legendVisible = new BooleanPropertyBase(this._legendVisible){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "legendVisible";
                }
            };
        }
        return this.legendVisible;
    }

    public ObservableList<ChartData> getData() {
        return this.data;
    }

    public void setData(List<ChartData> DATA) {
        if (DATA.size() < 4) {
            throw new IllegalArgumentException("Not enough sectors (min. 4needed)");
        }
        if (DATA.size() > 128) {
            throw new IllegalArgumentException("Too many sectors (max. 128 sectors allowed)");
        }
        DATA.forEach(d -> this.addData((ChartData)d));
    }

    public void addData(ChartData DATA) {
        if (this.data.size() > this.getNoOfSectors() + 1) {
            throw new IllegalArgumentException("Too many sectors (max. " + this.getNoOfSectors() + " sectors allowed)");
        }
        this.data.add((Object)DATA);
        this.setNoOfSectors(this.data.size());
    }

    public void reset() {
        this.data.clear();
        this.initData((List<ChartData>)this.data);
    }

    public Color getChartBackgroundColor() {
        return null == this.chartBackgroundColor ? this._chartBackgroundColor : (Color)this.chartBackgroundColor.getValue();
    }

    public void setChartBackgroundColor(Color COLOR) {
        if (null == this.chartBackgroundColor) {
            this._chartBackgroundColor = COLOR;
            this.redraw();
        } else {
            this.chartBackgroundColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> chartBackgroundColorProperty() {
        if (null == this.chartBackgroundColor) {
            this.chartBackgroundColor = new ObjectPropertyBase<Color>(this._chartBackgroundColor){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "chartBackgroundColor";
                }
            };
            this._chartBackgroundColor = null;
        }
        return this.chartBackgroundColor;
    }

    public Color getChartForegroundColor() {
        return null == this.chartForegroundColor ? this._chartForegroundColor : (Color)this.chartForegroundColor.getValue();
    }

    public void setChartForegroundColor(Color COLOR) {
        if (null == this.chartForegroundColor) {
            this._chartForegroundColor = COLOR;
            this.redraw();
        } else {
            this.chartForegroundColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> chartForegroundColorProperty() {
        if (null == this.chartForegroundColor) {
            this.chartForegroundColor = new ObjectPropertyBase<Color>(this._chartForegroundColor){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "chartForegroundColor";
                }
            };
            this._chartForegroundColor = null;
        }
        return this.chartForegroundColor;
    }

    public Color getChartTextColor() {
        return null == this.chartTextColor ? this._chartTextColor : (Color)this.chartTextColor.getValue();
    }

    public void setChartTextColor(Color COLOR) {
        if (null == this.chartTextColor) {
            this._chartTextColor = COLOR;
            this.redraw();
        } else {
            this.chartTextColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> chartTextColorProperty() {
        if (null == this.chartTextColor) {
            this.chartTextColor = new ObjectPropertyBase<Color>(this._chartTextColor){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "chartTextColor";
                }
            };
            this._chartTextColor = null;
        }
        return this.chartTextColor;
    }

    public Color getGridColor() {
        return null == this.gridColor ? this._gridColor : (Color)this.gridColor.getValue();
    }

    public void setGridColor(Color COLOR) {
        if (null == this.gridColor) {
            this._gridColor = COLOR;
            this.redraw();
        } else {
            this.gridColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> gridColorProperty() {
        if (null == this.gridColor) {
            this.gridColor = new ObjectPropertyBase<Color>(this._gridColor){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "gridColor";
                }
            };
            this._gridColor = null;
        }
        return this.gridColor;
    }

    public Paint getChartFill() {
        return null == this.chartFill ? this._chartFill : (Paint)this.chartFill.getValue();
    }

    public void setChartFill(Paint PAINT) {
        if (null == this.chartFill) {
            this._chartFill = PAINT;
            this.redraw();
        } else {
            this.chartFill.setValue((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartFillProperty() {
        if (null == this.chartFill) {
            this.chartFill = new ObjectPropertyBase<Paint>(this._chartFill){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "chartFill";
                }
            };
            this._chartFill = null;
        }
        return this.chartFill;
    }

    public Color getThresholdColor() {
        return null == this.thresholdColor ? this._thresholdColor : (Color)this.thresholdColor.getValue();
    }

    public void setThresholdColor(Color COLOR) {
        if (null == this.thresholdColor) {
            this._thresholdColor = COLOR;
            this.redraw();
        } else {
            this.thresholdColor.setValue((Object)COLOR);
        }
    }

    public ObjectProperty<Color> thresholdColorProperty() {
        if (null == this.thresholdColor) {
            this.thresholdColor = new ObjectPropertyBase<Color>(this._thresholdColor){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "thresholdColor";
                }
            };
            this._thresholdColor = null;
        }
        return this.thresholdColor;
    }

    public void scaleLegendToValue(double VALUE) {
        this.legendScaleFactor = VALUE;
        this.redrawText();
    }

    public Mode getMode() {
        return null == this.mode ? this._mode : (Mode)((Object)this.mode.get());
    }

    public void setMode(Mode MODE) {
        if (null == this.mode) {
            this._mode = MODE;
            this.redraw();
        } else {
            this.mode.set((Object)MODE);
        }
    }

    public ObjectProperty<Mode> modeProperty() {
        if (null == this.mode) {
            this.mode = new ObjectPropertyBase<Mode>(this._mode){

                protected void invalidated() {
                    RadarChart.this.redraw();
                }

                public Object getBean() {
                    return RadarChart.this;
                }

                public String getName() {
                    return "mode";
                }
            };
            this._mode = null;
        }
        return this.mode;
    }

    public boolean isSmoothing() {
        return this._smoothing;
    }

    public void setSmoothing(boolean SMOOTHING) {
        this._smoothing = SMOOTHING;
        this.redraw();
    }

    public String getUserAgentStylesheet() {
        return RadarChart.class.getResource("radarchart.css").toExternalForm();
    }

    private void resize() {
        double height;
        double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        double d = this.size = width < (height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.getChartBackgroundColor(), new CornerRadii(1024.0), Insets.EMPTY)}));
            this.chartCanvas.setWidth(this.size);
            this.chartCanvas.setHeight(this.size);
            this.overlayCanvas.setWidth(this.size);
            this.overlayCanvas.setHeight(this.size);
            this.redraw();
        }
    }

    private void redrawText() {
        Color textColor = this.getChartTextColor();
        this.dropShadow.setColor(null == textColor ? Color.BLACK : Helper.getContrastColor(textColor));
        this.dropShadow.setRadius(this.size * 0.025);
        this.unitText.setFill((Paint)textColor);
        this.unitText.setText(this.getUnit());
        this.unitText.setFont(Fonts.latoRegular(this.size * 0.1));
        Helper.adjustTextSize(this.unitText, this.size * 0.22, this.size * 0.1);
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.unitText.getLayoutBounds().getHeight()) * 0.5);
        this.minValueText.setVisible(this.isLegendVisible());
        this.legend1Text.setVisible(this.isLegendVisible());
        this.legend2Text.setVisible(this.isLegendVisible());
        this.legend3Text.setVisible(this.isLegendVisible());
        this.legend4Text.setVisible(this.isLegendVisible());
        this.maxValueText.setVisible(this.isLegendVisible());
        if (this.isLegendVisible()) {
            Font font = Fonts.latoRegular(this.size * 0.025);
            this.minValueText.setFill((Paint)textColor);
            this.minValueText.setText(String.format(Locale.US, this.formatString, this.getMinValue()));
            this.minValueText.setFont(font);
            this.minValueText.relocate((this.size - this.minValueText.getLayoutBounds().getWidth()) * 0.5, 0.3435 * this.size);
            this.legendStep = this.getRange() / 5.0;
            this.legend1Text.setFill((Paint)textColor);
            this.legend1Text.setText(String.format(Locale.US, this.formatString, (this.getMinValue() + this.legendStep) * this.legendScaleFactor));
            this.legend1Text.setFont(font);
            this.legend1Text.relocate((this.size - this.legend1Text.getLayoutBounds().getWidth()) * 0.5, 0.29 * this.size);
            this.legend2Text.setFill((Paint)textColor);
            this.legend2Text.setText(String.format(Locale.US, this.formatString, (this.getMinValue() + this.legendStep * 2.0) * this.legendScaleFactor));
            this.legend2Text.setFont(font);
            this.legend2Text.relocate((this.size - this.legend2Text.getLayoutBounds().getWidth()) * 0.5, 0.225 * this.size);
            this.legend3Text.setFill((Paint)textColor);
            this.legend3Text.setText(String.format(Locale.US, this.formatString, (this.getMinValue() + this.legendStep * 3.0) * this.legendScaleFactor));
            this.legend3Text.setFont(font);
            this.legend3Text.relocate((this.size - this.legend3Text.getLayoutBounds().getWidth()) * 0.5, 0.1599 * this.size);
            this.legend4Text.setFill((Paint)textColor);
            this.legend4Text.setText(String.format(Locale.US, this.formatString, (this.getMinValue() + this.legendStep * 4.0) * this.legendScaleFactor));
            this.legend4Text.setFont(font);
            this.legend4Text.relocate((this.size - this.legend4Text.getLayoutBounds().getWidth()) * 0.5, 0.097 * this.size);
            this.maxValueText.setFill((Paint)textColor);
            this.maxValueText.setText(String.format(Locale.US, this.formatString, this.getMaxValue()));
            this.maxValueText.setFont(font);
            this.maxValueText.relocate((this.size - this.maxValueText.getLayoutBounds().getWidth()) * 0.5, 0.048 * this.size);
        }
    }

    public void redraw() {
        this.chartCanvas.setCache(false);
        this.drawChart();
        this.chartCanvas.setCache(true);
        this.chartCanvas.setCacheHint(CacheHint.QUALITY);
        this.overlayCanvas.setCache(false);
        this.drawOverlay();
        this.overlayCanvas.setCache(true);
        this.overlayCanvas.setCacheHint(CacheHint.QUALITY);
        this.redrawText();
    }

    private void drawChart() {
        double CENTER_X;
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.9 * this.size;
        double DATA_RANGE = this.getRange();
        double RANGE = 0.35714 * CIRCLE_SIZE;
        double OFFSET = 0.14286 * CIRCLE_SIZE;
        int NO_OF_SECTORS = this.getNoOfSectors();
        double MIN_VALUE = this.getMinValue();
        double MAX_VALUE = this.getMaxValue();
        this.chartCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.chartCtx.save();
        if (this.gradientStops.isEmpty()) {
            this.chartCtx.setFill(this.getChartFill());
        } else {
            this.chartCtx.setFill((Paint)new RadialGradient(0.0, 0.0, CENTER_X, CENTER_Y, CIRCLE_SIZE * 0.5, false, CycleMethod.NO_CYCLE, this.stops));
        }
        switch (this.getMode()) {
            case POLYGON: {
                double radiusFactor;
                if (this.isSmoothing()) {
                    double radAngle = Math.toRadians(180.0);
                    double radAngleStep = Math.toRadians(this.angleStep);
                    ArrayList<Point> points = new ArrayList<Point>();
                    double x = CENTER_X + -Math.sin(radAngle) * (CENTER_Y - 0.36239 * this.size);
                    double y = CENTER_Y + Math.cos(radAngle) * (CENTER_Y - 0.36239 * this.size);
                    points.add(new Point(x, y));
                    for (int i = 0; i < NO_OF_SECTORS; ++i) {
                        double r1 = CENTER_Y - (CENTER_Y - OFFSET - (((ChartData)this.data.get(i)).getValue() - MIN_VALUE) / DATA_RANGE * RANGE);
                        x = CENTER_X + -Math.sin(radAngle) * r1;
                        y = CENTER_Y + Math.cos(radAngle) * r1;
                        points.add(new Point(x, y));
                        radAngle += radAngleStep;
                    }
                    double r3 = CENTER_Y - (CENTER_Y - OFFSET - (((ChartData)this.data.get(NO_OF_SECTORS - 1)).getValue() - MIN_VALUE) / DATA_RANGE * RANGE);
                    x = CENTER_X + -Math.sin(radAngle) * r3;
                    y = CENTER_Y + Math.cos(radAngle) * r3;
                    points.add(new Point(x, y));
                    Point[] interpolatedPoints = Helper.subdividePoints(points.toArray(new Point[0]), 8);
                    this.chartCtx.beginPath();
                    this.chartCtx.moveTo(interpolatedPoints[0].getX(), interpolatedPoints[0].getY());
                    for (int i = 0; i < interpolatedPoints.length - 1; ++i) {
                        Point point = interpolatedPoints[i];
                        this.chartCtx.lineTo(point.getX(), point.getY());
                    }
                    this.chartCtx.lineTo(interpolatedPoints[interpolatedPoints.length - 1].getX(), interpolatedPoints[interpolatedPoints.length - 1].getY());
                    this.chartCtx.closePath();
                    this.chartCtx.fill();
                    break;
                }
                this.chartCtx.beginPath();
                this.chartCtx.moveTo(CENTER_X, 0.36239 * this.size);
                for (int i = 0; i < NO_OF_SECTORS; ++i) {
                    radiusFactor = Helper.clamp(MIN_VALUE, MAX_VALUE, ((ChartData)this.data.get(i)).getValue() - MIN_VALUE) / DATA_RANGE;
                    this.chartCtx.lineTo(CENTER_X, CENTER_Y - OFFSET - radiusFactor * RANGE);
                    this.chartCtx.translate(CENTER_X, CENTER_Y);
                    this.chartCtx.rotate(this.angleStep);
                    this.chartCtx.translate(-CENTER_X, -CENTER_Y);
                }
                radiusFactor = (Helper.clamp(MIN_VALUE, MAX_VALUE, ((ChartData)this.data.get(NO_OF_SECTORS - 1)).getValue()) - MIN_VALUE) / DATA_RANGE;
                this.chartCtx.lineTo(CENTER_X, CENTER_Y - OFFSET - radiusFactor * RANGE);
                this.chartCtx.closePath();
                this.chartCtx.fill();
                break;
            }
            case SECTOR: {
                this.chartCtx.translate(CENTER_X, CENTER_Y);
                this.chartCtx.rotate(-90.0);
                this.chartCtx.translate(-CENTER_X, -CENTER_Y);
                for (int i = 0; i < NO_OF_SECTORS; ++i) {
                    double radiusFactor = Helper.clamp(MIN_VALUE, MAX_VALUE, ((ChartData)this.data.get(i)).getValue() - MIN_VALUE) / DATA_RANGE;
                    this.chartCtx.beginPath();
                    this.chartCtx.moveTo(CENTER_X, CENTER_Y);
                    this.chartCtx.arc(CENTER_X, CENTER_Y, radiusFactor * RANGE + OFFSET, radiusFactor * RANGE + OFFSET, 0.0, -this.angleStep);
                    this.chartCtx.closePath();
                    this.chartCtx.fill();
                    this.chartCtx.translate(CENTER_X, CENTER_Y);
                    this.chartCtx.rotate(this.angleStep);
                    this.chartCtx.translate(-CENTER_X, -CENTER_Y);
                }
                break;
            }
        }
        this.chartCtx.restore();
    }

    private void drawOverlay() {
        int i;
        double CENTER_X;
        Color CHART_BKG = this.getChartBackgroundColor();
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.9 * this.size;
        double DATA_RANGE = this.getRange();
        double RANGE = 0.35714 * CIRCLE_SIZE;
        double OFFSET = 0.14286 * CIRCLE_SIZE;
        int NO_OF_SECTORS = this.getNoOfSectors();
        double MIN_VALUE = this.getMinValue();
        this.overlayCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.overlayCtx.save();
        this.overlayCtx.setFill((Paint)CHART_BKG);
        this.overlayCtx.translate(CENTER_X - OFFSET, CENTER_Y - OFFSET);
        this.overlayCtx.fillOval(0.0, 0.0, 2.0 * OFFSET, 2.0 * OFFSET);
        this.overlayCtx.restore();
        this.overlayCtx.setLineWidth(1.0);
        this.overlayCtx.setStroke((Paint)this.getGridColor());
        double ringStepSize = (CIRCLE_SIZE - CIRCLE_SIZE * 0.28571) / 20.0;
        double pos = 0.5 * (this.size - CIRCLE_SIZE);
        double ringSize = CIRCLE_SIZE;
        for (i = 0; i < 11; ++i) {
            this.overlayCtx.strokeOval(pos, pos, ringSize, ringSize);
            pos += ringStepSize;
            ringSize -= 2.0 * ringStepSize;
        }
        this.overlayCtx.save();
        for (i = 0; i < NO_OF_SECTORS; ++i) {
            this.overlayCtx.strokeLine(CENTER_X, 0.37 * this.size, CENTER_X, 0.5 * (this.size - CIRCLE_SIZE));
            this.overlayCtx.translate(CENTER_X, CENTER_Y);
            this.overlayCtx.rotate(this.angleStep);
            this.overlayCtx.translate(-CENTER_X, -CENTER_Y);
        }
        this.overlayCtx.restore();
        if (this.isThresholdVisible()) {
            double radius = (this.getThreshold() - MIN_VALUE) / DATA_RANGE;
            this.overlayCtx.setLineWidth(Helper.clamp(1.0, 3.0, this.size * 0.005));
            this.overlayCtx.setStroke((Paint)this.getThresholdColor());
            this.overlayCtx.strokeOval(0.5 * this.size - OFFSET - radius * RANGE, 0.5 * this.size - OFFSET - radius * RANGE, 2.0 * (radius * RANGE + OFFSET), 2.0 * (radius * RANGE + OFFSET));
        }
        this.overlayCtx.save();
        if (Mode.SECTOR == this.getMode()) {
            this.overlayCtx.translate(CENTER_X, CENTER_Y);
            this.overlayCtx.rotate(this.angleStep * 0.5);
            this.overlayCtx.translate(-CENTER_X, -CENTER_Y);
        }
        this.overlayCtx.save();
        this.overlayCtx.setFont(Fonts.latoRegular(0.04 * this.size));
        this.overlayCtx.setTextAlign(TextAlignment.CENTER);
        this.overlayCtx.setTextBaseline(VPos.CENTER);
        if (NO_OF_SECTORS == 0) {
            this.overlayCtx.setFill((Paint)this.getChartForegroundColor());
        }
        for (i = 0; i < NO_OF_SECTORS; ++i) {
            this.overlayCtx.setFill((Paint)((ChartData)this.data.get(i)).getTextColor());
            this.overlayCtx.fillText(((ChartData)this.data.get(i)).getName(), CENTER_X, this.size * 0.02);
            this.overlayCtx.translate(CENTER_X, CENTER_Y);
            this.overlayCtx.rotate(this.angleStep);
            this.overlayCtx.translate(-CENTER_X, -CENTER_Y);
        }
        this.overlayCtx.restore();
        this.overlayCtx.restore();
    }

    public static enum Mode {
        SECTOR,
        POLYGON;

    }
}

