/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.GradientLookup;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class BarGaugeTileSkin
extends TileSkin {
    private static final double START_ANGLE = 90.0;
    private static final double ANGLE_RANGE = 180.0;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Text text;
    private GradientLookup gradientLookup;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private Text minValueText;
    private Text maxValueText;
    private Arc barBackground;
    private Arc bar;
    private Line threshold;
    private Text thresholdText;

    public BarGaugeTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.gradientLookup = new GradientLookup(this.tile.getGradientStops());
        this.noOfGradientStops = this.tile.getGradientStops().size();
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.colorGradientEnabled = this.tile.isStrokeWithGradient();
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.CENTER);
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill((Paint)this.tile.getTextColor());
        this.barBackground = new Arc(125.0, 125.0, 100.0, 100.0, 0.0, 180.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(31.25);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 100.0, 100.0, 270.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.tile.getBarColor());
        this.bar.setStrokeWidth(31.25);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.threshold = new Line();
        this.threshold.setStroke((Paint)this.tile.getThresholdColor());
        this.threshold.setStrokeLineCap(StrokeLineCap.BUTT);
        Helper.enableNode((Node)this.threshold, this.tile.isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, this.formatString, this.tile.getThreshold()));
        Helper.enableNode((Node)this.thresholdText, this.tile.isThresholdVisible());
        this.minValueText = new Text();
        this.maxValueText = new Text();
        this.getPane().getChildren().addAll((Object[])new Node[]{this.barBackground, this.bar, this.threshold, this.thresholdText, this.minValueText, this.maxValueText, this.titleText, this.valueUnitFlow, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.threshold, this.tile.isThresholdVisible());
            Helper.enableNode((Node)this.thresholdText, this.tile.isThresholdVisible());
            this.sectionsVisible = this.tile.getSectionsVisible();
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.resizeDynamicText();
        this.setBar(VALUE);
    }

    private void setBar(double VALUE) {
        double barLength = 0.0;
        double barStart = 0.0;
        double step = this.tile.getAngleStep();
        double clampedValue = Helper.clamp(this.minValue, this.maxValue, VALUE);
        if (this.tile.isStartFromZero()) {
            if ((VALUE > this.minValue || this.minValue < 0.0) && (VALUE < this.maxValue || this.maxValue > 0.0)) {
                if (this.maxValue < 0.0) {
                    barStart = -360.0;
                    barLength = (this.maxValue - clampedValue) * step;
                } else if (this.minValue > 0.0) {
                    barStart = -180.0;
                    barLength = (this.minValue - clampedValue) * step;
                } else {
                    barStart = -180.0 + this.minValue * step;
                    barLength = -clampedValue * step;
                }
            }
        } else {
            barStart = -180.0;
            barLength = (this.minValue - clampedValue) * step;
        }
        this.bar.setStartAngle(barStart);
        this.bar.setLength(barLength);
        this.setBarColor(VALUE);
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke((Paint)this.tile.getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.bar.setStroke((Paint)this.gradientLookup.getColorAt((VALUE - this.minValue) / this.range));
        } else {
            this.bar.setStroke((Paint)this.tile.getBarColor());
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - this.size * 0.275;
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.07;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        this.minValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.minValue));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        this.minValueText.setX(this.width * 0.5 - this.size * 0.2);
        this.minValueText.setY(this.height * 0.85);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        this.maxValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.maxValue));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        this.maxValueText.setX(this.width * 0.5 + this.size * 0.2 - this.maxValueText.getLayoutBounds().getWidth());
        this.maxValueText.setY(this.height * 0.85);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.1);
    }

    @Override
    protected void resize() {
        super.resize();
        this.handleCurrentValue(this.tile.getValue());
        this.resizeStaticText();
        this.resizeDynamicText();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.85;
        this.valueUnitFlow.setPrefWidth(this.contentBounds.getWidth());
        this.valueUnitFlow.relocate(this.contentBounds.getX(), this.contentBounds.getY());
        this.barBackground.setCenterX(centerX);
        this.barBackground.setCenterY(centerY);
        this.barBackground.setRadiusX(this.size * 0.325);
        this.barBackground.setRadiusY(this.size * 0.325);
        this.barBackground.setStrokeWidth(this.size * 0.15);
        this.bar.setCenterX(centerX);
        this.bar.setCenterY(centerY);
        this.bar.setRadiusX(this.size * 0.325);
        this.bar.setRadiusY(this.size * 0.325);
        this.bar.setStrokeWidth(this.size * 0.15);
        this.threshold.setStrokeWidth(Helper.clamp(1.0, 2.0, 0.00675676 * this.size));
        double thresholdInnerRadius = 0.25 * this.size;
        double thresholdOuterRadius = 0.4 * this.size;
        double thresholdAngle = Helper.clamp(90.0, 270.0, (this.tile.getThreshold() - this.minValue) * this.angleStep + 90.0);
        this.threshold.setStartX(centerX + thresholdInnerRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setStartY(centerY + thresholdInnerRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndX(centerX + thresholdOuterRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndY(centerY + thresholdOuterRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        double thresholdTextRadius = 0.43 * this.size;
        this.thresholdText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getThreshold()));
        this.thresholdText.setFont(Fonts.latoRegular(this.size * 0.047));
        this.thresholdText.setRotate(thresholdAngle + 180.0);
        this.thresholdText.relocate(centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.sin(-Math.toRadians(thresholdAngle)), centerY - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.cos(-Math.toRadians(thresholdAngle)));
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.gradientLookup.setStops(this.tile.getGradientStops());
        this.colorGradientEnabled = this.tile.isStrokeWithGradient();
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.setBar(this.tile.getCurrentValue());
        this.threshold.setStroke((Paint)this.tile.getThresholdColor());
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.unitText.setText(this.tile.getUnit());
        if (!this.tile.getDescription().isEmpty()) {
            this.text.setText(this.tile.getDescription());
        }
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.minValueText.setFill((Paint)this.tile.getTextColor());
        this.maxValueText.setFill((Paint)this.tile.getTextColor());
        this.thresholdText.setFill((Paint)this.tile.getValueColor());
    }
}

