/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class NumberTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Label description;

    public NumberTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(" " + this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.unitText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.RIGHT);
        this.description = new Label(this.tile.getText());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.valueUnitFlow, this.description});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.resizeDynamicText();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        maxWidth = this.width - this.size * 0.275;
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.valueUnitFlow.setPrefWidth(this.contentBounds.getWidth());
        this.valueUnitFlow.relocate(this.contentBounds.getX(), this.contentBounds.getY());
        this.description.setPrefSize(this.width - this.size * 0.1, this.size * 0.43);
        this.description.relocate(this.size * 0.05, this.titleText.isVisible() ? this.height * 0.42 : this.height * 0.32);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.valueText.setText(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.unitText.setText(this.tile.getUnit());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.description.setTextFill((Paint)this.tile.getDescriptionColor());
    }
}

