/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class PercentageTileSkin
extends TileSkin {
    private Region barBackground;
    private Rectangle barClip;
    private Rectangle bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Label description;
    private Text percentageText;
    private Text percentageUnitText;
    private Rectangle maxValueRect;
    private Text maxValueText;
    private Text maxValueUnitText;
    private Color barColor;

    public PercentageTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.barColor = this.tile.getBarColor();
        this.barBackground = new Region();
        this.barBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.tile.getBarBackgroundColor(), new CornerRadii(0.0, 0.0, 0.025, 0.025, true), Insets.EMPTY)}));
        this.barClip = new Rectangle();
        this.bar = new Rectangle();
        this.bar.setFill((Paint)this.tile.getBarColor());
        this.bar.setStroke(null);
        this.bar.setClip((Node)this.barClip);
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.RIGHT);
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        this.percentageText = new Text();
        this.percentageText.setFill((Paint)this.tile.getBarColor());
        this.percentageUnitText = new Text("%");
        this.percentageUnitText.setFill((Paint)this.tile.getBarColor());
        this.maxValueRect = new Rectangle();
        this.maxValueRect.setFill((Paint)this.tile.getThresholdColor());
        this.maxValueText = new Text();
        this.maxValueText.setFill((Paint)this.tile.getBackgroundColor());
        this.maxValueUnitText = new Text(this.tile.getUnit());
        this.maxValueUnitText.setFill((Paint)this.tile.getBackgroundColor());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.barBackground, this.bar, this.titleText, this.valueUnitFlow, this.description, this.percentageText, this.percentageUnitText, this.maxValueRect, this.maxValueText, this.maxValueUnitText});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        double targetValue = (Helper.clamp(this.minValue, this.maxValue, VALUE) - this.minValue) * this.stepSize;
        this.bar.setWidth(targetValue);
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        this.percentageText.setText(String.format(this.locale, this.formatString, (VALUE - this.minValue) / this.range * 100.0));
        this.maxValueRect.setFill((Paint)(Double.compare(VALUE, this.maxValue) >= 0 ? this.barColor : this.tile.getThresholdColor()));
        this.resizeDynamicText();
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            this.setBarColor(VALUE);
        }
    }

    private void setBarColor(double VALUE) {
        Color color = this.barColor;
        for (Section section : this.sections) {
            if (!section.contains(VALUE)) continue;
            color = section.getColor();
            break;
        }
        this.bar.setFill((Paint)color);
        this.percentageText.setFill((Paint)color);
        this.percentageUnitText.setFill((Paint)color);
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.size * 0.725 : this.size * 0.9;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.percentageUnitText.relocate(this.percentageText.getLayoutBounds().getMaxX() + this.size * 0.075, this.height - this.size * 0.25);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - this.size * 0.275;
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.55;
        fontSize = this.size * 0.18;
        this.percentageText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageText, maxWidth, fontSize);
        }
        this.percentageText.relocate(this.size * 0.05, this.height - this.size * 0.305);
        maxWidth = this.width - this.size * 0.9;
        fontSize = this.size * 0.12;
        this.percentageUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageUnitText, maxWidth, fontSize);
        }
        this.percentageUnitText.relocate(this.percentageText.getLayoutBounds().getMaxX() + this.size * 0.075, this.height - this.size * 0.25);
        maxWidth = this.width - this.size * 0.8;
        fontSize = this.size * 0.05;
        this.maxValueUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueUnitText, maxWidth, fontSize);
        }
        this.maxValueUnitText.setX(this.width - this.size * 0.075 - this.maxValueUnitText.getLayoutBounds().getWidth());
        this.maxValueUnitText.setY(this.height - this.size * 0.145);
        maxWidth = this.width - this.size * 0.55;
        fontSize = this.size * 0.08;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.maxValueText.setX(this.width - this.size * 0.075 - (this.size * 0.01 + this.maxValueText.getLayoutBounds().getWidth() + this.maxValueUnitText.getLayoutBounds().getWidth()));
        } else {
            this.maxValueText.setX(this.width - this.size * 0.075 - this.maxValueText.getLayoutBounds().getWidth());
        }
        this.maxValueText.setY(this.height - this.size * 0.145);
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.width - this.size * 0.1, this.size * 0.43);
        this.description.relocate(this.size * 0.05, this.height * 0.42);
        this.barBackground.setPrefSize(this.width, this.size * 0.035);
        this.barBackground.relocate(0.0, this.height - this.size * 0.035);
        this.barClip.setX(0.0);
        this.barClip.setY(this.height - this.size * 0.05);
        this.barClip.setWidth(this.width);
        this.barClip.setHeight(this.size * 0.05);
        this.barClip.setArcWidth(this.tile.getRoundedCorners() ? this.size * 0.05 : 0.0);
        this.barClip.setArcHeight(this.tile.getRoundedCorners() ? this.size * 0.05 : 0.0);
        this.bar.setX(0.0);
        this.bar.setY(this.height - this.size * 0.035);
        this.bar.setWidth(Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue()) * this.stepSize);
        this.bar.setHeight(this.size * 0.035);
        this.maxValueRect.setWidth(this.maxValueText.getLayoutBounds().getWidth() + this.maxValueUnitText.getLayoutBounds().getWidth() + this.size * 0.06);
        this.maxValueRect.setHeight(this.maxValueText.getLayoutBounds().getHeight() * 1.01);
        this.maxValueRect.setX(this.width - this.size * 0.05 - this.maxValueRect.getWidth());
        this.maxValueRect.setY(this.height - this.size * 0.2225);
        this.maxValueRect.setArcWidth(this.size * 0.025);
        this.maxValueRect.setArcHeight(this.size * 0.025);
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.unitText.setText(this.tile.getUnit());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.percentageText.setText(String.format(this.locale, "%." + this.tile.getDecimals() + "f", this.tile.getValue() / this.range * 100.0));
        this.maxValueText.setText(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMaxValue()));
        this.maxValueUnitText.setText(this.tile.getUnit());
        this.resizeStaticText();
        this.barBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.tile.getBarBackgroundColor().brighter().brighter(), new CornerRadii(0.0, 0.0, this.tile.getRoundedCorners() ? this.size * 0.025 : 0.0, this.tile.getRoundedCorners() ? this.size * 0.025 : 0.0, false), Insets.EMPTY)}));
        this.barColor = this.tile.getBarColor();
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            this.setBarColor(this.tile.getValue());
        } else {
            this.bar.setFill((Paint)this.barColor);
        }
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.description.setTextFill((Paint)this.tile.getDescriptionColor());
        this.maxValueText.setFill((Paint)this.tile.getBackgroundColor());
        this.maxValueUnitText.setFill((Paint)this.tile.getBackgroundColor());
        this.maxValueRect.setFill((Paint)(Double.compare(this.tile.getCurrentValue(), this.maxValue) >= 0 ? this.barColor : this.tile.getThresholdColor()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
    }
}

