/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.GradientLookup;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.MovingAverage;
import eu.hansolo.tilesfx.tools.NiceScale;
import eu.hansolo.tilesfx.tools.Point;
import eu.hansolo.tilesfx.tools.Statistics;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class SparkLineTileSkin
extends TileSkin {
    private static final int MONTH = 2592000;
    private static final int DAY = 86400;
    private static final int HOUR = 3600;
    private static final int MINUTE = 60;
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private Text averageText;
    private Text highText;
    private Text lowText;
    private Text text;
    private Text timeSpanText;
    private Rectangle graphBounds;
    private List<PathElement> pathElements;
    private Path sparkLine;
    private Circle dot;
    private Rectangle stdDeviationArea;
    private Line averageLine;
    private LinearGradient gradient;
    private GradientLookup gradientLookup;
    private double low;
    private double high;
    private double lastLow;
    private double lastHigh;
    private double stdDeviation;
    private int noOfDatapoints;
    private List<Double> dataList;
    private MovingAverage movingAverage;
    private InvalidationListener averagingListener;
    private NiceScale niceScaleY;
    private List<Line> horizontalTickLines;
    private double horizontalLineOffset;
    private double tickLabelFontSize;
    private List<Text> tickLabelsY;
    private Color tickLineColor;

    public SparkLineTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        int i;
        super.initGraphics();
        this.averagingListener = o -> this.handleEvents("AVERAGING");
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm", this.tile.getLocale());
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.niceScaleY = new NiceScale(this.tile.getMinValue(), this.tile.getMaxValue());
        this.niceScaleY.setMaxTicks(5.0);
        this.tickLineColor = Color.color((double)this.tile.getChartGridColor().getRed(), (double)this.tile.getChartGridColor().getGreen(), (double)this.tile.getChartGridColor().getBlue(), (double)0.5);
        this.horizontalTickLines = new ArrayList<Line>(5);
        this.tickLabelsY = new ArrayList<Text>(5);
        for (i = 0; i < 5; ++i) {
            Line hLine = new Line(0.0, 0.0, 0.0, 0.0);
            hLine.getStrokeDashArray().addAll((Object[])new Double[]{1.0, 2.0});
            hLine.setStroke((Paint)Color.TRANSPARENT);
            this.horizontalTickLines.add(hLine);
            Text tickLabelY = new Text("");
            tickLabelY.setFill((Paint)Color.TRANSPARENT);
            this.tickLabelsY.add(tickLabelY);
        }
        this.gradientLookup = new GradientLookup(this.tile.getGradientStops());
        this.lastLow = this.low = this.tile.getMaxValue();
        this.lastHigh = this.high = this.tile.getMinValue();
        this.stdDeviation = 0.0;
        this.movingAverage = this.tile.getMovingAverage();
        this.noOfDatapoints = this.tile.getAveragingPeriod();
        this.dataList = new LinkedList<Double>();
        if (this.noOfDatapoints < 4) {
            throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
        }
        this.graphBounds = new Rectangle(12.5, 125.0, 225.0, 112.5);
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.RIGHT);
        this.averageText = new Text(String.format(this.locale, this.formatString, this.tile.getAverage()));
        this.averageText.setFill((Paint)Tile.FOREGROUND);
        Helper.enableNode((Node)this.averageText, this.tile.isAverageVisible());
        this.highText = new Text();
        this.highText.setTextOrigin(VPos.BOTTOM);
        this.highText.setFill((Paint)this.tile.getValueColor());
        this.lowText = new Text();
        this.lowText.setTextOrigin(VPos.TOP);
        this.lowText.setFill((Paint)this.tile.getValueColor());
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill((Paint)this.tile.getTextColor());
        this.timeSpanText = new Text("");
        this.timeSpanText.setTextOrigin(VPos.TOP);
        this.timeSpanText.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.timeSpanText, !this.tile.isTextVisible());
        this.stdDeviationArea = new Rectangle();
        Helper.enableNode((Node)this.stdDeviationArea, this.tile.isAverageVisible());
        this.averageLine = new Line();
        this.averageLine.setStroke((Paint)Tile.FOREGROUND);
        this.averageLine.getStrokeDashArray().addAll((Object[])new Double[]{1.25, 1.25});
        Helper.enableNode((Node)this.averageLine, this.tile.isAverageVisible());
        this.pathElements = new ArrayList<PathElement>(this.noOfDatapoints);
        this.pathElements.add(0, (PathElement)new MoveTo());
        for (i = 1; i < this.noOfDatapoints; ++i) {
            this.pathElements.add(i, (PathElement)new LineTo());
        }
        this.sparkLine = new Path();
        this.sparkLine.getElements().addAll(this.pathElements);
        this.sparkLine.setFill(null);
        this.sparkLine.setStroke((Paint)this.tile.getBarColor());
        this.sparkLine.setStrokeWidth(1.875);
        this.sparkLine.setStrokeLineCap(StrokeLineCap.ROUND);
        this.sparkLine.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.dot = new Circle();
        this.dot.setFill((Paint)this.tile.getBarColor());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.valueUnitFlow, this.stdDeviationArea, this.averageLine, this.sparkLine, this.dot, this.averageText, this.highText, this.lowText, this.timeSpanText, this.text});
        this.getPane().getChildren().addAll(this.horizontalTickLines);
        this.getPane().getChildren().addAll(this.tickLabelsY);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.averagingPeriodProperty().addListener(this.averagingListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.timeSpanText, !this.tile.isTextVisible());
            Helper.enableNode((Node)this.averageLine, this.tile.isAverageVisible());
            Helper.enableNode((Node)this.averageText, this.tile.isAverageVisible());
            Helper.enableNode((Node)this.stdDeviationArea, this.tile.isAverageVisible());
            this.redraw();
        } else if ("VALUE".equals(EVENT_TYPE)) {
            if (this.tile.isAnimated()) {
                this.tile.setAnimated(false);
            }
            if (!this.tile.isAveragingEnabled()) {
                this.tile.setAveragingEnabled(true);
            }
            double value = Helper.clamp(this.minValue, this.maxValue, this.tile.getValue());
            this.addData(value);
            this.handleCurrentValue(value);
        } else if ("AVERAGING".equals(EVENT_TYPE)) {
            int i;
            this.noOfDatapoints = this.tile.getAveragingPeriod();
            if (this.noOfDatapoints < 4) {
                throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
            }
            for (i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(this.minValue);
            }
            this.pathElements.clear();
            this.pathElements.add(0, (PathElement)new MoveTo());
            for (i = 1; i < this.noOfDatapoints; ++i) {
                this.pathElements.add(i, (PathElement)new LineTo());
            }
            this.sparkLine.getElements().setAll(this.pathElements);
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        boolean loHiChanged;
        this.low = Statistics.getMin(this.dataList);
        this.high = Statistics.getMax(this.dataList);
        if (Helper.equals(this.low, this.high)) {
            this.low = this.minValue;
            this.high = this.maxValue;
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        boolean bl = loHiChanged = Double.compare(this.lastLow, this.low) != 0 || Double.compare(this.lastHigh, this.high) != 0;
        if (loHiChanged) {
            this.niceScaleY.setMinMax(this.low, this.high);
            int lineCountY = 1;
            int tickLabelOffsetY = 1;
            double tickSpacingY = this.niceScaleY.getTickSpacing();
            double tickStepY = tickSpacingY * stepY;
            double tickStartY = maxY - tickStepY;
            if (tickSpacingY < this.low) {
                tickLabelOffsetY = (int)(this.low / tickSpacingY) + 1;
                tickStartY = maxY - ((double)tickLabelOffsetY * tickSpacingY - this.low) * stepY;
            }
            this.horizontalTickLines.forEach(line -> line.setStroke((Paint)Color.TRANSPARENT));
            this.tickLabelsY.forEach(label -> label.setFill((Paint)Color.TRANSPARENT));
            this.horizontalLineOffset = 0.0;
            double y = tickStartY;
            while ((double)Math.round(y) > minY) {
                Line line2 = this.horizontalTickLines.get(lineCountY);
                Text label2 = this.tickLabelsY.get(lineCountY);
                label2.setText(String.format(this.locale, "%.0f", this.low + (double)lineCountY * tickSpacingY));
                label2.setY(y + this.graphBounds.getHeight() * 0.03);
                label2.setFill((Paint)this.tickLineColor);
                this.horizontalLineOffset = Math.max(label2.getLayoutBounds().getWidth(), this.horizontalLineOffset);
                line2.setStartX(minX);
                line2.setStartY(y);
                line2.setEndY(y);
                line2.setStroke((Paint)this.tickLineColor);
                ++lineCountY;
                lineCountY = Helper.clamp(0, 4, lineCountY);
                y -= tickStepY;
            }
            if (this.tickLabelFontSize < 6.0) {
                this.horizontalLineOffset = 0.0;
            }
            this.horizontalTickLines.forEach(line -> line.setEndX(maxX - this.horizontalLineOffset));
            this.tickLabelsY.forEach(label -> label.setX(maxX - label.getLayoutBounds().getWidth()));
            this.highText.setText(String.format(this.locale, this.formatString, this.high));
            this.lowText.setText(String.format(this.locale, this.formatString, this.low));
        }
        if (!this.dataList.isEmpty()) {
            if (this.tile.isSmoothing()) {
                this.smooth(this.dataList);
            } else {
                MoveTo begin = (MoveTo)this.pathElements.get(0);
                begin.setX(minX);
                begin.setY(maxY - Math.abs(this.low - this.dataList.get(0)) * stepY);
                for (int i = 1; i < this.noOfDatapoints - 1; ++i) {
                    LineTo lineTo = (LineTo)this.pathElements.get(i);
                    lineTo.setX(minX + (double)i * stepX);
                    lineTo.setY(maxY - Math.abs(this.low - this.dataList.get(i)) * stepY);
                }
                LineTo end = (LineTo)this.pathElements.get(this.noOfDatapoints - 1);
                end.setX(maxX);
                end.setY(maxY - Math.abs(this.low - this.dataList.get(this.noOfDatapoints - 1)) * stepY);
                this.dot.setCenterX(maxX);
                this.dot.setCenterY(end.getY());
            }
            if (this.tile.isStrokeWithGradient() && loHiChanged) {
                this.setupGradient();
                this.dot.setFill((Paint)this.gradient);
                this.sparkLine.setStroke((Paint)this.gradient);
            }
            double average = this.tile.getAverage();
            double averageY = Helper.clamp(minY, maxY, maxY - Math.abs(this.low - average) * stepY);
            this.averageLine.setStartX(minX);
            this.averageLine.setStartY(averageY);
            this.averageLine.setEndX(maxX);
            this.averageLine.setEndY(averageY);
            this.stdDeviationArea.setY(this.averageLine.getStartY() - this.stdDeviation * 0.5 * stepY);
            this.stdDeviationArea.setHeight(this.stdDeviation * stepY);
            this.averageText.setText(String.format(this.locale, this.formatString, average));
        }
        this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeDynamicText();
        this.lastLow = this.low;
        this.lastHigh = this.high;
    }

    private void addData(double VALUE) {
        if (this.dataList.isEmpty()) {
            for (int i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(VALUE);
            }
        }
        if (this.dataList.size() <= this.noOfDatapoints) {
            Collections.rotate(this.dataList, -1);
            this.dataList.set(this.noOfDatapoints - 1, VALUE);
        } else {
            this.dataList.add(VALUE);
        }
        this.stdDeviation = Statistics.getStdDev(this.dataList);
    }

    private void setupGradient() {
        double loFactor = (this.low - this.minValue) / this.tile.getRange();
        double hiFactor = (this.high - this.minValue) / this.tile.getRange();
        Stop loStop = new Stop(loFactor, this.gradientLookup.getColorAt(loFactor));
        Stop hiStop = new Stop(hiFactor, this.gradientLookup.getColorAt(hiFactor));
        List<Stop> stopsInBetween = this.gradientLookup.getStopsBetween(loFactor, hiFactor);
        double range = hiFactor - loFactor;
        double factor = 1.0 / range;
        ArrayList<Stop> stops = new ArrayList<Stop>();
        stops.add(new Stop(0.0, loStop.getColor()));
        for (Stop stop : stopsInBetween) {
            stops.add(new Stop((stop.getOffset() - loFactor) * factor, stop.getColor()));
        }
        stops.add(new Stop(1.0, hiStop.getColor()));
        this.gradient = new LinearGradient(0.0, this.graphBounds.getY() + this.graphBounds.getHeight(), 0.0, this.graphBounds.getY(), false, CycleMethod.NO_CYCLE, stops);
    }

    private String createTimeSpanText() {
        long timeSpan = this.movingAverage.getTimeSpan().getEpochSecond();
        StringBuilder timeSpanBuilder = new StringBuilder(this.movingAverage.isFilling() ? "\u22a2 " : "\u2190 ");
        if (timeSpan > 2592000L) {
            int months = (int)(timeSpan / 2592000L);
            double days = timeSpan % 2592000L;
            timeSpanBuilder.append(months).append("M").append(String.format(Locale.US, "%.0f", days)).append("d").append(" \u2192");
        } else if (timeSpan > 86400L) {
            int days = (int)(timeSpan / 86400L);
            double hours = (timeSpan - (long)(days * 86400)) / 3600L;
            timeSpanBuilder.append(days).append("d").append(String.format(Locale.US, "%.0f", hours)).append("h").append(" \u2192");
        } else if (timeSpan > 3600L) {
            int hours = (int)(timeSpan / 3600L);
            double minutes = (timeSpan - (long)(hours * 3600)) / 60L;
            timeSpanBuilder.append(hours).append("h").append(String.format(Locale.US, "%.0f", minutes)).append("m").append(" \u2192");
        } else if (timeSpan > 60L) {
            int minutes = (int)(timeSpan / 60L);
            double seconds = timeSpan - (long)(minutes * 60);
            timeSpanBuilder.append(minutes).append("m").append(String.format(Locale.US, "%.0f", seconds)).append("s").append(" \u2192");
        } else {
            int seconds = (int)timeSpan;
            timeSpanBuilder.append(seconds).append("s").append(" \u2192");
        }
        return timeSpanBuilder.toString();
    }

    @Override
    public void dispose() {
        this.tile.averagingPeriodProperty().removeListener(this.averagingListener);
        super.dispose();
    }

    private void smooth(final List<Double> DATA_LIST) {
        Task<Point[]> smoothTask = new Task<Point[]>(){

            protected Point[] call() {
                return Helper.smoothSparkLine(DATA_LIST, SparkLineTileSkin.this.minValue, SparkLineTileSkin.this.maxValue, SparkLineTileSkin.this.graphBounds, SparkLineTileSkin.this.noOfDatapoints);
            }
        };
        smoothTask.setOnSucceeded(arg_0 -> this.lambda$smooth$5((Task)smoothTask, arg_0));
        Thread smoothThread = new Thread((Runnable)smoothTask);
        smoothThread.setDaemon(true);
        smoothThread.start();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.7;
        fontSize = this.size * 0.06;
        this.averageText.setFont(Fonts.latoRegular(fontSize));
        if (this.averageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.averageText, maxWidth, fontSize);
        }
        if (this.averageLine.getStartY() < this.graphBounds.getY() + this.graphBounds.getHeight() * 0.5) {
            this.averageText.setY(this.averageLine.getStartY() + this.size * 0.0425);
        } else {
            this.averageText.setY(this.averageLine.getStartY() - this.size * 0.0075);
        }
        this.highText.setFont(Fonts.latoRegular(fontSize));
        if (this.highText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.highText, maxWidth, fontSize);
        }
        this.highText.setY(this.graphBounds.getY() - this.size * 0.0125);
        this.lowText.setFont(Fonts.latoRegular(fontSize));
        if (this.lowText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.lowText, maxWidth, fontSize);
        }
        this.lowText.setY(this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.text.setFont(Fonts.latoRegular(fontSize));
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        this.text.relocate(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth(), this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.timeSpanText.setFont(Fonts.latoRegular(fontSize));
        if (this.timeSpanText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.timeSpanText, maxWidth, fontSize);
        }
        this.timeSpanText.relocate((this.width - this.timeSpanText.getLayoutBounds().getWidth()) * 0.5, this.height - this.size * 0.1);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - this.size * 0.275;
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.averageText.setX(this.size * 0.05);
        this.highText.setX(this.size * 0.05);
        this.lowText.setX(this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.graphBounds = new Rectangle(this.contentBounds.getX(), this.titleText.isVisible() ? this.size * 0.5 : this.size * 0.4, this.contentBounds.getWidth(), this.titleText.isVisible() ? this.height - this.size * 0.61 : this.height - this.size * 0.51);
        this.lastLow = this.maxValue;
        this.lastHigh = this.minValue;
        this.tickLabelFontSize = this.graphBounds.getHeight() * 0.1;
        Font tickLabelFont = Fonts.latoRegular(this.tickLabelFontSize);
        this.tickLabelsY.forEach(label -> {
            Helper.enableNode((Node)label, this.tickLabelFontSize >= 6.0);
            label.setFont(tickLabelFont);
        });
        this.horizontalTickLines.forEach(line -> line.setStrokeWidth(0.5));
        this.stdDeviationArea.setX(this.graphBounds.getX());
        this.stdDeviationArea.setWidth(this.graphBounds.getWidth());
        this.averageLine.getStrokeDashArray().setAll((Object[])new Double[]{this.graphBounds.getWidth() * 0.01, this.graphBounds.getWidth() * 0.01});
        this.handleCurrentValue(this.tile.getValue());
        if (this.tile.getAveragingPeriod() < 250) {
            this.sparkLine.setStrokeWidth(this.size * 0.01);
            this.dot.setRadius(this.size * 0.014);
        } else if (this.tile.getAveragingPeriod() < 500) {
            this.sparkLine.setStrokeWidth(this.size * 0.0075);
            this.dot.setRadius(this.size * 0.0105);
        } else {
            this.sparkLine.setStrokeWidth(this.size * 0.005);
            this.dot.setRadius(this.size * 0.007);
        }
        if (this.tile.isStrokeWithGradient()) {
            this.setupGradient();
        }
        this.resizeStaticText();
        this.resizeDynamicText();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.unitText.setText(this.tile.getUnit());
        if (!this.tile.getDescription().isEmpty()) {
            this.text.setText(this.tile.getDescription());
        }
        if (this.tile.isTextVisible()) {
            this.text.setText(this.tile.getText());
        } else if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.highText.setFill((Paint)this.tile.getValueColor());
        this.lowText.setFill((Paint)this.tile.getValueColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.timeSpanText.setFill((Paint)this.tile.getTextColor());
        if (this.tile.isStrokeWithGradient()) {
            this.setupGradient();
            this.sparkLine.setStroke((Paint)this.gradient);
        } else {
            this.sparkLine.setStroke((Paint)this.tile.getBarColor());
        }
        this.stdDeviationArea.setFill((Paint)Helper.getColorWithOpacity(Tile.FOREGROUND, 0.1));
        this.dot.setFill((Paint)(this.tile.isStrokeWithGradient() ? this.gradient : this.tile.getBarColor()));
    }

    private /* synthetic */ void lambda$smooth$5(Task smoothTask, WorkerStateEvent t) {
        Point[] smoothedPoints = (Point[])smoothTask.getValue();
        int lengthMinusOne = smoothedPoints.length - 1;
        this.sparkLine.getElements().clear();
        this.sparkLine.getElements().add((Object)new MoveTo(smoothedPoints[0].getX(), smoothedPoints[0].getY()));
        for (int i = 1; i < lengthMinusOne; ++i) {
            this.sparkLine.getElements().add((Object)new LineTo(smoothedPoints[i].getX(), smoothedPoints[i].getY()));
        }
        this.dot.setCenterX(smoothedPoints[lengthMinusOne].getX());
        this.dot.setCenterY(smoothedPoints[lengthMinusOne].getY());
    }
}

