/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.SunburstChart;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.events.TreeNodeEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.TreeNode;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class SunburstChartTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private SunburstChart sunburstChart;

    public SunburstChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.sunburstChart = this.tile.getSunburstChart();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.sunburstChart, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        TreeNode<ChartData> tree = this.tile.getSunburstChart().getTreeNode();
        System.out.println("check 1");
        if (null == tree) {
            return;
        }
        System.out.println("check 2");
        tree.setOnTreeNodeEvent(e -> {
            System.out.println("TreeNodeEvent");
            TreeNodeEvent.EventType type = e.getType();
            if (TreeNodeEvent.EventType.NODE_SELECTED == type) {
                TreeNode segment = e.getSource();
                this.tile.fireTileEvent(new TileEvent(TileEvent.EventType.SELECTED_CHART_DATA, (ChartData)segment.getItem()));
            }
        });
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.sunburstChart.redraw();
        }
    }

    @Override
    public void dispose() {
        this.sunburstChart.dispose();
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        double chartSize;
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double chartWidth = this.contentBounds.getWidth();
        double chartHeight = this.contentBounds.getHeight();
        double d = chartSize = chartWidth < chartHeight ? chartWidth : chartHeight;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.sunburstChart.setPrefSize(chartSize, chartSize);
            this.sunburstChart.relocate((this.width - chartSize) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartSize) * 0.5);
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.sunburstChart.redraw();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
    }
}

